/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java.test;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.test.MyPojo;
import io.vertx.rx.java.test.MySubscriber;
import java.util.Arrays;
import org.junit.Test;
import rx.Observable;

public class BufferTest {
    @Test
    public void testBufferReduce() {
        Observable stream = Observable.from(Arrays.asList(Buffer.buffer((String)"lorem"), Buffer.buffer((String)"ipsum")));
        Observable reduced = stream.reduce(Buffer::appendBuffer);
        MySubscriber<Buffer> sub = new MySubscriber<Buffer>();
        reduced.subscribe(sub);
        sub.assertItem(Buffer.buffer((String)"loremipsum"));
        sub.assertCompleted();
        sub.assertEmpty();
    }

    @Test
    public void testUnmarshallJsonObjectFromBuffer() {
        Observable stream = Observable.from(Arrays.asList(Buffer.buffer((String)"{\"foo\":\"bar\"}")));
        Observable mapped = stream.map(buffer -> new JsonObject(buffer.toString("UTF-8")));
        MySubscriber<JsonObject> sub = new MySubscriber<JsonObject>();
        mapped.subscribe(sub);
        sub.assertItem(new JsonObject().put("foo", "bar"));
        sub.assertCompleted();
        sub.assertEmpty();
    }

    @Test
    public void testMapPojoFromBuffer() throws Exception {
        Observable stream = Observable.from(Arrays.asList(Buffer.buffer((String)"{\"foo\":\"bar\"}")));
        Observable mapped = stream.lift(RxHelper.unmarshaller(MyPojo.class));
        MySubscriber<MyPojo> sub = new MySubscriber<MyPojo>();
        mapped.subscribe(sub);
        sub.assertItem(new MyPojo("bar"));
        sub.assertCompleted();
        sub.assertEmpty();
    }

    @Test
    public void testMapObjectNodeFromBuffer() throws Exception {
        Observable stream = Observable.from(Arrays.asList(Buffer.buffer((String)"{\"foo\":\"bar\"}")));
        Observable mapped = stream.lift(RxHelper.unmarshaller(JsonNode.class));
        MySubscriber<ObjectNode> sub = new MySubscriber<ObjectNode>();
        mapped.subscribe(sub);
        sub.assertItem(new ObjectMapper().createObjectNode().put("foo", "bar"));
        sub.assertCompleted();
        sub.assertEmpty();
    }
}

