/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java.test;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.test.MySubscriber;
import org.junit.Assert;
import org.junit.Test;
import rx.Subscription;
import rx.exceptions.OnErrorNotImplementedException;

public class AsyncResultHandlerTest {
    @Test
    public void testCompleteWithSuccessBeforeSubscribe() {
        ObservableFuture o = RxHelper.observableFuture();
        o.toHandler().handle((Object)Future.succeededFuture((Object)"abc"));
        MySubscriber<String> subscriber = new MySubscriber<String>();
        o.subscribe(subscriber);
        subscriber.assertItem("abc").assertCompleted().assertEmpty();
    }

    @Test
    public void testCompleteWithSuccessAfterSubscribe() {
        ObservableFuture o = RxHelper.observableFuture();
        MySubscriber<String> subscriber = new MySubscriber<String>();
        o.subscribe(subscriber);
        subscriber.assertEmpty();
        o.toHandler().handle((Object)Future.succeededFuture((Object)"abc"));
        subscriber.assertItem("abc").assertCompleted().assertEmpty();
    }

    @Test
    public void testCompleteWithFailureBeforeSubscribe() {
        ObservableFuture o = RxHelper.observableFuture();
        Throwable failure = new Throwable();
        o.toHandler().handle((Object)Future.failedFuture((Throwable)failure));
        MySubscriber subscriber = new MySubscriber();
        o.subscribe(subscriber);
        subscriber.assertError(failure).assertEmpty();
    }

    @Test
    public void testCompleteWithFailureAfterSubscribe() {
        ObservableFuture o = RxHelper.observableFuture();
        MySubscriber subscriber = new MySubscriber();
        o.subscribe(subscriber);
        subscriber.assertEmpty();
        Throwable failure = new Throwable();
        o.toHandler().handle((Object)Future.failedFuture((Throwable)failure));
        subscriber.assertError(failure).assertEmpty();
    }

    @Test
    public void testUnsubscribeBeforeResolve() {
        ObservableFuture o = RxHelper.observableFuture();
        MySubscriber subscriber = new MySubscriber();
        Subscription sub = o.subscribe(subscriber);
        sub.unsubscribe();
        Assert.assertTrue((boolean)sub.isUnsubscribed());
        subscriber.assertEmpty();
    }

    @Test
    public void testCompleteTwice() {
        ObservableFuture o = RxHelper.observableFuture();
        MySubscriber<String> subscriber = new MySubscriber<String>();
        o.subscribe(subscriber);
        o.toHandler().handle((Object)Future.succeededFuture((Object)"abc"));
        o.toHandler().handle((Object)Future.succeededFuture((Object)"def"));
        subscriber.assertItem("abc").assertCompleted().assertEmpty();
    }

    @Test
    public void testFailTwice() {
        ObservableFuture o = RxHelper.observableFuture();
        MySubscriber subscriber = new MySubscriber();
        o.subscribe(subscriber);
        Throwable failure = new Throwable();
        o.toHandler().handle((Object)Future.failedFuture((Throwable)failure));
        o.toHandler().handle((Object)Future.failedFuture((Throwable)new Throwable()));
        subscriber.assertError(failure).assertEmpty();
    }

    @Test
    public void testFulfillAdaptedSubscriber() {
        MySubscriber<String> subscriber = new MySubscriber<String>();
        Handler o = RxHelper.toFuture(subscriber);
        o.handle((Object)Future.succeededFuture((Object)"abc"));
        subscriber.assertItem("abc").assertCompleted().assertEmpty();
    }

    @Test
    public void testRejectAdaptedSubscriber() {
        MySubscriber subscriber = new MySubscriber();
        Handler o = RxHelper.toFuture(subscriber);
        Exception e = new Exception();
        o.handle((Object)Future.failedFuture((Throwable)e));
        subscriber.assertError(e).assertEmpty();
    }

    @Test
    public void testFulfillAdaptedFunctions1() {
        MySubscriber<String> subscriber = new MySubscriber<String>();
        Handler o = RxHelper.toFuture(subscriber::onNext);
        o.handle((Object)Future.succeededFuture((Object)"abc"));
        subscriber.assertItem("abc").assertEmpty();
    }

    @Test
    public void testFulfillAdaptedFunctions2() {
        MySubscriber<String> subscriber = new MySubscriber<String>();
        Handler o = RxHelper.toFuture(subscriber::onNext, subscriber::onError);
        o.handle((Object)Future.succeededFuture((Object)"abc"));
        subscriber.assertItem("abc").assertEmpty();
    }

    @Test
    public void testFulfillAdaptedFunctions3() {
        MySubscriber<String> subscriber = new MySubscriber<String>();
        Handler o = RxHelper.toFuture(subscriber::onNext, subscriber::onError, subscriber::onCompleted);
        o.handle((Object)Future.succeededFuture((Object)"abc"));
        subscriber.assertItem("abc").assertCompleted().assertEmpty();
    }

    @Test
    public void testRejectAdaptedFunctions1() {
        MySubscriber subscriber = new MySubscriber();
        Handler o = RxHelper.toFuture(subscriber::onNext);
        Exception cause = new Exception();
        try {
            o.handle((Object)Future.failedFuture((Throwable)cause));
        }
        catch (OnErrorNotImplementedException e) {
            Assert.assertSame((Object)cause, (Object)e.getCause());
        }
        subscriber.assertEmpty();
    }

    @Test
    public void testRejectAdaptedFunctions2() {
        MySubscriber subscriber = new MySubscriber();
        Handler o = RxHelper.toFuture(subscriber::onNext, subscriber::onError);
        Exception cause = new Exception();
        o.handle((Object)Future.failedFuture((Throwable)cause));
        subscriber.assertError(cause).assertEmpty();
    }

    @Test
    public void testRejectAdaptedFunctions3() {
        MySubscriber subscriber = new MySubscriber();
        Handler o = RxHelper.toFuture(subscriber::onNext, subscriber::onError, subscriber::onCompleted);
        Exception cause = new Exception();
        o.handle((Object)Future.failedFuture((Throwable)cause));
        subscriber.assertError(cause).assertEmpty();
    }
}

