/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java.test;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.rx.java.test.MySubscriber;
import io.vertx.rx.java.test.stream.BufferReadStreamImpl;
import io.vertx.test.core.VertxTestBase;
import org.junit.Test;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;

public abstract class AbstractReadStreamAdapterTest<B>
extends VertxTestBase {
    protected abstract Observable<B> toObservable(BufferReadStreamImpl var1);

    protected abstract B buffer(String var1);

    protected abstract String string(B var1);

    @Test
    public void testReact() {
        BufferReadStreamImpl stream = new BufferReadStreamImpl();
        Observable<B> observable = this.toObservable(stream);
        MySubscriber subscriber = new MySubscriber<B>(){

            @Override
            protected void assertEquals(Object expected, Object actual) {
                super.assertEquals(AbstractReadStreamAdapterTest.this.string(expected), AbstractReadStreamAdapterTest.this.string(actual));
            }
        };
        Subscription subscription = observable.subscribe((Subscriber)subscriber);
        this.assertNotNull(stream.endHandler);
        this.assertNotNull(stream.endHandler);
        this.assertNotNull(stream.handler);
        stream.handler.handle((Object)Buffer.buffer((String)"foo"));
        subscriber.assertItem(this.buffer("foo")).assertEmpty();
        stream.handler.handle((Object)Buffer.buffer((String)"bar"));
        subscriber.assertItem(this.buffer("bar")).assertEmpty();
        stream.endHandler.handle(null);
        subscriber.assertCompleted().assertEmpty();
        this.assertTrue(subscription.isUnsubscribed());
        this.testComplete();
    }

    @Test
    public void testConcat() {
        final BufferReadStreamImpl stream1 = new BufferReadStreamImpl();
        final BufferReadStreamImpl stream2 = new BufferReadStreamImpl();
        Subscriber observer = new Subscriber<B>(){

            public void onNext(B next) {
                switch (AbstractReadStreamAdapterTest.this.string(next)) {
                    case "item1": {
                        AbstractReadStreamAdapterTest.this.assertNotNull(stream1.handler);
                        AbstractReadStreamAdapterTest.this.assertNull(stream2.handler);
                        stream1.endHandler.handle(null);
                        stream2.handler.handle((Object)Buffer.buffer((String)"item2"));
                        break;
                    }
                    case "item2": {
                        AbstractReadStreamAdapterTest.this.assertNotNull(stream1.handler);
                        AbstractReadStreamAdapterTest.this.assertNotNull(stream2.handler);
                        stream2.endHandler.handle(null);
                        break;
                    }
                    default: {
                        AbstractReadStreamAdapterTest.this.fail();
                    }
                }
            }

            public void onError(Throwable e) {
                AbstractReadStreamAdapterTest.this.fail();
            }

            public void onCompleted() {
                AbstractReadStreamAdapterTest.this.testComplete();
            }
        };
        Observable<B> observable1 = this.toObservable(stream1);
        Observable<B> observable2 = this.toObservable(stream2);
        Observable observable = Observable.concat(observable1, observable2);
        observable.subscribe((Observer)observer);
        stream1.handler.handle((Object)Buffer.buffer((String)"item1"));
        this.await();
    }

    @Test
    public void testDataHandlerShouldBeSetAndUnsetAfterOtherHandlers() {
        BufferReadStreamImpl stream = new BufferReadStreamImpl(){

            @Override
            public BufferReadStreamImpl handler(Handler<Buffer> handler) {
                if (handler == null) {
                    AbstractReadStreamAdapterTest.this.assertNull(this.exceptionHandler);
                    AbstractReadStreamAdapterTest.this.assertNull(this.endHandler);
                } else {
                    AbstractReadStreamAdapterTest.this.assertNotNull(this.exceptionHandler);
                    AbstractReadStreamAdapterTest.this.assertNotNull(this.endHandler);
                }
                return super.handler((Handler)handler);
            }
        };
        Observable<B> observable = this.toObservable(stream);
        Subscription subscription = observable.subscribe(item -> {});
        subscription.unsubscribe();
    }

    @Test
    public void testOnSubscribeHandlerIsSetLast() {
        BufferReadStreamImpl stream = new BufferReadStreamImpl(){

            @Override
            public BufferReadStreamImpl handler(Handler<Buffer> handler) {
                AbstractReadStreamAdapterTest.this.assertNotNull(this.endHandler);
                AbstractReadStreamAdapterTest.this.assertNotNull(this.exceptionHandler);
                return super.handler((Handler)handler);
            }
        };
        Observable<B> observable = this.toObservable(stream);
        observable.subscribe(s -> {}, err -> {}, () -> {});
    }
}

