/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.testmodel;

import io.vertx.codegen.testmodel.AbstractHandlerUserType;
import io.vertx.codegen.testmodel.ConcreteHandlerUserType;
import io.vertx.codegen.testmodel.ConcreteHandlerUserTypeExtension;
import io.vertx.codegen.testmodel.GenericRefedInterface;
import io.vertx.codegen.testmodel.GenericRefedInterfaceImpl;
import io.vertx.codegen.testmodel.RefedInterface1;
import io.vertx.codegen.testmodel.RefedInterface1Impl;
import io.vertx.codegen.testmodel.RefedInterface2;
import io.vertx.codegen.testmodel.RefedInterface2Impl;
import io.vertx.codegen.testmodel.TestDataObject;
import io.vertx.codegen.testmodel.TestEnum;
import io.vertx.codegen.testmodel.TestGenEnum;
import io.vertx.codegen.testmodel.TestInterface;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;

public class TestInterfaceImpl
implements TestInterface {
    private static <T> T assertInstanceOf(Class<T> expectedType, Object obj) {
        if (expectedType.isInstance(obj)) {
            return expectedType.cast(obj);
        }
        throw new AssertionError((Object)("Was expecting " + obj + " to be an instance of " + expectedType));
    }

    @Override
    public void methodWithBasicParams(byte b, short s, int i, long l, float f, double d, boolean bool, char ch, String str) {
        Assert.assertEquals((long)123L, (long)b);
        Assert.assertEquals((long)12345L, (long)s);
        Assert.assertEquals((long)1234567L, (long)i);
        Assert.assertEquals((long)1265615234L, (long)l);
        Assert.assertEquals((float)12.345f, (float)f, (float)0.0f);
        Assert.assertEquals((double)12.34566, (double)d, (double)0.0);
        Assert.assertTrue((boolean)bool);
        Assert.assertEquals((long)88L, (long)ch);
        Assert.assertEquals((Object)"foobar", (Object)str);
    }

    @Override
    public void methodWithBasicBoxedParams(Byte b, Short s, Integer i, Long l, Float f, Double d, Boolean bool, Character ch) {
        Assert.assertEquals((long)123L, (long)b.byteValue());
        Assert.assertEquals((long)12345L, (long)s.shortValue());
        Assert.assertEquals((long)1234567L, (long)i.intValue());
        Assert.assertEquals((long)1265615234L, (long)l);
        Assert.assertEquals((float)12.345f, (float)f.floatValue(), (float)0.0f);
        Assert.assertEquals((double)12.34566, (double)d, (double)0.0);
        Assert.assertTrue((boolean)bool);
        Assert.assertEquals((long)88L, (long)ch.charValue());
    }

    @Override
    public void methodWithHandlerBasicTypes(Handler<Byte> byteHandler, Handler<Short> shortHandler, Handler<Integer> intHandler, Handler<Long> longHandler, Handler<Float> floatHandler, Handler<Double> doubleHandler, Handler<Boolean> booleanHandler, Handler<Character> charHandler, Handler<String> stringHandler) {
        byteHandler.handle((Object)123);
        shortHandler.handle((Object)12345);
        intHandler.handle((Object)1234567);
        longHandler.handle((Object)1265615234L);
        floatHandler.handle((Object)Float.valueOf(12.345f));
        doubleHandler.handle((Object)12.34566);
        booleanHandler.handle((Object)true);
        charHandler.handle((Object)Character.valueOf('X'));
        stringHandler.handle((Object)"quux!");
    }

    @Override
    public Handler<String> methodWithHandlerStringReturn(String expected) {
        return event -> Assert.assertEquals((Object)expected, (Object)event);
    }

    @Override
    public <T> Handler<T> methodWithHandlerGenericReturn(Handler<T> handler) {
        return arg_0 -> handler.handle(arg_0);
    }

    @Override
    public Handler<RefedInterface1> methodWithHandlerVertxGenReturn(String expected) {
        return event -> Assert.assertEquals((Object)expected, (Object)event.getString());
    }

    @Override
    public void methodWithHandlerAsyncResultByte(boolean sendFailure, Handler<AsyncResult<Byte>> handler) {
        if (sendFailure) {
            Exception e = new Exception("foobar!");
            handler.handle((Object)Future.failedFuture((Throwable)e));
        } else {
            handler.handle((Object)Future.succeededFuture((Object)123));
        }
    }

    @Override
    public void methodWithHandlerAsyncResultShort(boolean sendFailure, Handler<AsyncResult<Short>> handler) {
        if (sendFailure) {
            Exception e = new Exception("foobar!");
            handler.handle((Object)Future.failedFuture((Throwable)e));
        } else {
            handler.handle((Object)Future.succeededFuture((Object)12345));
        }
    }

    @Override
    public void methodWithHandlerAsyncResultInteger(boolean sendFailure, Handler<AsyncResult<Integer>> handler) {
        if (sendFailure) {
            Exception e = new Exception("foobar!");
            handler.handle((Object)Future.failedFuture((Throwable)e));
        } else {
            handler.handle((Object)Future.succeededFuture((Object)1234567));
        }
    }

    @Override
    public void methodWithHandlerAsyncResultLong(boolean sendFailure, Handler<AsyncResult<Long>> handler) {
        if (sendFailure) {
            Exception e = new Exception("foobar!");
            handler.handle((Object)Future.failedFuture((Throwable)e));
        } else {
            handler.handle((Object)Future.succeededFuture((Object)1265615234L));
        }
    }

    @Override
    public void methodWithHandlerAsyncResultFloat(boolean sendFailure, Handler<AsyncResult<Float>> handler) {
        if (sendFailure) {
            Exception e = new Exception("foobar!");
            handler.handle((Object)Future.failedFuture((Throwable)e));
        } else {
            handler.handle((Object)Future.succeededFuture((Object)Float.valueOf(12.345f)));
        }
    }

    @Override
    public void methodWithHandlerAsyncResultDouble(boolean sendFailure, Handler<AsyncResult<Double>> handler) {
        if (sendFailure) {
            Exception e = new Exception("foobar!");
            handler.handle((Object)Future.failedFuture((Throwable)e));
        } else {
            handler.handle((Object)Future.succeededFuture((Object)12.34566));
        }
    }

    @Override
    public void methodWithHandlerAsyncResultBoolean(boolean sendFailure, Handler<AsyncResult<Boolean>> handler) {
        if (sendFailure) {
            Exception e = new Exception("foobar!");
            handler.handle((Object)Future.failedFuture((Throwable)e));
        } else {
            handler.handle((Object)Future.succeededFuture((Object)true));
        }
    }

    @Override
    public void methodWithHandlerAsyncResultCharacter(boolean sendFailure, Handler<AsyncResult<Character>> handler) {
        if (sendFailure) {
            Exception e = new Exception("foobar!");
            handler.handle((Object)Future.failedFuture((Throwable)e));
        } else {
            handler.handle((Object)Future.succeededFuture((Object)Character.valueOf('X')));
        }
    }

    @Override
    public void methodWithHandlerAsyncResultString(boolean sendFailure, Handler<AsyncResult<String>> handler) {
        if (sendFailure) {
            Exception e = new Exception("foobar!");
            handler.handle((Object)Future.failedFuture((Throwable)e));
        } else {
            handler.handle((Object)Future.succeededFuture((Object)"quux!"));
        }
    }

    @Override
    public void methodWithHandlerAsyncResultDataObject(boolean sendFailure, Handler<AsyncResult<TestDataObject>> handler) {
        if (sendFailure) {
            Exception e = new Exception("foobar!");
            handler.handle((Object)Future.failedFuture((Throwable)e));
        } else {
            handler.handle((Object)Future.succeededFuture((Object)new TestDataObject().setFoo("foo").setBar(123)));
        }
    }

    @Override
    public Handler<AsyncResult<String>> methodWithHandlerAsyncResultStringReturn(String expected, boolean fail) {
        return ar -> {
            if (!fail) {
                Assert.assertTrue((boolean)ar.succeeded());
                Assert.assertEquals((Object)expected, (Object)ar.result());
            } else {
                Assert.assertEquals((Object)false, (Object)ar.succeeded());
                Assert.assertEquals((Object)expected, (Object)ar.cause().getMessage());
            }
        };
    }

    @Override
    public <T> Handler<AsyncResult<T>> methodWithHandlerAsyncResultGenericReturn(Handler<AsyncResult<T>> handler) {
        return arg_0 -> handler.handle(arg_0);
    }

    @Override
    public Handler<AsyncResult<RefedInterface1>> methodWithHandlerAsyncResultVertxGenReturn(String expected, boolean fail) {
        return ar -> {
            if (!fail) {
                Assert.assertTrue((boolean)ar.succeeded());
                Assert.assertEquals((Object)expected, (Object)((RefedInterface1)ar.result()).getString());
            } else {
                Assert.assertEquals((Object)false, (Object)ar.succeeded());
                Assert.assertEquals((Object)expected, (Object)ar.cause().getMessage());
            }
        };
    }

    @Override
    public void methodWithUserTypes(RefedInterface1 refed) {
        Assert.assertEquals((Object)"aardvarks", (Object)refed.getString());
    }

    @Override
    public void methodWithObjectParam(String str, Object obj) {
        switch (str) {
            case "null": {
                Assert.assertNull((Object)obj);
                break;
            }
            case "string": {
                Assert.assertTrue((boolean)(obj instanceof String));
                String s = (String)obj;
                Assert.assertEquals((Object)"wibble", (Object)s);
                break;
            }
            case "true": {
                Assert.assertTrue((boolean)(obj instanceof Boolean));
                Boolean t = (Boolean)obj;
                Assert.assertEquals((Object)true, (Object)t);
                break;
            }
            case "false": {
                Assert.assertTrue((boolean)(obj instanceof Boolean));
                Boolean f = (Boolean)obj;
                Assert.assertEquals((Object)false, (Object)f);
                break;
            }
            case "long": {
                Assert.assertTrue((boolean)(obj instanceof Number));
                Number l = (Number)obj;
                Assert.assertEquals((long)123L, (long)l.longValue());
                break;
            }
            case "double": {
                Assert.assertTrue((boolean)(obj instanceof Number));
                Number n = (Number)obj;
                Assert.assertEquals((double)123.456, (double)n.doubleValue(), (double)0.0);
                break;
            }
            case "JsonObject": {
                Assert.assertTrue((boolean)(obj instanceof JsonObject));
                JsonObject jsonObject = (JsonObject)obj;
                Assert.assertEquals((Object)"hello", (Object)jsonObject.getString("foo"));
                Assert.assertEquals((long)123L, (long)jsonObject.getInteger("bar").intValue());
                break;
            }
            case "JsonArray": {
                Assert.assertTrue((boolean)(obj instanceof JsonArray));
                JsonArray arr = (JsonArray)obj;
                Assert.assertEquals((long)3L, (long)arr.size());
                Assert.assertEquals((Object)"foo", (Object)arr.getString(0));
                Assert.assertEquals((Object)"bar", (Object)arr.getString(1));
                Assert.assertEquals((Object)"wib", (Object)arr.getString(2));
                break;
            }
            default: {
                Assert.fail((String)"invalid type");
            }
        }
    }

    @Override
    public void methodWithDataObjectParam(TestDataObject dataObject) {
        Assert.assertEquals((Object)"hello", (Object)dataObject.getFoo());
        Assert.assertEquals((long)123L, (long)dataObject.getBar());
        Assert.assertEquals((double)1.23, (double)dataObject.getWibble(), (double)0.0);
    }

    @Override
    public void methodWithListOfDataObjectsParam(List<TestDataObject> dataObjects) {
        Assert.assertEquals((long)2L, (long)dataObjects.size());
        Assert.assertEquals((Object)"hello", (Object)dataObjects.get(0).getFoo());
        Assert.assertEquals((Object)"world", (Object)dataObjects.get(1).getFoo());
    }

    @Override
    public void methodWithSetOfDataObjectsParam(Set<TestDataObject> dataObjects) {
        Assert.assertEquals((long)2L, (long)dataObjects.size());
        List strings = dataObjects.stream().map(TestDataObject::getFoo).collect(Collectors.toList());
        Assert.assertTrue((boolean)strings.contains("hello"));
        Assert.assertTrue((boolean)strings.contains("world"));
    }

    @Override
    public void methodWithNullDataObjectParam(TestDataObject dataObject) {
        Assert.assertNull((Object)dataObject);
    }

    @Override
    public void methodWithListParams(List<String> listString, List<Byte> listByte, List<Short> listShort, List<Integer> listInt, List<Long> listLong, List<JsonObject> listJsonObject, List<JsonArray> listJsonArray, List<RefedInterface1> listVertxGen, List<TestDataObject> listDataObject, List<TestEnum> listEnum) {
        Assert.assertEquals((Object)"foo", (Object)listString.get(0));
        Assert.assertEquals((Object)"bar", (Object)listString.get(1));
        Assert.assertEquals((long)2L, (long)listByte.get(0).byteValue());
        Assert.assertEquals((long)3L, (long)listByte.get(1).byteValue());
        Assert.assertEquals((long)12L, (long)listShort.get(0).shortValue());
        Assert.assertEquals((long)13L, (long)listShort.get(1).shortValue());
        Assert.assertEquals((long)1234L, (long)listInt.get(0).intValue());
        Assert.assertEquals((long)1345L, (long)listInt.get(1).intValue());
        System.out.println("entry type is " + listLong.get(0).getClass().getName());
        Assert.assertEquals((long)123L, (long)listLong.get(0));
        Assert.assertEquals((long)456L, (long)listLong.get(1));
        Assert.assertEquals((Object)new JsonObject().put("foo", "bar"), (Object)listJsonObject.get(0));
        Assert.assertEquals((Object)new JsonObject().put("eek", "wibble"), (Object)listJsonObject.get(1));
        Assert.assertEquals((Object)new JsonArray().add("foo"), (Object)listJsonArray.get(0));
        Assert.assertEquals((Object)new JsonArray().add("blah"), (Object)listJsonArray.get(1));
        Assert.assertEquals((Object)"foo", (Object)listVertxGen.get(0).getString());
        Assert.assertEquals((Object)"bar", (Object)listVertxGen.get(1).getString());
        Assert.assertEquals((Object)new JsonObject().put("foo", "String 1").put("bar", Integer.valueOf(1)).put("wibble", Double.valueOf(1.1)), (Object)listDataObject.get(0).toJson());
        Assert.assertEquals((Object)new JsonObject().put("foo", "String 2").put("bar", Integer.valueOf(2)).put("wibble", Double.valueOf(2.2)), (Object)listDataObject.get(1).toJson());
        Assert.assertEquals(Arrays.asList(TestEnum.JULIEN, TestEnum.TIM), new ArrayList<TestEnum>(listEnum));
    }

    @Override
    public void methodWithSetParams(Set<String> setString, Set<Byte> setByte, Set<Short> setShort, Set<Integer> setInt, Set<Long> setLong, Set<JsonObject> setJsonObject, Set<JsonArray> setJsonArray, Set<RefedInterface1> setVertxGen, Set<TestDataObject> setDataObject, Set<TestEnum> setEnum) {
        Assert.assertTrue((boolean)setString.contains("foo"));
        Assert.assertTrue((boolean)setString.contains("bar"));
        Assert.assertTrue((boolean)setByte.contains((byte)2));
        Assert.assertTrue((boolean)setByte.contains((byte)3));
        Assert.assertTrue((boolean)setShort.contains((short)12));
        Assert.assertTrue((boolean)setShort.contains((short)13));
        Assert.assertTrue((boolean)setInt.contains(1234));
        Assert.assertTrue((boolean)setInt.contains(1345));
        Assert.assertTrue((boolean)setLong.contains(123L));
        Assert.assertTrue((boolean)setLong.contains(456L));
        Assert.assertTrue((boolean)setJsonObject.contains(new JsonObject().put("foo", "bar")));
        Assert.assertTrue((boolean)setJsonObject.contains(new JsonObject().put("eek", "wibble")));
        Assert.assertTrue((boolean)setJsonArray.contains(new JsonArray().add("foo")));
        Assert.assertTrue((boolean)setJsonArray.contains(new JsonArray().add("blah")));
        Assert.assertTrue((boolean)setVertxGen.contains(new RefedInterface1Impl().setString("foo")));
        Assert.assertTrue((boolean)setVertxGen.contains(new RefedInterface1Impl().setString("bar")));
        Assert.assertEquals((long)2L, (long)setDataObject.size());
        Set setDataObjectJson = setDataObject.stream().map(d -> d.toJson()).collect(Collectors.toSet());
        Assert.assertTrue((boolean)setDataObjectJson.contains(new JsonObject().put("foo", "String 1").put("bar", Integer.valueOf(1)).put("wibble", Double.valueOf(1.1))));
        Assert.assertTrue((boolean)setDataObjectJson.contains(new JsonObject().put("foo", "String 2").put("bar", Integer.valueOf(2)).put("wibble", Double.valueOf(2.2))));
        Assert.assertEquals((long)2L, (long)setEnum.size());
        Assert.assertTrue((boolean)setEnum.contains((Object)TestEnum.JULIEN));
        Assert.assertTrue((boolean)setEnum.contains((Object)TestEnum.TIM));
    }

    @Override
    public void methodWithMapParams(Map<String, String> mapString, Map<String, Byte> mapByte, Map<String, Short> mapShort, Map<String, Integer> mapInt, Map<String, Long> mapLong, Map<String, JsonObject> mapJsonObject, Map<String, JsonArray> mapJsonArray, Map<String, RefedInterface1> mapVertxGen) {
        Assert.assertEquals((Object)"bar", (Object)mapString.get("foo"));
        Assert.assertEquals((Object)"wibble", (Object)mapString.get("eek"));
        Assert.assertEquals((long)2L, (long)mapByte.get("foo").byteValue());
        Assert.assertEquals((long)3L, (long)mapByte.get("eek").byteValue());
        Assert.assertEquals((long)12L, (long)mapShort.get("foo").shortValue());
        Assert.assertEquals((long)13L, (long)mapShort.get("eek").shortValue());
        Assert.assertEquals((long)1234L, (long)mapInt.get("foo").intValue());
        Assert.assertEquals((long)1345L, (long)mapInt.get("eek").intValue());
        Assert.assertEquals((long)123L, (long)mapLong.get("foo"));
        Assert.assertEquals((long)456L, (long)mapLong.get("eek"));
        Assert.assertEquals((Object)new JsonObject().put("foo", "bar"), (Object)mapJsonObject.get("foo"));
        Assert.assertEquals((Object)new JsonObject().put("eek", "wibble"), (Object)mapJsonObject.get("eek"));
        Assert.assertEquals((Object)new JsonArray().add("foo"), (Object)mapJsonArray.get("foo"));
        Assert.assertEquals((Object)new JsonArray().add("blah"), (Object)mapJsonArray.get("eek"));
        Assert.assertEquals((Object)new RefedInterface1Impl().setString("foo"), (Object)mapVertxGen.get("foo"));
        Assert.assertEquals((Object)new RefedInterface1Impl().setString("bar"), (Object)mapVertxGen.get("eek"));
    }

    @Override
    public void methodWithHandlerListAndSet(Handler<List<String>> listStringHandler, Handler<List<Integer>> listIntHandler, Handler<Set<String>> setStringHandler, Handler<Set<Integer>> setIntHandler) {
        List<String> listString = Arrays.asList("foo", "bar", "wibble");
        List<Integer> listInt = Arrays.asList(5, 12, 100);
        LinkedHashSet<String> setString = new LinkedHashSet<String>(Arrays.asList("foo", "bar", "wibble"));
        LinkedHashSet<Integer> setInt = new LinkedHashSet<Integer>(Arrays.asList(5, 12, 100));
        listStringHandler.handle(listString);
        listIntHandler.handle(listInt);
        setStringHandler.handle(setString);
        setIntHandler.handle(setInt);
    }

    @Override
    public void methodWithHandlerAsyncResultListString(Handler<AsyncResult<List<String>>> handler) {
        List<String> listString = Arrays.asList("foo", "bar", "wibble");
        handler.handle((Object)Future.succeededFuture(listString));
    }

    @Override
    public void methodWithHandlerAsyncResultListInteger(Handler<AsyncResult<List<Integer>>> handler) {
        List<Integer> listInt = Arrays.asList(5, 12, 100);
        handler.handle((Object)Future.succeededFuture(listInt));
    }

    @Override
    public void methodWithHandlerAsyncResultSetString(Handler<AsyncResult<Set<String>>> handler) {
        LinkedHashSet<String> setString = new LinkedHashSet<String>(Arrays.asList("foo", "bar", "wibble"));
        handler.handle((Object)Future.succeededFuture(setString));
    }

    @Override
    public void methodWithHandlerAsyncResultSetInteger(Handler<AsyncResult<Set<Integer>>> handler) {
        LinkedHashSet<Integer> setInt = new LinkedHashSet<Integer>(Arrays.asList(5, 12, 100));
        handler.handle((Object)Future.succeededFuture(setInt));
    }

    @Override
    public void methodWithHandlerListVertxGen(Handler<List<RefedInterface1>> listHandler) {
        List<RefedInterface1> list = Arrays.asList(new RefedInterface1Impl().setString("foo"), new RefedInterface1Impl().setString("bar"));
        listHandler.handle(list);
    }

    @Override
    public void methodWithHandlerSetVertxGen(Handler<Set<RefedInterface1>> setHandler) {
        LinkedHashSet<RefedInterface1> list = new LinkedHashSet<RefedInterface1>(Arrays.asList(new RefedInterface1Impl().setString("foo"), new RefedInterface1Impl().setString("bar")));
        setHandler.handle(list);
    }

    @Override
    public void methodWithHandlerListAbstractVertxGen(Handler<List<RefedInterface2>> listHandler) {
        List<RefedInterface2> list = Arrays.asList(new RefedInterface2Impl().setString("abstractfoo"), new RefedInterface2Impl().setString("abstractbar"));
        listHandler.handle(list);
    }

    @Override
    public void methodWithHandlerSetAbstractVertxGen(Handler<Set<RefedInterface2>> setHandler) {
        LinkedHashSet<RefedInterface2> list = new LinkedHashSet<RefedInterface2>(Arrays.asList(new RefedInterface2Impl().setString("abstractfoo"), new RefedInterface2Impl().setString("abstractbar")));
        setHandler.handle(list);
    }

    @Override
    public void methodWithHandlerListJsonObject(Handler<List<JsonObject>> listHandler) {
        List<JsonObject> list = Arrays.asList(new JsonObject().put("cheese", "stilton"), new JsonObject().put("socks", "tartan"));
        listHandler.handle(list);
    }

    @Override
    public void methodWithHandlerListNullJsonObject(Handler<List<JsonObject>> listHandler) {
        List<Object> list = Collections.singletonList(null);
        listHandler.handle(list);
    }

    @Override
    public void methodWithHandlerListComplexJsonObject(Handler<List<JsonObject>> listHandler) {
        List<JsonObject> list = Arrays.asList(new JsonObject().put("outer", new JsonObject().put("socks", "tartan")).put("list", new JsonArray().add("yellow").add("blue")));
        listHandler.handle(list);
    }

    @Override
    public void methodWithHandlerSetJsonObject(Handler<Set<JsonObject>> setHandler) {
        LinkedHashSet<JsonObject> set = new LinkedHashSet<JsonObject>(Arrays.asList(new JsonObject().put("cheese", "stilton"), new JsonObject().put("socks", "tartan")));
        setHandler.handle(set);
    }

    @Override
    public void methodWithHandlerSetNullJsonObject(Handler<Set<JsonObject>> setHandler) {
        Set<Object> set = Collections.singleton(null);
        setHandler.handle(set);
    }

    @Override
    public void methodWithHandlerSetComplexJsonObject(Handler<Set<JsonObject>> setHandler) {
        LinkedHashSet<JsonObject> set = new LinkedHashSet<JsonObject>(Arrays.asList(new JsonObject().put("outer", new JsonObject().put("socks", "tartan")).put("list", new JsonArray().add("yellow").add("blue"))));
        setHandler.handle(set);
    }

    @Override
    public void methodWithHandlerListJsonArray(Handler<List<JsonArray>> listHandler) {
        List<JsonArray> list = Arrays.asList(new JsonArray().add("green").add("blue"), new JsonArray().add("yellow").add("purple"));
        listHandler.handle(list);
    }

    @Override
    public void methodWithHandlerListNullJsonArray(Handler<List<JsonArray>> listHandler) {
        List<Object> list = Collections.singletonList(null);
        listHandler.handle(list);
    }

    @Override
    public void methodWithHandlerListComplexJsonArray(Handler<List<JsonArray>> listHandler) {
        List<JsonArray> list = Arrays.asList(new JsonArray().add(new JsonObject().put("foo", "hello")), new JsonArray().add(new JsonObject().put("bar", "bye")));
        listHandler.handle(list);
    }

    @Override
    public void methodWithHandlerSetJsonArray(Handler<Set<JsonArray>> listHandler) {
        LinkedHashSet<JsonArray> set = new LinkedHashSet<JsonArray>(Arrays.asList(new JsonArray().add("green").add("blue"), new JsonArray().add("yellow").add("purple")));
        listHandler.handle(set);
    }

    @Override
    public void methodWithHandlerSetNullJsonArray(Handler<Set<JsonArray>> listHandler) {
        Set<Object> set = Collections.singleton(null);
        listHandler.handle(set);
    }

    @Override
    public void methodWithHandlerSetComplexJsonArray(Handler<Set<JsonArray>> setHandler) {
        List<JsonArray> list = Arrays.asList(new JsonArray().add(new JsonObject().put("foo", "hello")), new JsonArray().add(new JsonObject().put("bar", "bye")));
        LinkedHashSet<JsonArray> set = new LinkedHashSet<JsonArray>(list);
        setHandler.handle(set);
    }

    @Override
    public void methodWithHandlerListDataObject(Handler<List<TestDataObject>> listHandler) {
        List<TestDataObject> list = Arrays.asList(new TestDataObject().setFoo("String 1").setBar(1).setWibble(1.1), new TestDataObject().setFoo("String 2").setBar(2).setWibble(2.2));
        listHandler.handle(list);
    }

    @Override
    public void methodWithHandlerListNullDataObject(Handler<List<TestDataObject>> listHandler) {
        List<Object> list = Collections.singletonList(null);
        listHandler.handle(list);
    }

    @Override
    public void methodWithHandlerSetDataObject(Handler<Set<TestDataObject>> setHandler) {
        LinkedHashSet<TestDataObject> set = new LinkedHashSet<TestDataObject>(Arrays.asList(new TestDataObject().setFoo("String 1").setBar(1).setWibble(1.1), new TestDataObject().setFoo("String 2").setBar(2).setWibble(2.2)));
        setHandler.handle(set);
    }

    @Override
    public void methodWithHandlerSetNullDataObject(Handler<Set<TestDataObject>> setHandler) {
        Set<Object> set = Collections.singleton(null);
        setHandler.handle(set);
    }

    @Override
    public void methodWithHandlerListEnum(Handler<List<TestEnum>> listHandler) {
        listHandler.handle(Arrays.asList(TestEnum.TIM, TestEnum.JULIEN));
    }

    @Override
    public void methodWithHandlerSetEnum(Handler<Set<TestEnum>> setHandler) {
        setHandler.handle(new LinkedHashSet<TestEnum>(Arrays.asList(TestEnum.TIM, TestEnum.JULIEN)));
    }

    @Override
    public void methodWithHandlerAsyncResultListVertxGen(Handler<AsyncResult<List<RefedInterface1>>> listHandler) {
        List<RefedInterface1> list = Arrays.asList(new RefedInterface1Impl().setString("foo"), new RefedInterface1Impl().setString("bar"));
        listHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void methodWithHandlerAsyncResultSetVertxGen(Handler<AsyncResult<Set<RefedInterface1>>> setHandler) {
        LinkedHashSet<RefedInterface1> list = new LinkedHashSet<RefedInterface1>(Arrays.asList(new RefedInterface1Impl().setString("foo"), new RefedInterface1Impl().setString("bar")));
        setHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void methodWithHandlerAsyncResultListAbstractVertxGen(Handler<AsyncResult<List<RefedInterface2>>> listHandler) {
        List<RefedInterface2> list = Arrays.asList(new RefedInterface2Impl().setString("abstractfoo"), new RefedInterface2Impl().setString("abstractbar"));
        listHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void methodWithHandlerAsyncResultSetAbstractVertxGen(Handler<AsyncResult<Set<RefedInterface2>>> setHandler) {
        LinkedHashSet<RefedInterface2> list = new LinkedHashSet<RefedInterface2>(Arrays.asList(new RefedInterface2Impl().setString("abstractfoo"), new RefedInterface2Impl().setString("abstractbar")));
        setHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void methodWithHandlerAsyncResultListJsonObject(Handler<AsyncResult<List<JsonObject>>> listHandler) {
        List<JsonObject> list = Arrays.asList(new JsonObject().put("cheese", "stilton"), new JsonObject().put("socks", "tartan"));
        listHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void methodWithHandlerAsyncResultListNullJsonObject(Handler<AsyncResult<List<JsonObject>>> listHandler) {
        List<Object> list = Collections.singletonList(null);
        listHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void methodWithHandlerAsyncResultListComplexJsonObject(Handler<AsyncResult<List<JsonObject>>> listHandler) {
        List<JsonObject> list = Arrays.asList(new JsonObject().put("outer", new JsonObject().put("socks", "tartan")).put("list", new JsonArray().add("yellow").add("blue")));
        listHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void methodWithHandlerAsyncResultSetJsonObject(Handler<AsyncResult<Set<JsonObject>>> setHandler) {
        LinkedHashSet<JsonObject> set = new LinkedHashSet<JsonObject>(Arrays.asList(new JsonObject().put("cheese", "stilton"), new JsonObject().put("socks", "tartan")));
        setHandler.handle((Object)Future.succeededFuture(set));
    }

    @Override
    public void methodWithHandlerAsyncResultSetNullJsonObject(Handler<AsyncResult<Set<JsonObject>>> setHandler) {
        Set<Object> set = Collections.singleton(null);
        setHandler.handle((Object)Future.succeededFuture(set));
    }

    @Override
    public void methodWithHandlerAsyncResultSetComplexJsonObject(Handler<AsyncResult<Set<JsonObject>>> setHandler) {
        LinkedHashSet<JsonObject> set = new LinkedHashSet<JsonObject>(Arrays.asList(new JsonObject().put("outer", new JsonObject().put("socks", "tartan")).put("list", new JsonArray().add("yellow").add("blue"))));
        setHandler.handle((Object)Future.succeededFuture(set));
    }

    @Override
    public void methodWithHandlerAsyncResultListJsonArray(Handler<AsyncResult<List<JsonArray>>> listHandler) {
        List<JsonArray> list = Arrays.asList(new JsonArray().add("green").add("blue"), new JsonArray().add("yellow").add("purple"));
        listHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void methodWithHandlerAsyncResultListNullJsonArray(Handler<AsyncResult<List<JsonArray>>> listHandler) {
        List<Object> list = Collections.singletonList(null);
        listHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void methodWithHandlerAsyncResultListComplexJsonArray(Handler<AsyncResult<List<JsonArray>>> listHandler) {
        List<JsonArray> list = Arrays.asList(new JsonArray().add(new JsonObject().put("foo", "hello")), new JsonArray().add(new JsonObject().put("bar", "bye")));
        listHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void methodWithHandlerAsyncResultSetJsonArray(Handler<AsyncResult<Set<JsonArray>>> listHandler) {
        LinkedHashSet<JsonArray> set = new LinkedHashSet<JsonArray>(Arrays.asList(new JsonArray().add("green").add("blue"), new JsonArray().add("yellow").add("purple")));
        listHandler.handle((Object)Future.succeededFuture(set));
    }

    @Override
    public void methodWithHandlerAsyncResultSetNullJsonArray(Handler<AsyncResult<Set<JsonArray>>> listHandler) {
        Set<Object> set = Collections.singleton(null);
        listHandler.handle((Object)Future.succeededFuture(set));
    }

    @Override
    public void methodWithHandlerAsyncResultSetComplexJsonArray(Handler<AsyncResult<Set<JsonArray>>> listHandler) {
        LinkedHashSet<JsonArray> set = new LinkedHashSet<JsonArray>(Arrays.asList(new JsonArray().add(new JsonObject().put("foo", "hello")), new JsonArray().add(new JsonObject().put("bar", "bye"))));
        listHandler.handle((Object)Future.succeededFuture(set));
    }

    @Override
    public void methodWithHandlerAsyncResultListDataObject(Handler<AsyncResult<List<TestDataObject>>> listHandler) {
        List<TestDataObject> list = Arrays.asList(new TestDataObject().setFoo("String 1").setBar(1).setWibble(1.1), new TestDataObject().setFoo("String 2").setBar(2).setWibble(2.2));
        listHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void methodWithHandlerAsyncResultListNullDataObject(Handler<AsyncResult<List<TestDataObject>>> listHandler) {
        List<Object> list = Collections.singletonList(null);
        listHandler.handle((Object)Future.succeededFuture(list));
    }

    @Override
    public void methodWithHandlerAsyncResultSetDataObject(Handler<AsyncResult<Set<TestDataObject>>> setHandler) {
        LinkedHashSet<TestDataObject> set = new LinkedHashSet<TestDataObject>(Arrays.asList(new TestDataObject().setFoo("String 1").setBar(1).setWibble(1.1), new TestDataObject().setFoo("String 2").setBar(2).setWibble(2.2)));
        setHandler.handle((Object)Future.succeededFuture(set));
    }

    @Override
    public void methodWithHandlerAsyncResultSetNullDataObject(Handler<AsyncResult<Set<TestDataObject>>> setHandler) {
        Set<Object> set = Collections.singleton(null);
        setHandler.handle((Object)Future.succeededFuture(set));
    }

    @Override
    public void methodWithHandlerAsyncResultListEnum(Handler<AsyncResult<List<TestEnum>>> listHandler) {
        listHandler.handle((Object)Future.succeededFuture(Arrays.asList(TestEnum.TIM, TestEnum.JULIEN)));
    }

    @Override
    public void methodWithHandlerAsyncResultSetEnum(Handler<AsyncResult<Set<TestEnum>>> setHandler) {
        setHandler.handle((Object)Future.succeededFuture(new LinkedHashSet<TestEnum>(Arrays.asList(TestEnum.TIM, TestEnum.JULIEN))));
    }

    @Override
    public void methodWithHandlerUserTypes(Handler<RefedInterface1> handler) {
        RefedInterface1Impl refed = new RefedInterface1Impl();
        refed.setString("echidnas");
        handler.handle((Object)refed);
    }

    @Override
    public void methodWithHandlerAsyncResultUserTypes(Handler<AsyncResult<RefedInterface1>> handler) {
        RefedInterface1Impl refed = new RefedInterface1Impl();
        refed.setString("cheetahs");
        handler.handle((Object)Future.succeededFuture((Object)refed));
    }

    @Override
    public void methodWithConcreteHandlerUserTypeSubtype(ConcreteHandlerUserType handler) {
        RefedInterface1Impl refed = new RefedInterface1Impl();
        refed.setString("echidnas");
        handler.handle(refed);
    }

    @Override
    public void methodWithAbstractHandlerUserTypeSubtype(AbstractHandlerUserType handler) {
        RefedInterface1Impl refed = new RefedInterface1Impl();
        refed.setString("echidnas");
        handler.handle(refed);
    }

    @Override
    public void methodWithConcreteHandlerUserTypeSubtypeExtension(ConcreteHandlerUserTypeExtension handler) {
        RefedInterface1Impl refed = new RefedInterface1Impl();
        refed.setString("echidnas");
        handler.handle(refed);
    }

    @Override
    public void methodWithHandlerVoid(Handler<Void> handler) {
        handler.handle(null);
    }

    @Override
    public void methodWithHandlerAsyncResultVoid(boolean sendFailure, Handler<AsyncResult<Void>> handler) {
        if (sendFailure) {
            handler.handle((Object)Future.failedFuture((Throwable)new VertxException("foo!")));
        } else {
            handler.handle((Object)Future.succeededFuture((Object)null));
        }
    }

    @Override
    public void methodWithHandlerThrowable(Handler<Throwable> handler) {
        handler.handle((Object)new VertxException("cheese!"));
    }

    @Override
    public void methodWithHandlerDataObject(Handler<TestDataObject> handler) {
        handler.handle((Object)this.methodWithDataObjectReturn());
    }

    @Override
    public <U> void methodWithHandlerGenericUserType(U value, Handler<GenericRefedInterface<U>> handler) {
        GenericRefedInterfaceImpl<U> userObj = new GenericRefedInterfaceImpl<U>();
        userObj.setValue(value);
        handler.handle(userObj);
    }

    @Override
    public <U> void methodWithHandlerAsyncResultGenericUserType(U value, Handler<AsyncResult<GenericRefedInterface<U>>> handler) {
        GenericRefedInterfaceImpl<U> userObj = new GenericRefedInterfaceImpl<U>();
        userObj.setValue(value);
        handler.handle((Object)Future.succeededFuture(userObj));
    }

    @Override
    public byte methodWithByteReturn() {
        return 123;
    }

    @Override
    public short methodWithShortReturn() {
        return 12345;
    }

    @Override
    public int methodWithIntReturn() {
        return 12345464;
    }

    @Override
    public long methodWithLongReturn() {
        return 65675123L;
    }

    @Override
    public float methodWithFloatReturn() {
        return 1.23f;
    }

    @Override
    public double methodWithDoubleReturn() {
        return 3.34535;
    }

    @Override
    public boolean methodWithBooleanReturn() {
        return true;
    }

    @Override
    public char methodWithCharReturn() {
        return 'Y';
    }

    @Override
    public String methodWithStringReturn() {
        return "orangutan";
    }

    @Override
    public RefedInterface1 methodWithVertxGenReturn() {
        RefedInterface1Impl refed = new RefedInterface1Impl();
        refed.setString("chaffinch");
        return refed;
    }

    @Override
    public RefedInterface1 methodWithVertxGenNullReturn() {
        return null;
    }

    @Override
    public RefedInterface2 methodWithAbstractVertxGenReturn() {
        RefedInterface2Impl refed = new RefedInterface2Impl();
        refed.setString("abstractchaffinch");
        return refed;
    }

    @Override
    public TestDataObject methodWithDataObjectReturn() {
        return new TestDataObject().setFoo("foo").setBar(123);
    }

    @Override
    public TestDataObject methodWithDataObjectNullReturn() {
        return null;
    }

    @Override
    public String overloadedMethod(String str, RefedInterface1 refed) {
        Assert.assertEquals((Object)"cat", (Object)str);
        Assert.assertEquals((Object)"dog", (Object)refed.getString());
        return "meth1";
    }

    @Override
    public String overloadedMethod(String str, RefedInterface1 refed, long period, Handler<String> handler) {
        Assert.assertEquals((Object)"cat", (Object)str);
        Assert.assertEquals((Object)"dog", (Object)refed.getString());
        Assert.assertEquals((long)12345L, (long)period);
        Assert.assertNotNull(handler);
        handler.handle((Object)"giraffe");
        return "meth2";
    }

    @Override
    public String overloadedMethod(String str, Handler<String> handler) {
        Assert.assertEquals((Object)"cat", (Object)str);
        Assert.assertNotNull(handler);
        handler.handle((Object)"giraffe");
        return "meth3";
    }

    @Override
    public String overloadedMethod(String str, RefedInterface1 refed, Handler<String> handler) {
        Assert.assertEquals((Object)"cat", (Object)str);
        Assert.assertEquals((Object)"dog", (Object)refed.getString());
        Assert.assertNotNull(handler);
        handler.handle((Object)"giraffe");
        return "meth4";
    }

    @Override
    public void superMethodWithBasicParams(byte b, short s, int i, long l, float f, double d, boolean bool, char ch, String str) {
        Assert.assertEquals((long)123L, (long)b);
        Assert.assertEquals((long)12345L, (long)s);
        Assert.assertEquals((long)1234567L, (long)i);
        Assert.assertEquals((long)1265615234L, (long)l);
        Assert.assertEquals((float)12.345f, (float)f, (float)0.0f);
        Assert.assertEquals((double)12.34566, (double)d, (double)0.0);
        Assert.assertTrue((boolean)bool);
        Assert.assertEquals((long)88L, (long)ch);
        Assert.assertEquals((Object)"foobar", (Object)str);
    }

    @Override
    public void otherSuperMethodWithBasicParams(byte b, short s, int i, long l, float f, double d, boolean bool, char ch, String str) {
        this.superMethodWithBasicParams(b, s, i, l, f, d, bool, ch, str);
    }

    @Override
    public <U> U methodWithGenericReturn(String type) {
        switch (type) {
            case "Boolean": {
                return (U)Boolean.valueOf(true);
            }
            case "Byte": {
                return (U)Byte.valueOf((byte)123);
            }
            case "Short": {
                return (U)Short.valueOf((short)12345);
            }
            case "Integer": {
                return (U)Integer.valueOf(1234567);
            }
            case "Long": {
                return (U)Long.valueOf(1265615234L);
            }
            case "Float": {
                return (U)Float.valueOf(12.345f);
            }
            case "Double": {
                return (U)Double.valueOf(12.34566);
            }
            case "Character": {
                return (U)Character.valueOf('x');
            }
            case "String": {
                return (U)"foo";
            }
            case "Ref": {
                return (U)new RefedInterface1Impl().setString("bar");
            }
            case "JsonObject": {
                return (U)new JsonObject().put("foo", "hello").put("bar", Integer.valueOf(123));
            }
            case "JsonObjectLong": {
                return (U)new JsonObject().put("foo", "hello").put("bar", Long.valueOf(123L));
            }
            case "JsonObjectComplex": {
                return (U)new JsonObject().put("outer", new JsonObject().put("foo", "hello")).put("bar", new JsonArray().add("this").add("that"));
            }
            case "JsonArray": {
                return (U)new JsonArray().add("foo").add("bar").add("wib");
            }
        }
        throw new AssertionError((Object)("Unexpected " + type));
    }

    @Override
    public <U> void methodWithGenericParam(String type, U u) {
        U expected = this.methodWithGenericReturn(type);
        Assert.assertEquals(expected.getClass(), u.getClass());
        Assert.assertEquals(expected, u);
    }

    @Override
    public <U> void methodWithGenericHandler(String type, Handler<U> handler) {
        U value = this.methodWithGenericReturn(type);
        handler.handle(value);
    }

    @Override
    public <U> void methodWithGenericHandlerAsyncResult(String type, Handler<AsyncResult<U>> asyncResultHandler) {
        U value = this.methodWithGenericReturn(type);
        asyncResultHandler.handle((Object)Future.succeededFuture(value));
    }

    @Override
    public TestInterface fluentMethod(String str) {
        Assert.assertEquals((Object)"bar", (Object)str);
        return this;
    }

    @Override
    public RefedInterface1 methodWithCachedReturn(String foo) {
        RefedInterface1Impl refed = new RefedInterface1Impl();
        refed.setString(foo);
        return refed;
    }

    @Override
    public int methodWithCachedReturnPrimitive(int arg) {
        return arg;
    }

    @Override
    public List<RefedInterface1> methodWithCachedListReturn() {
        return Arrays.asList(new RefedInterface1Impl().setString("foo"), new RefedInterface1Impl().setString("bar"));
    }

    @Override
    public JsonObject methodWithJsonObjectReturn() {
        return new JsonObject().put("cheese", "stilton");
    }

    @Override
    public JsonObject methodWithNullJsonObjectReturn() {
        return null;
    }

    @Override
    public JsonObject methodWithComplexJsonObjectReturn() {
        return new JsonObject().put("outer", new JsonObject().put("socks", "tartan")).put("list", new JsonArray().add("yellow").add("blue"));
    }

    @Override
    public JsonArray methodWithJsonArrayReturn() {
        return new JsonArray().add("socks").add("shoes");
    }

    @Override
    public JsonArray methodWithNullJsonArrayReturn() {
        return null;
    }

    @Override
    public JsonArray methodWithComplexJsonArrayReturn() {
        return new JsonArray().add(new JsonObject().put("foo", "hello")).add(new JsonObject().put("bar", "bye"));
    }

    @Override
    public void methodWithJsonParams(JsonObject jsonObject, JsonArray jsonArray) {
        Assert.assertNotNull((Object)jsonObject);
        Assert.assertNotNull((Object)jsonArray);
        Assert.assertEquals((Object)"lion", (Object)jsonObject.getString("cat"));
        Assert.assertEquals((Object)"cheddar", (Object)jsonObject.getString("cheese"));
        Assert.assertEquals((Object)"house", (Object)jsonArray.getString(0));
        Assert.assertEquals((Object)"spider", (Object)jsonArray.getString(1));
    }

    @Override
    public void methodWithNullJsonParams(JsonObject jsonObject, JsonArray jsonArray) {
        Assert.assertNull((Object)jsonObject);
        Assert.assertNull((Object)jsonArray);
    }

    @Override
    public void methodWithHandlerJson(Handler<JsonObject> jsonObjectHandler, Handler<JsonArray> jsonArrayHandler) {
        Assert.assertNotNull(jsonObjectHandler);
        Assert.assertNotNull(jsonArrayHandler);
        jsonObjectHandler.handle((Object)new JsonObject().put("cheese", "stilton"));
        jsonArrayHandler.handle((Object)new JsonArray().add("socks").add("shoes"));
    }

    @Override
    public void methodWithHandlerNullJson(Handler<JsonObject> jsonObjectHandler, Handler<JsonArray> jsonArrayHandler) {
        Assert.assertNotNull(jsonObjectHandler);
        Assert.assertNotNull(jsonArrayHandler);
        jsonObjectHandler.handle(null);
        jsonArrayHandler.handle(null);
    }

    @Override
    public void methodWithHandlerComplexJson(Handler<JsonObject> jsonObjectHandler, Handler<JsonArray> jsonArrayHandler) {
        Assert.assertNotNull(jsonObjectHandler);
        Assert.assertNotNull(jsonArrayHandler);
        jsonObjectHandler.handle((Object)new JsonObject().put("outer", new JsonObject().put("socks", "tartan")).put("list", new JsonArray().add("yellow").add("blue")));
        jsonArrayHandler.handle((Object)new JsonArray().add(new JsonArray().add(new JsonObject().put("foo", "hello"))).add(new JsonArray().add(new JsonObject().put("bar", "bye"))));
    }

    @Override
    public void methodWithHandlerAsyncResultJsonObject(Handler<AsyncResult<JsonObject>> handler) {
        Assert.assertNotNull(handler);
        handler.handle((Object)Future.succeededFuture((Object)new JsonObject().put("cheese", "stilton")));
    }

    @Override
    public void methodWithHandlerAsyncResultNullJsonObject(Handler<AsyncResult<JsonObject>> handler) {
        Assert.assertNotNull(handler);
        handler.handle((Object)Future.succeededFuture(null));
    }

    @Override
    public void methodWithHandlerAsyncResultComplexJsonObject(Handler<AsyncResult<JsonObject>> handler) {
        Assert.assertNotNull(handler);
        handler.handle((Object)Future.succeededFuture((Object)new JsonObject().put("outer", new JsonObject().put("socks", "tartan")).put("list", new JsonArray().add("yellow").add("blue"))));
    }

    @Override
    public void methodWithHandlerAsyncResultJsonArray(Handler<AsyncResult<JsonArray>> handler) {
        Assert.assertNotNull(handler);
        handler.handle((Object)Future.succeededFuture((Object)new JsonArray().add("socks").add("shoes")));
    }

    @Override
    public void methodWithHandlerAsyncResultNullJsonArray(Handler<AsyncResult<JsonArray>> handler) {
        Assert.assertNotNull(handler);
        handler.handle((Object)Future.succeededFuture(null));
    }

    @Override
    public void methodWithHandlerAsyncResultComplexJsonArray(Handler<AsyncResult<JsonArray>> handler) {
        Assert.assertNotNull(handler);
        handler.handle((Object)Future.succeededFuture((Object)new JsonArray().add(new JsonObject().put("foo", "hello")).add(new JsonObject().put("bar", "bye"))));
    }

    @Override
    public List<String> methodWithListStringReturn() {
        return Arrays.asList("foo", "bar", "wibble");
    }

    @Override
    public Set<String> methodWithSetStringReturn() {
        return new LinkedHashSet<String>(Arrays.asList("foo", "bar", "wibble"));
    }

    @Override
    public Map<String, String> methodWithMapReturn(Handler<String> handler) {
        HandlerTestMap<String> map = new HandlerTestMap<String>(handler);
        return map;
    }

    @Override
    public Map<String, String> methodWithMapStringReturn(Handler<String> handler) {
        StringHandlerTestMap map = new StringHandlerTestMap(handler);
        map.put("foo", "bar");
        return map;
    }

    @Override
    public Map<String, JsonObject> methodWithMapJsonObjectReturn(Handler<String> handler) {
        JsonObjectHandlerTestMap map = new JsonObjectHandlerTestMap(handler);
        map.put("foo", new JsonObject().put("wibble", "eek"));
        return map;
    }

    @Override
    public Map<String, JsonObject> methodWithMapComplexJsonObjectReturn(Handler<String> handler) {
        JsonObjectHandlerTestMap map = new JsonObjectHandlerTestMap(handler);
        map.put("foo", new JsonObject().put("outer", new JsonObject().put("socks", "tartan")).put("list", new JsonArray().add("yellow").add("blue")));
        return map;
    }

    @Override
    public Map<String, JsonArray> methodWithMapJsonArrayReturn(Handler<String> handler) {
        JsonArrayHandlerTestMap map = new JsonArrayHandlerTestMap(handler);
        map.put("foo", new JsonArray().add("wibble"));
        return map;
    }

    @Override
    public Map<String, JsonArray> methodWithMapComplexJsonArrayReturn(Handler<String> handler) {
        JsonArrayHandlerTestMap map = new JsonArrayHandlerTestMap(handler);
        map.put("foo", new JsonArray().add(new JsonObject().put("foo", "hello")).add(new JsonObject().put("bar", "bye")));
        return map;
    }

    @Override
    public Map<String, Long> methodWithMapLongReturn(Handler<String> handler) {
        LongHandlerTestMap map = new LongHandlerTestMap(handler);
        map.put("foo", Long.valueOf(123L));
        return map;
    }

    @Override
    public Map<String, Integer> methodWithMapIntegerReturn(Handler<String> handler) {
        IntegerHandlerTestMap map = new IntegerHandlerTestMap(handler);
        map.put("foo", Integer.valueOf(123));
        return map;
    }

    @Override
    public Map<String, Short> methodWithMapShortReturn(Handler<String> handler) {
        ShortHandlerTestMap map = new ShortHandlerTestMap(handler);
        map.put("foo", Short.valueOf((short)123));
        return map;
    }

    @Override
    public Map<String, Byte> methodWithMapByteReturn(Handler<String> handler) {
        ByteHandlerTestMap map = new ByteHandlerTestMap(handler);
        map.put("foo", Byte.valueOf((byte)123));
        return map;
    }

    @Override
    public Map<String, Character> methodWithMapCharacterReturn(Handler<String> handler) {
        CharacterHandlerTestMap map = new CharacterHandlerTestMap(handler);
        map.put("foo", Character.valueOf('X'));
        return map;
    }

    @Override
    public Map<String, Boolean> methodWithMapBooleanReturn(Handler<String> handler) {
        BooleanHandlerTestMap map = new BooleanHandlerTestMap(handler);
        map.put("foo", Boolean.valueOf(true));
        return map;
    }

    @Override
    public Map<String, Float> methodWithMapFloatReturn(Handler<String> handler) {
        FloatHandlerTestMap map = new FloatHandlerTestMap(handler);
        map.put("foo", Float.valueOf(0.123f));
        return map;
    }

    @Override
    public Map<String, Double> methodWithMapDoubleReturn(Handler<String> handler) {
        DoubleHandlerTestMap map = new DoubleHandlerTestMap(handler);
        map.put("foo", Double.valueOf(0.123));
        return map;
    }

    @Override
    public Map<String, String> methodWithNullMapReturn() {
        return null;
    }

    @Override
    public List<Long> methodWithListLongReturn() {
        return Arrays.asList(123L, 456L);
    }

    @Override
    public List<RefedInterface1> methodWithListVertxGenReturn() {
        return Arrays.asList(new RefedInterface1Impl().setString("foo"), new RefedInterface1Impl().setString("bar"));
    }

    @Override
    public List<JsonObject> methodWithListJsonObjectReturn() {
        return Arrays.asList(new JsonObject().put("foo", "bar"), new JsonObject().put("blah", "eek"));
    }

    @Override
    public List<JsonObject> methodWithListComplexJsonObjectReturn() {
        return Arrays.asList(new JsonObject().put("outer", new JsonObject().put("socks", "tartan")).put("list", new JsonArray().add("yellow").add("blue")));
    }

    @Override
    public List<JsonArray> methodWithListJsonArrayReturn() {
        return Arrays.asList(new JsonArray().add("foo"), new JsonArray().add("blah"));
    }

    @Override
    public List<JsonArray> methodWithListComplexJsonArrayReturn() {
        return Arrays.asList(new JsonArray().add(new JsonObject().put("foo", "hello")), new JsonArray().add(new JsonObject().put("bar", "bye")));
    }

    @Override
    public List<TestDataObject> methodWithListDataObjectReturn() {
        return Arrays.asList(new TestDataObject().setFoo("String 1").setBar(1).setWibble(1.1), new TestDataObject().setFoo("String 2").setBar(2).setWibble(2.2));
    }

    @Override
    public List<TestEnum> methodWithListEnumReturn() {
        return Arrays.asList(TestEnum.JULIEN, TestEnum.TIM);
    }

    @Override
    public List<String> methodWithNullListReturn() {
        return null;
    }

    @Override
    public Set<Long> methodWithSetLongReturn() {
        return new LinkedHashSet<Long>(Arrays.asList(123L, 456L));
    }

    @Override
    public Set<RefedInterface1> methodWithSetVertxGenReturn() {
        return new LinkedHashSet<RefedInterface1>(Arrays.asList(new RefedInterface1Impl().setString("foo"), new RefedInterface1Impl().setString("bar")));
    }

    @Override
    public Set<JsonObject> methodWithSetJsonObjectReturn() {
        return new LinkedHashSet<JsonObject>(Arrays.asList(new JsonObject().put("foo", "bar"), new JsonObject().put("blah", "eek")));
    }

    @Override
    public Set<JsonObject> methodWithSetComplexJsonObjectReturn() {
        return new LinkedHashSet<JsonObject>(Arrays.asList(new JsonObject().put("outer", new JsonObject().put("socks", "tartan")).put("list", new JsonArray().add("yellow").add("blue"))));
    }

    @Override
    public Set<JsonArray> methodWithSetJsonArrayReturn() {
        return new LinkedHashSet<JsonArray>(Arrays.asList(new JsonArray().add("foo"), new JsonArray().add("blah")));
    }

    @Override
    public Set<JsonArray> methodWithSetComplexJsonArrayReturn() {
        return new LinkedHashSet<JsonArray>(Arrays.asList(new JsonArray().add(new JsonObject().put("foo", "hello")), new JsonArray().add(new JsonObject().put("bar", "bye"))));
    }

    @Override
    public Set<TestDataObject> methodWithSetDataObjectReturn() {
        return new LinkedHashSet<TestDataObject>(this.methodWithListDataObjectReturn());
    }

    @Override
    public Set<TestEnum> methodWithSetEnumReturn() {
        return new LinkedHashSet<TestEnum>(this.methodWithListEnumReturn());
    }

    @Override
    public Set<String> methodWithNullSetReturn() {
        return null;
    }

    @Override
    public String methodWithEnumParam(String strVal, TestEnum weirdo) {
        return strVal + (Object)((Object)weirdo);
    }

    @Override
    public TestEnum methodWithEnumReturn(String strVal) {
        return TestEnum.valueOf(strVal);
    }

    @Override
    public String methodWithGenEnumParam(String strVal, TestGenEnum weirdo) {
        return strVal + (Object)((Object)weirdo);
    }

    @Override
    public TestGenEnum methodWithGenEnumReturn(String strVal) {
        return TestGenEnum.valueOf(strVal);
    }

    @Override
    public Throwable methodWithThrowableReturn(String strVal) {
        return new Exception(strVal);
    }

    @Override
    public String methodWithThrowableParam(Throwable t) {
        return t.getMessage();
    }

    @Override
    public int superMethodOverloadedBySubclass(String s) {
        return 1;
    }

    @Override
    public int superMethodOverloadedBySubclass() {
        return 0;
    }

    private static class BooleanHandlerTestMap
    extends HandlerTestMap<Boolean> {
        public BooleanHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public Boolean put(String key, Boolean value) {
            return super.put(key, value);
        }
    }

    private static class StringHandlerTestMap
    extends HandlerTestMap<String> {
        public StringHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public String put(String key, String value) {
            return super.put(key, value);
        }
    }

    private static class JsonObjectHandlerTestMap
    extends HandlerTestMap<JsonObject> {
        public JsonObjectHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public JsonObject put(String key, JsonObject value) {
            return super.put(key, value);
        }
    }

    private static class EnumHandlerTestMap
    extends HandlerTestMap<TestEnum> {
        public EnumHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public TestEnum put(String key, TestEnum value) {
            return super.put(key, value);
        }
    }

    private static class DataObjectHandlerTestMap
    extends HandlerTestMap<TestDataObject> {
        public DataObjectHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public TestDataObject put(String key, TestDataObject value) {
            return super.put(key, value);
        }
    }

    private static class JsonArrayHandlerTestMap
    extends HandlerTestMap<JsonArray> {
        public JsonArrayHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public JsonArray put(String key, JsonArray value) {
            return super.put(key, value);
        }
    }

    private static class LongHandlerTestMap
    extends HandlerTestMap<Long> {
        public LongHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public Long put(String key, Long value) {
            return super.put(key, value);
        }
    }

    private static class ShortHandlerTestMap
    extends HandlerTestMap<Short> {
        public ShortHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public Short put(String key, Short value) {
            return super.put(key, value);
        }
    }

    private static class IntegerHandlerTestMap
    extends HandlerTestMap<Integer> {
        public IntegerHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public Integer put(String key, Integer value) {
            return super.put(key, value);
        }
    }

    private static class ByteHandlerTestMap
    extends HandlerTestMap<Byte> {
        public ByteHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public Byte put(String key, Byte value) {
            return super.put(key, value);
        }
    }

    private static class CharacterHandlerTestMap
    extends HandlerTestMap<Character> {
        public CharacterHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public Character put(String key, Character value) {
            return super.put(key, value);
        }
    }

    private static class FloatHandlerTestMap
    extends HandlerTestMap<Float> {
        public FloatHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public Float put(String key, Float value) {
            return super.put(key, value);
        }
    }

    private static class HandlerTestMap<V>
    implements Map<String, V> {
        private Handler<String> handler;
        private Map<String, V> map = new HashMap<String, V>();

        private HandlerTestMap(Handler<String> handler) {
            this.handler = handler;
        }

        @Override
        public int size() {
            this.handler.handle((Object)"size()");
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            this.handler.handle((Object)"isEmpty()");
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            this.handler.handle((Object)("containsKey(" + key + ")"));
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            this.handler.handle((Object)("containsValue(" + value + ")"));
            return this.map.containsValue(value);
        }

        @Override
        public V get(Object key) {
            this.handler.handle((Object)("get(" + key + ")"));
            return this.map.get(key);
        }

        @Override
        public V put(String key, V value) {
            this.handler.handle((Object)("put(" + key + "," + value + ")"));
            return this.map.put(key, value);
        }

        @Override
        public V remove(Object key) {
            this.handler.handle((Object)("remove(" + key + ")"));
            return this.map.remove(key);
        }

        @Override
        public void putAll(Map<? extends String, ? extends V> m) {
            this.handler.handle((Object)"putAll(m)");
            this.map.putAll(m);
        }

        @Override
        public void clear() {
            this.handler.handle((Object)"clear()");
            this.map.clear();
        }

        @Override
        public Set<String> keySet() {
            this.handler.handle((Object)"keySet()");
            return this.map.keySet();
        }

        @Override
        public Collection<V> values() {
            this.handler.handle((Object)"values()");
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<String, V>> entrySet() {
            this.handler.handle((Object)"entrySet()");
            return this.map.entrySet();
        }
    }

    static class DoubleHandlerTestMap
    extends HandlerTestMap<Double> {
        public DoubleHandlerTestMap(Handler<String> handler) {
            super(handler);
        }

        @Override
        public Double put(String key, Double value) {
            return super.put(key, value);
        }
    }
}

