/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.testmodel;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.testmodel.FunctionParamTCK;
import io.vertx.codegen.testmodel.GenericRefedInterface;
import io.vertx.codegen.testmodel.GenericRefedInterfaceImpl;
import io.vertx.codegen.testmodel.RefedInterface1;
import io.vertx.codegen.testmodel.TestDataObject;
import io.vertx.codegen.testmodel.TestEnum;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.Assert;

public class FunctionParamTCKImpl
implements FunctionParamTCK {
    @Override
    public List<String> methodWithBasicParam(Function<Byte, String> byteFunc, Function<Short, String> shortFunc, Function<Integer, String> integerFunc, Function<Long, String> longFunc, Function<Float, String> floatFunc, Function<Double, String> doubleFunc, Function<Boolean, String> booleanFunc, Function<Character, String> charFunc, Function<String, String> stringFunc) {
        return Arrays.asList(byteFunc.apply((byte)100), shortFunc.apply((short)1000), integerFunc.apply(100000), longFunc.apply(10000000000L), floatFunc.apply(Float.valueOf(3.5f)), doubleFunc.apply(0.01), booleanFunc.apply(true), charFunc.apply(Character.valueOf('F')), stringFunc.apply("wibble"));
    }

    @Override
    public List<String> methodWithJsonParam(Function<JsonObject, String> objectFunc, Function<JsonArray, String> arrayFunc) {
        return Arrays.asList(objectFunc.apply(new JsonObject().put("one", Integer.valueOf(1)).put("two", Integer.valueOf(2)).put("three", Integer.valueOf(3))), arrayFunc.apply(new JsonArray().add("one").add("two").add("three")));
    }

    @Override
    public String methodWithDataObjectParam(Function<TestDataObject, String> func) {
        return func.apply(new TestDataObject().setFoo("foo_value").setBar(3).setWibble(0.01));
    }

    @Override
    public String methodWithEnumParam(Function<TestEnum, String> func) {
        return func.apply(TestEnum.TIM);
    }

    @Override
    public String methodWithVoidParam(Function<Void, String> func) {
        return func.apply(null);
    }

    @Override
    public String methodWithUserTypeParam(RefedInterface1 arg, Function<RefedInterface1, String> func) {
        return func.apply(arg);
    }

    @Override
    public String methodWithObjectParam(Object arg, Function<Object, String> func) {
        return func.apply(arg);
    }

    @Override
    public String methodWithListParam(Function<List<String>, String> func) {
        return func.apply(Arrays.asList("one", "two", "three"));
    }

    @Override
    public String methodWithSetParam(Function<Set<String>, String> func) {
        return func.apply(new LinkedHashSet<String>(Arrays.asList("one", "two", "three")));
    }

    @Override
    public String methodWithMapParam(Function<Map<String, String>, String> func) {
        return func.apply(Arrays.asList("one", "two", "three").stream().collect(Collectors.toMap(s -> s, s -> s)));
    }

    @Override
    public <T> String methodWithGenericParam(T t, Function<T, String> func) {
        return func.apply(t);
    }

    @Override
    public <T> String methodWithGenericUserTypeParam(T t, Function<GenericRefedInterface<T>, String> func) {
        GenericRefedInterfaceImpl<T> userObj = new GenericRefedInterfaceImpl<T>();
        userObj.setValue(t);
        return func.apply(userObj);
    }

    @Override
    public String methodWithBasicReturn(Function<String, Byte> byteFunc, Function<String, Short> shortFunc, Function<String, Integer> integerFunc, Function<String, Long> longFunc, Function<String, Float> floatFunc, Function<String, Double> doubleFunc, Function<String, Boolean> booleanFunc, Function<String, Character> charFunc, Function<String, String> stringFunc) {
        Assert.assertEquals((long)10L, (long)byteFunc.apply("whatever").byteValue());
        Assert.assertEquals((long)1000L, (long)shortFunc.apply("whatever").shortValue());
        Assert.assertEquals((long)100000L, (long)integerFunc.apply("whatever").intValue());
        Assert.assertEquals((long)10000000000L, (long)longFunc.apply("whatever"));
        Assert.assertEquals((double)0.01f, (double)floatFunc.apply("whatever").floatValue(), (double)0.001);
        Assert.assertEquals((double)1.0E-5, (double)doubleFunc.apply("whatever"), (double)1.0E-6);
        Assert.assertEquals((Object)true, (Object)booleanFunc.apply("whatever"));
        Assert.assertEquals((long)67L, (long)charFunc.apply("whatever").charValue());
        Assert.assertEquals((Object)"the-return", (Object)stringFunc.apply("whatever"));
        return "ok";
    }

    @Override
    public String methodWithJsonReturn(Function<String, JsonObject> objectFunc, Function<String, JsonArray> arrayFunc) {
        Assert.assertEquals((Object)new JsonObject().put("foo", "foo_value").put("bar", Integer.valueOf(10)).put("wibble", Double.valueOf(0.1)), (Object)objectFunc.apply("whatever"));
        Assert.assertEquals((Object)new JsonArray().add("one").add("two").add("three"), (Object)arrayFunc.apply("whatever"));
        return "ok";
    }

    @Override
    public String methodWithObjectReturn(Function<Integer, Object> func) {
        Assert.assertEquals((Object)"the-string", (Object)func.apply(0));
        Assert.assertEquals((long)123L, (long)((Number)func.apply(1)).intValue());
        Assert.assertEquals((Object)true, (Object)func.apply(2));
        Assert.assertEquals((Object)new JsonObject().put("foo", "foo_value"), (Object)func.apply(3));
        Assert.assertEquals((Object)new JsonArray().add("foo").add("bar"), (Object)func.apply(4));
        return "ok";
    }

    @Override
    public String methodWithDataObjectReturn(Function<String, TestDataObject> func) {
        TestDataObject val = func.apply("whatever");
        Assert.assertEquals((Object)"wasabi", (Object)val.getFoo());
        Assert.assertEquals((long)6L, (long)val.getBar());
        Assert.assertEquals((double)0.01, (double)val.getWibble(), (double)0.001);
        return "ok";
    }

    @Override
    public String methodWithEnumReturn(Function<String, TestEnum> func) {
        Assert.assertEquals((Object)((Object)TestEnum.NICK), (Object)((Object)func.apply("whatever")));
        return "ok";
    }

    @Override
    public String methodWithListReturn(Function<String, List<String>> func) {
        Assert.assertEquals(Arrays.asList("one", "two", "three"), func.apply("whatever"));
        return "ok";
    }

    @Override
    public String methodWithSetReturn(Function<String, Set<String>> func) {
        Assert.assertEquals(new HashSet<String>(Arrays.asList("one", "two", "three")), func.apply("whatever"));
        return "ok";
    }

    @Override
    public String methodWithMapReturn(Function<String, Map<String, String>> func) {
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("one", "one");
        expected.put("two", "two");
        expected.put("three", "three");
        Assert.assertEquals(expected, func.apply("whatever"));
        return "ok";
    }

    @Override
    public <T> String methodWithGenericReturn(Function<Integer, T> func) {
        return this.methodWithObjectReturn(func::apply);
    }

    @Override
    public <T> String methodWithGenericUserTypeReturn(Function<GenericRefedInterface<T>, GenericRefedInterface<T>> func) {
        GenericRefedInterfaceImpl impl = new GenericRefedInterfaceImpl();
        Assert.assertEquals(impl, func.apply(impl));
        return "ok";
    }

    @Override
    public String methodWithNullableListParam(Function<@Nullable List<String>, String> func) {
        return func.apply(null);
    }

    @Override
    public String methodWithNullableListReturn(Function<String, @Nullable List<String>> func) {
        Assert.assertEquals(null, func.apply("whatever"));
        return "ok";
    }
}

