/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.http;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.lang.rxjava.ReadStreamAdapter;
import io.vertx.rxjava.core.MultiMap;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.http.HttpServerFileUpload;
import io.vertx.rxjava.core.http.HttpServerResponse;
import io.vertx.rxjava.core.http.ServerWebSocket;
import io.vertx.rxjava.core.net.NetSocket;
import io.vertx.rxjava.core.net.SocketAddress;
import io.vertx.rxjava.core.streams.ReadStream;
import java.util.function.Function;
import rx.Observable;

public class HttpServerRequest
implements ReadStream<Buffer> {
    final io.vertx.core.http.HttpServerRequest delegate;
    private Observable<Buffer> observable;
    private HttpServerResponse cached_0;
    private MultiMap cached_1;
    private MultiMap cached_2;
    private SocketAddress cached_3;
    private SocketAddress cached_4;
    private NetSocket cached_5;
    private MultiMap cached_6;

    public HttpServerRequest(io.vertx.core.http.HttpServerRequest delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<Buffer> toObservable() {
        if (this.observable == null) {
            Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
            ReadStreamAdapter<io.vertx.core.buffer.Buffer, Buffer> adapter = new ReadStreamAdapter<io.vertx.core.buffer.Buffer, Buffer>(this, conv);
            this.observable = Observable.create(adapter);
        }
        return this.observable;
    }

    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpServerRequest handler(final Handler<Buffer> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.core.buffer.Buffer>(){

            public void handle(io.vertx.core.buffer.Buffer event) {
                handler.handle((Object)new Buffer(event));
            }
        });
        return this;
    }

    public HttpServerRequest pause() {
        this.delegate.pause();
        return this;
    }

    public HttpServerRequest resume() {
        this.delegate.resume();
        return this;
    }

    public HttpServerRequest endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public HttpVersion version() {
        HttpVersion ret = this.delegate.version();
        return ret;
    }

    public HttpMethod method() {
        HttpMethod ret = this.delegate.method();
        return ret;
    }

    public String uri() {
        String ret = this.delegate.uri();
        return ret;
    }

    public String path() {
        String ret = this.delegate.path();
        return ret;
    }

    public String query() {
        String ret = this.delegate.query();
        return ret;
    }

    public HttpServerResponse response() {
        HttpServerResponse ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = HttpServerResponse.newInstance(this.delegate.response());
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public String getHeader(String headerName) {
        String ret = this.delegate.getHeader(headerName);
        return ret;
    }

    public MultiMap params() {
        MultiMap ret;
        if (this.cached_2 != null) {
            return this.cached_2;
        }
        this.cached_2 = ret = MultiMap.newInstance(this.delegate.params());
        return ret;
    }

    public String getParam(String paramName) {
        String ret = this.delegate.getParam(paramName);
        return ret;
    }

    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_3 != null) {
            return this.cached_3;
        }
        this.cached_3 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_4 != null) {
            return this.cached_4;
        }
        this.cached_4 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    public String absoluteURI() {
        String ret = this.delegate.absoluteURI();
        return ret;
    }

    public HttpServerRequest bodyHandler(final Handler<Buffer> bodyHandler) {
        this.delegate.bodyHandler((Handler)new Handler<io.vertx.core.buffer.Buffer>(){

            public void handle(io.vertx.core.buffer.Buffer event) {
                bodyHandler.handle((Object)new Buffer(event));
            }
        });
        return this;
    }

    public NetSocket netSocket() {
        NetSocket ret;
        if (this.cached_5 != null) {
            return this.cached_5;
        }
        this.cached_5 = ret = NetSocket.newInstance(this.delegate.netSocket());
        return ret;
    }

    public HttpServerRequest setExpectMultipart(boolean expect) {
        this.delegate.setExpectMultipart(expect);
        return this;
    }

    public boolean isExpectMultipart() {
        boolean ret = this.delegate.isExpectMultipart();
        return ret;
    }

    public HttpServerRequest uploadHandler(final Handler<HttpServerFileUpload> uploadHandler) {
        this.delegate.uploadHandler((Handler)new Handler<io.vertx.core.http.HttpServerFileUpload>(){

            public void handle(io.vertx.core.http.HttpServerFileUpload event) {
                uploadHandler.handle((Object)new HttpServerFileUpload(event));
            }
        });
        return this;
    }

    public MultiMap formAttributes() {
        MultiMap ret;
        if (this.cached_6 != null) {
            return this.cached_6;
        }
        this.cached_6 = ret = MultiMap.newInstance(this.delegate.formAttributes());
        return ret;
    }

    public String getFormAttribute(String attributeName) {
        String ret = this.delegate.getFormAttribute(attributeName);
        return ret;
    }

    public ServerWebSocket upgrade() {
        ServerWebSocket ret = ServerWebSocket.newInstance(this.delegate.upgrade());
        return ret;
    }

    public boolean isEnded() {
        boolean ret = this.delegate.isEnded();
        return ret;
    }

    public static HttpServerRequest newInstance(io.vertx.core.http.HttpServerRequest arg) {
        return arg != null ? new HttpServerRequest(arg) : null;
    }
}

