/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.eventbus;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.lang.rxjava.InternalHelper;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rxjava.core.MultiMap;
import rx.Observable;

public class Message<T> {
    final io.vertx.core.eventbus.Message delegate;
    private T cached_0;

    public Message(io.vertx.core.eventbus.Message delegate) {
        this.delegate = delegate;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public String address() {
        String ret = this.delegate.address();
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public T body() {
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        Object ret = this.delegate.body();
        this.cached_0 = ret;
        return (T)ret;
    }

    public String replyAddress() {
        String ret = this.delegate.replyAddress();
        return ret;
    }

    public void reply(Object message) {
        this.delegate.reply(message);
    }

    public <R> void reply(Object message, final Handler<AsyncResult<Message<R>>> replyHandler) {
        this.delegate.reply(message, new Handler<AsyncResult<io.vertx.core.eventbus.Message<R>>>(){

            public void handle(AsyncResult<io.vertx.core.eventbus.Message<R>> event) {
                Object f = event.succeeded() ? InternalHelper.result(new Message((io.vertx.core.eventbus.Message)event.result())) : InternalHelper.failure(event.cause());
                replyHandler.handle(f);
            }
        });
    }

    public <R> Observable<Message<R>> replyObservable(Object message) {
        ObservableFuture<Message<R>> replyHandler = RxHelper.observableFuture();
        this.reply(message, replyHandler.toHandler());
        return replyHandler;
    }

    public void reply(Object message, DeliveryOptions options) {
        this.delegate.reply(message, options);
    }

    public <R> void reply(Object message, DeliveryOptions options, final Handler<AsyncResult<Message<R>>> replyHandler) {
        this.delegate.reply(message, options, new Handler<AsyncResult<io.vertx.core.eventbus.Message<R>>>(){

            public void handle(AsyncResult<io.vertx.core.eventbus.Message<R>> event) {
                Object f = event.succeeded() ? InternalHelper.result(new Message((io.vertx.core.eventbus.Message)event.result())) : InternalHelper.failure(event.cause());
                replyHandler.handle(f);
            }
        });
    }

    public <R> Observable<Message<R>> replyObservable(Object message, DeliveryOptions options) {
        ObservableFuture<Message<R>> replyHandler = RxHelper.observableFuture();
        this.reply(message, options, replyHandler.toHandler());
        return replyHandler;
    }

    public void fail(int failureCode, String message) {
        this.delegate.fail(failureCode, message);
    }

    public static <T> Message newInstance(io.vertx.core.eventbus.Message arg) {
        return arg != null ? new Message<T>(arg) : null;
    }
}

