/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import rx.Observable;

public class Future<T> {
    final io.vertx.core.Future delegate;

    public Future(io.vertx.core.Future delegate) {
        this.delegate = delegate;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public static <T> Future<T> future() {
        Future ret = Future.newInstance(io.vertx.core.Future.future());
        return ret;
    }

    public static <T> Future<T> succeededFuture() {
        Future ret = Future.newInstance(io.vertx.core.Future.succeededFuture());
        return ret;
    }

    public static <T> Future<T> succeededFuture(T result) {
        Future ret = Future.newInstance(io.vertx.core.Future.succeededFuture(result));
        return ret;
    }

    public static <T> Future<T> failedFuture(String failureMessage) {
        Future ret = Future.newInstance(io.vertx.core.Future.failedFuture((String)failureMessage));
        return ret;
    }

    public boolean isComplete() {
        boolean ret = this.delegate.isComplete();
        return ret;
    }

    public void setHandler(Handler<AsyncResult<T>> handler) {
        this.delegate.setHandler(handler);
    }

    public Observable<T> setHandlerObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setHandler(handler.toHandler());
        return handler;
    }

    public void complete(T result) {
        this.delegate.complete(result);
    }

    public void complete() {
        this.delegate.complete();
    }

    public void fail(String failureMessage) {
        this.delegate.fail(failureMessage);
    }

    public static <T> Future newInstance(io.vertx.core.Future arg) {
        return arg != null ? new Future<T>(arg) : null;
    }
}

