/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rxjava.core.Future;
import io.vertx.rxjava.core.Vertx;
import java.util.List;
import rx.Observable;

public class Context {
    final io.vertx.core.Context delegate;

    public Context(io.vertx.core.Context delegate) {
        this.delegate = delegate;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public static boolean isOnWorkerThread() {
        boolean ret = io.vertx.core.Context.isOnWorkerThread();
        return ret;
    }

    public static boolean isOnEventLoopThread() {
        boolean ret = io.vertx.core.Context.isOnEventLoopThread();
        return ret;
    }

    public static boolean isOnVertxThread() {
        boolean ret = io.vertx.core.Context.isOnVertxThread();
        return ret;
    }

    public void runOnContext(Handler<Void> action) {
        this.delegate.runOnContext(action);
    }

    public <T> void executeBlocking(final Handler<Future<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> resultHandler) {
        this.delegate.executeBlocking(new Handler<io.vertx.core.Future<T>>(){

            public void handle(io.vertx.core.Future<T> event) {
                blockingCodeHandler.handle(new Future(event));
            }
        }, ordered, resultHandler);
    }

    public <T> Observable<T> executeBlockingObservable(Handler<Future<T>> blockingCodeHandler, boolean ordered) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.executeBlocking(blockingCodeHandler, ordered, resultHandler.toHandler());
        return resultHandler;
    }

    public <T> void executeBlocking(final Handler<Future<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler) {
        this.delegate.executeBlocking(new Handler<io.vertx.core.Future<T>>(){

            public void handle(io.vertx.core.Future<T> event) {
                blockingCodeHandler.handle(new Future(event));
            }
        }, resultHandler);
    }

    public <T> Observable<T> executeBlockingObservable(Handler<Future<T>> blockingCodeHandler) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.executeBlocking(blockingCodeHandler, resultHandler.toHandler());
        return resultHandler;
    }

    public String deploymentID() {
        String ret = this.delegate.deploymentID();
        return ret;
    }

    public JsonObject config() {
        JsonObject ret = this.delegate.config();
        return ret;
    }

    public List<String> processArgs() {
        List ret = this.delegate.processArgs();
        return ret;
    }

    public boolean isEventLoopContext() {
        boolean ret = this.delegate.isEventLoopContext();
        return ret;
    }

    public boolean isWorkerContext() {
        boolean ret = this.delegate.isWorkerContext();
        return ret;
    }

    public boolean isMultiThreadedWorkerContext() {
        boolean ret = this.delegate.isMultiThreadedWorkerContext();
        return ret;
    }

    public <T> T get(String key) {
        Object ret = this.delegate.get(key);
        return (T)ret;
    }

    public void put(String key, Object value) {
        this.delegate.put(key, value);
    }

    public boolean remove(String key) {
        boolean ret = this.delegate.remove(key);
        return ret;
    }

    public Vertx owner() {
        Vertx ret = Vertx.newInstance(this.delegate.owner());
        return ret;
    }

    public int getInstanceCount() {
        int ret = this.delegate.getInstanceCount();
        return ret;
    }

    public static Context newInstance(io.vertx.core.Context arg) {
        return arg != null ? new Context(arg) : null;
    }
}

