/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java.test.gen;

import io.vertx.codegen.testmodel.NullableTCKImpl;
import io.vertx.codegen.testmodel.TestDataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.rx.java.test.gen.ApiTCKTest;
import io.vertx.rx.java.test.gen.AsyncResultChecker;
import io.vertx.rxjava.codegen.testmodel.NullableTCK;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class NullableTCKTest {
    private final List<TestDataObject> TEST_DATA_OBJECTS = Arrays.asList(new TestDataObject().setFoo("first").setBar(1).setWibble(1.1), null, new TestDataObject().setFoo("third").setBar(3).setWibble(3.3));
    private final List<JsonArray> EXPECTED1BILT = Arrays.asList(new JsonArray().add((Object)"foo").add((Object)"bar"), null, new JsonArray().add((Object)"juu"));
    private final List<JsonObject> EXPECTED = Arrays.asList(new JsonObject().put("foo", (Object)"bar"), null, new JsonObject().put("juu", (Object)3));
    private final NullableTCK obj = new NullableTCK(new NullableTCKImpl());

    @Test
    public void testNullDataObjectParam() {
        this.obj.methodWithNullableDataObjectParam(true, null);
    }

    @Test
    public void testNullJsonHandlerParams() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithNullableJsonObjectHandler(true, checker.resultHandler(it -> Assert.assertEquals((Object)new JsonObject().put("foo", (Object)"wibble").put("bar", (Object)3), (Object)it)));
        this.obj.methodWithNullableJsonObjectHandler(false, checker.resultHandler(it -> Assert.assertEquals(null, (Object)it)));
        this.obj.methodWithNullableJsonArrayHandler(true, checker.resultHandler(it -> Assert.assertEquals((Object)new JsonArray().add((Object)"one").add((Object)"two").add((Object)"three"), (Object)it)));
        this.obj.methodWithNullableJsonArrayHandler(false, checker.resultHandler(it -> Assert.assertEquals(null, (Object)it)));
        Assert.assertEquals((long)4L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerListNullJsonObject() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithListNullableJsonObjectHandler(checker.expectedResult(this.EXPECTED));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultListNullJsonObject() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithListNullableJsonObjectHandlerAsyncResult(checker.asyncExpectedResult(this.EXPECTED));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureListNullJsonObject() throws Exception {
        List<JsonObject> result = ApiTCKTest.get(this.obj.rxMethodWithListNullableJsonObjectHandlerAsyncResult());
        Assert.assertEquals(this.EXPECTED, result);
    }

    @Test
    public void testMethodWithHandlerSetNullJsonObject() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithSetNullableJsonObjectHandler(checker.resultHandler(r -> Assert.assertEquals(this.EXPECTED, new ArrayList(r))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultSetNullJsonObject() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithSetNullableJsonObjectHandlerAsyncResult(checker.asyncResultHandler(it -> Assert.assertEquals(this.EXPECTED, new ArrayList(it))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureSetNullJsonObject() throws Exception {
        Set<JsonObject> result = ApiTCKTest.get(this.obj.rxMethodWithSetNullableJsonObjectHandlerAsyncResult());
        Assert.assertEquals(this.EXPECTED, new ArrayList<JsonObject>(result));
    }

    @Test
    public void testMethodWithHandlerListNullJsonArray() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithListNullableJsonArrayHandler(checker.expectedResult(this.EXPECTED1BILT));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultListNullJsonArray() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithListNullableJsonArrayHandlerAsyncResult(checker.asyncExpectedResult(this.EXPECTED1BILT));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureListNullJsonArray() throws Exception {
        List<JsonArray> result = ApiTCKTest.get(this.obj.rxMethodWithListNullableJsonArrayHandlerAsyncResult());
        Assert.assertEquals(result, this.EXPECTED1BILT);
    }

    @Test
    public void testMethodWithHandlerSetNullJsonArray() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithSetNullableJsonArrayHandler(checker.resultHandler(it -> Assert.assertEquals(this.EXPECTED1BILT, new ArrayList(it))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultSetNullJsonArray() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithSetNullableJsonArrayHandlerAsyncResult(checker.asyncResultHandler(it -> Assert.assertEquals(this.EXPECTED1BILT, new ArrayList(it))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureSetNullJsonArray() throws Exception {
        Set<JsonArray> result = ApiTCKTest.get(this.obj.rxMethodWithSetNullableJsonArrayHandlerAsyncResult());
        Assert.assertEquals(this.EXPECTED1BILT, new ArrayList<JsonArray>(result));
    }

    @Test
    public void testMethodWithHandlerNullListDataObject() throws Exception {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithListNullableDataObjectHandler(checker.resultHandler(list -> Assert.assertEquals(this.TEST_DATA_OBJECTS, (Object)list)));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultNullListDataObject() throws Exception {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithListNullableDataObjectHandlerAsyncResult(checker.asyncResultHandler(list -> Assert.assertEquals(this.TEST_DATA_OBJECTS, (Object)list)));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerNullSetDataObject() throws Exception {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithSetNullableDataObjectHandler(checker.resultHandler(set -> Assert.assertEquals(this.TEST_DATA_OBJECTS, new ArrayList(set))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultNullSetDataObject() throws Exception {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithSetNullableDataObjectHandlerAsyncResult(checker.asyncResultHandler(set -> Assert.assertEquals(this.TEST_DATA_OBJECTS, new ArrayList(set))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }
}

