/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java.test.gen;

import io.vertx.codegen.testmodel.GenericsTCKImpl;
import io.vertx.codegen.testmodel.RefedInterface1Impl;
import io.vertx.rx.java.test.gen.AsyncResultChecker;
import io.vertx.rxjava.codegen.testmodel.GenericNullableRefedInterface;
import io.vertx.rxjava.codegen.testmodel.GenericRefedInterface;
import io.vertx.rxjava.codegen.testmodel.GenericsTCK;
import io.vertx.rxjava.codegen.testmodel.RefedInterface1;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class GenericsTCKTest {
    final GenericsTCK obj = new GenericsTCK(new GenericsTCKImpl());

    @Test
    public void testMethodWithUserTypeParameterizedReturn() {
        GenericRefedInterface<RefedInterface1> gen = this.obj.methodWithUserTypeParameterizedReturn();
        RefedInterface1 refed = gen.getValue();
        Assert.assertEquals((Object)"foo", (Object)refed.getString());
        refed = new RefedInterface1(new RefedInterface1Impl());
        refed.setString("the_string");
        gen.setValue(refed);
        refed = gen.getValue();
        Assert.assertEquals((Object)"the_string", (Object)refed.getString());
    }

    @Test
    public void testMethodWithGenericNullableApiHandler() throws Exception {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerGenericNullableApi(false, checker.resultHandler(ret -> Assert.assertEquals(null, ret.getValue())));
    }

    @Test
    public void testMethodWithGenericNullableApiHandlerAsyncResult() throws Exception {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultGenericNullableApi(false, checker.resultHandler(ret -> Assert.assertEquals(null, ((GenericNullableRefedInterface)ret.result()).getValue())));
    }

    @Test
    public void testMethodWithGenericNullableApiReturn() throws Exception {
        GenericNullableRefedInterface<RefedInterface1> ret = this.obj.methodWithGenericNullableApiReturn(false);
        Assert.assertEquals(null, (Object)ret.getValue());
    }

    @Test
    public void testMethodWithClassTypeParameterizedReturn() throws Exception {
        GenericRefedInterface<RefedInterface1> refed = this.obj.methodWithClassTypeParameterizedReturn(RefedInterface1.class);
        RefedInterface1 a = refed.getValue();
        Assert.assertEquals((Object)"foo", (Object)a.getString());
    }

    @Test
    public void testMethodWithParamInferedReturn() throws Exception {
        GenericRefedInterface<RefedInterface1> refed = this.obj.methodWithUserTypeParameterizedReturn();
        GenericRefedInterface<RefedInterface1> ret = this.obj.methodWithParamInferedReturn(refed);
        Assert.assertSame((Object)refed.getDelegate(), (Object)ret.getDelegate());
    }

    @Test
    public void testMethodWithHandlerParamInfered() throws Exception {
        GenericRefedInterface<RefedInterface1> refed = this.obj.methodWithUserTypeParameterizedReturn();
        this.obj.methodWithHandlerParamInfered(refed, ret -> Assert.assertSame((Object)refed.getDelegate(), (Object)ret.getDelegate()));
    }

    @Test
    public void testMethodWithHandlerAsyncResultParamInfered() throws Exception {
        GenericRefedInterface<RefedInterface1> refed = this.obj.methodWithUserTypeParameterizedReturn();
        this.obj.methodWithHandlerAsyncResultParamInfered(refed, ret -> Assert.assertSame((Object)refed.getDelegate(), (Object)((GenericRefedInterface)ret.result()).getDelegate()));
    }

    @Test
    public void testMethodWithClassTypeReturn() throws Exception {
        RefedInterface1 refed = this.obj.methodWithClassTypeReturn(RefedInterface1.class);
        Assert.assertEquals((Object)"foo", (Object)refed.getString());
    }

    @Test
    public void testMethodWithClassTypeHandler() throws Exception {
        AtomicReference refed = new AtomicReference();
        this.obj.methodWithClassTypeHandler(RefedInterface1.class, refed::set);
        Assert.assertEquals((Object)"foo", (Object)((RefedInterface1)refed.get()).getString());
    }

    @Test
    public void testMethodWithClassTypeHandlerAsyncResult() throws Exception {
        AtomicReference refed = new AtomicReference();
        this.obj.methodWithClassTypeHandlerAsyncResult(RefedInterface1.class, ar -> refed.set(ar.result()));
        Assert.assertEquals((Object)"foo", (Object)((RefedInterface1)refed.get()).getString());
    }
}

