/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java.test.gen;

import com.acme.rxjava.pkg.MyInterface;
import com.acme.rxjava.pkg.sub.SubInterface;
import io.vertx.codegen.testmodel.RefedInterface1Impl;
import io.vertx.codegen.testmodel.TestDataObject;
import io.vertx.codegen.testmodel.TestInterfaceImpl;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.rx.java.test.gen.AsyncResultChecker;
import io.vertx.rxjava.codegen.testmodel.Factory;
import io.vertx.rxjava.codegen.testmodel.RefedInterface1;
import io.vertx.rxjava.codegen.testmodel.RefedInterface2;
import io.vertx.rxjava.codegen.testmodel.TestInterface;
import io.vertx.test.core.TestUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import rx.Observable;
import rx.Single;

public class ApiTCKTest {
    final TestInterface obj = new TestInterface(new TestInterfaceImpl());

    @Test
    public void testMethodWithBasicParams() {
        this.obj.methodWithBasicParams((byte)123, (short)12345, 1234567, 1265615234L, 12.345f, 12.34566, true, 'X', "foobar");
    }

    @Test
    public void testMethodWithBasicBoxedParams() {
        this.obj.methodWithBasicBoxedParams((byte)123, (short)12345, 1234567, 1265615234L, Float.valueOf(12.345f), 12.34566, true, Character.valueOf('X'));
    }

    @Test
    public void testMethodWithHandlerBasicTypes() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerBasicTypes(checker.expectedResult((byte)123), checker.expectedResult((short)12345), checker.expectedResult(1234567), checker.expectedResult(1265615234L), checker.expectedResult(Float.valueOf(12.345f)), checker.expectedResult(12.34566), checker.expectedResult(true), checker.expectedResult(Character.valueOf('X')), checker.expectedResult("quux!"));
        Assert.assertEquals((long)9L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultBasicTypes() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultByte(false, checker.asyncExpectedResult((byte)123));
        this.obj.methodWithHandlerAsyncResultShort(false, checker.asyncExpectedResult((short)12345));
        this.obj.methodWithHandlerAsyncResultInteger(false, checker.asyncExpectedResult(1234567));
        this.obj.methodWithHandlerAsyncResultLong(false, checker.asyncExpectedResult(1265615234L));
        this.obj.methodWithHandlerAsyncResultFloat(false, checker.asyncExpectedResult(Float.valueOf(12.345f)));
        this.obj.methodWithHandlerAsyncResultDouble(false, checker.asyncExpectedResult(12.34566));
        this.obj.methodWithHandlerAsyncResultBoolean(false, checker.asyncExpectedResult(true));
        this.obj.methodWithHandlerAsyncResultCharacter(false, checker.asyncExpectedResult(Character.valueOf('X')));
        this.obj.methodWithHandlerAsyncResultString(false, checker.asyncExpectedResult("quux!"));
        Assert.assertEquals((long)9L, (long)checker.count);
        checker.count = 0;
        this.obj.methodWithHandlerAsyncResultByte(true, checker.failureAsserter("foobar!"));
        this.obj.methodWithHandlerAsyncResultShort(true, checker.failureAsserter("foobar!"));
        this.obj.methodWithHandlerAsyncResultInteger(true, checker.failureAsserter("foobar!"));
        this.obj.methodWithHandlerAsyncResultLong(true, checker.failureAsserter("foobar!"));
        this.obj.methodWithHandlerAsyncResultFloat(true, checker.failureAsserter("foobar!"));
        this.obj.methodWithHandlerAsyncResultDouble(true, checker.failureAsserter("foobar!"));
        this.obj.methodWithHandlerAsyncResultBoolean(true, checker.failureAsserter("foobar!"));
        this.obj.methodWithHandlerAsyncResultCharacter(true, checker.failureAsserter("foobar!"));
        this.obj.methodWithHandlerAsyncResultString(true, checker.failureAsserter("foobar!"));
        Assert.assertEquals((long)9L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureBasicTypes() throws Exception {
        Assert.assertEquals((long)123L, (long)ApiTCKTest.get(this.obj.rxMethodWithHandlerAsyncResultByte(false)).byteValue());
        Assert.assertEquals((long)12345L, (long)ApiTCKTest.get(this.obj.rxMethodWithHandlerAsyncResultShort(false)).shortValue());
        Assert.assertEquals((long)1234567L, (long)ApiTCKTest.get(this.obj.rxMethodWithHandlerAsyncResultInteger(false)).intValue());
        Assert.assertEquals((long)1265615234L, (long)ApiTCKTest.get(this.obj.rxMethodWithHandlerAsyncResultLong(false)));
        Assert.assertEquals((float)12.345f, (float)ApiTCKTest.get(this.obj.rxMethodWithHandlerAsyncResultFloat(false)).floatValue(), (float)0.0f);
        Assert.assertEquals((double)12.34566, (double)ApiTCKTest.get(this.obj.rxMethodWithHandlerAsyncResultDouble(false)), (double)0.0);
        Assert.assertEquals((Object)true, (Object)ApiTCKTest.get(this.obj.rxMethodWithHandlerAsyncResultBoolean(false)));
        Assert.assertEquals((long)88L, (long)ApiTCKTest.get(this.obj.rxMethodWithHandlerAsyncResultCharacter(false)).charValue());
        Assert.assertEquals((Object)"quux!", (Object)ApiTCKTest.get(this.obj.rxMethodWithHandlerAsyncResultString(false)));
        this.assertFailure("foobar!", this.obj.rxMethodWithHandlerAsyncResultByte(true));
        this.assertFailure("foobar!", this.obj.rxMethodWithHandlerAsyncResultShort(true));
        this.assertFailure("foobar!", this.obj.rxMethodWithHandlerAsyncResultInteger(true));
        this.assertFailure("foobar!", this.obj.rxMethodWithHandlerAsyncResultLong(true));
        this.assertFailure("foobar!", this.obj.rxMethodWithHandlerAsyncResultFloat(true));
        this.assertFailure("foobar!", this.obj.rxMethodWithHandlerAsyncResultDouble(true));
        this.assertFailure("foobar!", this.obj.rxMethodWithHandlerAsyncResultBoolean(true));
        this.assertFailure("foobar!", this.obj.rxMethodWithHandlerAsyncResultCharacter(true));
        this.assertFailure("foobar!", this.obj.rxMethodWithHandlerAsyncResultString(true));
    }

    static <T> T get(Observable<T> future) throws Exception {
        return (T)future.toBlocking().first();
    }

    static <T> T get(Single<T> future) throws Exception {
        return (T)future.toBlocking().value();
    }

    private <T> void assertFailure(String message, Observable<T> future) throws Exception {
        try {
            future.toBlocking().first();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private <T> void assertFailure(String message, Single<T> future) throws Exception {
        try {
            future.toBlocking().value();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testMethodWithUserTypes() {
        RefedInterface1 refed = new RefedInterface1(new RefedInterface1Impl());
        refed.setString("aardvarks");
        this.obj.methodWithUserTypes(refed);
    }

    @Test
    public void testObjectParam() {
        this.obj.methodWithObjectParam("JsonObject", new JsonObject().put("foo", (Object)"hello").put("bar", (Object)123));
        this.obj.methodWithObjectParam("JsonArray", new JsonArray().add((Object)"foo").add((Object)"bar").add((Object)"wib"));
    }

    @Test
    public void testDataObjectParam() {
        TestDataObject options = new TestDataObject();
        options.setFoo("hello");
        options.setBar(123);
        options.setWibble(1.23);
        this.obj.methodWithDataObjectParam(options);
    }

    @Test
    public void testMethodWithHandlerDataObject() {
        TestDataObject dataObject = new TestDataObject();
        dataObject.setFoo("foo");
        dataObject.setBar(123);
        AtomicInteger count = new AtomicInteger();
        this.obj.methodWithHandlerDataObject((Handler<TestDataObject>)((Handler)it -> {
            Assert.assertEquals((Object)dataObject.getFoo(), (Object)it.getFoo());
            Assert.assertEquals((long)dataObject.getBar(), (long)it.getBar());
            count.incrementAndGet();
        }));
        Assert.assertEquals((long)1L, (long)count.get());
    }

    @Test
    public void testMethodWithHandlerAsyncResultDataObject() {
        TestDataObject dataObject = new TestDataObject();
        dataObject.setFoo("foo");
        dataObject.setBar(123);
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultDataObject(false, (Handler<AsyncResult<TestDataObject>>)((Handler)result -> {
            Assert.assertTrue((boolean)result.succeeded());
            Assert.assertFalse((boolean)result.failed());
            TestDataObject res = (TestDataObject)result.result();
            Assert.assertEquals((Object)dataObject.getFoo(), (Object)res.getFoo());
            Assert.assertNull((Object)result.cause());
            ++checker.count;
        }));
        this.obj.methodWithHandlerAsyncResultDataObject(true, (Handler<AsyncResult<TestDataObject>>)((Handler)result -> checker.assertAsyncFailure("foobar!", result)));
        Assert.assertEquals((long)2L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerStringReturn() {
        Handler<String> handler = this.obj.methodWithHandlerStringReturn("the-result");
        handler.handle((Object)"the-result");
        boolean failed = false;
        try {
            handler.handle((Object)"not-expected");
        }
        catch (Throwable ignore) {
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
    }

    @Test
    public void testMethodWithHandlerGenericReturn() {
        AtomicReference result = new AtomicReference();
        this.obj.methodWithHandlerGenericReturn(result::set).handle((Object)"the-result");
        Assert.assertEquals((Object)"the-result", result.get());
        this.obj.methodWithHandlerGenericReturn(result::set).handle((Object)this.obj);
        Assert.assertEquals((Object)this.obj, result.get());
    }

    @Test
    public void testMethodWithHandlerVertxGenReturn() {
        this.obj.methodWithHandlerVertxGenReturn("the-gen-result").handle((Object)new RefedInterface1(new RefedInterface1Impl().setString("the-gen-result")));
    }

    @Test
    public void testMethodWithHandlerAsyncResultStringReturn() {
        Handler<AsyncResult<String>> succeedingHandler = this.obj.methodWithHandlerAsyncResultStringReturn("the-result", false);
        succeedingHandler.handle((Object)Future.succeededFuture((Object)"the-result"));
        boolean failed = false;
        try {
            succeedingHandler.handle((Object)Future.succeededFuture((Object)"not-expected"));
        }
        catch (Throwable ignore) {
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        Handler<AsyncResult<String>> failingHandler = this.obj.methodWithHandlerAsyncResultStringReturn("an-error", true);
        failingHandler.handle((Object)Future.failedFuture((String)"an-error"));
        failed = false;
        try {
            failingHandler.handle((Object)Future.succeededFuture((Object)"whatever"));
        }
        catch (Throwable ignore) {
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
    }

    @Test
    public void testMethodWithHandlerAsyncResultGenericReturn() {
        AtomicReference result = new AtomicReference();
        Handler succeedingHandler = this.obj.methodWithHandlerAsyncResultGenericReturn(ar -> result.set(ar.succeeded() ? ar.result() : ar.cause()));
        succeedingHandler.handle((Object)Future.succeededFuture((Object)"the-result"));
        Assert.assertEquals((Object)"the-result", result.get());
        succeedingHandler.handle((Object)Future.succeededFuture((Object)this.obj));
        Assert.assertEquals((Object)this.obj, result.get());
    }

    @Test
    public void testMethodWithHandlerAsyncResultVertxGenReturn() {
        this.obj.methodWithHandlerAsyncResultVertxGenReturn("the-gen-result", false).handle((Object)Future.succeededFuture((Object)new RefedInterface1(new RefedInterface1Impl().setString("the-gen-result"))));
        this.obj.methodWithHandlerAsyncResultVertxGenReturn("it-failed-dude", true).handle((Object)Future.failedFuture((Throwable)new Exception("it-failed-dude")));
    }

    @Test
    public void testMethodWithHandlerUserTypes() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerUserTypes(checker.resultHandler(it -> Assert.assertEquals((Object)"echidnas", (Object)it.getString())));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithConcreteHandlerUserTypeSubtype() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithConcreteHandlerUserTypeSubtype(Factory.createConcreteHandlerUserType(checker.resultHandler(it -> Assert.assertEquals((Object)"echidnas", (Object)it.getString()))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithAbstractHandlerUserTypeSubtype() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithAbstractHandlerUserTypeSubtype(Factory.createAbstractHandlerUserType(checker.resultHandler(it -> Assert.assertEquals((Object)"echidnas", (Object)it.getString()))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithAbstractHandlerUserTypeSubtypeExtension() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithConcreteHandlerUserTypeSubtypeExtension(Factory.createConcreteHandlerUserTypeExtension(checker.resultHandler(it -> Assert.assertEquals((Object)"echidnas", (Object)it.getString()))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultUserTypes() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultUserTypes(checker.asyncResultHandler(it -> Assert.assertEquals((Object)"cheetahs", (Object)it.getString())));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureUserTypes() throws Exception {
        RefedInterface1 result = ApiTCKTest.get(this.obj.rxMethodWithHandlerAsyncResultUserTypes());
        Assert.assertEquals((Object)"cheetahs", (Object)result.getString());
    }

    @Test
    public void testMethodWithHandlerVoid() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerVoid(checker.resultHandler(Assert::assertNull));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultVoid() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultVoid(false, checker.asyncResultHandler(Assert::assertNull));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureVoid() throws Exception {
        Void result = ApiTCKTest.get(this.obj.rxMethodWithHandlerAsyncResultVoid(false));
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void testMethodWithHandlerAsyncResultVoidFails() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultVoid(true, checker.failureAsserter("foo!"));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureVoidFails() throws Exception {
        this.assertFailure("foo!", this.obj.rxMethodWithHandlerAsyncResultVoid(true));
    }

    @Test
    public void testMethodWithHandlerThrowable() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerThrowable(checker.resultHandler(t -> {
            Assert.assertTrue((boolean)(t instanceof VertxException));
            Assert.assertEquals((Object)"cheese!", (Object)t.getMessage());
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithGenericParam() {
        this.obj.methodWithGenericParam("String", "foo");
        this.obj.methodWithGenericParam("Ref", new RefedInterface1Impl().setString("bar"));
        this.obj.methodWithGenericParam("JsonObject", new JsonObject().put("foo", (Object)"hello").put("bar", (Object)123));
        this.obj.methodWithGenericParam("JsonArray", new JsonArray().add((Object)"foo").add((Object)"bar").add((Object)"wib"));
    }

    @Test
    public void testMethodWithGenericHandler() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithGenericHandler("String", checker.expectedResult("foo"));
        this.obj.methodWithGenericHandler("Ref", checker.resultHandler(it -> Assert.assertEquals((Object)"bar", (Object)it.getString())));
        this.obj.methodWithGenericHandler("JsonObject", checker.expectedResult(new JsonObject().put("foo", (Object)"hello").put("bar", (Object)123)));
        this.obj.methodWithGenericHandler("JsonArray", checker.expectedResult(new JsonArray().add((Object)"foo").add((Object)"bar").add((Object)"wib")));
        Assert.assertEquals((long)4L, (long)checker.count);
    }

    @Test
    public void testMethodWithGenericHandlerAsyncResult() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithGenericHandlerAsyncResult("String", checker.asyncExpectedResult("foo"));
        this.obj.methodWithGenericHandlerAsyncResult("Ref", checker.asyncResultHandler(it -> Assert.assertEquals((Object)"bar", (Object)it.getString())));
        this.obj.methodWithGenericHandlerAsyncResult("JsonObject", checker.asyncExpectedResult(new JsonObject().put("foo", (Object)"hello").put("bar", (Object)123)));
        this.obj.methodWithGenericHandlerAsyncResult("JsonArray", checker.asyncExpectedResult(new JsonArray().add((Object)"foo").add((Object)"bar").add((Object)"wib")));
        Assert.assertEquals((long)4L, (long)checker.count);
    }

    @Test
    public void testMethodWithGenericObservable() throws Exception {
        Assert.assertEquals((Object)"foo", ApiTCKTest.get(this.obj.rxMethodWithGenericHandlerAsyncResult("String")));
        RefedInterface1Impl ref = (RefedInterface1Impl)ApiTCKTest.get(this.obj.rxMethodWithGenericHandlerAsyncResult("Ref"));
        Assert.assertEquals((Object)"bar", (Object)ref.getString());
        Assert.assertEquals((Object)new JsonObject().put("foo", (Object)"hello").put("bar", (Object)123), ApiTCKTest.get(this.obj.rxMethodWithGenericHandlerAsyncResult("JsonObject")));
        Assert.assertEquals((Object)new JsonArray().add((Object)"foo").add((Object)"bar").add((Object)"wib"), ApiTCKTest.get(this.obj.rxMethodWithGenericHandlerAsyncResult("JsonArray")));
    }

    @Test
    public void testBasicReturns() {
        Assert.assertEquals((long)123L, (long)this.obj.methodWithByteReturn());
        Assert.assertEquals((long)12345L, (long)this.obj.methodWithShortReturn());
        Assert.assertEquals((long)12345464L, (long)this.obj.methodWithIntReturn());
        Assert.assertEquals((long)65675123L, (long)this.obj.methodWithLongReturn());
        Assert.assertEquals((float)1.23f, (float)this.obj.methodWithFloatReturn(), (float)0.0f);
        Assert.assertEquals((double)3.34535, (double)this.obj.methodWithDoubleReturn(), (double)0.0);
        Assert.assertEquals((Object)true, (Object)this.obj.methodWithBooleanReturn());
        Assert.assertEquals((long)89L, (long)this.obj.methodWithCharReturn());
        Assert.assertEquals((Object)"orangutan", (Object)this.obj.methodWithStringReturn());
    }

    @Test
    public void testVertxGenReturn() {
        RefedInterface1 r = this.obj.methodWithVertxGenReturn();
        Assert.assertEquals((Object)"chaffinch", (Object)r.getString());
    }

    @Test
    public void testVertxGenNullReturn() {
        RefedInterface1 r = this.obj.methodWithVertxGenNullReturn();
        Assert.assertNull((Object)r);
    }

    @Test
    public void testAbstractVertxGenReturn() {
        RefedInterface2 r = this.obj.methodWithAbstractVertxGenReturn();
        Assert.assertEquals((Object)"abstractchaffinch", (Object)r.getString());
    }

    @Test
    public void testDataObjectReturn() {
        TestDataObject r = this.obj.methodWithDataObjectReturn();
        Assert.assertEquals((Object)"foo", (Object)r.getFoo());
        Assert.assertEquals((long)123L, (long)r.getBar());
    }

    @Test
    public void testDataObjectNullReturn() {
        TestDataObject r = this.obj.methodWithDataObjectNullReturn();
        Assert.assertNull((Object)r);
    }

    @Test
    public void testOverloadedMethods() {
        RefedInterface1 refed = new RefedInterface1(new RefedInterface1Impl());
        refed.setString("dog");
        Assert.assertEquals((Object)"meth1", (Object)this.obj.overloadedMethod("cat", refed));
        AtomicBoolean called = new AtomicBoolean(false);
        Assert.assertEquals((Object)"meth2", (Object)this.obj.overloadedMethod("cat", refed, 12345L, (Handler<String>)((Handler)it -> {
            Assert.assertEquals((Object)"giraffe", (Object)it);
            called.set(true);
        })));
        Assert.assertTrue((boolean)called.getAndSet(false));
        Assert.assertEquals((Object)"meth3", (Object)this.obj.overloadedMethod("cat", (Handler<String>)((Handler)it -> {
            Assert.assertEquals((Object)"giraffe", (Object)it);
            called.set(true);
        })));
        Assert.assertTrue((boolean)called.getAndSet(false));
        Assert.assertEquals((Object)"meth4", (Object)this.obj.overloadedMethod("cat", refed, (Handler<String>)((Handler)it -> {
            Assert.assertEquals((Object)"giraffe", (Object)it);
            called.set(true);
        })));
        Assert.assertTrue((boolean)called.get());
    }

    @Test
    public void testSuperInterfaces() {
        this.obj.superMethodWithBasicParams((byte)123, (short)12345, 1234567, 1265615234L, 12.345f, 12.34566, true, 'X', "foobar");
        this.obj.otherSuperMethodWithBasicParams((byte)123, (short)12345, 1234567, 1265615234L, 12.345f, 12.34566, true, 'X', "foobar");
    }

    @Test
    public void testMethodWithGenericReturn() {
        Object ret = this.obj.methodWithGenericReturn("JsonObject");
        Assert.assertTrue((String)("Was expecting " + ret + " to implement JsonObject"), (boolean)(ret instanceof JsonObject));
        Assert.assertEquals((Object)new JsonObject().put("foo", (Object)"hello").put("bar", (Object)123), ret);
        ret = this.obj.methodWithGenericReturn("JsonArray");
        Assert.assertTrue((String)("Was expecting " + ret + " to implement JsonArray"), (boolean)(ret instanceof JsonArray));
        Assert.assertEquals((Object)new JsonArray().add((Object)"foo").add((Object)"bar").add((Object)"wib"), ret);
    }

    @Test
    public void testFluentMethod() {
        TestInterface ret = this.obj.fluentMethod("bar");
        Assert.assertSame((Object)this.obj, (Object)ret);
    }

    @Test
    public void testStaticFactoryMethod() {
        RefedInterface1 ret = TestInterface.staticFactoryMethod("bar");
        Assert.assertEquals((Object)"bar", (Object)ret.getString());
    }

    @Test
    public void testMethodWithCachedReturn() {
        RefedInterface1 ret1 = this.obj.methodWithCachedReturn("bar");
        Assert.assertEquals((Object)"bar", (Object)ret1.getString());
        RefedInterface1 ret2 = this.obj.methodWithCachedReturn("bar");
        Assert.assertSame((Object)ret1, (Object)ret2);
        RefedInterface1 ret3 = this.obj.methodWithCachedReturn("bar");
        Assert.assertSame((Object)ret1, (Object)ret3);
    }

    @Test
    public void testMethodWithCachedListReturn() {
        List<RefedInterface1> ret1 = this.obj.methodWithCachedListReturn();
        Assert.assertEquals((long)2L, (long)ret1.size());
        Assert.assertEquals((Object)"foo", (Object)ret1.get(0).getString());
        Assert.assertEquals((Object)"bar", (Object)ret1.get(1).getString());
        List<RefedInterface1> ret2 = this.obj.methodWithCachedListReturn();
        Assert.assertSame(ret1, ret2);
        List<RefedInterface1> ret3 = this.obj.methodWithCachedListReturn();
        Assert.assertSame(ret1, ret3);
    }

    @Test
    public void testMethodWithCachedReturnPrimitive() {
        int value = TestUtils.randomInt();
        Assert.assertEquals((long)value, (long)this.obj.methodWithCachedReturnPrimitive(value));
        Assert.assertEquals((long)value, (long)this.obj.methodWithCachedReturnPrimitive(value));
    }

    @Test
    public void testJsonReturns() {
        JsonObject ret1 = this.obj.methodWithJsonObjectReturn();
        Assert.assertEquals((Object)new JsonObject().put("cheese", (Object)"stilton"), (Object)ret1);
        JsonArray ret2 = this.obj.methodWithJsonArrayReturn();
        Assert.assertEquals((Object)new JsonArray().add((Object)"socks").add((Object)"shoes"), (Object)ret2);
    }

    @Test
    public void testNullJsonReturns() {
        JsonObject ret1 = this.obj.methodWithNullJsonObjectReturn();
        Assert.assertEquals(null, (Object)ret1);
        JsonArray ret2 = this.obj.methodWithNullJsonArrayReturn();
        Assert.assertEquals(null, (Object)ret2);
    }

    @Test
    public void testJsonParams() {
        this.obj.methodWithJsonParams(new JsonObject().put("cat", (Object)"lion").put("cheese", (Object)"cheddar"), new JsonArray().add((Object)"house").add((Object)"spider"));
    }

    @Test
    public void testNullJsonParams() {
        this.obj.methodWithNullJsonParams(null, null);
    }

    @Test
    public void testJsonHandlerParams() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerJson(checker.resultHandler(it -> Assert.assertEquals((Object)new JsonObject().put("cheese", (Object)"stilton"), (Object)it)), checker.resultHandler(it -> Assert.assertEquals((Object)new JsonArray().add((Object)"socks").add((Object)"shoes"), (Object)it)));
        Assert.assertEquals((long)2L, (long)checker.count);
    }

    @Test
    public void testJsonHandlerAsyncResultParams() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultJsonObject(checker.asyncResultHandler(it -> Assert.assertEquals((Object)new JsonObject().put("cheese", (Object)"stilton"), (Object)it)));
        this.obj.methodWithHandlerAsyncResultJsonArray(checker.asyncResultHandler(it -> Assert.assertEquals((Object)new JsonArray().add((Object)"socks").add((Object)"shoes"), (Object)it)));
        Assert.assertEquals((long)2L, (long)checker.count);
    }

    @Test
    public void testNullJsonHandlerAsyncResultParams() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultNullJsonObject(checker.asyncResultHandler(it -> Assert.assertEquals(null, (Object)it)));
        this.obj.methodWithHandlerAsyncResultNullJsonArray(checker.asyncResultHandler(it -> Assert.assertEquals(null, (Object)it)));
        Assert.assertEquals((long)2L, (long)checker.count);
    }

    @Test
    public void testJsonFutureParams() throws Exception {
        Assert.assertEquals((Object)new JsonObject().put("cheese", (Object)"stilton"), (Object)ApiTCKTest.get(this.obj.rxMethodWithHandlerAsyncResultJsonObject()));
        Assert.assertEquals((Object)new JsonArray().add((Object)"socks").add((Object)"shoes"), (Object)ApiTCKTest.get(this.obj.rxMethodWithHandlerAsyncResultJsonArray()));
    }

    @Test
    public void testNullJsonFutureParams() throws Exception {
        Assert.assertEquals(null, (Object)ApiTCKTest.get(this.obj.rxMethodWithHandlerAsyncResultNullJsonObject()));
        Assert.assertEquals(null, (Object)ApiTCKTest.get(this.obj.rxMethodWithHandlerAsyncResultNullJsonArray()));
    }

    @Test
    public void testCustomModule() {
        MyInterface my = MyInterface.create();
        TestInterface testInterface = my.method();
        testInterface.methodWithBasicParams((byte)123, (short)12345, 1234567, 1265615234L, 12.345f, 12.34566, true, 'X', "foobar");
        SubInterface sub = my.sub();
        Assert.assertEquals((Object)"olleh", (Object)sub.reverse("hello"));
    }

    @Test
    public void testThrowableParam() {
        Assert.assertEquals((Object)"throwable_message", (Object)this.obj.methodWithThrowableParam(new Exception("throwable_message")));
    }

    static <V> Map<String, V> map(String key1, V value1) {
        HashMap<String, V> map = new HashMap<String, V>();
        map.put(key1, value1);
        return map;
    }

    static <V> Map<String, V> map(String key1, V value1, String key2, V value2) {
        HashMap<String, V> map = new HashMap<String, V>();
        map.put(key1, value1);
        map.put(key2, value2);
        return map;
    }

    static <E> Set<E> set(E ... elements) {
        return new HashSet<E>(Arrays.asList(elements));
    }

    static <E> List<E> list(E ... elements) {
        return Arrays.asList(elements);
    }
}

