/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java.test;

import io.vertx.core.streams.ReadStream;
import io.vertx.lang.rx.test.ReadStreamSubscriberStaticsTestBase;
import io.vertx.rx.java.ReadStreamSubscriber;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import rx.Observable;

public class ReadStreamSubscriberStaticsTest
extends ReadStreamSubscriberStaticsTestBase<Integer, Observable<Integer>> {
    public Observable<Integer> emptyFlowable() {
        return Observable.empty();
    }

    public List<Integer> generateData(int count) {
        return IntStream.range(0, count).boxed().collect(Collectors.toList());
    }

    public Observable<Integer> flowable(Iterable<Integer> source) {
        return Observable.from(source);
    }

    public ReadStream<Integer> asReadStream(Observable<Integer> flowable) {
        return ReadStreamSubscriber.asReadStream(flowable, Function.identity());
    }

    public Observable<Integer> emptyExceptionFlowable(String errorMessage) {
        return Observable.error((Throwable)new RuntimeException(errorMessage));
    }

    public Observable<Integer> exceptionAfterDataFlowable(String errorMessage, Iterable<Integer> source) {
        return this.flowable(source).concatWith(this.emptyExceptionFlowable(errorMessage));
    }
}

