/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java.test;

import io.vertx.core.Handler;
import io.vertx.lang.rx.test.TestSubscriber;
import io.vertx.rx.java.ObservableHandler;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.test.TestUtils;
import java.util.ArrayList;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class ObservableHandlerTest {
    @Test
    public void testMultiNotifyBeforeSubscribe() {
        ObservableHandler o = RxHelper.observableHandler((boolean)true);
        o.toHandler().handle((Object)"abc");
        TestSubscriber subscriber = new TestSubscriber();
        TestUtils.subscribe(o, subscriber);
        subscriber.assertEmpty();
    }

    @Test
    public void testSingleNotifyBeforeSubscribe() {
        ObservableHandler o = RxHelper.observableHandler();
        o.toHandler().handle((Object)"abc");
        TestSubscriber subscriber = new TestSubscriber();
        TestUtils.subscribe(o, subscriber);
        subscriber.assertCompleted().assertEmpty();
    }

    @Test
    public void testMultiNotifyAfterSubscribe() {
        ObservableHandler o = RxHelper.observableHandler((boolean)true);
        TestSubscriber subscriber = new TestSubscriber();
        TestUtils.subscribe(o, subscriber);
        subscriber.assertEmpty();
        o.toHandler().handle((Object)"abc");
        subscriber.assertItem((Object)"abc").assertEmpty();
    }

    @Test
    public void testSingleNotifyAfterSubscribe() {
        ObservableHandler o = RxHelper.observableHandler();
        TestSubscriber subscriber = new TestSubscriber();
        TestUtils.subscribe(o, subscriber);
        subscriber.assertEmpty();
        o.toHandler().handle((Object)"abc");
        subscriber.assertItem((Object)"abc").assertCompleted().assertEmpty();
    }

    @Test
    public void testMultiUnsubscribeBeforeNotify() {
        ObservableHandler o = RxHelper.observableHandler((boolean)true);
        TestSubscriber subscriber = new TestSubscriber();
        TestUtils.subscribe(o, subscriber);
        subscriber.unsubscribe();
        Assert.assertTrue((boolean)subscriber.isUnsubscribed());
        subscriber.assertEmpty();
        o.toHandler().handle((Object)"abc");
        subscriber.assertEmpty();
    }

    @Test
    public void testSingleUnsubscribeBeforeNotify() {
        ObservableHandler o = RxHelper.observableHandler();
        TestSubscriber subscriber = new TestSubscriber();
        TestUtils.subscribe(o, subscriber);
        subscriber.unsubscribe();
        Assert.assertTrue((boolean)subscriber.isUnsubscribed());
        subscriber.assertEmpty();
        o.toHandler().handle((Object)"abc");
        subscriber.assertEmpty();
    }

    @Test
    public void testMultiNotifyTwice() {
        ObservableHandler o = RxHelper.observableHandler((boolean)true);
        TestSubscriber subscriber = new TestSubscriber();
        TestUtils.subscribe(o, subscriber);
        o.toHandler().handle((Object)"abc");
        o.toHandler().handle((Object)"def");
        subscriber.assertItem((Object)"abc").assertItem((Object)"def").assertEmpty();
    }

    @Test
    public void testSingleNotifyTwice() {
        ObservableHandler o = RxHelper.observableHandler();
        TestSubscriber subscriber = new TestSubscriber();
        TestUtils.subscribe(o, subscriber);
        o.toHandler().handle((Object)"abc");
        o.toHandler().handle((Object)"def");
        subscriber.assertItem((Object)"abc").assertCompleted().assertEmpty();
    }

    @Test
    public void testMultiFulfillAdaptedSubscriber() {
        TestSubscriber subscriber = new TestSubscriber();
        Handler o = RxHelper.toHandler(TestUtils.toObserver(subscriber), (boolean)true);
        o.handle((Object)"abc");
        subscriber.assertItem((Object)"abc").assertEmpty();
    }

    @Test
    public void testSingleFulfillAdaptedSubscriber() {
        TestSubscriber subscriber = new TestSubscriber();
        Handler o = RxHelper.toHandler(TestUtils.toObserver(subscriber));
        o.handle((Object)"abc");
        subscriber.assertItem((Object)"abc").assertCompleted().assertEmpty();
    }

    @Test
    public void testFulfillAdaptedFunctions1() {
        ArrayList items = new ArrayList();
        Handler o = RxHelper.toHandler(items::add);
        o.handle((Object)"abc");
        Assert.assertEquals(Collections.singletonList("abc"), items);
    }
}

