/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java.test;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.test.TestSubscriber;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.test.TestUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import rx.exceptions.OnErrorNotImplementedException;

public class AsyncResultHandlerTest {
    @Test
    public void testCompleteWithSuccessBeforeSubscribe() {
        ObservableFuture o = RxHelper.observableFuture();
        o.toHandler().handle((Object)Future.succeededFuture((Object)"abc"));
        TestSubscriber subscriber = new TestSubscriber();
        TestUtils.subscribe(o, subscriber);
        subscriber.assertItem((Object)"abc").assertCompleted().assertEmpty();
    }

    @Test
    public void testCompleteWithSuccessAfterSubscribe() {
        ObservableFuture o = RxHelper.observableFuture();
        TestSubscriber subscriber = new TestSubscriber();
        TestUtils.subscribe(o, subscriber);
        subscriber.assertEmpty();
        o.toHandler().handle((Object)Future.succeededFuture((Object)"abc"));
        subscriber.assertItem((Object)"abc").assertCompleted().assertEmpty();
    }

    @Test
    public void testCompleteWithFailureBeforeSubscribe() {
        ObservableFuture o = RxHelper.observableFuture();
        Throwable failure = new Throwable();
        o.toHandler().handle((Object)Future.failedFuture((Throwable)failure));
        TestSubscriber subscriber = new TestSubscriber();
        TestUtils.subscribe(o, subscriber);
        subscriber.assertError(failure).assertEmpty();
    }

    @Test
    public void testCompleteWithFailureAfterSubscribe() {
        ObservableFuture o = RxHelper.observableFuture();
        TestSubscriber subscriber = new TestSubscriber();
        TestUtils.subscribe(o, subscriber);
        subscriber.assertEmpty();
        Throwable failure = new Throwable();
        o.toHandler().handle((Object)Future.failedFuture((Throwable)failure));
        subscriber.assertError(failure).assertEmpty();
    }

    @Test
    public void testUnsubscribeBeforeResolve() {
        ObservableFuture o = RxHelper.observableFuture();
        TestSubscriber subscriber = new TestSubscriber();
        TestUtils.subscribe(o, subscriber);
        subscriber.unsubscribe();
        Assert.assertTrue((boolean)subscriber.isUnsubscribed());
        subscriber.assertEmpty();
    }

    @Test
    public void testCompleteTwice() {
        ObservableFuture o = RxHelper.observableFuture();
        TestSubscriber subscriber = new TestSubscriber();
        TestUtils.subscribe(o, subscriber);
        o.toHandler().handle((Object)Future.succeededFuture((Object)"abc"));
        o.toHandler().handle((Object)Future.succeededFuture((Object)"def"));
        subscriber.assertItem((Object)"abc").assertCompleted().assertEmpty();
    }

    @Test
    public void testFailTwice() {
        ObservableFuture o = RxHelper.observableFuture();
        TestSubscriber subscriber = new TestSubscriber();
        TestUtils.subscribe(o, subscriber);
        Throwable failure = new Throwable();
        o.toHandler().handle((Object)Future.failedFuture((Throwable)failure));
        o.toHandler().handle((Object)Future.failedFuture((Throwable)new Throwable()));
        subscriber.assertError(failure).assertEmpty();
    }

    @Test
    public void testFulfillAdaptedSubscriber() {
        TestSubscriber subscriber = new TestSubscriber();
        Handler o = RxHelper.toFuture(TestUtils.toObserver(subscriber));
        o.handle((Object)Future.succeededFuture((Object)"abc"));
        subscriber.assertItem((Object)"abc").assertCompleted().assertEmpty();
    }

    @Test
    public void testRejectAdaptedSubscriber() {
        TestSubscriber subscriber = new TestSubscriber();
        Handler o = RxHelper.toFuture(TestUtils.toObserver(subscriber));
        Exception e = new Exception();
        o.handle((Object)Future.failedFuture((Throwable)e));
        subscriber.assertError((Throwable)e).assertEmpty();
    }

    @Test
    public void testFulfillAdaptedFunctions1() {
        ArrayList items = new ArrayList();
        Handler o = RxHelper.toFuture(items::add);
        o.handle((Object)Future.succeededFuture((Object)"abc"));
        Assert.assertEquals(Collections.singletonList("abc"), items);
    }

    @Test
    public void testFulfillAdaptedFunctions2() {
        ArrayList items = new ArrayList();
        ArrayList errors = new ArrayList();
        Handler o = RxHelper.toFuture(items::add, errors::add);
        o.handle((Object)Future.succeededFuture((Object)"abc"));
        Assert.assertEquals(Collections.singletonList("abc"), items);
        Assert.assertEquals(Collections.emptyList(), errors);
    }

    @Test
    public void testFulfillAdaptedFunctions3() {
        ArrayList items = new ArrayList();
        ArrayList errors = new ArrayList();
        AtomicInteger completions = new AtomicInteger();
        Handler o = RxHelper.toFuture(items::add, errors::add, completions::incrementAndGet);
        o.handle((Object)Future.succeededFuture((Object)"abc"));
        Assert.assertEquals(Collections.singletonList("abc"), items);
        Assert.assertEquals(Collections.emptyList(), errors);
        Assert.assertEquals((long)1L, (long)completions.get());
    }

    @Test
    public void testRejectAdaptedFunctions1() {
        TestSubscriber subscriber = new TestSubscriber();
        Handler o = RxHelper.toFuture(arg_0 -> ((TestSubscriber)subscriber).onNext(arg_0));
        Exception cause = new Exception();
        try {
            o.handle((Object)Future.failedFuture((Throwable)cause));
        }
        catch (OnErrorNotImplementedException e) {
            Assert.assertSame((Object)cause, (Object)e.getCause());
        }
        subscriber.assertEmpty();
    }

    @Test
    public void testRejectAdaptedFunctions2() {
        TestSubscriber subscriber = new TestSubscriber();
        Handler o = RxHelper.toFuture(arg_0 -> ((TestSubscriber)subscriber).onNext(arg_0), arg_0 -> ((TestSubscriber)subscriber).onError(arg_0));
        Exception cause = new Exception();
        o.handle((Object)Future.failedFuture((Throwable)cause));
        subscriber.assertError((Throwable)cause).assertEmpty();
    }

    @Test
    public void testRejectAdaptedFunctions3() {
        TestSubscriber subscriber = new TestSubscriber();
        Handler o = RxHelper.toFuture(arg_0 -> ((TestSubscriber)subscriber).onNext(arg_0), arg_0 -> ((TestSubscriber)subscriber).onError(arg_0), () -> ((TestSubscriber)subscriber).onCompleted());
        Exception cause = new Exception();
        o.handle((Object)Future.failedFuture((Throwable)cause));
        subscriber.assertError((Throwable)cause).assertEmpty();
    }
}

