/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen.converter;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.test.codegen.converter.AggregatedDataObject;
import io.vertx.test.codegen.converter.TestDataObject;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TestDataObjectConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, TestDataObject obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "addedAggregatedDataObjects": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            obj.addAddedAggregatedDataObject(new AggregatedDataObject((JsonObject)item));
                        }
                    });
                    break;
                }
                case "addedBoxedBooleanValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Boolean) {
                            obj.addAddedBoxedBooleanValue((Boolean)item);
                        }
                    });
                    break;
                }
                case "addedBoxedByteValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            obj.addAddedBoxedByteValue(((Number)item).byteValue());
                        }
                    });
                    break;
                }
                case "addedBoxedCharValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addAddedBoxedCharValue(Character.valueOf(((String)item).charAt(0)));
                        }
                    });
                    break;
                }
                case "addedBoxedDoubleValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            obj.addAddedBoxedDoubleValue(((Number)item).doubleValue());
                        }
                    });
                    break;
                }
                case "addedBoxedFloatValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            obj.addAddedBoxedFloatValue(Float.valueOf(((Number)item).floatValue()));
                        }
                    });
                    break;
                }
                case "addedBoxedIntValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            obj.addAddedBoxedIntValue(((Number)item).intValue());
                        }
                    });
                    break;
                }
                case "addedBoxedLongValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            obj.addAddedBoxedLongValue(((Number)item).longValue());
                        }
                    });
                    break;
                }
                case "addedBoxedShortValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            obj.addAddedBoxedShortValue(((Number)item).shortValue());
                        }
                    });
                    break;
                }
                case "addedBuffers": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addAddedBuffer(Buffer.buffer((byte[])Base64.getDecoder().decode((String)item)));
                        }
                    });
                    break;
                }
                case "addedHttpMethods": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addAddedHttpMethod(TimeUnit.valueOf((String)item));
                        }
                    });
                    break;
                }
                case "addedJsonArrays": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonArray) {
                            obj.addAddedJsonArray(((JsonArray)item).copy());
                        }
                    });
                    break;
                }
                case "addedJsonObjects": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            obj.addAddedJsonObject(((JsonObject)item).copy());
                        }
                    });
                    break;
                }
                case "addedObjects": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Object) {
                            obj.addAddedObject(item);
                        }
                    });
                    break;
                }
                case "addedStringValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addAddedStringValue((String)item);
                        }
                    });
                    break;
                }
                case "aggregatedDataObject": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setAggregatedDataObject(new AggregatedDataObject((JsonObject)member.getValue()));
                    break;
                }
                case "aggregatedDataObjectMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof JsonObject) {
                            map.put((String)entry.getKey(), new AggregatedDataObject((JsonObject)entry.getValue()));
                        }
                    });
                    obj.setAggregatedDataObjectMap(map);
                    break;
                }
                case "aggregatedDataObjectSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new AggregatedDataObject((JsonObject)item));
                        }
                    });
                    obj.setAggregatedDataObjectSet(list);
                    break;
                }
                case "aggregatedDataObjects": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new AggregatedDataObject((JsonObject)item));
                        }
                    });
                    obj.setAggregatedDataObjects((List<AggregatedDataObject>)((Object)list));
                    break;
                }
                case "booleanValue": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setBooleanValue((Boolean)member.getValue());
                    break;
                }
                case "boxedBooleanSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Boolean) {
                            list.add((Boolean)item);
                        }
                    });
                    obj.setBoxedBooleanSet(list);
                    break;
                }
                case "boxedBooleanValue": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setBoxedBooleanValue((Boolean)member.getValue());
                    break;
                }
                case "boxedBooleanValueMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Boolean) {
                            map.put((String)entry.getKey(), (Boolean)entry.getValue());
                        }
                    });
                    obj.setBoxedBooleanValueMap(map);
                    break;
                }
                case "boxedBooleanValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Boolean) {
                            list.add((Boolean)item);
                        }
                    });
                    obj.setBoxedBooleanValues((List<Boolean>)((Object)list));
                    break;
                }
                case "boxedByteSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(((Number)item).byteValue());
                        }
                    });
                    obj.setBoxedByteSet(list);
                    break;
                }
                case "boxedByteValue": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setBoxedByteValue(((Number)member.getValue()).byteValue());
                    break;
                }
                case "boxedByteValueMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            map.put((String)entry.getKey(), ((Number)entry.getValue()).byteValue());
                        }
                    });
                    obj.setBoxedByteValueMap(map);
                    break;
                }
                case "boxedByteValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(((Number)item).byteValue());
                        }
                    });
                    obj.setBoxedByteValues((List<Byte>)((Object)list));
                    break;
                }
                case "boxedCharSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add(Character.valueOf(((String)item).charAt(0)));
                        }
                    });
                    obj.setBoxedCharSet(list);
                    break;
                }
                case "boxedCharValue": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setBoxedCharValue(Character.valueOf(((String)member.getValue()).charAt(0)));
                    break;
                }
                case "boxedCharValueMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), Character.valueOf(((String)entry.getValue()).charAt(0)));
                        }
                    });
                    obj.setBoxedCharValueMap(map);
                    break;
                }
                case "boxedCharValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add(Character.valueOf(((String)item).charAt(0)));
                        }
                    });
                    obj.setBoxedCharValues((List<Character>)((Object)list));
                    break;
                }
                case "boxedDoubleSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(((Number)item).doubleValue());
                        }
                    });
                    obj.setBoxedDoubleSet(list);
                    break;
                }
                case "boxedDoubleValue": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setBoxedDoubleValue(((Number)member.getValue()).doubleValue());
                    break;
                }
                case "boxedDoubleValueMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            map.put((String)entry.getKey(), ((Number)entry.getValue()).doubleValue());
                        }
                    });
                    obj.setBoxedDoubleValueMap(map);
                    break;
                }
                case "boxedDoubleValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(((Number)item).doubleValue());
                        }
                    });
                    obj.setBoxedDoubleValues((List<Double>)((Object)list));
                    break;
                }
                case "boxedFloatSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(Float.valueOf(((Number)item).floatValue()));
                        }
                    });
                    obj.setBoxedFloatSet(list);
                    break;
                }
                case "boxedFloatValue": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setBoxedFloatValue(Float.valueOf(((Number)member.getValue()).floatValue()));
                    break;
                }
                case "boxedFloatValueMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            map.put((String)entry.getKey(), Float.valueOf(((Number)entry.getValue()).floatValue()));
                        }
                    });
                    obj.setBoxedFloatValueMap(map);
                    break;
                }
                case "boxedFloatValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(Float.valueOf(((Number)item).floatValue()));
                        }
                    });
                    obj.setBoxedFloatValues((List<Float>)((Object)list));
                    break;
                }
                case "boxedIntSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(((Number)item).intValue());
                        }
                    });
                    obj.setBoxedIntSet(list);
                    break;
                }
                case "boxedIntValue": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setBoxedIntValue(((Number)member.getValue()).intValue());
                    break;
                }
                case "boxedIntValueMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            map.put((String)entry.getKey(), ((Number)entry.getValue()).intValue());
                        }
                    });
                    obj.setBoxedIntValueMap(map);
                    break;
                }
                case "boxedIntValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(((Number)item).intValue());
                        }
                    });
                    obj.setBoxedIntValues((List<Integer>)((Object)list));
                    break;
                }
                case "boxedLongSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(((Number)item).longValue());
                        }
                    });
                    obj.setBoxedLongSet(list);
                    break;
                }
                case "boxedLongValue": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setBoxedLongValue(((Number)member.getValue()).longValue());
                    break;
                }
                case "boxedLongValueMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            map.put((String)entry.getKey(), ((Number)entry.getValue()).longValue());
                        }
                    });
                    obj.setBoxedLongValueMap(map);
                    break;
                }
                case "boxedLongValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(((Number)item).longValue());
                        }
                    });
                    obj.setBoxedLongValues((List<Long>)((Object)list));
                    break;
                }
                case "boxedShortSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(((Number)item).shortValue());
                        }
                    });
                    obj.setBoxedShortSet(list);
                    break;
                }
                case "boxedShortValue": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setBoxedShortValue(((Number)member.getValue()).shortValue());
                    break;
                }
                case "boxedShortValueMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            map.put((String)entry.getKey(), ((Number)entry.getValue()).shortValue());
                        }
                    });
                    obj.setBoxedShortValueMap(map);
                    break;
                }
                case "boxedShortValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(((Number)item).shortValue());
                        }
                    });
                    obj.setBoxedShortValues((List<Short>)((Object)list));
                    break;
                }
                case "buffer": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setBuffer(Buffer.buffer((byte[])Base64.getDecoder().decode((String)member.getValue())));
                    break;
                }
                case "bufferMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), Buffer.buffer((byte[])Base64.getDecoder().decode((String)entry.getValue())));
                        }
                    });
                    obj.setBufferMap(map);
                    break;
                }
                case "bufferSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add(Buffer.buffer((byte[])Base64.getDecoder().decode((String)item)));
                        }
                    });
                    obj.setBufferSet(list);
                    break;
                }
                case "buffers": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add(Buffer.buffer((byte[])Base64.getDecoder().decode((String)item)));
                        }
                    });
                    obj.setBuffers((List<Buffer>)((Object)list));
                    break;
                }
                case "byteValue": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setByteValue(((Number)member.getValue()).byteValue());
                    break;
                }
                case "charValue": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setCharValue(((String)member.getValue()).charAt(0));
                    break;
                }
                case "doubleValue": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setDoubleValue(((Number)member.getValue()).doubleValue());
                    break;
                }
                case "floatValue": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setFloatValue(((Number)member.getValue()).floatValue());
                    break;
                }
                case "httpMethod": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHttpMethod(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "httpMethodMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), (Object)TimeUnit.valueOf((String)entry.getValue()));
                        }
                    });
                    obj.setHttpMethodMap(map);
                    break;
                }
                case "httpMethodSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((Object)TimeUnit.valueOf((String)item));
                        }
                    });
                    obj.setHttpMethodSet(list);
                    break;
                }
                case "httpMethods": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((Object)TimeUnit.valueOf((String)item));
                        }
                    });
                    obj.setHttpMethods((List<TimeUnit>)((Object)list));
                    break;
                }
                case "intValue": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setIntValue(((Number)member.getValue()).intValue());
                    break;
                }
                case "jsonArray": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    obj.setJsonArray(((JsonArray)member.getValue()).copy());
                    break;
                }
                case "jsonArrayMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof JsonArray) {
                            map.put((String)entry.getKey(), ((JsonArray)entry.getValue()).copy());
                        }
                    });
                    obj.setJsonArrayMap(map);
                    break;
                }
                case "jsonArraySet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonArray) {
                            list.add(((JsonArray)item).copy());
                        }
                    });
                    obj.setJsonArraySet(list);
                    break;
                }
                case "jsonArrays": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonArray) {
                            list.add(((JsonArray)item).copy());
                        }
                    });
                    obj.setJsonArrays((List<JsonArray>)((Object)list));
                    break;
                }
                case "jsonObject": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setJsonObject(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "jsonObjectMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof JsonObject) {
                            map.put((String)entry.getKey(), ((JsonObject)entry.getValue()).copy());
                        }
                    });
                    obj.setJsonObjectMap(map);
                    break;
                }
                case "jsonObjectSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(((JsonObject)item).copy());
                        }
                    });
                    obj.setJsonObjectSet(list);
                    break;
                }
                case "jsonObjects": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(((JsonObject)item).copy());
                        }
                    });
                    obj.setJsonObjects((List<JsonObject>)((Object)list));
                    break;
                }
                case "keyedBoxedBooleanValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Boolean) {
                            obj.addKeyedBoxedBooleanValue((String)entry.getKey(), (Boolean)entry.getValue());
                        }
                    });
                    break;
                }
                case "keyedBoxedByteValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            obj.addKeyedBoxedByteValue((String)entry.getKey(), ((Number)entry.getValue()).byteValue());
                        }
                    });
                    break;
                }
                case "keyedBoxedCharValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            obj.addKeyedBoxedCharValue((String)entry.getKey(), Character.valueOf(((String)entry.getValue()).charAt(0)));
                        }
                    });
                    break;
                }
                case "keyedBoxedDoubleValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            obj.addKeyedBoxedDoubleValue((String)entry.getKey(), ((Number)entry.getValue()).doubleValue());
                        }
                    });
                    break;
                }
                case "keyedBoxedFloatValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            obj.addKeyedBoxedFloatValue((String)entry.getKey(), Float.valueOf(((Number)entry.getValue()).floatValue()));
                        }
                    });
                    break;
                }
                case "keyedBoxedIntValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            obj.addKeyedBoxedIntValue((String)entry.getKey(), ((Number)entry.getValue()).intValue());
                        }
                    });
                    break;
                }
                case "keyedBoxedLongValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            obj.addKeyedBoxedLongValue((String)entry.getKey(), ((Number)entry.getValue()).longValue());
                        }
                    });
                    break;
                }
                case "keyedBoxedShortValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            obj.addKeyedBoxedShortValue((String)entry.getKey(), ((Number)entry.getValue()).shortValue());
                        }
                    });
                    break;
                }
                case "keyedBufferValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            obj.addKeyedBufferValue((String)entry.getKey(), Buffer.buffer((byte[])Base64.getDecoder().decode((String)entry.getValue())));
                        }
                    });
                    break;
                }
                case "keyedDataObjectValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof JsonObject) {
                            obj.addKeyedDataObjectValue((String)entry.getKey(), new AggregatedDataObject((JsonObject)entry.getValue()));
                        }
                    });
                    break;
                }
                case "keyedEnumValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            obj.addKeyedEnumValue((String)entry.getKey(), TimeUnit.valueOf((String)entry.getValue()));
                        }
                    });
                    break;
                }
                case "keyedJsonArrayValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof JsonArray) {
                            obj.addKeyedJsonArrayValue((String)entry.getKey(), ((JsonArray)entry.getValue()).copy());
                        }
                    });
                    break;
                }
                case "keyedJsonObjectValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof JsonObject) {
                            obj.addKeyedJsonObjectValue((String)entry.getKey(), ((JsonObject)entry.getValue()).copy());
                        }
                    });
                    break;
                }
                case "keyedObjectValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Object) {
                            obj.addKeyedObjectValue((String)entry.getKey(), entry.getValue());
                        }
                    });
                    break;
                }
                case "keyedStringValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            obj.addKeyedStringValue((String)entry.getKey(), (String)entry.getValue());
                        }
                    });
                    break;
                }
                case "longValue": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setLongValue(((Number)member.getValue()).longValue());
                    break;
                }
                case "objectMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Object) {
                            map.put((String)entry.getKey(), entry.getValue());
                        }
                    });
                    obj.setObjectMap(map);
                    break;
                }
                case "objectSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Object) {
                            list.add(item);
                        }
                    });
                    obj.setObjectSet(list);
                    break;
                }
                case "objects": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Object) {
                            list.add(item);
                        }
                    });
                    obj.setObjects((List<Object>)((Object)list));
                    break;
                }
                case "shortValue": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setShortValue(((Number)member.getValue()).shortValue());
                    break;
                }
                case "stringSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setStringSet(list);
                    break;
                }
                case "stringValue": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setStringValue((String)member.getValue());
                    break;
                }
                case "stringValueMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), (String)entry.getValue());
                        }
                    });
                    obj.setStringValueMap(map);
                    break;
                }
                case "stringValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setStringValues((List<String>)((Object)list));
                }
            }
        }
    }

    public static void toJson(TestDataObject obj, JsonObject json) {
        TestDataObjectConverter.toJson(obj, json.getMap());
    }

    public static void toJson(TestDataObject obj, Map<String, Object> json) {
        JsonObject map;
        JsonArray array;
        if (obj.getAddedAggregatedDataObjects() != null) {
            array = new JsonArray();
            obj.getAddedAggregatedDataObjects().forEach(item -> array.add((Object)item.toJson()));
            json.put("addedAggregatedDataObjects", array);
        }
        if (obj.getAddedBoxedBooleanValues() != null) {
            array = new JsonArray();
            obj.getAddedBoxedBooleanValues().forEach(item -> array.add(item));
            json.put("addedBoxedBooleanValues", array);
        }
        if (obj.getAddedBoxedByteValues() != null) {
            array = new JsonArray();
            obj.getAddedBoxedByteValues().forEach(item -> array.add(item));
            json.put("addedBoxedByteValues", array);
        }
        if (obj.getAddedBoxedCharValues() != null) {
            array = new JsonArray();
            obj.getAddedBoxedCharValues().forEach(item -> array.add((Object)Character.toString(item.charValue())));
            json.put("addedBoxedCharValues", array);
        }
        if (obj.getAddedBoxedDoubleValues() != null) {
            array = new JsonArray();
            obj.getAddedBoxedDoubleValues().forEach(item -> array.add(item));
            json.put("addedBoxedDoubleValues", array);
        }
        if (obj.getAddedBoxedFloatValues() != null) {
            array = new JsonArray();
            obj.getAddedBoxedFloatValues().forEach(item -> array.add(item));
            json.put("addedBoxedFloatValues", array);
        }
        if (obj.getAddedBoxedIntValues() != null) {
            array = new JsonArray();
            obj.getAddedBoxedIntValues().forEach(item -> array.add(item));
            json.put("addedBoxedIntValues", array);
        }
        if (obj.getAddedBoxedLongValues() != null) {
            array = new JsonArray();
            obj.getAddedBoxedLongValues().forEach(item -> array.add(item));
            json.put("addedBoxedLongValues", array);
        }
        if (obj.getAddedBoxedShortValues() != null) {
            array = new JsonArray();
            obj.getAddedBoxedShortValues().forEach(item -> array.add(item));
            json.put("addedBoxedShortValues", array);
        }
        if (obj.getAddedBuffers() != null) {
            array = new JsonArray();
            obj.getAddedBuffers().forEach(item -> array.add((Object)Base64.getEncoder().encodeToString(item.getBytes())));
            json.put("addedBuffers", array);
        }
        if (obj.getAddedHttpMethods() != null) {
            array = new JsonArray();
            obj.getAddedHttpMethods().forEach(item -> array.add((Object)item.name()));
            json.put("addedHttpMethods", array);
        }
        if (obj.getAddedJsonArrays() != null) {
            array = new JsonArray();
            obj.getAddedJsonArrays().forEach(item -> array.add(item));
            json.put("addedJsonArrays", array);
        }
        if (obj.getAddedJsonObjects() != null) {
            array = new JsonArray();
            obj.getAddedJsonObjects().forEach(item -> array.add(item));
            json.put("addedJsonObjects", array);
        }
        if (obj.getAddedObjects() != null) {
            array = new JsonArray();
            obj.getAddedObjects().forEach(item -> array.add(item));
            json.put("addedObjects", array);
        }
        if (obj.getAddedStringValues() != null) {
            array = new JsonArray();
            obj.getAddedStringValues().forEach(item -> array.add(item));
            json.put("addedStringValues", array);
        }
        if (obj.getAggregatedDataObject() != null) {
            json.put("aggregatedDataObject", obj.getAggregatedDataObject().toJson());
        }
        if (obj.getAggregatedDataObjectMap() != null) {
            map = new JsonObject();
            obj.getAggregatedDataObjectMap().forEach((key, value) -> map.put(key, (Object)value.toJson()));
            json.put("aggregatedDataObjectMap", map);
        }
        if (obj.getAggregatedDataObjectSet() != null) {
            array = new JsonArray();
            obj.getAggregatedDataObjectSet().forEach(item -> array.add((Object)item.toJson()));
            json.put("aggregatedDataObjectSet", array);
        }
        if (obj.getAggregatedDataObjects() != null) {
            array = new JsonArray();
            obj.getAggregatedDataObjects().forEach(item -> array.add((Object)item.toJson()));
            json.put("aggregatedDataObjects", array);
        }
        json.put("booleanValue", obj.isBooleanValue());
        if (obj.getBoxedBooleanSet() != null) {
            array = new JsonArray();
            obj.getBoxedBooleanSet().forEach(item -> array.add(item));
            json.put("boxedBooleanSet", array);
        }
        if (obj.isBoxedBooleanValue() != null) {
            json.put("boxedBooleanValue", obj.isBoxedBooleanValue());
        }
        if (obj.getBoxedBooleanValueMap() != null) {
            map = new JsonObject();
            obj.getBoxedBooleanValueMap().forEach((key, value) -> map.put(key, value));
            json.put("boxedBooleanValueMap", map);
        }
        if (obj.getBoxedBooleanValues() != null) {
            array = new JsonArray();
            obj.getBoxedBooleanValues().forEach(item -> array.add(item));
            json.put("boxedBooleanValues", array);
        }
        if (obj.getBoxedByteSet() != null) {
            array = new JsonArray();
            obj.getBoxedByteSet().forEach(item -> array.add(item));
            json.put("boxedByteSet", array);
        }
        if (obj.getBoxedByteValue() != null) {
            json.put("boxedByteValue", obj.getBoxedByteValue());
        }
        if (obj.getBoxedByteValueMap() != null) {
            map = new JsonObject();
            obj.getBoxedByteValueMap().forEach((key, value) -> map.put(key, value));
            json.put("boxedByteValueMap", map);
        }
        if (obj.getBoxedByteValues() != null) {
            array = new JsonArray();
            obj.getBoxedByteValues().forEach(item -> array.add(item));
            json.put("boxedByteValues", array);
        }
        if (obj.getBoxedCharSet() != null) {
            array = new JsonArray();
            obj.getBoxedCharSet().forEach(item -> array.add((Object)Character.toString(item.charValue())));
            json.put("boxedCharSet", array);
        }
        if (obj.getBoxedCharValue() != null) {
            json.put("boxedCharValue", Character.toString(obj.getBoxedCharValue().charValue()));
        }
        if (obj.getBoxedCharValueMap() != null) {
            map = new JsonObject();
            obj.getBoxedCharValueMap().forEach((key, value) -> map.put(key, (Object)Character.toString(value.charValue())));
            json.put("boxedCharValueMap", map);
        }
        if (obj.getBoxedCharValues() != null) {
            array = new JsonArray();
            obj.getBoxedCharValues().forEach(item -> array.add((Object)Character.toString(item.charValue())));
            json.put("boxedCharValues", array);
        }
        if (obj.getBoxedDoubleSet() != null) {
            array = new JsonArray();
            obj.getBoxedDoubleSet().forEach(item -> array.add(item));
            json.put("boxedDoubleSet", array);
        }
        if (obj.getBoxedDoubleValue() != null) {
            json.put("boxedDoubleValue", obj.getBoxedDoubleValue());
        }
        if (obj.getBoxedDoubleValueMap() != null) {
            map = new JsonObject();
            obj.getBoxedDoubleValueMap().forEach((key, value) -> map.put(key, value));
            json.put("boxedDoubleValueMap", map);
        }
        if (obj.getBoxedDoubleValues() != null) {
            array = new JsonArray();
            obj.getBoxedDoubleValues().forEach(item -> array.add(item));
            json.put("boxedDoubleValues", array);
        }
        if (obj.getBoxedFloatSet() != null) {
            array = new JsonArray();
            obj.getBoxedFloatSet().forEach(item -> array.add(item));
            json.put("boxedFloatSet", array);
        }
        if (obj.getBoxedFloatValue() != null) {
            json.put("boxedFloatValue", obj.getBoxedFloatValue());
        }
        if (obj.getBoxedFloatValueMap() != null) {
            map = new JsonObject();
            obj.getBoxedFloatValueMap().forEach((key, value) -> map.put(key, value));
            json.put("boxedFloatValueMap", map);
        }
        if (obj.getBoxedFloatValues() != null) {
            array = new JsonArray();
            obj.getBoxedFloatValues().forEach(item -> array.add(item));
            json.put("boxedFloatValues", array);
        }
        if (obj.getBoxedIntSet() != null) {
            array = new JsonArray();
            obj.getBoxedIntSet().forEach(item -> array.add(item));
            json.put("boxedIntSet", array);
        }
        if (obj.getBoxedIntValue() != null) {
            json.put("boxedIntValue", obj.getBoxedIntValue());
        }
        if (obj.getBoxedIntValueMap() != null) {
            map = new JsonObject();
            obj.getBoxedIntValueMap().forEach((key, value) -> map.put(key, value));
            json.put("boxedIntValueMap", map);
        }
        if (obj.getBoxedIntValues() != null) {
            array = new JsonArray();
            obj.getBoxedIntValues().forEach(item -> array.add(item));
            json.put("boxedIntValues", array);
        }
        if (obj.getBoxedLongSet() != null) {
            array = new JsonArray();
            obj.getBoxedLongSet().forEach(item -> array.add(item));
            json.put("boxedLongSet", array);
        }
        if (obj.getBoxedLongValue() != null) {
            json.put("boxedLongValue", obj.getBoxedLongValue());
        }
        if (obj.getBoxedLongValueMap() != null) {
            map = new JsonObject();
            obj.getBoxedLongValueMap().forEach((key, value) -> map.put(key, value));
            json.put("boxedLongValueMap", map);
        }
        if (obj.getBoxedLongValues() != null) {
            array = new JsonArray();
            obj.getBoxedLongValues().forEach(item -> array.add(item));
            json.put("boxedLongValues", array);
        }
        if (obj.getBoxedShortSet() != null) {
            array = new JsonArray();
            obj.getBoxedShortSet().forEach(item -> array.add(item));
            json.put("boxedShortSet", array);
        }
        if (obj.getBoxedShortValue() != null) {
            json.put("boxedShortValue", obj.getBoxedShortValue());
        }
        if (obj.getBoxedShortValueMap() != null) {
            map = new JsonObject();
            obj.getBoxedShortValueMap().forEach((key, value) -> map.put(key, value));
            json.put("boxedShortValueMap", map);
        }
        if (obj.getBoxedShortValues() != null) {
            array = new JsonArray();
            obj.getBoxedShortValues().forEach(item -> array.add(item));
            json.put("boxedShortValues", array);
        }
        if (obj.getBuffer() != null) {
            json.put("buffer", Base64.getEncoder().encodeToString(obj.getBuffer().getBytes()));
        }
        if (obj.getBufferMap() != null) {
            map = new JsonObject();
            obj.getBufferMap().forEach((key, value) -> map.put(key, (Object)Base64.getEncoder().encodeToString(value.getBytes())));
            json.put("bufferMap", map);
        }
        if (obj.getBufferSet() != null) {
            array = new JsonArray();
            obj.getBufferSet().forEach(item -> array.add((Object)Base64.getEncoder().encodeToString(item.getBytes())));
            json.put("bufferSet", array);
        }
        if (obj.getBuffers() != null) {
            array = new JsonArray();
            obj.getBuffers().forEach(item -> array.add((Object)Base64.getEncoder().encodeToString(item.getBytes())));
            json.put("buffers", array);
        }
        json.put("byteValue", obj.getByteValue());
        json.put("charValue", Character.toString(obj.getCharValue()));
        json.put("doubleValue", obj.getDoubleValue());
        json.put("floatValue", Float.valueOf(obj.getFloatValue()));
        if (obj.getHttpMethod() != null) {
            json.put("httpMethod", obj.getHttpMethod().name());
        }
        if (obj.getHttpMethodMap() != null) {
            map = new JsonObject();
            obj.getHttpMethodMap().forEach((key, value) -> map.put(key, (Object)value.name()));
            json.put("httpMethodMap", map);
        }
        if (obj.getHttpMethodSet() != null) {
            array = new JsonArray();
            obj.getHttpMethodSet().forEach(item -> array.add((Object)item.name()));
            json.put("httpMethodSet", array);
        }
        if (obj.getHttpMethods() != null) {
            array = new JsonArray();
            obj.getHttpMethods().forEach(item -> array.add((Object)item.name()));
            json.put("httpMethods", array);
        }
        json.put("intValue", obj.getIntValue());
        if (obj.getJsonArray() != null) {
            json.put("jsonArray", obj.getJsonArray());
        }
        if (obj.getJsonArrayMap() != null) {
            map = new JsonObject();
            obj.getJsonArrayMap().forEach((key, value) -> map.put(key, value));
            json.put("jsonArrayMap", map);
        }
        if (obj.getJsonArraySet() != null) {
            array = new JsonArray();
            obj.getJsonArraySet().forEach(item -> array.add(item));
            json.put("jsonArraySet", array);
        }
        if (obj.getJsonArrays() != null) {
            array = new JsonArray();
            obj.getJsonArrays().forEach(item -> array.add(item));
            json.put("jsonArrays", array);
        }
        if (obj.getJsonObject() != null) {
            json.put("jsonObject", obj.getJsonObject());
        }
        if (obj.getJsonObjectMap() != null) {
            map = new JsonObject();
            obj.getJsonObjectMap().forEach((key, value) -> map.put(key, value));
            json.put("jsonObjectMap", map);
        }
        if (obj.getJsonObjectSet() != null) {
            array = new JsonArray();
            obj.getJsonObjectSet().forEach(item -> array.add(item));
            json.put("jsonObjectSet", array);
        }
        if (obj.getJsonObjects() != null) {
            array = new JsonArray();
            obj.getJsonObjects().forEach(item -> array.add(item));
            json.put("jsonObjects", array);
        }
        if (obj.getKeyedBoxedBooleanValues() != null) {
            map = new JsonObject();
            obj.getKeyedBoxedBooleanValues().forEach((key, value) -> map.put(key, value));
            json.put("keyedBoxedBooleanValues", map);
        }
        if (obj.getKeyedBoxedByteValues() != null) {
            map = new JsonObject();
            obj.getKeyedBoxedByteValues().forEach((key, value) -> map.put(key, value));
            json.put("keyedBoxedByteValues", map);
        }
        if (obj.getKeyedBoxedCharValues() != null) {
            map = new JsonObject();
            obj.getKeyedBoxedCharValues().forEach((key, value) -> map.put(key, (Object)Character.toString(value.charValue())));
            json.put("keyedBoxedCharValues", map);
        }
        if (obj.getKeyedBoxedDoubleValues() != null) {
            map = new JsonObject();
            obj.getKeyedBoxedDoubleValues().forEach((key, value) -> map.put(key, value));
            json.put("keyedBoxedDoubleValues", map);
        }
        if (obj.getKeyedBoxedFloatValues() != null) {
            map = new JsonObject();
            obj.getKeyedBoxedFloatValues().forEach((key, value) -> map.put(key, value));
            json.put("keyedBoxedFloatValues", map);
        }
        if (obj.getKeyedBoxedIntValues() != null) {
            map = new JsonObject();
            obj.getKeyedBoxedIntValues().forEach((key, value) -> map.put(key, value));
            json.put("keyedBoxedIntValues", map);
        }
        if (obj.getKeyedBoxedLongValues() != null) {
            map = new JsonObject();
            obj.getKeyedBoxedLongValues().forEach((key, value) -> map.put(key, value));
            json.put("keyedBoxedLongValues", map);
        }
        if (obj.getKeyedBoxedShortValues() != null) {
            map = new JsonObject();
            obj.getKeyedBoxedShortValues().forEach((key, value) -> map.put(key, value));
            json.put("keyedBoxedShortValues", map);
        }
        if (obj.getKeyedBufferValues() != null) {
            map = new JsonObject();
            obj.getKeyedBufferValues().forEach((key, value) -> map.put(key, (Object)Base64.getEncoder().encodeToString(value.getBytes())));
            json.put("keyedBufferValues", map);
        }
        if (obj.getKeyedDataObjectValues() != null) {
            map = new JsonObject();
            obj.getKeyedDataObjectValues().forEach((key, value) -> map.put(key, (Object)value.toJson()));
            json.put("keyedDataObjectValues", map);
        }
        if (obj.getKeyedEnumValues() != null) {
            map = new JsonObject();
            obj.getKeyedEnumValues().forEach((key, value) -> map.put(key, (Object)value.name()));
            json.put("keyedEnumValues", map);
        }
        if (obj.getKeyedJsonArrayValues() != null) {
            map = new JsonObject();
            obj.getKeyedJsonArrayValues().forEach((key, value) -> map.put(key, value));
            json.put("keyedJsonArrayValues", map);
        }
        if (obj.getKeyedJsonObjectValues() != null) {
            map = new JsonObject();
            obj.getKeyedJsonObjectValues().forEach((key, value) -> map.put(key, value));
            json.put("keyedJsonObjectValues", map);
        }
        if (obj.getKeyedObjectValues() != null) {
            map = new JsonObject();
            obj.getKeyedObjectValues().forEach((key, value) -> map.put(key, value));
            json.put("keyedObjectValues", map);
        }
        if (obj.getKeyedStringValues() != null) {
            map = new JsonObject();
            obj.getKeyedStringValues().forEach((key, value) -> map.put(key, value));
            json.put("keyedStringValues", map);
        }
        json.put("longValue", obj.getLongValue());
        if (obj.getObjectMap() != null) {
            map = new JsonObject();
            obj.getObjectMap().forEach((key, value) -> map.put(key, value));
            json.put("objectMap", map);
        }
        if (obj.getObjectSet() != null) {
            array = new JsonArray();
            obj.getObjectSet().forEach(item -> array.add(item));
            json.put("objectSet", array);
        }
        if (obj.getObjects() != null) {
            array = new JsonArray();
            obj.getObjects().forEach(item -> array.add(item));
            json.put("objects", array);
        }
        json.put("shortValue", obj.getShortValue());
        if (obj.getStringSet() != null) {
            array = new JsonArray();
            obj.getStringSet().forEach(item -> array.add(item));
            json.put("stringSet", array);
        }
        if (obj.getStringValue() != null) {
            json.put("stringValue", obj.getStringValue());
        }
        if (obj.getStringValueMap() != null) {
            map = new JsonObject();
            obj.getStringValueMap().forEach((key, value) -> map.put(key, value));
            json.put("stringValueMap", map);
        }
        if (obj.getStringValues() != null) {
            array = new JsonArray();
            obj.getStringValues().forEach(item -> array.add(item));
            json.put("stringValues", array);
        }
    }
}

