/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen;

import io.vertx.codegen.ClassModel;
import io.vertx.codegen.CodeGen;
import io.vertx.codegen.Compiler;
import io.vertx.codegen.DataObjectModel;
import io.vertx.codegen.EnumModel;
import io.vertx.codegen.ModuleModel;
import io.vertx.codegen.PackageModel;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.ModuleGen;
import io.vertx.codegen.annotations.ProxyGen;
import io.vertx.codegen.annotations.VertxGen;
import java.io.File;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.processing.Completion;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;

public class GeneratorHelper {
    DiagnosticCollector<JavaFileObject> collector = new DiagnosticCollector();

    public PackageModel generatePackage(Class clazz, Set<Class> otherSupportedAnnotations) throws Exception {
        URL url = clazz.getClassLoader().getResource(clazz.getName().replace('.', '/') + ".java");
        File f = new File(url.toURI());
        MyProcessor processor = new MyProcessor(codegen -> codegen.getPackageModel(clazz.getPackage().getName()), otherSupportedAnnotations.stream().map(Class::getCanonicalName).collect(Collectors.toSet()));
        Compiler compiler = new Compiler(processor, this.collector);
        compiler.compile(new File[]{f});
        return (PackageModel)processor.result;
    }

    public PackageModel generatePackage(Class clazz) throws Exception {
        return this.generatePackage(clazz, new HashSet<Class>());
    }

    public ModuleModel generateModule(ClassLoader loader, String packageFqn, Set<Class> otherSupportedAnnotations) throws Exception {
        URL url = loader.getResource(packageFqn.replace('.', '/') + "/package-info.java");
        File info = new File(url.toURI());
        File[] files = (File[])Files.walk(info.getParentFile().toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).toArray(File[]::new);
        MyProcessor processor = new MyProcessor(codegen -> codegen.getModuleModel(packageFqn), otherSupportedAnnotations.stream().map(Class::getCanonicalName).collect(Collectors.toSet()));
        Compiler compiler = new Compiler(processor, this.collector);
        compiler.compile(files);
        return (ModuleModel)processor.result;
    }

    public ModuleModel generateModule(ClassLoader loader, String packageFqn) throws Exception {
        return this.generateModule(loader, packageFqn, new HashSet<Class>());
    }

    public DataObjectModel generateDataObject(Class c, Class ... rest) throws Exception {
        return this.generateClass((CodeGen codegen) -> codegen.getDataObjectModel(c.getCanonicalName()), c, rest);
    }

    public ClassModel generateClass(Class c, Class ... rest) throws Exception {
        return this.generateClass((CodeGen codegen) -> codegen.getClassModel(c.getCanonicalName()), c, rest);
    }

    public EnumModel generateEnum(Class c, Class ... rest) throws Exception {
        return this.generateClass((CodeGen codegen) -> codegen.getEnumModel(c.getCanonicalName()), c, rest);
    }

    public <M> M generateClass(Function<CodeGen, M> f, Set<Class> otherSupportedAnnotations, Class c, Class ... rest) throws Exception {
        ArrayList<Class> types = new ArrayList<Class>();
        types.add(c);
        Collections.addAll(types, rest);
        String className = c.getCanonicalName();
        MyProcessor processor = new MyProcessor(f, otherSupportedAnnotations.stream().map(Class::getCanonicalName).collect(Collectors.toSet()));
        Compiler compiler = new Compiler(processor, this.collector);
        compiler.compile(types);
        if (processor.result == null) {
            throw new IllegalArgumentException(className + " not processed.");
        }
        return (M)processor.result;
    }

    public <M> M generateClass(Function<CodeGen, M> f, Class annotation, Class c, Class ... rest) throws Exception {
        HashSet<Class> s = new HashSet<Class>();
        s.add(annotation);
        return this.generateClass(f, s, c, rest);
    }

    public <M> M generateClass(Function<CodeGen, M> f, Class c, Class ... rest) throws Exception {
        return this.generateClass(f, new HashSet<Class>(), c, rest);
    }

    private class MyProcessor<R>
    implements Processor {
        private ProcessingEnvironment env;
        private final Function<CodeGen, R> f;
        private R result;
        private Set<String> supportedAnnotations;

        private MyProcessor(Function<CodeGen, R> f, Set<String> otherSupportedAnnotations) {
            this.f = f;
            this.supportedAnnotations = new HashSet<String>();
            this.supportedAnnotations.add(ProxyGen.class.getCanonicalName());
            this.supportedAnnotations.add(VertxGen.class.getCanonicalName());
            this.supportedAnnotations.add(DataObject.class.getCanonicalName());
            this.supportedAnnotations.add(ModuleGen.class.getCanonicalName());
            this.supportedAnnotations.addAll(otherSupportedAnnotations);
        }

        @Override
        public Set<String> getSupportedOptions() {
            return Collections.emptySet();
        }

        @Override
        public Set<String> getSupportedAnnotationTypes() {
            return this.supportedAnnotations;
        }

        @Override
        public SourceVersion getSupportedSourceVersion() {
            return SourceVersion.RELEASE_8;
        }

        @Override
        public void init(ProcessingEnvironment processingEnv) {
            this.env = processingEnv;
        }

        @Override
        public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
            if (!roundEnv.processingOver()) {
                CodeGen codegen = new CodeGen(this.env, roundEnv, Thread.currentThread().getContextClassLoader());
                this.result = this.f.apply(codegen);
            }
            return true;
        }

        @Override
        public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
            return Collections.emptyList();
        }
    }
}

