/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen;

import io.vertx.codegen.overloadcheck.MethodOverloadChecker;
import io.vertx.codegen.overloadcheck.SimpleMethod;
import io.vertx.codegen.overloadcheck.SimpleParam;
import io.vertx.codegen.testmodel.RefedInterface1;
import io.vertx.codegen.testmodel.TestDataObject;
import io.vertx.codegen.testmodel.TestEnum;
import io.vertx.codegen.type.ClassKind;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class MethodOverloadHelperTest {
    protected MethodOverloadChecker checker = new MethodOverloadChecker();

    @Test
    public void testAmbiguousMethods1() throws Exception {
        ArrayList<SimpleMethod> meths = new ArrayList<SimpleMethod>();
        ArrayList<SimpleParam> params1 = new ArrayList<SimpleParam>();
        params1.add(new SimpleParam("arg0", ClassKind.JSON_ARRAY, JsonArray.class.getName()));
        params1.add(new SimpleParam("arg1", ClassKind.STRING, String.class.getName()));
        SimpleMethod meth1 = new SimpleMethod("meth1", params1);
        meths.add(meth1);
        ArrayList<SimpleParam> params2 = new ArrayList<SimpleParam>();
        params2.add(new SimpleParam("arg0", ClassKind.LIST, List.class.getName()));
        params2.add(new SimpleParam("arg1", ClassKind.STRING, String.class.getName()));
        SimpleMethod meth2 = new SimpleMethod("meth1", params2);
        meths.add(meth2);
        this.testAmbiguousMethods(meths);
    }

    @Test
    public void testAmbiguousMethodsArrayClash1() throws Exception {
        this.testAmbiguousMethods(ClassKind.JSON_ARRAY, JsonArray.class.getName(), ClassKind.LIST, List.class.getName());
    }

    @Test
    public void testAmbiguousMethodsArrayClash2() throws Exception {
        this.testAmbiguousMethods(ClassKind.JSON_ARRAY, JsonArray.class.getName(), ClassKind.SET, Set.class.getName());
    }

    @Test
    public void testAmbiguousMethodsArrayClash3() throws Exception {
        this.testAmbiguousMethods(ClassKind.LIST, List.class.getName(), ClassKind.SET, Set.class.getName());
    }

    @Test
    public void testAmbiguousMethodsArrayClash4() throws Exception {
        this.testAmbiguousMethods(ClassKind.JSON_ARRAY, JsonArray.class.getName(), ClassKind.JSON_ARRAY, JsonArray.class.getName());
    }

    @Test
    public void testAmbiguousMethodsObjectClash1() throws Exception {
        this.testAmbiguousMethods(ClassKind.JSON_OBJECT, JsonObject.class.getName(), ClassKind.DATA_OBJECT, TestDataObject.class.getName());
    }

    @Test
    public void testAmbiguousMethodsObjectClash2() throws Exception {
        this.testAmbiguousMethods(ClassKind.JSON_OBJECT, JsonObject.class.getName(), ClassKind.MAP, Map.class.getName());
    }

    @Test
    public void testAmbiguousMethodsObjectClash3() throws Exception {
        this.testAmbiguousMethods(ClassKind.MAP, Map.class.getName(), ClassKind.DATA_OBJECT, TestDataObject.class.getName());
    }

    @Test
    public void testAmbiguousMethodsObjectClash4() throws Exception {
        this.testAmbiguousMethods(ClassKind.JSON_OBJECT, JsonObject.class.getName(), ClassKind.JSON_OBJECT, JsonObject.class.getName());
    }

    @Test
    public void testFunctionClash1() throws Exception {
        this.testAmbiguousMethods(ClassKind.HANDLER, Handler.class.getName(), ClassKind.HANDLER, Handler.class.getName());
    }

    @Test
    public void testVertxGenClash1() throws Exception {
        this.testAmbiguousMethods(ClassKind.API, RefedInterface1.class.getName(), ClassKind.API, RefedInterface1.class.getName());
    }

    @Test
    public void testStringClash1() throws Exception {
        this.testAmbiguousMethods(ClassKind.STRING, String.class.getName(), ClassKind.ENUM, TestEnum.class.getName());
    }

    @Test
    public void testStringClash2() throws Exception {
        this.testAmbiguousMethods(ClassKind.STRING, String.class.getName(), ClassKind.STRING, String.class.getName());
    }

    private void testNumberClash(ClassKind kind, String typeName) throws Exception {
        this.testAmbiguousMethods(kind, typeName, ClassKind.PRIMITIVE, "long");
        this.testAmbiguousMethods(kind, typeName, ClassKind.PRIMITIVE, "int");
        this.testAmbiguousMethods(kind, typeName, ClassKind.PRIMITIVE, "double");
        this.testAmbiguousMethods(kind, typeName, ClassKind.PRIMITIVE, "float");
        this.testAmbiguousMethods(kind, typeName, ClassKind.PRIMITIVE, "short");
        this.testAmbiguousMethods(kind, typeName, ClassKind.PRIMITIVE, "byte");
        this.testAmbiguousMethods(kind, typeName, ClassKind.BOXED_PRIMITIVE, "java.lang.Long");
        this.testAmbiguousMethods(kind, typeName, ClassKind.BOXED_PRIMITIVE, "java.lang.Integer");
        this.testAmbiguousMethods(kind, typeName, ClassKind.BOXED_PRIMITIVE, "java.lang.Double");
        this.testAmbiguousMethods(kind, typeName, ClassKind.BOXED_PRIMITIVE, "java.lang.Float");
        this.testAmbiguousMethods(kind, typeName, ClassKind.BOXED_PRIMITIVE, "java.lang.Short");
        this.testAmbiguousMethods(kind, typeName, ClassKind.BOXED_PRIMITIVE, "java.lang.Byte");
    }

    @Test
    public void testNumberClash1() throws Exception {
        this.testNumberClash(ClassKind.PRIMITIVE, "long");
    }

    @Test
    public void testNumberClash2() throws Exception {
        this.testNumberClash(ClassKind.PRIMITIVE, "int");
    }

    @Test
    public void testNumberClash3() throws Exception {
        this.testNumberClash(ClassKind.PRIMITIVE, "short");
    }

    @Test
    public void testNumberClash4() throws Exception {
        this.testNumberClash(ClassKind.PRIMITIVE, "float");
    }

    @Test
    public void testNumberClash5() throws Exception {
        this.testNumberClash(ClassKind.PRIMITIVE, "double");
    }

    @Test
    public void testNumberClash6() throws Exception {
        this.testNumberClash(ClassKind.PRIMITIVE, "byte");
    }

    @Test
    public void testNumberClash7() throws Exception {
        this.testNumberClash(ClassKind.BOXED_PRIMITIVE, "java.lang.Long");
    }

    @Test
    public void testNumberClash8() throws Exception {
        this.testNumberClash(ClassKind.BOXED_PRIMITIVE, "java.lang.Integer");
    }

    @Test
    public void testNumberClash9() throws Exception {
        this.testNumberClash(ClassKind.BOXED_PRIMITIVE, "java.lang.Short");
    }

    @Test
    public void testNumberClash10() throws Exception {
        this.testNumberClash(ClassKind.BOXED_PRIMITIVE, "java.lang.Float");
    }

    @Test
    public void testNumberClash11() throws Exception {
        this.testNumberClash(ClassKind.BOXED_PRIMITIVE, "java.lang.Double");
    }

    @Test
    public void testNumberClash12() throws Exception {
        this.testNumberClash(ClassKind.BOXED_PRIMITIVE, "java.lang.Byte");
    }

    @Test
    public void testAmbiguousMethodsBooleanClash1() throws Exception {
        this.testAmbiguousMethods(ClassKind.PRIMITIVE, "boolean", ClassKind.PRIMITIVE, "boolean");
    }

    @Test
    public void testAmbiguousMethodsBooleanClash2() throws Exception {
        this.testAmbiguousMethods(ClassKind.BOXED_PRIMITIVE, "java.lang.Boolean", ClassKind.PRIMITIVE, "boolean");
    }

    @Test
    public void testAllClash1() throws Exception {
        this.testAmbiguousMethods(ClassKind.OBJECT, TestEnum.class.getName(), ClassKind.STRING, String.class.getName());
    }

    @Test
    public void testAllClash2() throws Exception {
        this.testAmbiguousMethods(ClassKind.OBJECT, TestEnum.class.getName(), ClassKind.PRIMITIVE, "int");
    }

    @Test
    public void testAllClash3() throws Exception {
        this.testAmbiguousMethods(ClassKind.OBJECT, TestEnum.class.getName(), ClassKind.BOXED_PRIMITIVE, "java.lang.Integer");
    }

    @Test
    public void testAllClash4() throws Exception {
        this.testAmbiguousMethods(ClassKind.OBJECT, TestEnum.class.getName(), ClassKind.API, Object.class.getName());
    }

    @Test
    public void testAllClash5() throws Exception {
        this.testAmbiguousMethods(ClassKind.OBJECT, TestEnum.class.getName(), ClassKind.JSON_OBJECT, JsonObject.class.getName());
    }

    @Test
    public void testAllClash6() throws Exception {
        this.testAmbiguousMethods(ClassKind.OBJECT, TestEnum.class.getName(), ClassKind.JSON_ARRAY, JsonArray.class.getName());
    }

    @Test
    public void testAllClash7() throws Exception {
        this.testAmbiguousMethods(ClassKind.OBJECT, TestEnum.class.getName(), ClassKind.DATA_OBJECT, TestDataObject.class.getName());
    }

    @Test
    public void testAllClash8() throws Exception {
        this.testAmbiguousMethods(ClassKind.OBJECT, TestEnum.class.getName(), ClassKind.ENUM, TestEnum.class.getName());
    }

    @Test
    public void testAllClash9() throws Exception {
        this.testAmbiguousMethods(ClassKind.OBJECT, TestEnum.class.getName(), ClassKind.OBJECT, TestEnum.class.getName());
    }

    private void testAmbiguousMethods(ClassKind kind1, String typeName1, ClassKind kind2, String typeName2) throws Exception {
        ArrayList<SimpleMethod> meths = new ArrayList<SimpleMethod>();
        ArrayList<SimpleParam> params1 = new ArrayList<SimpleParam>();
        params1.add(new SimpleParam("arg0", kind1, typeName1));
        SimpleMethod meth1 = new SimpleMethod("meth1", params1);
        meths.add(meth1);
        ArrayList<SimpleParam> params2 = new ArrayList<SimpleParam>();
        params2.add(new SimpleParam("arg0", kind2, typeName2));
        SimpleMethod meth2 = new SimpleMethod("meth1", params2);
        meths.add(meth2);
        this.testAmbiguousMethods(meths);
    }

    @Test
    public void testMethodsOK1() throws Exception {
        ArrayList<SimpleMethod> meths = new ArrayList<SimpleMethod>();
        ArrayList<SimpleParam> params1 = new ArrayList<SimpleParam>();
        params1.add(new SimpleParam("arg0", ClassKind.JSON_ARRAY, JsonArray.class.getName()));
        params1.add(new SimpleParam("arg1", ClassKind.STRING, String.class.getName()));
        SimpleMethod meth1 = new SimpleMethod("meth1", params1);
        meths.add(meth1);
        ArrayList<SimpleParam> params2 = new ArrayList<SimpleParam>();
        params2.add(new SimpleParam("arg0", ClassKind.JSON_OBJECT, List.class.getName()));
        params2.add(new SimpleParam("arg1", ClassKind.STRING, String.class.getName()));
        SimpleMethod meth2 = new SimpleMethod("meth1", params2);
        meths.add(meth2);
        this.testAmbiguousMethodsOK(meths);
    }

    @Test
    public void testMethodsOKDifferentPositions() throws Exception {
        ArrayList<SimpleMethod> meths = new ArrayList<SimpleMethod>();
        ArrayList<SimpleParam> params1 = new ArrayList<SimpleParam>();
        params1.add(new SimpleParam("arg0", ClassKind.STRING, String.class.getName()));
        params1.add(new SimpleParam("arg1", ClassKind.JSON_ARRAY, JsonArray.class.getName()));
        SimpleMethod meth1 = new SimpleMethod("meth1", params1);
        meths.add(meth1);
        ArrayList<SimpleParam> params2 = new ArrayList<SimpleParam>();
        params2.add(new SimpleParam("arg0", ClassKind.LIST, List.class.getName()));
        params2.add(new SimpleParam("arg1", ClassKind.STRING, String.class.getName()));
        SimpleMethod meth2 = new SimpleMethod("meth1", params2);
        meths.add(meth2);
        this.testAmbiguousMethodsOK(meths);
    }

    @Test
    public void testMethodsOKDifferentNumbersOfParams() throws Exception {
        ArrayList<SimpleMethod> meths = new ArrayList<SimpleMethod>();
        ArrayList<SimpleParam> params1 = new ArrayList<SimpleParam>();
        params1.add(new SimpleParam("arg0", ClassKind.JSON_ARRAY, JsonArray.class.getName()));
        params1.add(new SimpleParam("arg1", ClassKind.STRING, String.class.getName()));
        params1.add(new SimpleParam("arg2", ClassKind.PRIMITIVE, "long"));
        SimpleMethod meth1 = new SimpleMethod("meth1", params1);
        meths.add(meth1);
        ArrayList<SimpleParam> params2 = new ArrayList<SimpleParam>();
        params2.add(new SimpleParam("arg0", ClassKind.LIST, List.class.getName()));
        params2.add(new SimpleParam("arg1", ClassKind.STRING, String.class.getName()));
        SimpleMethod meth2 = new SimpleMethod("meth1", params2);
        meths.add(meth2);
        this.testAmbiguousMethodsOK(meths);
    }

    @Test
    public void testNullableNotAmbiguous() throws Exception {
        ArrayList<SimpleMethod> meths = new ArrayList<SimpleMethod>();
        ArrayList<SimpleParam> params1 = new ArrayList<SimpleParam>();
        params1.add(new SimpleParam("arg0", ClassKind.STRING, true, JsonArray.class.getName()));
        SimpleMethod meth1 = new SimpleMethod("meth1", params1);
        meths.add(meth1);
        ArrayList<SimpleParam> params2 = new ArrayList<SimpleParam>();
        params2.add(new SimpleParam("arg0", ClassKind.LIST, false, List.class.getName()));
        SimpleMethod meth2 = new SimpleMethod("meth1", params2);
        meths.add(meth2);
        this.testAmbiguousMethodsOK(meths);
    }

    @Test
    public void testNullableDifferentPositionsNotAmbiguous() throws Exception {
        ArrayList<SimpleMethod> meths = new ArrayList<SimpleMethod>();
        ArrayList<SimpleParam> params1 = new ArrayList<SimpleParam>();
        params1.add(new SimpleParam("arg0", ClassKind.STRING, true, JsonArray.class.getName()));
        params1.add(new SimpleParam("arg1", ClassKind.LIST, false, List.class.getName()));
        SimpleMethod meth1 = new SimpleMethod("meth1", params1);
        meths.add(meth1);
        ArrayList<SimpleParam> params2 = new ArrayList<SimpleParam>();
        params2.add(new SimpleParam("arg0", ClassKind.LIST, false, List.class.getName()));
        params2.add(new SimpleParam("arg1", ClassKind.STRING, true, String.class.getName()));
        SimpleMethod meth2 = new SimpleMethod("meth1", params2);
        meths.add(meth2);
        this.testAmbiguousMethodsOK(meths);
    }

    @Test
    public void testNullableAmbiguous() throws Exception {
        ArrayList<SimpleMethod> meths = new ArrayList<SimpleMethod>();
        ArrayList<SimpleParam> params1 = new ArrayList<SimpleParam>();
        params1.add(new SimpleParam("arg0", ClassKind.STRING, true, JsonArray.class.getName()));
        SimpleMethod meth1 = new SimpleMethod("meth1", params1);
        meths.add(meth1);
        ArrayList<SimpleParam> params2 = new ArrayList<SimpleParam>();
        params2.add(new SimpleParam("arg0", ClassKind.LIST, true, List.class.getName()));
        SimpleMethod meth2 = new SimpleMethod("meth1", params2);
        meths.add(meth2);
        this.testAmbiguousMethods(meths);
    }

    @Test
    public void testMultiTypes() throws Exception {
        SimpleMethod meth1 = new SimpleMethod("meth", new SimpleParam[]{new SimpleParam("arg0", ClassKind.STRING, JsonArray.class.getName())});
        SimpleMethod meth2 = new SimpleMethod("meth", new SimpleParam[]{new SimpleParam("arg0", ClassKind.OBJECT, Object.class.getName())});
        SimpleMethod meth3 = new SimpleMethod("meth", new SimpleParam[]{new SimpleParam("arg0", ClassKind.JSON_OBJECT, JsonObject.class.getName())});
        this.testAmbiguousMethods(Arrays.asList(meth1, meth2));
        this.testAmbiguousMethods(Arrays.asList(meth2, meth3));
    }

    private void testAmbiguousMethods(List<SimpleMethod> meths) throws Exception {
        MethodOverloadHelperTest.testAmbiguousMethods(this.checker, meths);
    }

    private static void testAmbiguousMethods(MethodOverloadChecker checker, List<SimpleMethod> meths) throws Exception {
        try {
            checker.checkAmbiguousSimple(meths);
            Assert.fail((String)"should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void testAmbiguousMethodsOK(List<SimpleMethod> meths) throws Exception {
        MethodOverloadHelperTest.testAmbiguousMethodsOK(this.checker, meths);
    }

    private static void testAmbiguousMethodsOK(MethodOverloadChecker checker, List<SimpleMethod> meths) throws Exception {
        checker.checkAmbiguousSimple(meths);
    }
}

