/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen;

import io.vertx.test.codegen.GeneratorHelper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;

public class ClassEnumerator {
    private static final Logger log = Logger.getLogger(GeneratorHelper.class.getName());

    private static Class<?> loadClass(String className) {
        try {
            return ClassEnumerator.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unexpected ClassNotFoundException loading class '" + className + "'");
        }
    }

    private static void processDirectory(File directory, String pkgname, ArrayList<Class<?>> classes, Function<String, Boolean> matcher) {
        if (!matcher.apply(directory.toString()).booleanValue()) {
            return;
        }
        log.fine("Reading Directory '" + directory + "'");
        String[] files = directory.list();
        for (int i = 0; i < files.length; ++i) {
            File subdir;
            String fileName = files[i];
            String className = null;
            if (fileName.endsWith(".class")) {
                className = pkgname + '.' + fileName.substring(0, fileName.length() - 6);
            }
            log.fine("FileName '" + fileName + "'  =>  class '" + className + "'");
            if (className != null) {
                classes.add(ClassEnumerator.loadClass(className));
            }
            if (!(subdir = new File(directory, fileName)).isDirectory()) continue;
            ClassEnumerator.processDirectory(subdir, pkgname + '.' + fileName, classes, matcher);
        }
    }

    private static void processJarfile(URL resource, String pkgname, ArrayList<Class<?>> classes, Function<String, Boolean> matcher) {
        JarFile jarFile;
        String relPath = pkgname.replace('.', '/');
        String resPath = resource.getPath();
        String jarPath = resPath.replaceFirst("[.]jar[!].*", ".jar").replaceFirst("file:", "");
        log.fine("Reading JAR file: '" + jarPath + "'");
        try {
            jarFile = new JarFile(jarPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException reading JAR File '" + jarPath + "'", e);
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!matcher.apply(entryName).booleanValue()) continue;
            String className = null;
            if (entryName.endsWith(".class") && entryName.startsWith(relPath) && entryName.length() > relPath.length() + "/".length()) {
                className = entryName.replace('/', '.').replace('\\', '.').replace(".class", "");
            }
            log.fine("JarEntry '" + entryName + "'  =>  class '" + className + "'");
            if (className == null) continue;
            classes.add(ClassEnumerator.loadClass(className));
        }
    }

    public static ArrayList<Class<?>> getClassesForPackage(String pkgname, Function<String, Boolean> matcher) {
        ArrayList classes = new ArrayList();
        String relPath = pkgname.replace('.', '/');
        URL resource = ClassEnumerator.getClassLoader().getResource(relPath);
        if (resource == null) {
            throw new RuntimeException("Unexpected problem: No resource for " + relPath);
        }
        log.fine("Package: '" + pkgname + "' becomes Resource: '" + resource.toString() + "'");
        resource.getPath();
        if (resource.toString().startsWith("jar:")) {
            ClassEnumerator.processJarfile(resource, pkgname, classes, matcher);
        } else {
            ClassEnumerator.processDirectory(new File(resource.getPath()), pkgname, classes, matcher);
        }
        return classes;
    }

    private static ClassLoader getClassLoader() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return tccl == null ? ClassEnumerator.class.getClassLoader() : tccl;
    }
}

