/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen;

import io.vertx.codegen.Helper;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.testmodel.TestDataObject;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.DataObjectTypeInfo;
import io.vertx.codegen.type.EnumTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.PrimitiveTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeMirrorFactory;
import io.vertx.codegen.type.TypeReflectionFactory;
import io.vertx.codegen.type.TypeVariableInfo;
import io.vertx.codegen.type.VoidTypeInfo;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.test.codegen.Utils;
import io.vertx.test.codegen.testapi.GenericInterface;
import io.vertx.test.codegen.testapi.streams.InterfaceExtentingReadStream;
import io.vertx.test.codegen.testapi.streams.InterfaceSubtypingReadStream;
import io.vertx.test.codegen.testapi.streams.ReadStreamWithParameterizedTypeArg;
import io.vertx.test.codegen.testtype.ApiHolder;
import io.vertx.test.codegen.testtype.ApiObject;
import io.vertx.test.codegen.testtype.AsyncHolder;
import io.vertx.test.codegen.testtype.BasicHolder;
import io.vertx.test.codegen.testtype.CollectionHolder;
import io.vertx.test.codegen.testtype.DataObjectHolder;
import io.vertx.test.codegen.testtype.EnumHolder;
import io.vertx.test.codegen.testtype.HandlerHolder;
import io.vertx.test.codegen.testtype.JsonHolder;
import io.vertx.test.codegen.testtype.OtherHolder;
import io.vertx.test.codegen.testtype.StreamHolder;
import io.vertx.test.codegen.testtype.ThrowableHolder;
import io.vertx.test.codegen.testtype.TypeParamHolder;
import io.vertx.test.codegen.testtype.VoidHolder;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.TypeElement;
import org.junit.Assert;
import org.junit.Test;

public class TypeInfoTest {
    private void doTest(Class<?> container, Consumer<Map<String, TypeInfo>> assertion) throws Exception {
        Map<String, TypeInfo> reflectedMap = Stream.of(container.getDeclaredMethods()).filter(m -> Modifier.isPublic(m.getModifiers())).collect(Collectors.toMap(Method::getName, m -> TypeReflectionFactory.create((Type)m.getGenericReturnType())));
        assertion.accept(reflectedMap);
        Utils.assertProcess((proc, env) -> {
            TypeMirrorFactory factory = new TypeMirrorFactory(proc.getElementUtils(), proc.getTypeUtils());
            TypeElement modelMap = proc.getElementUtils().getTypeElement(container.getName());
            Map<String, TypeInfo> collect = modelMap.getEnclosedElements().stream().flatMap(Helper.FILTER_METHOD).filter(elt -> elt.getModifiers().contains((Object)javax.lang.model.element.Modifier.PUBLIC)).collect(Collectors.toMap(m -> m.getSimpleName().toString(), m -> factory.create(m.getReturnType())));
            assertion.accept(collect);
        });
    }

    @Test
    public void testVoid() throws Exception {
        this.doTest(VoidHolder.class, map -> {
            VoidTypeInfo voidType = (VoidTypeInfo)map.get("voidType");
            Assert.assertEquals((Object)"void", (Object)voidType.getName());
            Assert.assertEquals((Object)"void", (Object)voidType.getSimpleName());
            Assert.assertEquals((Object)ClassKind.OTHER, (Object)voidType.getKind());
            this.assertClass((TypeInfo)map.get("VoidType"), "java.lang.Void", ClassKind.VOID);
        });
    }

    @Test
    public void testApi() throws Exception {
        this.doTest(ApiHolder.class, map -> {
            ApiTypeInfo api = this.assertApi((TypeInfo)map.get("api"), ApiObject.class.getName());
            Assert.assertEquals((Object)ApiObject.class.getName(), (Object)api.getName());
            ParameterizedTypeInfo apiParameterizedByClass = this.assertParameterized((TypeInfo)map.get("apiParameterizedByClass"), GenericInterface.class.getName() + "<java.lang.String>", ClassKind.API);
            this.assertClass(apiParameterizedByClass.getArg(0), "java.lang.String", ClassKind.STRING);
            ParameterizedTypeInfo apiParameterizedByClassTypeParam = this.assertParameterized((TypeInfo)map.get("apiParameterizedByClassTypeParam"), GenericInterface.class.getName() + "<ClassTypeParam>", ClassKind.API);
            TypeParamInfo.Class classTypeParam = (TypeParamInfo.Class)this.assertTypeVariable(apiParameterizedByClassTypeParam.getArg(0), "ClassTypeParam").getParam();
            Assert.assertEquals((Object)"ClassTypeParam", (Object)classTypeParam.getName());
            ParameterizedTypeInfo apiParameterizedByMethodTypeParam = this.assertParameterized((TypeInfo)map.get("apiParameterizedByMethodTypeParam"), GenericInterface.class.getName() + "<MethodTypeParam>", ClassKind.API);
            TypeParamInfo.Method methodTypeParam = (TypeParamInfo.Method)this.assertTypeVariable(apiParameterizedByMethodTypeParam.getArg(0), "MethodTypeParam").getParam();
            Assert.assertEquals((Object)"MethodTypeParam", (Object)methodTypeParam.getName());
        });
    }

    @Test
    public void testTypeParam() throws Exception {
        this.doTest(TypeParamHolder.class, map -> {
            TypeParamInfo.Class classTypeParam = (TypeParamInfo.Class)this.assertTypeVariable((TypeInfo)map.get("classTypeParam"), "ClassTypeParam").getParam();
            Assert.assertEquals((Object)"ClassTypeParam", (Object)classTypeParam.getName());
            TypeParamInfo.Method methodTypeParam = (TypeParamInfo.Method)this.assertTypeVariable((TypeInfo)map.get("methodTypeParam"), "MethodTypeParam").getParam();
            Assert.assertEquals((Object)"MethodTypeParam", (Object)methodTypeParam.getName());
        });
    }

    @Test
    public void testClass() throws Exception {
        this.doTest(OtherHolder.class, map -> {
            this.assertClass((TypeInfo)map.get("classType"), "java.util.Locale", ClassKind.OTHER);
            this.assertClass((TypeInfo)map.get("interfaceType"), "java.lang.Runnable", ClassKind.OTHER);
            this.assertClass((TypeInfo)map.get("genericInterface"), "java.util.concurrent.Callable", ClassKind.OTHER);
            this.assertClass(this.assertParameterized((TypeInfo)map.get("interfaceParameterizedByInterface"), "java.util.concurrent.Callable<java.lang.Runnable>", ClassKind.OTHER).getArg(0), "java.lang.Runnable", ClassKind.OTHER);
            this.assertClass(this.assertParameterized((TypeInfo)map.get("interfaceParameterizedByClass"), "java.util.concurrent.Callable<java.util.Locale>", ClassKind.OTHER).getArg(0), "java.util.Locale", ClassKind.OTHER);
            this.assertTypeVariable(this.assertParameterized((TypeInfo)map.get("interfaceParameterizedByClassTypeParam"), "java.util.concurrent.Callable<ClassTypeParam>", ClassKind.OTHER).getArg(0), "ClassTypeParam");
            this.assertTypeVariable(this.assertParameterized((TypeInfo)map.get("interfaceParameterizedByMethodTypeParam"), "java.util.concurrent.Callable<MethodTypeParam>", ClassKind.OTHER).getArg(0), "MethodTypeParam");
            this.assertClass(this.assertParameterized((TypeInfo)map.get("classParameterizedByInterface"), "java.util.Vector<java.lang.Runnable>", ClassKind.OTHER).getArg(0), "java.lang.Runnable", ClassKind.OTHER);
            this.assertClass(this.assertParameterized((TypeInfo)map.get("classParameterizedByClass"), "java.util.Vector<java.util.Locale>", ClassKind.OTHER).getArg(0), "java.util.Locale", ClassKind.OTHER);
            this.assertTypeVariable(this.assertParameterized((TypeInfo)map.get("classParameterizedByClassTypeParam"), "java.util.Vector<ClassTypeParam>", ClassKind.OTHER).getArg(0), "ClassTypeParam");
            this.assertTypeVariable(this.assertParameterized((TypeInfo)map.get("classParameterizedByMethodTypeParam"), "java.util.Vector<MethodTypeParam>", ClassKind.OTHER).getArg(0), "MethodTypeParam");
        });
    }

    @Test
    public void testHandler() throws Exception {
        this.doTest(HandlerHolder.class, map -> {
            this.assertClass(this.assertHandler((TypeInfo)map.get("handlerVoid"), "java.lang.Void"), "java.lang.Void", ClassKind.VOID);
            this.assertClass(this.assertHandler((TypeInfo)map.get("handlerString"), "java.lang.String"), "java.lang.String", ClassKind.STRING);
            this.assertClass(this.assertParameterized(this.assertHandler((TypeInfo)map.get("handlerListString"), "java.util.List<java.lang.String>"), "java.util.List<java.lang.String>", ClassKind.LIST).getArg(0), "java.lang.String", ClassKind.STRING);
            this.assertApi(this.assertParameterized(this.assertHandler((TypeInfo)map.get("handlerListApi"), "java.util.List<" + ApiObject.class.getName() + ">"), "java.util.List<" + ApiObject.class.getName() + ">", ClassKind.LIST).getArg(0), ApiObject.class.getName());
            this.assertTypeVariable(this.assertParameterized(this.assertHandler((TypeInfo)map.get("handlerParameterizedByClassTypeParam"), GenericInterface.class.getName() + "<ClassTypeParam>"), GenericInterface.class.getName() + "<ClassTypeParam>", ClassKind.API).getArg(0), "ClassTypeParam");
            this.assertTypeVariable(this.assertParameterized(this.assertHandler((TypeInfo)map.get("handlerParameterizedByMethodTypeParam"), GenericInterface.class.getName() + "<MethodTypeParam>"), GenericInterface.class.getName() + "<MethodTypeParam>", ClassKind.API).getArg(0), "MethodTypeParam");
        });
    }

    @Test
    public void testAsync() throws Exception {
        this.doTest(AsyncHolder.class, map -> {
            this.assertClass(this.assertAsync((TypeInfo)map.get("asyncVoid"), "java.lang.Void"), "java.lang.Void", ClassKind.VOID);
            this.assertClass(this.assertAsync((TypeInfo)map.get("asyncString"), "java.lang.String"), "java.lang.String", ClassKind.STRING);
            this.assertClass(this.assertParameterized(this.assertAsync((TypeInfo)map.get("asyncListString"), "java.util.List<java.lang.String>"), "java.util.List<java.lang.String>", ClassKind.LIST).getArg(0), "java.lang.String", ClassKind.STRING);
            this.assertApi(this.assertParameterized(this.assertAsync((TypeInfo)map.get("asyncListApi"), "java.util.List<" + ApiObject.class.getName() + ">"), "java.util.List<" + ApiObject.class.getName() + ">", ClassKind.LIST).getArg(0), ApiObject.class.getName());
            this.assertTypeVariable(this.assertParameterized(this.assertAsync((TypeInfo)map.get("asyncParameterizedByClassTypeParam"), GenericInterface.class.getName() + "<ClassTypeParam>"), GenericInterface.class.getName() + "<ClassTypeParam>", ClassKind.API).getArg(0), "ClassTypeParam");
            this.assertTypeVariable(this.assertParameterized(this.assertAsync((TypeInfo)map.get("asyncParameterizedByMethodTypeParam"), GenericInterface.class.getName() + "<MethodTypeParam>"), GenericInterface.class.getName() + "<MethodTypeParam>", ClassKind.API).getArg(0), "MethodTypeParam");
        });
    }

    @Test
    public void testDataObject() throws Exception {
        this.doTest(DataObjectHolder.class, map -> this.assertDataObject((TypeInfo)map.get("dataObject"), TestDataObject.class.getName(), ClassKind.DATA_OBJECT));
    }

    @Test
    public void testJson() throws Exception {
        this.doTest(JsonHolder.class, map -> {
            this.assertClass((TypeInfo)map.get("jsonObject"), JsonObject.class.getName(), ClassKind.JSON_OBJECT);
            this.assertClass((TypeInfo)map.get("jsonArray"), JsonArray.class.getName(), ClassKind.JSON_ARRAY);
        });
    }

    @Test
    public void testThrowable() throws Exception {
        this.doTest(ThrowableHolder.class, map -> this.assertClass((TypeInfo)map.get("throwable"), "java.lang.Throwable", ClassKind.THROWABLE));
    }

    @Test
    public void testBasic() throws Exception {
        this.doTest(BasicHolder.class, map -> {
            this.assertPrimitive((TypeInfo)map.get("booleanType"), "boolean");
            this.assertPrimitive((TypeInfo)map.get("byteType"), "byte");
            this.assertPrimitive((TypeInfo)map.get("shortType"), "short");
            this.assertPrimitive((TypeInfo)map.get("intType"), "int");
            this.assertPrimitive((TypeInfo)map.get("longType"), "long");
            this.assertPrimitive((TypeInfo)map.get("floatType"), "float");
            this.assertPrimitive((TypeInfo)map.get("doubleType"), "double");
            this.assertPrimitive((TypeInfo)map.get("charType"), "char");
            this.assertClass((TypeInfo)map.get("BooleanType"), "java.lang.Boolean", ClassKind.BOXED_PRIMITIVE);
            this.assertClass((TypeInfo)map.get("ShortType"), "java.lang.Short", ClassKind.BOXED_PRIMITIVE);
            this.assertClass((TypeInfo)map.get("IntegerType"), "java.lang.Integer", ClassKind.BOXED_PRIMITIVE);
            this.assertClass((TypeInfo)map.get("LongType"), "java.lang.Long", ClassKind.BOXED_PRIMITIVE);
            this.assertClass((TypeInfo)map.get("FloatType"), "java.lang.Float", ClassKind.BOXED_PRIMITIVE);
            this.assertClass((TypeInfo)map.get("DoubleType"), "java.lang.Double", ClassKind.BOXED_PRIMITIVE);
            this.assertClass((TypeInfo)map.get("CharacterType"), "java.lang.Character", ClassKind.BOXED_PRIMITIVE);
            this.assertClass((TypeInfo)map.get("StringType"), "java.lang.String", ClassKind.STRING);
        });
    }

    private PrimitiveTypeInfo assertPrimitive(TypeInfo type, String expectedName) {
        Assert.assertEquals(PrimitiveTypeInfo.class, type.getClass());
        PrimitiveTypeInfo primitiveType = (PrimitiveTypeInfo)type;
        Assert.assertEquals((Object)ClassKind.PRIMITIVE, (Object)primitiveType.getKind());
        Assert.assertEquals((Object)expectedName, (Object)primitiveType.getName());
        return primitiveType;
    }

    private TypeVariableInfo assertTypeVariable(TypeInfo type, String expectedName) {
        Assert.assertEquals(TypeVariableInfo.class, type.getClass());
        TypeVariableInfo classType = (TypeVariableInfo)type;
        Assert.assertEquals((Object)ClassKind.OBJECT, (Object)classType.getKind());
        Assert.assertEquals((Object)expectedName, (Object)classType.getName());
        return classType;
    }

    private ClassTypeInfo assertClass(TypeInfo type, String expectedName, ClassKind expectedKind) {
        Assert.assertEquals(ClassTypeInfo.class, type.getClass());
        ClassTypeInfo classType = (ClassTypeInfo)type;
        Assert.assertEquals((Object)expectedKind, (Object)classType.getKind());
        Assert.assertEquals((Object)expectedName, (Object)classType.getName());
        return classType;
    }

    private ApiTypeInfo assertApi(TypeInfo type, String expectedName) {
        Assert.assertEquals(ApiTypeInfo.class, type.getClass());
        ApiTypeInfo apiType = (ApiTypeInfo)type;
        Assert.assertEquals((Object)ClassKind.API, (Object)apiType.getKind());
        Assert.assertEquals((Object)expectedName, (Object)apiType.getName());
        return apiType;
    }

    private DataObjectTypeInfo assertDataObject(TypeInfo type, String expectedName, ClassKind expectedKind) {
        Assert.assertEquals(DataObjectTypeInfo.class, type.getClass());
        DataObjectTypeInfo classType = (DataObjectTypeInfo)type;
        Assert.assertEquals((Object)expectedKind, (Object)classType.getKind());
        Assert.assertEquals((Object)expectedName, (Object)classType.getName());
        return classType;
    }

    private ParameterizedTypeInfo assertParameterized(TypeInfo type, String expectedName, ClassKind expectedKind) {
        Assert.assertEquals(ParameterizedTypeInfo.class, type.getClass());
        ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
        Assert.assertEquals((Object)expectedKind, (Object)parameterizedType.getKind());
        Assert.assertEquals((Object)expectedName, (Object)parameterizedType.getName());
        return parameterizedType;
    }

    private TypeInfo assertAsync(TypeInfo type, String name) {
        String asyncName = "io.vertx.core.AsyncResult<" + name + ">";
        ParameterizedTypeInfo handlerType = this.assertParameterized(this.assertHandler(type, asyncName), asyncName, ClassKind.ASYNC_RESULT);
        ParameterizedTypeInfo resultType = this.assertParameterized((TypeInfo)handlerType, asyncName, ClassKind.ASYNC_RESULT);
        return resultType.getArg(0);
    }

    private TypeInfo assertHandler(TypeInfo type, String name) {
        String handlerName = "io.vertx.core.Handler<" + name + ">";
        ParameterizedTypeInfo handlerType = this.assertParameterized(type, handlerName, ClassKind.HANDLER);
        return handlerType.getArg(0);
    }

    @Test
    public void testCollection() throws Exception {
        this.doTest(CollectionHolder.class, map -> {
            String[] colTypes = new String[]{"list", "set", "map"};
            ClassKind[] colKinds = new ClassKind[]{ClassKind.LIST, ClassKind.SET, ClassKind.MAP};
            List<List> colTypeParams = Arrays.asList(Collections.singletonList("E"), Collections.singletonList("E"), Arrays.asList("K", "V"));
            int[] typeParamIndexes = new int[]{0, 0, 1};
            for (int idx = 0; idx < colKinds.length; ++idx) {
                String colType = colTypes[idx];
                ClassKind colKind = colKinds[idx];
                ClassTypeInfo col = (ClassTypeInfo)map.get(colType);
                int typeParamIndex = typeParamIndexes[idx];
                Assert.assertEquals((Object)colKind, (Object)col.getKind());
                Assert.assertEquals(ClassTypeInfo.class, col.getClass());
                Assert.assertEquals((Object)colTypeParams.get(idx), col.getParams().stream().map(TypeParamInfo::getName).collect(Collectors.toList()));
                ParameterizedTypeInfo ofString = (ParameterizedTypeInfo)map.get(colType + "OfString");
                Assert.assertEquals((Object)colKind, (Object)ofString.getKind());
                Assert.assertEquals(ParameterizedTypeInfo.class, ofString.getClass());
                Assert.assertEquals((Object)col, (Object)ofString.getRaw());
                Assert.assertEquals(map.get("String"), (Object)ofString.getArg(typeParamIndex));
                ParameterizedTypeInfo ofClassTypeParam = (ParameterizedTypeInfo)map.get(colType + "OfClassTypeParam");
                Assert.assertEquals((Object)colKind, (Object)ofClassTypeParam.getKind());
                Assert.assertEquals(ParameterizedTypeInfo.class, ofClassTypeParam.getClass());
                Assert.assertEquals((Object)col, (Object)ofClassTypeParam.getRaw());
                Assert.assertEquals(map.get("ClassTypeParam"), (Object)ofClassTypeParam.getArg(typeParamIndex));
                ParameterizedTypeInfo ofMethodTypeParam = (ParameterizedTypeInfo)map.get(colType + "OfMethodTypeParam");
                Assert.assertEquals((Object)colKind, (Object)ofMethodTypeParam.getKind());
                Assert.assertEquals(ParameterizedTypeInfo.class, ofMethodTypeParam.getClass());
                Assert.assertEquals((Object)col, (Object)ofMethodTypeParam.getRaw());
                Assert.assertEquals((long)(1 + typeParamIndex), (long)ofMethodTypeParam.getArgs().size());
                TypeParamInfo.Method methodTypeParam = (TypeParamInfo.Method)((TypeVariableInfo)ofMethodTypeParam.getArg(typeParamIndex)).getParam();
                Assert.assertEquals((Object)"MethodTypeParam", (Object)methodTypeParam.getName());
                ParameterizedTypeInfo ofDataObject = (ParameterizedTypeInfo)map.get(colType + "OfDataObject");
                Assert.assertEquals((Object)colKind, (Object)ofDataObject.getKind());
                Assert.assertEquals(ParameterizedTypeInfo.class, ofDataObject.getClass());
                Assert.assertEquals(map.get("DataObject"), (Object)ofDataObject.getArg(typeParamIndex));
                ParameterizedTypeInfo ofJsonObject = (ParameterizedTypeInfo)map.get(colType + "OfJsonObject");
                Assert.assertEquals((Object)colKind, (Object)ofJsonObject.getKind());
                Assert.assertEquals(ParameterizedTypeInfo.class, ofJsonObject.getClass());
                Assert.assertEquals(map.get("JsonObject"), (Object)ofJsonObject.getArg(typeParamIndex));
                ParameterizedTypeInfo ofJsonArray = (ParameterizedTypeInfo)map.get(colType + "OfJsonArray");
                Assert.assertEquals((Object)colKind, (Object)ofJsonArray.getKind());
                Assert.assertEquals(ParameterizedTypeInfo.class, ofJsonArray.getClass());
                Assert.assertEquals(map.get("JsonArray"), (Object)ofJsonArray.getArg(typeParamIndex));
                ParameterizedTypeInfo ofEnum = (ParameterizedTypeInfo)map.get(colType + "OfEnum");
                Assert.assertEquals((Object)colKind, (Object)ofEnum.getKind());
                Assert.assertEquals(ParameterizedTypeInfo.class, ofEnum.getClass());
                Assert.assertEquals(map.get("Enum"), (Object)ofEnum.getArg(typeParamIndex));
            }
        });
    }

    @Test
    public void testStream() throws Exception {
        this.doTest(StreamHolder.class, map -> {
            ApiTypeInfo readStreamOfString = this.assertApi((TypeInfo)this.assertParameterized((TypeInfo)map.get("readStreamOfString"), "io.vertx.core.streams.ReadStream<java.lang.String>", ClassKind.API).getRaw(), "io.vertx.core.streams.ReadStream");
            this.assertTypeVariable(readStreamOfString.getReadStreamArg(), "T");
            ApiTypeInfo extendsReadStreamWithClassArg = this.assertApi((TypeInfo)map.get("extendsReadStreamWithClassArg"), InterfaceExtentingReadStream.class.getName());
            this.assertClass(extendsReadStreamWithClassArg.getReadStreamArg(), "java.lang.String", ClassKind.STRING);
            ApiTypeInfo extendsGenericReadStreamSubTypeWithClassArg = this.assertApi((TypeInfo)map.get("extendsGenericReadStreamSubTypeWithClassArg"), InterfaceSubtypingReadStream.class.getName());
            this.assertClass(extendsGenericReadStreamSubTypeWithClassArg.getReadStreamArg(), "java.lang.String", ClassKind.STRING);
            ApiTypeInfo genericReadStreamSubTypeWithClassTypeParamArg = this.assertApi((TypeInfo)this.assertParameterized((TypeInfo)map.get("genericReadStreamSubTypeWithClassTypeParamArg"), ReadStreamWithParameterizedTypeArg.class.getName() + "<ClassTypeParam>", ClassKind.API).getRaw(), "io.vertx.test.codegen.testapi.streams.ReadStreamWithParameterizedTypeArg");
        });
    }

    @Test
    public void testEnum() throws Exception {
        this.doTest(EnumHolder.class, map -> {
            EnumTypeInfo apiEnum = (EnumTypeInfo)map.get("apiEnum");
            Assert.assertEquals((Object)ClassKind.ENUM, (Object)apiEnum.getKind());
            Assert.assertEquals(Arrays.asList("RED", "GREEN", "BLUE"), (Object)apiEnum.getValues());
            Assert.assertTrue((boolean)apiEnum.isGen());
            EnumTypeInfo otherEnum = (EnumTypeInfo)map.get("otherEnum");
            Assert.assertEquals((Object)ClassKind.ENUM, (Object)otherEnum.getKind());
            Assert.assertEquals(Arrays.asList("NANOSECONDS", "MICROSECONDS", "MILLISECONDS", "SECONDS", "MINUTES", "HOURS", "DAYS"), (Object)otherEnum.getValues());
            Assert.assertFalse((boolean)otherEnum.isGen());
        });
    }

    @Test
    public void testGetErased() {
        abstract class Container<M>
        implements AsyncResult<List<M>> {
            Container() {
            }
        }
        ParameterizedTypeInfo info = (ParameterizedTypeInfo)TypeReflectionFactory.create((Type)Container.class.getGenericInterfaces()[0]);
        abstract class Expected
        implements AsyncResult<List<Object>> {
            Expected() {
            }
        }
        ParameterizedTypeInfo expected = (ParameterizedTypeInfo)TypeReflectionFactory.create((Type)Expected.class.getGenericInterfaces()[0]);
        Assert.assertEquals((Object)expected, (Object)info.getErased());
    }
}

