/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen;

import io.vertx.codegen.ClassModel;
import io.vertx.codegen.Generator;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.doc.Doc;
import io.vertx.codegen.doc.Tag;
import io.vertx.codegen.doc.Token;
import io.vertx.test.codegen.doc.FooEnum;
import io.vertx.test.codegen.doc.LinkLabel;
import io.vertx.test.codegen.doc.LinkToEnum;
import io.vertx.test.codegen.doc.LinkToMethodInSameType;
import io.vertx.test.codegen.doc.LinkToSameType;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.ElementKind;
import org.junit.Assert;
import org.junit.Test;

public class DocTest {
    @Test
    public void testTags() {
        this.assertTag("foo");
        this.assertTag("foo bar");
        this.assertTag("foo  bar");
        this.assertTag("foo\nbar");
        this.assertTag("foo \n bar");
        this.assertTag(" foo");
        this.assertTag("foo ");
    }

    private void assertTag(String value) {
        Tag tag = new Tag("foo", value);
        Assert.assertEquals((Object)value, (Object)tag.getValue());
    }

    @Test
    public void testCommentParser() {
        this.assertComment("first", "first", null, new Tag[0]);
        this.assertComment("first\n\nbody", "first", "body", new Tag[0]);
        this.assertComment("first @tag", "first @tag", null, new Tag[0]);
        this.assertComment("first\n@tag1 value1", "first", null, new Tag("tag1", "value1"));
        this.assertComment("first\n@tag1 line1\nline2", "first", null, new Tag("tag1", "line1\nline2"));
        this.assertComment("first\n@tag1 value1\n@tag2 value2", "first", null, new Tag("tag1", "value1"), new Tag("tag2", "value2"));
        this.assertComment("@tag1 value", "", null, new Tag("tag1", "value"));
        this.assertComment("\n@tag1 value", "", null, new Tag("tag1", "value"));
        this.assertComment("@tag1 value1\n@tag2 value2", "", null, new Tag("tag1", "value1"), new Tag("tag2", "value2"));
    }

    private void assertComment(String text, String expectedFirstSentence, String expectedBody, Tag ... expectedBlockTags) {
        Doc comment = Doc.create((String)text);
        Assert.assertEquals((Object)expectedFirstSentence, (Object)comment.getFirstSentence().getValue());
        Assert.assertEquals((Object)expectedBody, comment.getBody() != null ? comment.getBody().getValue() : null);
        Assert.assertEquals(Arrays.asList(expectedBlockTags), (Object)comment.getBlockTags());
    }

    @Test
    public void testText() {
        List events = Token.tokenize((String)"abc");
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertTrue((boolean)((Token)events.get(0)).isText());
        Assert.assertEquals((Object)"abc", (Object)((Token)events.get(0)).getValue());
    }

    @Test
    public void testTag1() {
        List events = Token.tokenize((String)"{@def}");
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertTrue((boolean)((Token)events.get(0)).isInlineTag());
        Assert.assertEquals((Object)"{@def}", (Object)((Token)events.get(0)).getValue());
        Assert.assertEquals((Object)"def", (Object)((Token.InlineTag)events.get(0)).getTag().getName());
        Assert.assertEquals((Object)"", (Object)((Token.InlineTag)events.get(0)).getTag().getValue());
    }

    @Test
    public void testTag2() {
        List events = Token.tokenize((String)"{@def ghi}");
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertTrue((boolean)((Token)events.get(0)).isInlineTag());
        Assert.assertEquals((Object)"{@def ghi}", (Object)((Token)events.get(0)).getValue());
        Assert.assertEquals((Object)"def", (Object)((Token.InlineTag)events.get(0)).getTag().getName());
        Assert.assertEquals((Object)" ghi", (Object)((Token.InlineTag)events.get(0)).getTag().getValue());
    }

    @Test
    public void testTag3() {
        List events = Token.tokenize((String)"{@def\nghi}");
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertTrue((boolean)((Token)events.get(0)).isInlineTag());
        Assert.assertEquals((Object)"{@def\nghi}", (Object)((Token)events.get(0)).getValue());
        Assert.assertEquals((Object)"def", (Object)((Token.InlineTag)events.get(0)).getTag().getName());
        Assert.assertEquals((Object)"\nghi", (Object)((Token.InlineTag)events.get(0)).getTag().getValue());
    }

    @Test
    public void testSequence() {
        List events = Token.tokenize((String)"abc{@def}\nghi{@jkl mno}\n");
        Assert.assertEquals((long)6L, (long)events.size());
        Assert.assertTrue((boolean)((Token)events.get(0)).isText());
        Assert.assertEquals((Object)"abc", (Object)((Token)events.get(0)).getValue());
        Assert.assertTrue((boolean)((Token)events.get(1)).isInlineTag());
        Assert.assertEquals((Object)"{@def}", (Object)((Token)events.get(1)).getValue());
        Assert.assertEquals((Object)"def", (Object)((Token.InlineTag)events.get(1)).getTag().getName());
        Assert.assertEquals((Object)"", (Object)((Token.InlineTag)events.get(1)).getTag().getValue());
        Assert.assertTrue((boolean)((Token)events.get(2)).isLineBreak());
        Assert.assertEquals((Object)"\n", (Object)((Token)events.get(2)).getValue());
        Assert.assertTrue((boolean)((Token)events.get(3)).isText());
        Assert.assertEquals((Object)"ghi", (Object)((Token)events.get(3)).getValue());
        Assert.assertTrue((boolean)((Token)events.get(4)).isInlineTag());
        Assert.assertEquals((Object)"{@jkl mno}", (Object)((Token)events.get(4)).getValue());
        Assert.assertEquals((Object)"jkl", (Object)((Token.InlineTag)events.get(4)).getTag().getName());
        Assert.assertEquals((Object)" mno", (Object)((Token.InlineTag)events.get(4)).getTag().getValue());
        Assert.assertTrue((boolean)((Token)events.get(5)).isLineBreak());
        Assert.assertEquals((Object)"\n", (Object)((Token)events.get(5)).getValue());
    }

    @Test
    public void testLinkToMethodInSameType() throws Exception {
        ClassModel model = new Generator().generateClass(LinkToMethodInSameType.class, new Class[0]);
        MethodInfo method = (MethodInfo)((List)model.getMethodMap().get("m")).get(0);
        Doc doc = method.getDoc();
        List tokens = doc.getTokens();
        Assert.assertEquals((long)4L, (long)tokens.size());
        for (Token token : tokens) {
            Tag.Link link = (Tag.Link)((Token.InlineTag)token).getTag();
            Assert.assertEquals((Object)((Object)ElementKind.METHOD), (Object)((Object)link.getTargetElement().getKind()));
            Assert.assertEquals((Object)"method(java.lang.String,int)", (Object)link.getTargetElement().toString());
        }
    }

    @Test
    public void testLinkToSameType() throws Exception {
        ClassModel model = new Generator().generateClass(LinkToSameType.class, new Class[0]);
        MethodInfo method = (MethodInfo)((List)model.getMethodMap().get("m")).get(0);
        Doc doc = method.getDoc();
        List tokens = doc.getTokens();
        Assert.assertEquals((long)2L, (long)tokens.size());
        for (Token token : tokens) {
            Tag.Link link = (Tag.Link)((Token.InlineTag)token).getTag();
            Assert.assertEquals((Object)LinkToSameType.class.getName(), (Object)link.getTargetElement().toString());
        }
    }

    @Test
    public void testLinkToEnum() throws Exception {
        ClassModel model = new Generator().generateClass(LinkToEnum.class, new Class[0]);
        MethodInfo method = (MethodInfo)((List)model.getMethodMap().get("m")).get(0);
        Doc doc = method.getDoc();
        List tokens = doc.getTokens();
        Assert.assertEquals((long)2L, (long)tokens.size());
        for (Token token : tokens) {
            Tag.Link link = (Tag.Link)((Token.InlineTag)token).getTag();
            Assert.assertEquals((Object)FooEnum.class.getName(), (Object)link.getTargetElement().toString());
        }
    }

    @Test
    public void testLinkLabel() throws Exception {
        ClassModel model = new Generator().generateClass(LinkLabel.class, new Class[0]);
        MethodInfo method = (MethodInfo)((List)model.getMethodMap().get("m")).get(0);
        Doc doc = method.getDoc();
        List tokens = doc.getTokens();
        String[] expectedLabels = new String[]{"", "   ", " the label value"};
        Assert.assertEquals((long)expectedLabels.length, (long)tokens.size());
        for (int i = 0; i < tokens.size(); ++i) {
            Tag.Link link = (Tag.Link)((Token.InlineTag)tokens.get(i)).getTag();
            Assert.assertEquals((String)("" + i), (Object)expectedLabels[i], (Object)link.getLabel());
        }
    }

    @Test
    public void testTagParam() {
        this.assertTagParam("param_name param_desc", "param_name", "param_desc");
        this.assertTagParam("param_name", "param_name", null);
        this.assertTagParam("param_name ", "param_name", null);
        this.assertTagParam("param_name  ", "param_name", null);
        this.assertTagParam("param_name  param_desc", "param_name", "param_desc");
        this.assertTagParam(" param_name param_desc", "param_name", "param_desc");
        this.assertTagParam("param_name\nparam_desc", "param_name", "param_desc");
        this.assertTagParam("param_name param_\ndesc", "param_name", "param_ desc");
        this.assertTagParam("param_name param_desc ", "param_name", "param_desc");
        this.assertTagParam("param_name param desc", "param_name", "param desc");
        this.assertTagParam(")param_name param desc", null, null);
    }

    private void assertTagParam(String comment, String expectedName, String expectedDescription) {
        Tag.Param param = new Tag.Param("param", comment);
        Assert.assertEquals((Object)expectedName, (Object)param.getParamName());
        Assert.assertEquals((Object)expectedDescription, (Object)param.getParamDescription());
    }
}

