/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen;

import io.vertx.codegen.GenException;
import io.vertx.codegen.Generator;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.doc.Doc;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeReflectionFactory;
import io.vertx.test.codegen.TypeLiteral;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.junit.Assert;

public abstract class ClassTestBase {
    void checkMethod(MethodInfo meth, String name, int numParams, TypeLiteral<?> returnType, MethodKind kind, MethodCheck ... checks) {
        this.checkMethod(meth, name, numParams, returnType.type, kind, checks);
    }

    void checkMethod(MethodInfo meth, String name, int numParams, TypeLiteral<?> returnType, MethodKind kind, Doc comment, MethodCheck ... checks) {
        this.checkMethod(meth, name, numParams, returnType.type, kind, comment, checks);
    }

    void checkMethod(MethodInfo meth, String name, int numParams, Type returnType, MethodKind kind, MethodCheck ... checks) {
        this.checkMethod(meth, name, numParams, returnType.getTypeName().replaceAll(" ", ""), kind, checks);
    }

    void checkMethod(MethodInfo meth, String name, int numParams, Type returnType, MethodKind kind, Doc comment, MethodCheck ... checks) {
        this.checkMethod(meth, name, numParams, returnType.getTypeName().replaceAll(" ", ""), kind, comment, checks);
    }

    void checkMethod(MethodInfo meth, String name, int numParams, String returnType, MethodKind kind, MethodCheck ... checks) {
        this.checkMethod(meth, name, numParams, returnType, kind, (Doc)null, checks);
    }

    void checkMethod(MethodInfo meth, String name, int numParams, String returnType, MethodKind kind, Doc comment, MethodCheck ... checks) {
        EnumSet<MethodCheck> checkSet = EnumSet.noneOf(MethodCheck.class);
        Collections.addAll(checkSet, checks);
        Assert.assertEquals((Object)name, (Object)meth.getName());
        if (comment != null) {
            Assert.assertNotNull((Object)meth.getComment());
            Assert.assertEquals((Object)comment.getFirstSentence(), (Object)meth.getDoc().getFirstSentence());
            Assert.assertEquals((Object)comment.getBody(), (Object)meth.getDoc().getBody());
            Assert.assertEquals((Object)comment.getBlockTags(), (Object)meth.getDoc().getBlockTags());
        } else {
            Assert.assertNull((Object)meth.getComment());
        }
        Assert.assertEquals((Object)kind, (Object)meth.getKind());
        Assert.assertEquals((Object)returnType, (Object)meth.getReturnType().toString());
        Assert.assertEquals((Object)checkSet.contains((Object)MethodCheck.CACHE_RETURN), (Object)meth.isCacheReturn());
        Assert.assertEquals((Object)checkSet.contains((Object)MethodCheck.FLUENT), (Object)meth.isFluent());
        Assert.assertEquals((Object)checkSet.contains((Object)MethodCheck.STATIC), (Object)meth.isStaticMethod());
        Assert.assertEquals((long)numParams, (long)meth.getParams().size());
    }

    void checkParam(ParamInfo param, String name, TypeLiteral<?> expectedType) {
        this.checkParam(param, name, expectedType.type);
    }

    void checkParam(ParamInfo param, String name, Type expectedType) {
        Assert.assertEquals((Object)name, (Object)param.getName());
        TypeInfo expectedTypeInfo = TypeReflectionFactory.create((Type)expectedType);
        Assert.assertEquals((Object)expectedTypeInfo.getName(), (Object)param.getType().getName());
        Assert.assertEquals((Object)expectedTypeInfo.getKind(), (Object)param.getType().getKind());
    }

    void checkParam(ParamInfo param, String name, TypeLiteral<?> expectedType, TypeLiteral<?> expectedUnresolvedType) {
        this.checkParam(param, name, expectedType.type, expectedUnresolvedType.type);
    }

    void checkParam(ParamInfo param, String name, Type expectedType, Type expectedUnresolvedType) {
        this.checkParam(param, name, expectedType);
        TypeInfo expectedUnresolvedTypeInfo = TypeReflectionFactory.create((Type)expectedUnresolvedType);
        Assert.assertEquals((Object)expectedUnresolvedTypeInfo.getName(), (Object)param.getUnresolvedType().getName());
        Assert.assertEquals((Object)expectedUnresolvedTypeInfo.getKind(), (Object)param.getUnresolvedType().getKind());
    }

    void assertGenInvalid(Class<?> c, Class<?> ... rest) throws Exception {
        try {
            new Generator().generateClass(c, (Class[])rest);
            Assert.fail((String)"Should throw exception");
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    void assertGenFail(Class<?> type, String msg) throws Exception {
        try {
            new Generator().generateClass(type, new Class[0]);
            Assert.fail((String)msg);
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void blacklist(Runnable test, Stream<Class<?>> classes) {
        final HashSet blacklist = new HashSet();
        classes.map(Class::getName).forEach(blacklist::add);
        Thread thread = Thread.currentThread();
        ClassLoader prev = thread.getContextClassLoader();
        thread.setContextClassLoader(new ClassLoader(prev){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                if (blacklist.contains(name)) {
                    throw new ClassNotFoundException();
                }
                return super.loadClass(name);
            }
        });
        try {
            test.run();
        }
        finally {
            thread.setContextClassLoader(prev);
        }
    }

    static <T> Set<T> set(T ... values) {
        return new HashSet<T>(Arrays.asList(values));
    }

    static enum MethodCheck {
        FLUENT,
        STATIC,
        CACHE_RETURN;

    }
}

