/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen;

import io.vertx.codegen.ClassModel;
import io.vertx.codegen.GenException;
import io.vertx.codegen.Generator;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.Signature;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.codegen.doc.Doc;
import io.vertx.codegen.doc.Tag;
import io.vertx.codegen.testmodel.TestDataObject;
import io.vertx.codegen.testmodel.TestEnum;
import io.vertx.codegen.testmodel.TestGenEnum;
import io.vertx.codegen.type.AnnotationValueInfo;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.EnumTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.PrimitiveTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeReflectionFactory;
import io.vertx.codegen.type.TypeVariableInfo;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.WriteStream;
import io.vertx.test.codegen.ClassTestBase;
import io.vertx.test.codegen.TypeLiteral;
import io.vertx.test.codegen.annotations.EmptyAnnotation;
import io.vertx.test.codegen.testapi.AbstractDataObjectWithToJson;
import io.vertx.test.codegen.testapi.AbstractInterfaceWithConcreteSuperInterface;
import io.vertx.test.codegen.testapi.AbstractInterfaceWithStaticMethod;
import io.vertx.test.codegen.testapi.Annotated;
import io.vertx.test.codegen.testapi.CacheReturnMethodWithVoidReturn;
import io.vertx.test.codegen.testapi.ConcreteInterfaceWithTwoConcreteSuperInterfaces;
import io.vertx.test.codegen.testapi.DiamondMethod1;
import io.vertx.test.codegen.testapi.DiamondMethod2;
import io.vertx.test.codegen.testapi.DiamondMethod3;
import io.vertx.test.codegen.testapi.GenericAbstractInterface;
import io.vertx.test.codegen.testapi.GenericInterface;
import io.vertx.test.codegen.testapi.GenericInterface2;
import io.vertx.test.codegen.testapi.GenericInterfaceWithUpperBound;
import io.vertx.test.codegen.testapi.InterfaceDataObjectWithToJson;
import io.vertx.test.codegen.testapi.InterfaceExtendingGenericAbstractInterface;
import io.vertx.test.codegen.testapi.InterfaceWithCacheReturnMethods;
import io.vertx.test.codegen.testapi.InterfaceWithComments;
import io.vertx.test.codegen.testapi.InterfaceWithDefaultMethod;
import io.vertx.test.codegen.testapi.InterfaceWithGenericMethodOverride;
import io.vertx.test.codegen.testapi.InterfaceWithIgnoredElements;
import io.vertx.test.codegen.testapi.InterfaceWithInstanceMethods;
import io.vertx.test.codegen.testapi.InterfaceWithMethodOverloadedFromParent;
import io.vertx.test.codegen.testapi.InterfaceWithMethodOverride;
import io.vertx.test.codegen.testapi.InterfaceWithMethodOverrideParameterRenamed;
import io.vertx.test.codegen.testapi.InterfaceWithNoMethods;
import io.vertx.test.codegen.testapi.InterfaceWithNoNotIgnoredMethods;
import io.vertx.test.codegen.testapi.InterfaceWithNonGenSuperType;
import io.vertx.test.codegen.testapi.InterfaceWithOnlyDefaultMethod;
import io.vertx.test.codegen.testapi.InterfaceWithOverloadedFutureMethod;
import io.vertx.test.codegen.testapi.InterfaceWithOverloadedInstanceAndStaticMethod;
import io.vertx.test.codegen.testapi.InterfaceWithOverloadedMethods;
import io.vertx.test.codegen.testapi.InterfaceWithParameterizedArraySupertype;
import io.vertx.test.codegen.testapi.InterfaceWithParameterizedDeclaredSupertype;
import io.vertx.test.codegen.testapi.InterfaceWithParameterizedGenericArraySupertype;
import io.vertx.test.codegen.testapi.InterfaceWithParameterizedVariableSupertype;
import io.vertx.test.codegen.testapi.InterfaceWithStaticMethods;
import io.vertx.test.codegen.testapi.InterfaceWithSuperStaticMethods;
import io.vertx.test.codegen.testapi.InterfaceWithSupertypes;
import io.vertx.test.codegen.testapi.InterfaceWithTypeVariableArgument1;
import io.vertx.test.codegen.testapi.InterfaceWithTypeVariableArgument2;
import io.vertx.test.codegen.testapi.InterfaceWithTypeVariableArgument3;
import io.vertx.test.codegen.testapi.MethodWithDataObjectParam;
import io.vertx.test.codegen.testapi.MethodWithDiamond;
import io.vertx.test.codegen.testapi.MethodWithEnumParam;
import io.vertx.test.codegen.testapi.MethodWithEnumReturn;
import io.vertx.test.codegen.testapi.MethodWithFunctionInHandler;
import io.vertx.test.codegen.testapi.MethodWithFunctionInHandlerAsyncResult;
import io.vertx.test.codegen.testapi.MethodWithHandlerAsyncResultParam;
import io.vertx.test.codegen.testapi.MethodWithHandlerAsyncResultReturn;
import io.vertx.test.codegen.testapi.MethodWithHandlerNonVertxGenReturn;
import io.vertx.test.codegen.testapi.MethodWithHandlerParam;
import io.vertx.test.codegen.testapi.MethodWithHandlerReturn;
import io.vertx.test.codegen.testapi.MethodWithInvalidAbstractDataObjectParam;
import io.vertx.test.codegen.testapi.MethodWithInvalidExceptionParam;
import io.vertx.test.codegen.testapi.MethodWithInvalidFunctionParam1;
import io.vertx.test.codegen.testapi.MethodWithInvalidFunctionParam2;
import io.vertx.test.codegen.testapi.MethodWithInvalidFunctionParam3;
import io.vertx.test.codegen.testapi.MethodWithInvalidFunctionParam4;
import io.vertx.test.codegen.testapi.MethodWithInvalidFunctionParam5;
import io.vertx.test.codegen.testapi.MethodWithInvalidFunctionParam6;
import io.vertx.test.codegen.testapi.MethodWithInvalidFunctionParam7;
import io.vertx.test.codegen.testapi.MethodWithInvalidFunctionParam8;
import io.vertx.test.codegen.testapi.MethodWithInvalidHandlerAsyncResultDataObjectParam;
import io.vertx.test.codegen.testapi.MethodWithInvalidHandlerDataObjectParam;
import io.vertx.test.codegen.testapi.MethodWithInvalidInterfaceDataObjectParam;
import io.vertx.test.codegen.testapi.MethodWithInvalidListParams1;
import io.vertx.test.codegen.testapi.MethodWithInvalidListParams2;
import io.vertx.test.codegen.testapi.MethodWithInvalidListReturn1;
import io.vertx.test.codegen.testapi.MethodWithInvalidListReturn2;
import io.vertx.test.codegen.testapi.MethodWithInvalidMapParams1;
import io.vertx.test.codegen.testapi.MethodWithInvalidMapParams2;
import io.vertx.test.codegen.testapi.MethodWithInvalidMapReturn1;
import io.vertx.test.codegen.testapi.MethodWithInvalidMapReturn2;
import io.vertx.test.codegen.testapi.MethodWithInvalidMapReturn3;
import io.vertx.test.codegen.testapi.MethodWithInvalidMapReturn4;
import io.vertx.test.codegen.testapi.MethodWithInvalidMapReturn5;
import io.vertx.test.codegen.testapi.MethodWithInvalidNestedEnumParam;
import io.vertx.test.codegen.testapi.MethodWithInvalidSetParams1;
import io.vertx.test.codegen.testapi.MethodWithInvalidSetParams2;
import io.vertx.test.codegen.testapi.MethodWithInvalidSetReturn1;
import io.vertx.test.codegen.testapi.MethodWithInvalidSetReturn2;
import io.vertx.test.codegen.testapi.MethodWithInvalidTypeParamByObjectReturn;
import io.vertx.test.codegen.testapi.MethodWithInvalidTypeParamByParameterizedReturn;
import io.vertx.test.codegen.testapi.MethodWithInvalidTypeParamByThrowableReturn;
import io.vertx.test.codegen.testapi.MethodWithInvalidWildcardTypeArg;
import io.vertx.test.codegen.testapi.MethodWithJavaDotObjectInHandler;
import io.vertx.test.codegen.testapi.MethodWithJavaDotObjectInHandlerAsyncResult;
import io.vertx.test.codegen.testapi.MethodWithJavaDotObjectParam;
import io.vertx.test.codegen.testapi.MethodWithJavaDotObjectReturn;
import io.vertx.test.codegen.testapi.MethodWithListNonBasicTypeReturn;
import io.vertx.test.codegen.testapi.MethodWithNotVertxGenObjectInHandler;
import io.vertx.test.codegen.testapi.MethodWithNotVertxGenObjectInHandlerAsyncResult;
import io.vertx.test.codegen.testapi.MethodWithNotVertxGenObjectParam;
import io.vertx.test.codegen.testapi.MethodWithNotVertxGenObjectReturn;
import io.vertx.test.codegen.testapi.MethodWithObjectParam;
import io.vertx.test.codegen.testapi.MethodWithObjectReturn;
import io.vertx.test.codegen.testapi.MethodWithSameSignatureInheritedFromDistinctInterfaces;
import io.vertx.test.codegen.testapi.MethodWithSetNonBasicTypeReturn;
import io.vertx.test.codegen.testapi.MethodWithThrowableReturn;
import io.vertx.test.codegen.testapi.MethodWithTypeParameter;
import io.vertx.test.codegen.testapi.MethodWithTypeParameterUpperBound;
import io.vertx.test.codegen.testapi.MethodWithTypeVarParamByGenericType;
import io.vertx.test.codegen.testapi.MethodWithValidBasicBoxedParams;
import io.vertx.test.codegen.testapi.MethodWithValidBasicParams;
import io.vertx.test.codegen.testapi.MethodWithValidBasicReturn;
import io.vertx.test.codegen.testapi.MethodWithValidClassTypeParams;
import io.vertx.test.codegen.testapi.MethodWithValidDataObjectReturn;
import io.vertx.test.codegen.testapi.MethodWithValidFunctionParams;
import io.vertx.test.codegen.testapi.MethodWithValidHandlerAsyncResultJSON;
import io.vertx.test.codegen.testapi.MethodWithValidHandlerAsyncResultParams;
import io.vertx.test.codegen.testapi.MethodWithValidHandlerAsyncResultTypeParamByInterface;
import io.vertx.test.codegen.testapi.MethodWithValidHandlerJSON;
import io.vertx.test.codegen.testapi.MethodWithValidHandlerParams;
import io.vertx.test.codegen.testapi.MethodWithValidHandlerTypeParamByInterface;
import io.vertx.test.codegen.testapi.MethodWithValidJSONParams;
import io.vertx.test.codegen.testapi.MethodWithValidJSONReturn;
import io.vertx.test.codegen.testapi.MethodWithValidListParams;
import io.vertx.test.codegen.testapi.MethodWithValidListReturn;
import io.vertx.test.codegen.testapi.MethodWithValidMapParams;
import io.vertx.test.codegen.testapi.MethodWithValidMapReturn;
import io.vertx.test.codegen.testapi.MethodWithValidSetParams;
import io.vertx.test.codegen.testapi.MethodWithValidSetReturn;
import io.vertx.test.codegen.testapi.MethodWithValidThrowableParam;
import io.vertx.test.codegen.testapi.MethodWithValidTypeParamByInterfaceReturn;
import io.vertx.test.codegen.testapi.MethodWithValidVertxGenParams;
import io.vertx.test.codegen.testapi.MethodWithValidVertxGenReturn;
import io.vertx.test.codegen.testapi.MethodWithValidVoidReturn;
import io.vertx.test.codegen.testapi.MethodWithValidVoidTypeArg;
import io.vertx.test.codegen.testapi.MethodWithWildcardLowerBoundTypeArg;
import io.vertx.test.codegen.testapi.MethodWithWildcardUpperBoundTypeArg;
import io.vertx.test.codegen.testapi.NestedInterface;
import io.vertx.test.codegen.testapi.NoVertxGen;
import io.vertx.test.codegen.testapi.NotInterface;
import io.vertx.test.codegen.testapi.OverloadedMethodsWithDifferentReturnType;
import io.vertx.test.codegen.testapi.PlainDataObject;
import io.vertx.test.codegen.testapi.PlainDataObjectWithToJson;
import io.vertx.test.codegen.testapi.RecursiveFuture;
import io.vertx.test.codegen.testapi.SameSignatureMethod1;
import io.vertx.test.codegen.testapi.SameSignatureMethod2;
import io.vertx.test.codegen.testapi.VertxGenClass1;
import io.vertx.test.codegen.testapi.VertxGenClass2;
import io.vertx.test.codegen.testapi.VertxGenInterface;
import io.vertx.test.codegen.testapi.fluent.AbstractInterfaceWithFluentMethods;
import io.vertx.test.codegen.testapi.fluent.ConcreteInterfaceWithFluentMethods;
import io.vertx.test.codegen.testapi.fluent.FluentMethodOverrideWithSuperType;
import io.vertx.test.codegen.testapi.fluent.FluentMethodWithGenericReturn;
import io.vertx.test.codegen.testapi.fluent.FluentMethodWithIllegalParameterizedReturn;
import io.vertx.test.codegen.testapi.fluent.FluentMethodWithIllegalReturn;
import io.vertx.test.codegen.testapi.fluent.FluentMethodWithVoidReturn;
import io.vertx.test.codegen.testapi.fluent.InterfaceWithFluentMethodOverrideFromAbstract;
import io.vertx.test.codegen.testapi.fluent.InterfaceWithFluentMethodOverrideFromConcrete;
import io.vertx.test.codegen.testapi.handler.FutureLike;
import io.vertx.test.codegen.testapi.handler.InterfaceExtendingHandlerStringSubtype;
import io.vertx.test.codegen.testapi.handler.InterfaceExtendingHandlerVertxGenSubtype;
import io.vertx.test.codegen.testapi.impl.InterfaceInImplPackage;
import io.vertx.test.codegen.testapi.impl.sub.InterfaceInImplParentPackage;
import io.vertx.test.codegen.testapi.simple.InterfaceInImplContainingPackage;
import io.vertx.test.codegen.testapi.streams.GenericInterfaceExtentingReadStream;
import io.vertx.test.codegen.testapi.streams.GenericInterfaceExtentingReadStreamAndWriteStream;
import io.vertx.test.codegen.testapi.streams.GenericInterfaceExtentingWriteStream;
import io.vertx.test.codegen.testapi.streams.InterfaceExtentingReadStream;
import io.vertx.test.codegen.testapi.streams.InterfaceExtentingReadStreamAndWriteStream;
import io.vertx.test.codegen.testapi.streams.InterfaceExtentingWriteStream;
import io.vertx.test.codegen.testapi.streams.InterfaceSubtypingReadStream;
import io.vertx.test.codegen.testapi.streams.ReadStreamWithParameterizedTypeArg;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class ClassTest
extends ClassTestBase {
    static final ClassTypeInfo GenericInterfaceInfo = (ClassTypeInfo)TypeReflectionFactory.create(GenericInterface.class);
    static final ClassTypeInfo VertxGenClass1Info = (ClassTypeInfo)TypeReflectionFactory.create(VertxGenClass1.class);
    static final ClassTypeInfo VertxGenClass2Info = (ClassTypeInfo)TypeReflectionFactory.create(VertxGenClass2.class);
    static final ClassTypeInfo VertxGenInterfaceInfo = (ClassTypeInfo)TypeReflectionFactory.create(VertxGenInterface.class);

    @Test
    public void testGenerateNotInterface() throws Exception {
        this.assertGenInvalid(NotInterface.class, new Class[0]);
    }

    @Test
    public void testGenerateNoVertxGenAnnotation() throws Exception {
        try {
            new Generator().generateClass(NoVertxGen.class, new Class[0]);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGenerateNestedInterfaces() throws Exception {
        this.assertGenInvalid(NestedInterface.class, new Class[0]);
    }

    @Test
    public void testGenerateInterfaceWithNoMethods() throws Exception {
        this.assertGenInvalid(InterfaceWithNoMethods.class, new Class[0]);
    }

    @Test
    public void testGenerateInterfaceWithNoNotIgnoredMethods() throws Exception {
        this.assertGenInvalid(InterfaceWithNoNotIgnoredMethods.class, new Class[0]);
    }

    @Test
    public void testGenerateInterfaceWithOnlyDefaultMethod() throws Exception {
        this.assertGenInvalid(InterfaceWithOnlyDefaultMethod.class, new Class[0]);
    }

    @Test
    public void testGenerateMethodWithJavaDotObjectParam() throws Exception {
        this.assertGenInvalid(MethodWithJavaDotObjectParam.class, new Class[0]);
    }

    @Test
    public void testGenerateMethodWithJavaDotObjectInHandler() throws Exception {
        this.assertGenInvalid(MethodWithJavaDotObjectInHandler.class, new Class[0]);
    }

    @Test
    public void testGenerateMethodWithJavaDotObjectInHandlerAsyncResult() throws Exception {
        this.assertGenInvalid(MethodWithJavaDotObjectInHandlerAsyncResult.class, new Class[0]);
    }

    @Test
    public void testGenerateMethodWithNonVertxGenParam() throws Exception {
        Class<MethodWithNotVertxGenObjectParam> c = MethodWithNotVertxGenObjectParam.class;
        this.assertGenInvalid(c, new Class[0]);
    }

    @Test
    public void testGenerateMethodWithNonVertxGenInHandler() throws Exception {
        this.assertGenInvalid(MethodWithNotVertxGenObjectInHandler.class, new Class[0]);
    }

    @Test
    public void testGenerateMethodWithNonVertxGenInHandlerAsyncResult() throws Exception {
        this.assertGenInvalid(MethodWithNotVertxGenObjectInHandlerAsyncResult.class, new Class[0]);
    }

    @Test
    public void testGenerateMethodWithFunctionInHandler() throws Exception {
        this.assertGenInvalid(MethodWithFunctionInHandler.class, new Class[0]);
    }

    @Test
    public void testGenerateMethodWithFunctionInHandlerAsyncResult() throws Exception {
        this.assertGenInvalid(MethodWithFunctionInHandlerAsyncResult.class, new Class[0]);
    }

    @Test
    public void testGenerateMethodWithWildcardUpperBoundTypeArg() throws Exception {
        this.assertGenInvalid(MethodWithWildcardUpperBoundTypeArg.class, new Class[0]);
    }

    @Test
    public void testGenerateMethodWithWildcardLowerBoundTypeArg() throws Exception {
        this.assertGenInvalid(MethodWithWildcardLowerBoundTypeArg.class, new Class[0]);
    }

    @Test
    public void testGenerateMethodWithJavaDotObjectReturn() throws Exception {
        this.assertGenInvalid(MethodWithJavaDotObjectReturn.class, new Class[0]);
    }

    @Test
    public void testGenerateMethodWithNonVertxGenReturn() throws Exception {
        this.assertGenInvalid(MethodWithNotVertxGenObjectReturn.class, new Class[0]);
    }

    @Test
    public void testGenerateMethodWithReturnSetNonBasicType() throws Exception {
        this.assertGenInvalid(MethodWithSetNonBasicTypeReturn.class, new Class[0]);
    }

    @Test
    public void testGenerateMethodWithReturnListNonBasicType() throws Exception {
        this.assertGenInvalid(MethodWithListNonBasicTypeReturn.class, new Class[0]);
    }

    @Test
    public void testGenerateMethodWithReturnHandlerNonVertxGen() throws Exception {
        this.assertGenInvalid(MethodWithHandlerNonVertxGenReturn.class, new Class[0]);
    }

    @Test
    public void testOverloadedMethodsWithDifferentReturnType() throws Exception {
        this.assertGenInvalid(OverloadedMethodsWithDifferentReturnType.class, new Class[0]);
    }

    @Test
    public void testFluentMethodWithVoidReturn() throws Exception {
        this.assertGenInvalid(FluentMethodWithVoidReturn.class, new Class[0]);
    }

    @Test
    public void testFluentMethodWithIllegalReturn() throws Exception {
        this.assertGenInvalid(FluentMethodWithIllegalReturn.class, new Class[0]);
    }

    @Test
    public void testFluentMethodWithGenericReturn() throws Exception {
        this.assertGenInvalid(FluentMethodWithGenericReturn.class, new Class[0]);
    }

    @Test
    public void testFluentMethodWithIllegalParameterizedReturn() throws Exception {
        this.assertGenInvalid(FluentMethodWithIllegalParameterizedReturn.class, new Class[0]);
    }

    @Test
    public void testFluentMethodOverrideWithSuperType() throws Exception {
        this.assertGenInvalid(FluentMethodOverrideWithSuperType.class, new Class[0]);
    }

    @Test
    public void testCacheReturnMethodWithVoidReturn() throws Exception {
        this.assertGenInvalid(CacheReturnMethodWithVoidReturn.class, new Class[0]);
    }

    @Test
    public void testMethodWithTypeParameterUpperBound() throws Exception {
        this.assertGenInvalid(MethodWithTypeParameterUpperBound.class, new Class[0]);
    }

    @Test
    public void testMethodWithIllegalGenericsReturn() throws Exception {
        this.assertGenInvalid(MethodWithInvalidTypeParamByObjectReturn.class, new Class[0]);
        this.assertGenInvalid(MethodWithInvalidTypeParamByParameterizedReturn.class, new Class[0]);
        this.assertGenInvalid(MethodWithInvalidTypeParamByThrowableReturn.class, new Class[0]);
    }

    @Test
    public void testAbstractInterfaceCannotExtendConcreteInterface() throws Exception {
        this.assertGenInvalid(AbstractInterfaceWithConcreteSuperInterface.class, new Class[0]);
    }

    @Test
    public void testAbstractInterfaceCannotHaveStaticMethod() throws Exception {
        this.assertGenInvalid(AbstractInterfaceWithStaticMethod.class, new Class[0]);
    }

    @Test
    public void testConcreteInterfaceCannotExtendTwoConcreteInterfaces() throws Exception {
        this.assertGenInvalid(ConcreteInterfaceWithTwoConcreteSuperInterfaces.class, new Class[0]);
    }

    @Test
    public void testInvalidWildcardTypeArg() throws Exception {
        this.assertGenInvalid(MethodWithInvalidWildcardTypeArg.class, new Class[0]);
    }

    @Test
    public void testValidBasicParams() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidBasicParams.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithValidBasicParams.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithValidBasicParams.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertTrue((boolean)model.getReferencedTypes().isEmpty());
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)1L, (long)model.getMethods().size());
        String methodName = "methodWithBasicParams";
        MethodInfo method = (MethodInfo)model.getMethods().get(0);
        this.checkMethod(method, methodName, 9, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        List params = method.getParams();
        this.checkParam((ParamInfo)params.get(0), "b", Byte.TYPE);
        this.checkParam((ParamInfo)params.get(1), "s", Short.TYPE);
        this.checkParam((ParamInfo)params.get(2), "i", Integer.TYPE);
        this.checkParam((ParamInfo)params.get(3), "l", Long.TYPE);
        this.checkParam((ParamInfo)params.get(4), "f", Float.TYPE);
        this.checkParam((ParamInfo)params.get(5), "d", Double.TYPE);
        this.checkParam((ParamInfo)params.get(6), "bool", Boolean.TYPE);
        this.checkParam((ParamInfo)params.get(7), "ch", Character.TYPE);
        this.checkParam((ParamInfo)params.get(8), "str", (Type)((Object)String.class));
        Assert.assertEquals((Object)"java.lang.Byte", (Object)((PrimitiveTypeInfo)((ParamInfo)params.get(0)).getType()).getBoxed().getName());
        Assert.assertEquals((Object)"java.lang.Short", (Object)((PrimitiveTypeInfo)((ParamInfo)params.get(1)).getType()).getBoxed().getName());
        Assert.assertEquals((Object)"java.lang.Integer", (Object)((PrimitiveTypeInfo)((ParamInfo)params.get(2)).getType()).getBoxed().getName());
        Assert.assertEquals((Object)"java.lang.Long", (Object)((PrimitiveTypeInfo)((ParamInfo)params.get(3)).getType()).getBoxed().getName());
        Assert.assertEquals((Object)"java.lang.Float", (Object)((PrimitiveTypeInfo)((ParamInfo)params.get(4)).getType()).getBoxed().getName());
        Assert.assertEquals((Object)"java.lang.Double", (Object)((PrimitiveTypeInfo)((ParamInfo)params.get(5)).getType()).getBoxed().getName());
        Assert.assertEquals((Object)"java.lang.Boolean", (Object)((PrimitiveTypeInfo)((ParamInfo)params.get(6)).getType()).getBoxed().getName());
        Assert.assertEquals((Object)"java.lang.Character", (Object)((PrimitiveTypeInfo)((ParamInfo)params.get(7)).getType()).getBoxed().getName());
    }

    @Test
    public void testValidBasicBoxedParams() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidBasicBoxedParams.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithValidBasicBoxedParams.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithValidBasicBoxedParams.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertTrue((boolean)model.getReferencedTypes().isEmpty());
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)1L, (long)model.getMethods().size());
        String methodName = "methodWithBasicParams";
        MethodInfo method = (MethodInfo)model.getMethods().get(0);
        this.checkMethod(method, methodName, 9, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        List params = method.getParams();
        this.checkParam((ParamInfo)params.get(0), "b", (Type)((Object)Byte.class));
        this.checkParam((ParamInfo)params.get(1), "s", (Type)((Object)Short.class));
        this.checkParam((ParamInfo)params.get(2), "i", (Type)((Object)Integer.class));
        this.checkParam((ParamInfo)params.get(3), "l", (Type)((Object)Long.class));
        this.checkParam((ParamInfo)params.get(4), "f", (Type)((Object)Float.class));
        this.checkParam((ParamInfo)params.get(5), "d", (Type)((Object)Double.class));
        this.checkParam((ParamInfo)params.get(6), "bool", (Type)((Object)Boolean.class));
        this.checkParam((ParamInfo)params.get(7), "ch", (Type)((Object)Character.class));
        this.checkParam((ParamInfo)params.get(8), "str", (Type)((Object)String.class));
    }

    @Test
    public void testValidTypeParam() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithTypeParameter.class, new Class[0]);
        Assert.assertEquals((long)1L, (long)model.getMethods().size());
        MethodInfo mi = (MethodInfo)model.getMethods().get(0);
        Assert.assertEquals((Object)"foo", (Object)mi.getName());
        Assert.assertEquals(Arrays.asList("T"), mi.getTypeParams().stream().map(TypeParamInfo::getName).collect(Collectors.toList()));
    }

    @Test
    public void testValidVoidTypeArg() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidVoidTypeArg.class, new Class[0]);
        Assert.assertEquals((long)1L, (long)model.getMethods().size());
        MethodInfo mi = (MethodInfo)model.getMethods().get(0);
        Assert.assertEquals((Object)"foo", (Object)mi.getName());
        Assert.assertEquals((Object)new ParameterizedTypeInfo(new ClassTypeInfo(ClassKind.API, GenericInterface.class.getName(), null, false, Collections.emptyList()), false, Arrays.asList(TypeReflectionFactory.create(Void.class))), (Object)((ParamInfo)mi.getParams().get(0)).getType());
        ParameterizedTypeInfo genericType = (ParameterizedTypeInfo)((ParamInfo)mi.getParams().get(0)).getType();
        ClassTypeInfo voidType = (ClassTypeInfo)genericType.getArgs().get(0);
        Assert.assertEquals((Object)ClassKind.VOID, (Object)voidType.getKind());
    }

    @Test
    public void testValidListParams() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidListParams.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithValidListParams.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithValidListParams.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertEquals((long)1L, (long)model.getReferencedTypes().size());
        Assert.assertTrue((boolean)model.getReferencedTypes().contains(VertxGenClass1Info));
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)1L, (long)model.getMethods().size());
        String methodName = "methodWithListParams";
        MethodInfo method = (MethodInfo)model.getMethods().get(0);
        this.checkMethod(method, methodName, 7, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        List params = method.getParams();
        this.checkParam((ParamInfo)params.get(0), "listString", new TypeLiteral<List<String>>(){});
        this.checkParam((ParamInfo)params.get(1), "listLong", new TypeLiteral<List<Long>>(){});
        this.checkParam((ParamInfo)params.get(2), "listJsonObject", new TypeLiteral<List<JsonObject>>(){});
        this.checkParam((ParamInfo)params.get(3), "listJsonArray", new TypeLiteral<List<JsonArray>>(){});
        this.checkParam((ParamInfo)params.get(4), "listVertxGen", new TypeLiteral<List<VertxGenClass1>>(){});
        this.checkParam((ParamInfo)params.get(5), "listDataObject", new TypeLiteral<List<TestDataObject>>(){});
        this.checkParam((ParamInfo)params.get(6), "listEnum", new TypeLiteral<List<TestEnum>>(){});
    }

    @Test
    public void testValidSetParams() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidSetParams.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithValidSetParams.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithValidSetParams.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertEquals((long)1L, (long)model.getReferencedTypes().size());
        Assert.assertTrue((boolean)model.getReferencedTypes().contains(VertxGenClass1Info));
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)1L, (long)model.getMethods().size());
        String methodName = "methodWithSetParams";
        MethodInfo method = (MethodInfo)model.getMethods().get(0);
        this.checkMethod(method, methodName, 7, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        List params = method.getParams();
        this.checkParam((ParamInfo)params.get(0), "setString", new TypeLiteral<Set<String>>(){});
        this.checkParam((ParamInfo)params.get(1), "setLong", new TypeLiteral<Set<Long>>(){});
        this.checkParam((ParamInfo)params.get(2), "setJsonObject", new TypeLiteral<Set<JsonObject>>(){});
        this.checkParam((ParamInfo)params.get(3), "setJsonArray", new TypeLiteral<Set<JsonArray>>(){});
        this.checkParam((ParamInfo)params.get(4), "setVertxGen", new TypeLiteral<Set<VertxGenClass1>>(){});
        this.checkParam((ParamInfo)params.get(5), "setDataObject", new TypeLiteral<Set<TestDataObject>>(){});
        this.checkParam((ParamInfo)params.get(6), "setEnum", new TypeLiteral<Set<TestEnum>>(){});
    }

    @Test
    public void testValidMapParams() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidMapParams.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithValidMapParams.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithValidMapParams.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertEquals((long)1L, (long)model.getReferencedTypes().size());
        Assert.assertTrue((boolean)model.getReferencedTypes().contains(VertxGenClass1Info));
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)1L, (long)model.getMethods().size());
        String methodName = "methodWithMapParams";
        MethodInfo method = (MethodInfo)model.getMethods().get(0);
        this.checkMethod(method, methodName, 5, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        List params = method.getParams();
        this.checkParam((ParamInfo)params.get(0), "mapString", new TypeLiteral<Map<String, String>>(){});
        this.checkParam((ParamInfo)params.get(1), "mapLong", new TypeLiteral<Map<String, Long>>(){});
        this.checkParam((ParamInfo)params.get(2), "mapJsonObject", new TypeLiteral<Map<String, JsonObject>>(){});
        this.checkParam((ParamInfo)params.get(3), "mapJsonArray", new TypeLiteral<Map<String, JsonArray>>(){});
        this.checkParam((ParamInfo)params.get(4), "mapVertxGen", new TypeLiteral<Map<String, VertxGenClass1>>(){});
    }

    @Test
    public void testValidClassTypeParams() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidClassTypeParams.class, new Class[0]);
        List methods = model.getMethods();
        Assert.assertEquals((long)2L, (long)methods.size());
        MethodInfo methodParam = (MethodInfo)methods.get(0);
        this.checkMethod(methodParam, "methodParam", 2, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        ParamInfo resolved = methodParam.resolveClassTypeParam((TypeVariableInfo)methodParam.getParam(0).getType());
        Assert.assertSame((Object)resolved, (Object)methodParam.getParam(1));
        MethodInfo returnParam = (MethodInfo)methods.get(1);
        this.checkMethod(returnParam, "returnParam", 1, "T", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        resolved = methodParam.resolveClassTypeParam((TypeVariableInfo)returnParam.getReturnType());
        Assert.assertSame((Object)resolved, (Object)methodParam.getParam(1));
    }

    @Test
    public void testValidHandlerParams() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidHandlerParams.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithValidHandlerParams.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithValidHandlerParams.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertEquals((long)2L, (long)model.getReferencedTypes().size());
        Assert.assertTrue((boolean)model.getReferencedTypes().contains(VertxGenClass1Info));
        Assert.assertTrue((boolean)model.getReferencedTypes().contains(VertxGenClass2Info));
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)4L, (long)model.getMethods().size());
        MethodInfo method = (MethodInfo)model.getMethods().get(0);
        this.checkMethod(method, "methodWithHandlerParams", 15, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        List params = method.getParams();
        this.checkParam((ParamInfo)params.get(0), "byteHandler", new TypeLiteral<Handler<Byte>>(){});
        this.checkParam((ParamInfo)params.get(1), "shortHandler", new TypeLiteral<Handler<Short>>(){});
        this.checkParam((ParamInfo)params.get(2), "intHandler", new TypeLiteral<Handler<Integer>>(){});
        this.checkParam((ParamInfo)params.get(3), "longHandler", new TypeLiteral<Handler<Long>>(){});
        this.checkParam((ParamInfo)params.get(4), "floatHandler", new TypeLiteral<Handler<Float>>(){});
        this.checkParam((ParamInfo)params.get(5), "doubleHandler", new TypeLiteral<Handler<Double>>(){});
        this.checkParam((ParamInfo)params.get(6), "booleanHandler", new TypeLiteral<Handler<Boolean>>(){});
        this.checkParam((ParamInfo)params.get(7), "charHandler", new TypeLiteral<Handler<Character>>(){});
        this.checkParam((ParamInfo)params.get(8), "strHandler", new TypeLiteral<Handler<String>>(){});
        this.checkParam((ParamInfo)params.get(9), "gen1Handler", new TypeLiteral<Handler<VertxGenClass1>>(){});
        this.checkParam((ParamInfo)params.get(10), "gen2Handler", new TypeLiteral<Handler<VertxGenClass2>>(){});
        this.checkParam((ParamInfo)params.get(11), "voidHandler", new TypeLiteral<Handler<Void>>(){});
        this.checkParam((ParamInfo)params.get(12), "throwableHandler", new TypeLiteral<Handler<Throwable>>(){});
        this.checkParam((ParamInfo)params.get(13), "dataObjectHandler", new TypeLiteral<Handler<TestDataObject>>(){});
        this.checkParam((ParamInfo)params.get(14), "enumHandler", new TypeLiteral<Handler<TestEnum>>(){});
        method = (MethodInfo)model.getMethods().get(1);
        this.checkMethod(method, "methodWithListHandlerParams", 14, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        params = method.getParams();
        this.checkParam((ParamInfo)params.get(0), "listByteHandler", new TypeLiteral<Handler<List<Byte>>>(){});
        this.checkParam((ParamInfo)params.get(1), "listShortHandler", new TypeLiteral<Handler<List<Short>>>(){});
        this.checkParam((ParamInfo)params.get(2), "listIntHandler", new TypeLiteral<Handler<List<Integer>>>(){});
        this.checkParam((ParamInfo)params.get(3), "listLongHandler", new TypeLiteral<Handler<List<Long>>>(){});
        this.checkParam((ParamInfo)params.get(4), "listFloatHandler", new TypeLiteral<Handler<List<Float>>>(){});
        this.checkParam((ParamInfo)params.get(5), "listDoubleHandler", new TypeLiteral<Handler<List<Double>>>(){});
        this.checkParam((ParamInfo)params.get(6), "listBooleanHandler", new TypeLiteral<Handler<List<Boolean>>>(){});
        this.checkParam((ParamInfo)params.get(7), "listCharHandler", new TypeLiteral<Handler<List<Character>>>(){});
        this.checkParam((ParamInfo)params.get(8), "listStrHandler", new TypeLiteral<Handler<List<String>>>(){});
        this.checkParam((ParamInfo)params.get(9), "listVertxGenHandler", new TypeLiteral<Handler<List<VertxGenClass1>>>(){});
        this.checkParam((ParamInfo)params.get(10), "listJsonObjectHandler", new TypeLiteral<Handler<List<JsonObject>>>(){});
        this.checkParam((ParamInfo)params.get(11), "listJsonArrayHandler", new TypeLiteral<Handler<List<JsonArray>>>(){});
        this.checkParam((ParamInfo)params.get(12), "listDataObjectHandler", new TypeLiteral<Handler<List<TestDataObject>>>(){});
        this.checkParam((ParamInfo)params.get(13), "listEnumHandler", new TypeLiteral<Handler<List<TestEnum>>>(){});
        method = (MethodInfo)model.getMethods().get(2);
        this.checkMethod(method, "methodWithSetHandlerParams", 14, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        params = method.getParams();
        this.checkParam((ParamInfo)params.get(0), "setByteHandler", new TypeLiteral<Handler<Set<Byte>>>(){});
        this.checkParam((ParamInfo)params.get(1), "setShortHandler", new TypeLiteral<Handler<Set<Short>>>(){});
        this.checkParam((ParamInfo)params.get(2), "setIntHandler", new TypeLiteral<Handler<Set<Integer>>>(){});
        this.checkParam((ParamInfo)params.get(3), "setLongHandler", new TypeLiteral<Handler<Set<Long>>>(){});
        this.checkParam((ParamInfo)params.get(4), "setFloatHandler", new TypeLiteral<Handler<Set<Float>>>(){});
        this.checkParam((ParamInfo)params.get(5), "setDoubleHandler", new TypeLiteral<Handler<Set<Double>>>(){});
        this.checkParam((ParamInfo)params.get(6), "setBooleanHandler", new TypeLiteral<Handler<Set<Boolean>>>(){});
        this.checkParam((ParamInfo)params.get(7), "setCharHandler", new TypeLiteral<Handler<Set<Character>>>(){});
        this.checkParam((ParamInfo)params.get(8), "setStrHandler", new TypeLiteral<Handler<Set<String>>>(){});
        this.checkParam((ParamInfo)params.get(9), "setVertxGenHandler", new TypeLiteral<Handler<Set<VertxGenClass1>>>(){});
        this.checkParam((ParamInfo)params.get(10), "setJsonObjectHandler", new TypeLiteral<Handler<Set<JsonObject>>>(){});
        this.checkParam((ParamInfo)params.get(11), "setJsonArrayHandler", new TypeLiteral<Handler<Set<JsonArray>>>(){});
        this.checkParam((ParamInfo)params.get(12), "setDataObjectHandler", new TypeLiteral<Handler<Set<TestDataObject>>>(){});
        this.checkParam((ParamInfo)params.get(13), "setEnumHandler", new TypeLiteral<Handler<Set<TestEnum>>>(){});
        method = (MethodInfo)model.getMethods().get(3);
        this.checkMethod(method, "methodWithMapHandlerParams", 11, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        params = method.getParams();
        this.checkParam((ParamInfo)params.get(0), "mapByteHandler", new TypeLiteral<Handler<Map<String, Byte>>>(){});
        this.checkParam((ParamInfo)params.get(1), "mapShortHandler", new TypeLiteral<Handler<Map<String, Short>>>(){});
        this.checkParam((ParamInfo)params.get(2), "mapIntHandler", new TypeLiteral<Handler<Map<String, Integer>>>(){});
        this.checkParam((ParamInfo)params.get(3), "mapLongHandler", new TypeLiteral<Handler<Map<String, Long>>>(){});
        this.checkParam((ParamInfo)params.get(4), "mapFloatHandler", new TypeLiteral<Handler<Map<String, Float>>>(){});
        this.checkParam((ParamInfo)params.get(5), "mapDoubleHandler", new TypeLiteral<Handler<Map<String, Double>>>(){});
        this.checkParam((ParamInfo)params.get(6), "mapBooleanHandler", new TypeLiteral<Handler<Map<String, Boolean>>>(){});
        this.checkParam((ParamInfo)params.get(7), "mapCharHandler", new TypeLiteral<Handler<Map<String, Character>>>(){});
        this.checkParam((ParamInfo)params.get(8), "mapStrHandler", new TypeLiteral<Handler<Map<String, String>>>(){});
        this.checkParam((ParamInfo)params.get(9), "mapJsonObjectHandler", new TypeLiteral<Handler<Map<String, JsonObject>>>(){});
        this.checkParam((ParamInfo)params.get(10), "mapJsonArrayHandler", new TypeLiteral<Handler<Map<String, JsonArray>>>(){});
    }

    @Test
    public <T> void testValidFunctionParams() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidFunctionParams.class, new Class[0]);
        MethodInfo method = (MethodInfo)model.getMethods().get(0);
        this.checkMethod(method, "methodWithFunctionParams", 18, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        List params = method.getParams();
        this.checkParam((ParamInfo)params.get(0), "byteFunction", new TypeLiteral<Function<Byte, Byte>>(){});
        this.checkParam((ParamInfo)params.get(1), "shortFunction", new TypeLiteral<Function<Short, Short>>(){});
        this.checkParam((ParamInfo)params.get(2), "intFunction", new TypeLiteral<Function<Integer, Integer>>(){});
        this.checkParam((ParamInfo)params.get(3), "longFunction", new TypeLiteral<Function<Long, Long>>(){});
        this.checkParam((ParamInfo)params.get(4), "floatFunction", new TypeLiteral<Function<Float, Float>>(){});
        this.checkParam((ParamInfo)params.get(5), "doubleFunction", new TypeLiteral<Function<Double, Double>>(){});
        this.checkParam((ParamInfo)params.get(6), "booleanFunction", new TypeLiteral<Function<Boolean, Boolean>>(){});
        this.checkParam((ParamInfo)params.get(7), "charFunction", new TypeLiteral<Function<Character, Character>>(){});
        this.checkParam((ParamInfo)params.get(8), "strFunction", new TypeLiteral<Function<String, String>>(){});
        this.checkParam((ParamInfo)params.get(9), "gen1Function", new TypeLiteral<Function<VertxGenClass1, VertxGenClass1>>(){});
        this.checkParam((ParamInfo)params.get(10), "gen2Function", new TypeLiteral<Function<VertxGenClass2, VertxGenClass2>>(){});
        this.checkParam((ParamInfo)params.get(11), "voidFunction", new TypeLiteral<Function<Void, String>>(){});
        this.checkParam((ParamInfo)params.get(12), "throwableFunction", new TypeLiteral<Function<Throwable, Throwable>>(){});
        this.checkParam((ParamInfo)params.get(13), "dataObjectFunction", new TypeLiteral<Function<TestDataObject, TestDataObject>>(){});
        this.checkParam((ParamInfo)params.get(14), "enumFunction", new TypeLiteral<Function<TestEnum, TestEnum>>(){});
        this.checkParam((ParamInfo)params.get(15), "objectFunction", new TypeLiteral<Function<Object, Object>>(){});
        this.checkParam((ParamInfo)params.get(16), "genericFunction", new TypeLiteral<Function<T, T>>(){});
        this.checkParam((ParamInfo)params.get(17), "genericUserTypeFunction", new TypeLiteral<Function<GenericInterface<T>, GenericInterface<T>>>(){});
        method = (MethodInfo)model.getMethods().get(1);
        this.checkMethod(method, "methodWithListFunctionParams", 14, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        params = method.getParams();
        this.checkParam((ParamInfo)params.get(0), "listByteFunction", new TypeLiteral<Function<List<Byte>, List<Byte>>>(){});
        this.checkParam((ParamInfo)params.get(1), "listShortFunction", new TypeLiteral<Function<List<Short>, List<Short>>>(){});
        this.checkParam((ParamInfo)params.get(2), "listIntFunction", new TypeLiteral<Function<List<Integer>, List<Integer>>>(){});
        this.checkParam((ParamInfo)params.get(3), "listLongFunction", new TypeLiteral<Function<List<Long>, List<Long>>>(){});
        this.checkParam((ParamInfo)params.get(4), "listFloatFunction", new TypeLiteral<Function<List<Float>, List<Float>>>(){});
        this.checkParam((ParamInfo)params.get(5), "listDoubleFunction", new TypeLiteral<Function<List<Double>, List<Double>>>(){});
        this.checkParam((ParamInfo)params.get(6), "listBooleanFunction", new TypeLiteral<Function<List<Boolean>, List<Boolean>>>(){});
        this.checkParam((ParamInfo)params.get(7), "listCharFunction", new TypeLiteral<Function<List<Character>, List<Character>>>(){});
        this.checkParam((ParamInfo)params.get(8), "listStrFunction", new TypeLiteral<Function<List<String>, List<String>>>(){});
        this.checkParam((ParamInfo)params.get(9), "listVertxGenFunction", new TypeLiteral<Function<List<VertxGenClass1>, List<VertxGenClass1>>>(){});
        this.checkParam((ParamInfo)params.get(10), "listJsonObjectFunction", new TypeLiteral<Function<List<JsonObject>, List<JsonObject>>>(){});
        this.checkParam((ParamInfo)params.get(11), "listJsonArrayFunction", new TypeLiteral<Function<List<JsonArray>, List<JsonArray>>>(){});
        this.checkParam((ParamInfo)params.get(12), "listDataObjectFunction", new TypeLiteral<Function<List<TestDataObject>, List<TestDataObject>>>(){});
        this.checkParam((ParamInfo)params.get(13), "listEnumFunction", new TypeLiteral<Function<List<TestEnum>, List<TestEnum>>>(){});
        method = (MethodInfo)model.getMethods().get(2);
        this.checkMethod(method, "methodWithSetFunctionParams", 14, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        params = method.getParams();
        this.checkParam((ParamInfo)params.get(0), "setByteFunction", new TypeLiteral<Function<Set<Byte>, Set<Byte>>>(){});
        this.checkParam((ParamInfo)params.get(1), "setShortFunction", new TypeLiteral<Function<Set<Short>, Set<Short>>>(){});
        this.checkParam((ParamInfo)params.get(2), "setIntFunction", new TypeLiteral<Function<Set<Integer>, Set<Integer>>>(){});
        this.checkParam((ParamInfo)params.get(3), "setLongFunction", new TypeLiteral<Function<Set<Long>, Set<Long>>>(){});
        this.checkParam((ParamInfo)params.get(4), "setFloatFunction", new TypeLiteral<Function<Set<Float>, Set<Float>>>(){});
        this.checkParam((ParamInfo)params.get(5), "setDoubleFunction", new TypeLiteral<Function<Set<Double>, Set<Double>>>(){});
        this.checkParam((ParamInfo)params.get(6), "setBooleanFunction", new TypeLiteral<Function<Set<Boolean>, Set<Boolean>>>(){});
        this.checkParam((ParamInfo)params.get(7), "setCharFunction", new TypeLiteral<Function<Set<Character>, Set<Character>>>(){});
        this.checkParam((ParamInfo)params.get(8), "setStrFunction", new TypeLiteral<Function<Set<String>, Set<String>>>(){});
        this.checkParam((ParamInfo)params.get(9), "setVertxGenFunction", new TypeLiteral<Function<Set<VertxGenClass1>, Set<VertxGenClass1>>>(){});
        this.checkParam((ParamInfo)params.get(10), "setJsonObjectFunction", new TypeLiteral<Function<Set<JsonObject>, Set<JsonObject>>>(){});
        this.checkParam((ParamInfo)params.get(11), "setJsonArrayFunction", new TypeLiteral<Function<Set<JsonArray>, Set<JsonArray>>>(){});
        this.checkParam((ParamInfo)params.get(12), "setDataObjectFunction", new TypeLiteral<Function<Set<TestDataObject>, Set<TestDataObject>>>(){});
        this.checkParam((ParamInfo)params.get(13), "setEnumFunction", new TypeLiteral<Function<Set<TestEnum>, Set<TestEnum>>>(){});
        method = (MethodInfo)model.getMethods().get(3);
        this.checkMethod(method, "methodWithMapFunctionParams", 11, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        params = method.getParams();
        this.checkParam((ParamInfo)params.get(0), "mapByteFunction", new TypeLiteral<Function<Map<String, Byte>, Map<String, Byte>>>(){});
        this.checkParam((ParamInfo)params.get(1), "mapShortFunction", new TypeLiteral<Function<Map<String, Short>, Map<String, Short>>>(){});
        this.checkParam((ParamInfo)params.get(2), "mapIntFunction", new TypeLiteral<Function<Map<String, Integer>, Map<String, Integer>>>(){});
        this.checkParam((ParamInfo)params.get(3), "mapLongFunction", new TypeLiteral<Function<Map<String, Long>, Map<String, Long>>>(){});
        this.checkParam((ParamInfo)params.get(4), "mapFloatFunction", new TypeLiteral<Function<Map<String, Float>, Map<String, Float>>>(){});
        this.checkParam((ParamInfo)params.get(5), "mapDoubleFunction", new TypeLiteral<Function<Map<String, Double>, Map<String, Double>>>(){});
        this.checkParam((ParamInfo)params.get(6), "mapBooleanFunction", new TypeLiteral<Function<Map<String, Boolean>, Map<String, Boolean>>>(){});
        this.checkParam((ParamInfo)params.get(7), "mapCharFunction", new TypeLiteral<Function<Map<String, Character>, Map<String, Character>>>(){});
        this.checkParam((ParamInfo)params.get(8), "mapStrFunction", new TypeLiteral<Function<Map<String, String>, Map<String, String>>>(){});
        this.checkParam((ParamInfo)params.get(9), "mapJsonObjectFunction", new TypeLiteral<Function<Map<String, JsonObject>, Map<String, JsonObject>>>(){});
        this.checkParam((ParamInfo)params.get(10), "mapJsonArrayFunction", new TypeLiteral<Function<Map<String, JsonArray>, Map<String, JsonArray>>>(){});
    }

    @Test
    public void testMethodWithInvalidFunctionParams() throws Exception {
        this.assertGenInvalid(MethodWithInvalidFunctionParam1.class, new Class[0]);
        this.assertGenInvalid(MethodWithInvalidFunctionParam2.class, new Class[0]);
        this.assertGenInvalid(MethodWithInvalidFunctionParam3.class, new Class[0]);
        this.assertGenInvalid(MethodWithInvalidFunctionParam4.class, new Class[0]);
        this.assertGenInvalid(MethodWithInvalidFunctionParam5.class, new Class[0]);
        this.assertGenInvalid(MethodWithInvalidFunctionParam6.class, new Class[0]);
        this.assertGenInvalid(MethodWithInvalidFunctionParam7.class, new Class[0]);
        this.assertGenInvalid(MethodWithInvalidFunctionParam8.class, new Class[0]);
    }

    @Test
    public void testValidHandlerAsyncResultParams() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidHandlerAsyncResultParams.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithValidHandlerAsyncResultParams.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithValidHandlerAsyncResultParams.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertEquals((long)2L, (long)model.getReferencedTypes().size());
        Assert.assertTrue((boolean)model.getReferencedTypes().contains(VertxGenClass1Info));
        Assert.assertTrue((boolean)model.getReferencedTypes().contains(VertxGenClass2Info));
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)4L, (long)model.getMethods().size());
        MethodInfo method = (MethodInfo)model.getMethods().get(0);
        this.checkMethod(method, "methodWithHandlerParams", 16, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        List params = method.getParams();
        this.checkParam((ParamInfo)params.get(0), "byteHandler", new TypeLiteral<Handler<AsyncResult<Byte>>>(){});
        this.checkParam((ParamInfo)params.get(1), "shortHandler", new TypeLiteral<Handler<AsyncResult<Short>>>(){});
        this.checkParam((ParamInfo)params.get(2), "intHandler", new TypeLiteral<Handler<AsyncResult<Integer>>>(){});
        this.checkParam((ParamInfo)params.get(3), "longHandler", new TypeLiteral<Handler<AsyncResult<Long>>>(){});
        this.checkParam((ParamInfo)params.get(4), "floatHandler", new TypeLiteral<Handler<AsyncResult<Float>>>(){});
        this.checkParam((ParamInfo)params.get(5), "doubleHandler", new TypeLiteral<Handler<AsyncResult<Double>>>(){});
        this.checkParam((ParamInfo)params.get(6), "booleanHandler", new TypeLiteral<Handler<AsyncResult<Boolean>>>(){});
        this.checkParam((ParamInfo)params.get(7), "charHandler", new TypeLiteral<Handler<AsyncResult<Character>>>(){});
        this.checkParam((ParamInfo)params.get(8), "strHandler", new TypeLiteral<Handler<AsyncResult<String>>>(){});
        this.checkParam((ParamInfo)params.get(9), "gen1Handler", new TypeLiteral<Handler<AsyncResult<VertxGenClass1>>>(){});
        this.checkParam((ParamInfo)params.get(10), "gen2Handler", new TypeLiteral<Handler<AsyncResult<VertxGenClass2>>>(){});
        this.checkParam((ParamInfo)params.get(11), "jsonObjectHandler", new TypeLiteral<Handler<AsyncResult<JsonObject>>>(){});
        this.checkParam((ParamInfo)params.get(12), "jsonArrayHandler", new TypeLiteral<Handler<AsyncResult<JsonArray>>>(){});
        this.checkParam((ParamInfo)params.get(13), "voidHandler", new TypeLiteral<Handler<AsyncResult<Void>>>(){});
        this.checkParam((ParamInfo)params.get(14), "dataObjectHandler", new TypeLiteral<Handler<AsyncResult<TestDataObject>>>(){});
        this.checkParam((ParamInfo)params.get(15), "enumHandler", new TypeLiteral<Handler<AsyncResult<TestEnum>>>(){});
        method = (MethodInfo)model.getMethods().get(1);
        this.checkMethod(method, "methodWithListHandlerParams", 14, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        params = method.getParams();
        this.checkParam((ParamInfo)params.get(0), "listByteHandler", new TypeLiteral<Handler<AsyncResult<List<Byte>>>>(){});
        this.checkParam((ParamInfo)params.get(1), "listShortHandler", new TypeLiteral<Handler<AsyncResult<List<Short>>>>(){});
        this.checkParam((ParamInfo)params.get(2), "listIntHandler", new TypeLiteral<Handler<AsyncResult<List<Integer>>>>(){});
        this.checkParam((ParamInfo)params.get(3), "listLongHandler", new TypeLiteral<Handler<AsyncResult<List<Long>>>>(){});
        this.checkParam((ParamInfo)params.get(4), "listFloatHandler", new TypeLiteral<Handler<AsyncResult<List<Float>>>>(){});
        this.checkParam((ParamInfo)params.get(5), "listDoubleHandler", new TypeLiteral<Handler<AsyncResult<List<Double>>>>(){});
        this.checkParam((ParamInfo)params.get(6), "listBooleanHandler", new TypeLiteral<Handler<AsyncResult<List<Boolean>>>>(){});
        this.checkParam((ParamInfo)params.get(7), "listCharHandler", new TypeLiteral<Handler<AsyncResult<List<Character>>>>(){});
        this.checkParam((ParamInfo)params.get(8), "listStrHandler", new TypeLiteral<Handler<AsyncResult<List<String>>>>(){});
        this.checkParam((ParamInfo)params.get(9), "listVertxGenHandler", new TypeLiteral<Handler<AsyncResult<List<VertxGenClass1>>>>(){});
        this.checkParam((ParamInfo)params.get(10), "listJsonObjectHandler", new TypeLiteral<Handler<AsyncResult<List<JsonObject>>>>(){});
        this.checkParam((ParamInfo)params.get(11), "listJsonArrayHandler", new TypeLiteral<Handler<AsyncResult<List<JsonArray>>>>(){});
        this.checkParam((ParamInfo)params.get(12), "listDataObjectHandler", new TypeLiteral<Handler<AsyncResult<List<TestDataObject>>>>(){});
        this.checkParam((ParamInfo)params.get(13), "listEnumHandler", new TypeLiteral<Handler<AsyncResult<List<TestEnum>>>>(){});
        method = (MethodInfo)model.getMethods().get(2);
        this.checkMethod(method, "methodWithSetHandlerParams", 14, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        params = method.getParams();
        this.checkParam((ParamInfo)params.get(0), "setByteHandler", new TypeLiteral<Handler<AsyncResult<Set<Byte>>>>(){});
        this.checkParam((ParamInfo)params.get(1), "setShortHandler", new TypeLiteral<Handler<AsyncResult<Set<Short>>>>(){});
        this.checkParam((ParamInfo)params.get(2), "setIntHandler", new TypeLiteral<Handler<AsyncResult<Set<Integer>>>>(){});
        this.checkParam((ParamInfo)params.get(3), "setLongHandler", new TypeLiteral<Handler<AsyncResult<Set<Long>>>>(){});
        this.checkParam((ParamInfo)params.get(4), "setFloatHandler", new TypeLiteral<Handler<AsyncResult<Set<Float>>>>(){});
        this.checkParam((ParamInfo)params.get(5), "setDoubleHandler", new TypeLiteral<Handler<AsyncResult<Set<Double>>>>(){});
        this.checkParam((ParamInfo)params.get(6), "setBooleanHandler", new TypeLiteral<Handler<AsyncResult<Set<Boolean>>>>(){});
        this.checkParam((ParamInfo)params.get(7), "setCharHandler", new TypeLiteral<Handler<AsyncResult<Set<Character>>>>(){});
        this.checkParam((ParamInfo)params.get(8), "setStrHandler", new TypeLiteral<Handler<AsyncResult<Set<String>>>>(){});
        this.checkParam((ParamInfo)params.get(9), "setVertxGenHandler", new TypeLiteral<Handler<AsyncResult<Set<VertxGenClass1>>>>(){});
        this.checkParam((ParamInfo)params.get(10), "setJsonObjectHandler", new TypeLiteral<Handler<AsyncResult<Set<JsonObject>>>>(){});
        this.checkParam((ParamInfo)params.get(11), "setJsonArrayHandler", new TypeLiteral<Handler<AsyncResult<Set<JsonArray>>>>(){});
        this.checkParam((ParamInfo)params.get(12), "setDataObjectHandler", new TypeLiteral<Handler<AsyncResult<Set<TestDataObject>>>>(){});
        this.checkParam((ParamInfo)params.get(13), "setEnumHandler", new TypeLiteral<Handler<AsyncResult<Set<TestEnum>>>>(){});
        method = (MethodInfo)model.getMethods().get(3);
        this.checkMethod(method, "methodWithMapHandlerParams", 11, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        params = method.getParams();
        this.checkParam((ParamInfo)params.get(0), "mapByteHandler", new TypeLiteral<Handler<AsyncResult<Map<String, Byte>>>>(){});
        this.checkParam((ParamInfo)params.get(1), "mapShortHandler", new TypeLiteral<Handler<AsyncResult<Map<String, Short>>>>(){});
        this.checkParam((ParamInfo)params.get(2), "mapIntHandler", new TypeLiteral<Handler<AsyncResult<Map<String, Integer>>>>(){});
        this.checkParam((ParamInfo)params.get(3), "mapLongHandler", new TypeLiteral<Handler<AsyncResult<Map<String, Long>>>>(){});
        this.checkParam((ParamInfo)params.get(4), "mapFloatHandler", new TypeLiteral<Handler<AsyncResult<Map<String, Float>>>>(){});
        this.checkParam((ParamInfo)params.get(5), "mapDoubleHandler", new TypeLiteral<Handler<AsyncResult<Map<String, Double>>>>(){});
        this.checkParam((ParamInfo)params.get(6), "mapBooleanHandler", new TypeLiteral<Handler<AsyncResult<Map<String, Boolean>>>>(){});
        this.checkParam((ParamInfo)params.get(7), "mapCharHandler", new TypeLiteral<Handler<AsyncResult<Map<String, Character>>>>(){});
        this.checkParam((ParamInfo)params.get(8), "mapStrHandler", new TypeLiteral<Handler<AsyncResult<Map<String, String>>>>(){});
        this.checkParam((ParamInfo)params.get(9), "mapJsonObjectHandler", new TypeLiteral<Handler<AsyncResult<Map<String, JsonObject>>>>(){});
        this.checkParam((ParamInfo)params.get(10), "mapJsonArrayHandler", new TypeLiteral<Handler<AsyncResult<Map<String, JsonArray>>>>(){});
    }

    @Test
    public void testValidVertxGenParams() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidVertxGenParams.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithValidVertxGenParams.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithValidVertxGenParams.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertEquals((long)2L, (long)model.getReferencedTypes().size());
        Assert.assertTrue((boolean)model.getReferencedTypes().contains(VertxGenClass1Info));
        Assert.assertTrue((boolean)model.getReferencedTypes().contains(VertxGenClass2Info));
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)1L, (long)model.getMethods().size());
        String methodName = "methodWithVertxGenParams";
        MethodInfo method = (MethodInfo)model.getMethods().get(0);
        this.checkMethod(method, methodName, 3, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        List params = method.getParams();
        this.checkParam((ParamInfo)params.get(0), "str", (Type)((Object)String.class));
        this.checkParam((ParamInfo)params.get(1), "myParam1", (Type)((Object)VertxGenClass1.class));
        this.checkParam((ParamInfo)params.get(2), "myParam2", (Type)((Object)VertxGenClass2.class));
    }

    @Test
    public void testValidExceptionParam() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidThrowableParam.class, new Class[0]);
        Assert.assertEquals((long)0L, (long)model.getReferencedTypes().size());
        Assert.assertEquals((long)1L, (long)model.getImportedTypes().size());
        Assert.assertEquals((Object)ClassKind.THROWABLE, (Object)((ClassTypeInfo)model.getImportedTypes().iterator().next()).getKind());
        Assert.assertEquals((long)1L, (long)model.getMethods().size());
        String methodName = "methodWithThrowableParam";
        MethodInfo method = (MethodInfo)model.getMethods().get(0);
        this.checkMethod(method, methodName, 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        List params = method.getParams();
        this.checkParam((ParamInfo)params.get(0), "t", (Type)((Object)Throwable.class));
    }

    @Test
    public void testValidObjectParam() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithObjectParam.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithObjectParam.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithObjectParam.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertTrue((boolean)model.getReferencedTypes().isEmpty());
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)1L, (long)model.getMethods().size());
        String methodName = "methodWithObjectParam";
        MethodInfo method = (MethodInfo)model.getMethods().get(0);
        this.checkMethod(method, methodName, 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        List params = method.getParams();
        this.checkParam((ParamInfo)params.get(0), "obj", (Type)((Object)Object.class));
    }

    @Test
    public void testValidEnumParam() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithEnumParam.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithEnumParam.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithEnumParam.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertTrue((boolean)model.getImportedTypes().contains(TypeReflectionFactory.create(TestEnum.class)));
        Assert.assertTrue((boolean)model.getReferencedTypes().isEmpty());
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)2L, (long)model.getMethods().size());
        MethodInfo method = (MethodInfo)model.getMethods().get(0);
        this.checkMethod(method, "methodWithEnumParam", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        List params = method.getParams();
        this.checkParam((ParamInfo)params.get(0), "weirdo", (Type)((Object)TestEnum.class));
        EnumTypeInfo enumType = (EnumTypeInfo)((ParamInfo)params.get(0)).getType();
        Assert.assertFalse((boolean)enumType.isGen());
        Assert.assertEquals(Arrays.asList("TIM", "JULIEN", "NICK", "WESTON"), (Object)enumType.getValues());
        method = (MethodInfo)model.getMethods().get(1);
        this.checkMethod(method, "methodWithGenEnumParam", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        params = method.getParams();
        this.checkParam((ParamInfo)params.get(0), "weirdo", (Type)((Object)TestGenEnum.class));
        enumType = (EnumTypeInfo)((ParamInfo)params.get(0)).getType();
        Assert.assertTrue((boolean)enumType.isGen());
        Assert.assertEquals(Arrays.asList("LAURA", "BOB", "MIKE", "LELAND"), (Object)enumType.getValues());
    }

    @Test
    public void testValidHandlerReturn() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithHandlerReturn.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithHandlerReturn.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithHandlerReturn.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertTrue((boolean)model.getReferencedTypes().isEmpty());
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)1L, (long)model.getMethods().size());
        this.checkMethod((MethodInfo)model.getMethods().get(0), "methodWithHandlerStringReturn", 0, new TypeLiteral<Handler<String>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        TypeInfo returnType = ((MethodInfo)model.getMethods().get(0)).getReturnType();
        Assert.assertEquals((Object)ClassKind.HANDLER, (Object)returnType.getKind());
        Assert.assertEquals((Object)ClassKind.STRING, (Object)((ParameterizedTypeInfo)returnType).getArg(0).getKind());
    }

    @Test
    public void testValidHandlerAsyncResultReturn() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithHandlerAsyncResultReturn.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithHandlerAsyncResultReturn.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithHandlerAsyncResultReturn.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertTrue((boolean)model.getReferencedTypes().isEmpty());
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)1L, (long)model.getMethods().size());
        this.checkMethod((MethodInfo)model.getMethods().get(0), "methodWithHandlerAsyncResultStringReturn", 0, new TypeLiteral<Handler<AsyncResult<String>>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        TypeInfo returnType = ((MethodInfo)model.getMethods().get(0)).getReturnType();
        Assert.assertEquals((Object)ClassKind.HANDLER, (Object)returnType.getKind());
        Assert.assertEquals((Object)ClassKind.ASYNC_RESULT, (Object)((ParameterizedTypeInfo)returnType).getArg(0).getKind());
        Assert.assertEquals((Object)ClassKind.STRING, (Object)((ParameterizedTypeInfo)((ParameterizedTypeInfo)returnType).getArg(0)).getArg(0).getKind());
    }

    @Test
    public void testValidEnumReturn() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithEnumReturn.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithEnumReturn.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithEnumReturn.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertTrue((boolean)model.getImportedTypes().contains(TypeReflectionFactory.create(TestEnum.class)));
        Assert.assertTrue((boolean)model.getReferencedTypes().isEmpty());
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)2L, (long)model.getMethods().size());
        this.checkMethod((MethodInfo)model.getMethods().get(0), "methodWithEnumReturn", 0, (Type)((Object)TestEnum.class), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(1), "methodWithGenEnumReturn", 0, (Type)((Object)TestGenEnum.class), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
    }

    @Test
    public void testValidThrowableReturn() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithThrowableReturn.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithThrowableReturn.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithThrowableReturn.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertTrue((boolean)model.getReferencedTypes().isEmpty());
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)1L, (long)model.getMethods().size());
        String methodName = "methodWithThrowableReturn";
        MethodInfo method = (MethodInfo)model.getMethods().get(0);
        this.checkMethod(method, methodName, 0, (Type)((Object)Throwable.class), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
    }

    @Test
    public void testValidDataObjectsParam() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithDataObjectParam.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithDataObjectParam.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithDataObjectParam.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertTrue((boolean)model.getReferencedTypes().isEmpty());
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)1L, (long)model.getMethods().size());
        String methodName = "methodWithDataObjectParam";
        MethodInfo method = (MethodInfo)model.getMethods().get(0);
        this.checkMethod(method, methodName, 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        List params = method.getParams();
        this.checkParam((ParamInfo)params.get(0), "dataObject", (Type)((Object)PlainDataObject.class));
    }

    @Test
    public void testInvalidDataObjectsParam() throws Exception {
        this.assertGenInvalid(MethodWithInvalidAbstractDataObjectParam.class, new Class[0]);
        this.assertGenInvalid(MethodWithInvalidInterfaceDataObjectParam.class, new Class[0]);
    }

    @Test
    public void testFoo() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithTypeVarParamByGenericType.class, new Class[0]);
    }

    @Test
    public <T, R> void testGenericInterface() throws Exception {
        ClassModel model = new Generator().generateClass(GenericInterface.class, new Class[0]);
        Assert.assertEquals((Object)(GenericInterface.class.getName() + "<T>"), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)GenericInterface.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertEquals(Collections.emptySet(), (Object)model.getReferencedTypes());
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        List methods = model.getMethods();
        Assert.assertEquals((long)2L, (long)methods.size());
        TypeParamInfo t = (TypeParamInfo)model.getType().getParams().get(0);
        this.checkMethod((MethodInfo)methods.get(0), "methodWithClassTypeParam", 3, "T", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        List params1 = ((MethodInfo)methods.get(0)).getParams();
        this.checkParam((ParamInfo)params1.get(0), "t", new TypeLiteral<T>(){});
        Assert.assertTrue((boolean)(((ParamInfo)params1.get(0)).getType() instanceof TypeVariableInfo));
        Assert.assertEquals((Object)t, (Object)((TypeVariableInfo)((ParamInfo)params1.get(0)).getType()).getParam());
        Assert.assertTrue((boolean)((TypeVariableInfo)((ParamInfo)params1.get(0)).getType()).isClassParam());
        Assert.assertFalse((boolean)((TypeVariableInfo)((ParamInfo)params1.get(0)).getType()).isMethodParam());
        Assert.assertNull((Object)((MethodInfo)methods.get(0)).resolveClassTypeParam((TypeVariableInfo)((ParamInfo)params1.get(0)).getType()));
        this.checkParam((ParamInfo)params1.get(1), "handler", new TypeLiteral<Handler<T>>(){});
        this.checkParam((ParamInfo)params1.get(2), "asyncResultHandler", new TypeLiteral<Handler<AsyncResult<T>>>(){});
        this.checkMethod((MethodInfo)methods.get(1), "someGenericMethod", 3, new TypeLiteral<GenericInterface<R>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        List params2 = ((MethodInfo)methods.get(1)).getParams();
        this.checkParam((ParamInfo)params2.get(0), "r", new TypeLiteral<R>(){});
        Assert.assertTrue((boolean)(((ParamInfo)params2.get(0)).getType() instanceof TypeVariableInfo));
        Assert.assertEquals(((MethodInfo)methods.get(1)).getTypeParams().get(0), (Object)((TypeVariableInfo)((ParamInfo)params2.get(0)).getType()).getParam());
        Assert.assertFalse((boolean)((TypeVariableInfo)((ParamInfo)params2.get(0)).getType()).isClassParam());
        Assert.assertTrue((boolean)((TypeVariableInfo)((ParamInfo)params2.get(0)).getType()).isMethodParam());
        Assert.assertNull((Object)((MethodInfo)methods.get(1)).resolveClassTypeParam((TypeVariableInfo)((ParamInfo)params2.get(0)).getType()));
        this.checkParam((ParamInfo)params2.get(1), "handler", new TypeLiteral<Handler<R>>(){});
        this.checkParam((ParamInfo)params2.get(2), "asyncResultHandler", new TypeLiteral<Handler<AsyncResult<R>>>(){});
    }

    @Test
    public void testGenericInterfaceWithUpperBound() throws Exception {
        try {
            new Generator().generateClass(GenericInterfaceWithUpperBound.class, new Class[0]);
            Assert.fail();
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testValidBasicReturn() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidBasicReturn.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithValidBasicReturn.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithValidBasicReturn.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertTrue((boolean)model.getReferencedTypes().isEmpty());
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        List methods = model.getMethods();
        Assert.assertEquals((long)17L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "methodWithByteReturn", 0, "byte", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(1), "methodWithShortReturn", 0, "short", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(2), "methodWithIntReturn", 0, "int", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(3), "methodWithLongReturn", 0, "long", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(4), "methodWithFloatReturn", 0, "float", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(5), "methodWithDoubleReturn", 0, "double", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(6), "methodWithBooleanReturn", 0, "boolean", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(7), "methodWithCharReturn", 0, "char", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(8), "methodWithStringReturn", 0, (Type)((Object)String.class), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(9), "methodWithByteObjectReturn", 0, (Type)((Object)Byte.class), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(10), "methodWithShortObjectReturn", 0, (Type)((Object)Short.class), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(11), "methodWithIntObjectReturn", 0, (Type)((Object)Integer.class), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(12), "methodWithLongObjectReturn", 0, (Type)((Object)Long.class), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(13), "methodWithFloatObjectReturn", 0, (Type)((Object)Float.class), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(14), "methodWithDoubleObjectReturn", 0, (Type)((Object)Double.class), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(15), "methodWithBooleanObjectReturn", 0, (Type)((Object)Boolean.class), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(16), "methodWithCharObjectReturn", 0, (Type)((Object)Character.class), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
    }

    @Test
    public void testValidVoidReturn() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidVoidReturn.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithValidVoidReturn.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithValidVoidReturn.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertTrue((boolean)model.getReferencedTypes().isEmpty());
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)1L, (long)model.getMethods().size());
        String methodName = "methodWithVoidReturn";
        this.checkMethod((MethodInfo)model.getMethods().get(0), methodName, 0, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
    }

    @Test
    public void testValidDataObjectReturn() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidDataObjectReturn.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithValidDataObjectReturn.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithValidDataObjectReturn.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertTrue((boolean)model.getReferencedTypes().isEmpty());
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)3L, (long)model.getMethods().size());
        this.checkMethod((MethodInfo)model.getMethods().get(0), "methodWithDataObjectReturn", 0, PlainDataObjectWithToJson.class.getName(), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(1), "methodWithAbstractDataObjectReturn", 0, AbstractDataObjectWithToJson.class.getName(), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(2), "methodWithInterfaceDataObjectReturn", 0, InterfaceDataObjectWithToJson.class.getName(), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
    }

    @Test
    public void testValidObjectReturn() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithObjectReturn.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithObjectReturn.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithObjectReturn.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertTrue((boolean)model.getReferencedTypes().isEmpty());
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)1L, (long)model.getMethods().size());
        this.checkMethod((MethodInfo)model.getMethods().get(0), "foo", 0, "java.lang.Object", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
    }

    @Test
    public void testValidListReturn() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidListReturn.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithValidListReturn.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithValidListReturn.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertEquals((long)2L, (long)model.getReferencedTypes().size());
        Assert.assertTrue((boolean)model.getReferencedTypes().contains(VertxGenClass1Info));
        Assert.assertTrue((boolean)model.getReferencedTypes().contains(VertxGenClass2Info));
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        List methods = model.getMethods();
        Assert.assertEquals((long)15L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "byteList", 0, new TypeLiteral<List<Byte>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(1), "shortList", 0, new TypeLiteral<List<Short>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(2), "intList", 0, new TypeLiteral<List<Integer>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(3), "longList", 0, new TypeLiteral<List<Long>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(4), "floatList", 0, new TypeLiteral<List<Float>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(5), "doubleList", 0, new TypeLiteral<List<Double>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(6), "booleanList", 0, new TypeLiteral<List<Boolean>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(7), "charList", 0, new TypeLiteral<List<Character>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(8), "stringList", 0, new TypeLiteral<List<String>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(9), "vertxGen1List", 0, new TypeLiteral<List<VertxGenClass1>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(10), "vertxGen2List", 0, new TypeLiteral<List<VertxGenClass2>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(11), "jsonArrayList", 0, new TypeLiteral<List<JsonArray>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(12), "jsonObjectList", 0, new TypeLiteral<List<JsonObject>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(13), "dataObjectList", 0, new TypeLiteral<List<TestDataObject>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(14), "enumList", 0, new TypeLiteral<List<TestEnum>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
    }

    @Test
    public void testValidSetReturn() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidSetReturn.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithValidSetReturn.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithValidSetReturn.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertEquals((long)2L, (long)model.getReferencedTypes().size());
        Assert.assertTrue((boolean)model.getReferencedTypes().contains(VertxGenClass1Info));
        Assert.assertTrue((boolean)model.getReferencedTypes().contains(VertxGenClass2Info));
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        List methods = model.getMethods();
        Assert.assertEquals((long)15L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "byteSet", 0, new TypeLiteral<Set<Byte>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(1), "shortSet", 0, new TypeLiteral<Set<Short>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(2), "intSet", 0, new TypeLiteral<Set<Integer>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(3), "longSet", 0, new TypeLiteral<Set<Long>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(4), "floatSet", 0, new TypeLiteral<Set<Float>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(5), "doubleSet", 0, new TypeLiteral<Set<Double>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(6), "booleanSet", 0, new TypeLiteral<Set<Boolean>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(7), "charSet", 0, new TypeLiteral<Set<Character>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(8), "stringSet", 0, new TypeLiteral<Set<String>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(9), "vertxGen1Set", 0, new TypeLiteral<Set<VertxGenClass1>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(10), "vertxGen2Set", 0, new TypeLiteral<Set<VertxGenClass2>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(11), "jsonArraySet", 0, new TypeLiteral<Set<JsonArray>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(12), "jsonObjectSet", 0, new TypeLiteral<Set<JsonObject>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(13), "dataObjectSet", 0, new TypeLiteral<Set<TestDataObject>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(14), "enumSet", 0, new TypeLiteral<Set<TestEnum>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
    }

    @Test
    public void testValidMapReturn() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidMapReturn.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithValidMapReturn.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithValidMapReturn.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertEquals((long)0L, (long)model.getReferencedTypes().size());
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        List methods = model.getMethods();
        Assert.assertEquals((long)11L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "byteMap", 0, new TypeLiteral<Map<String, Byte>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(1), "shortMap", 0, new TypeLiteral<Map<String, Short>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(2), "intMap", 0, new TypeLiteral<Map<String, Integer>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(3), "longMap", 0, new TypeLiteral<Map<String, Long>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(4), "floatMap", 0, new TypeLiteral<Map<String, Float>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(5), "doubleMap", 0, new TypeLiteral<Map<String, Double>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(6), "booleanMap", 0, new TypeLiteral<Map<String, Boolean>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(7), "charMap", 0, new TypeLiteral<Map<String, Character>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(8), "stringMap", 0, new TypeLiteral<Map<String, String>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(9), "jsonArrayMap", 0, new TypeLiteral<Map<String, JsonArray>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(10), "jsonObjectMap", 0, new TypeLiteral<Map<String, JsonObject>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
    }

    @Test
    public void testValidVertxGenReturn() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidVertxGenReturn.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithValidVertxGenReturn.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithValidVertxGenReturn.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertEquals((long)2L, (long)model.getReferencedTypes().size());
        Assert.assertTrue((boolean)model.getReferencedTypes().contains(VertxGenClass1Info));
        Assert.assertTrue((boolean)model.getReferencedTypes().contains(VertxGenClass2Info));
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        List methods = model.getMethods();
        Assert.assertEquals((long)2L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "methodWithVertxGen1Return", 0, (Type)((Object)VertxGenClass1.class), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(1), "methodWithVertxGen2Return", 0, (Type)((Object)VertxGenClass2.class), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
    }

    @Test
    public void testIgnore() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceWithIgnoredElements.class, new Class[0]);
        Assert.assertEquals((Object)InterfaceWithIgnoredElements.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)InterfaceWithIgnoredElements.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertTrue((boolean)model.getReferencedTypes().isEmpty());
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        List methods = model.getMethods();
        Assert.assertEquals((long)2L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "foo", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(1), "bar", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
    }

    @Test
    public void testFluentMethodOverrideFromConcrete() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceWithFluentMethodOverrideFromConcrete.class, new Class[0]);
        Assert.assertEquals((Object)InterfaceWithFluentMethodOverrideFromConcrete.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)InterfaceWithFluentMethodOverrideFromConcrete.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertEquals(Collections.singleton((ClassTypeInfo)TypeReflectionFactory.create(ConcreteInterfaceWithFluentMethods.class)), (Object)model.getReferencedTypes());
        Assert.assertEquals(Collections.singletonList(TypeReflectionFactory.create(ConcreteInterfaceWithFluentMethods.class)), (Object)model.getSuperTypes());
        List methods = model.getMethods();
        Assert.assertEquals((long)2L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "foo", 1, (Type)((Object)InterfaceWithFluentMethodOverrideFromConcrete.class), MethodKind.OTHER, ClassTestBase.MethodCheck.FLUENT);
        this.checkMethod((MethodInfo)methods.get(1), "bar", 1, (Type)((Object)InterfaceWithFluentMethodOverrideFromConcrete.class), MethodKind.OTHER, ClassTestBase.MethodCheck.FLUENT);
    }

    @Test
    public void testFluentMethodOverrideFromAbstract() throws Exception {
        Generator gen = new Generator();
        ClassModel model = gen.generateClass(InterfaceWithFluentMethodOverrideFromAbstract.class, new Class[0]);
        Assert.assertEquals((Object)InterfaceWithFluentMethodOverrideFromAbstract.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)InterfaceWithFluentMethodOverrideFromAbstract.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertEquals(Collections.singleton((ClassTypeInfo)TypeReflectionFactory.create(AbstractInterfaceWithFluentMethods.class)), (Object)model.getReferencedTypes());
        Assert.assertEquals(Collections.singletonList(TypeReflectionFactory.create(AbstractInterfaceWithFluentMethods.class)), (Object)model.getSuperTypes());
        List methods = model.getMethods();
        Assert.assertEquals((long)2L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "foo", 1, (Type)((Object)InterfaceWithFluentMethodOverrideFromAbstract.class), MethodKind.OTHER, ClassTestBase.MethodCheck.FLUENT);
        this.checkMethod((MethodInfo)methods.get(1), "bar", 1, (Type)((Object)InterfaceWithFluentMethodOverrideFromAbstract.class), MethodKind.OTHER, ClassTestBase.MethodCheck.FLUENT);
    }

    @Test
    public void testFluentMethods() throws Exception {
        ClassModel model = new Generator().generateClass(ConcreteInterfaceWithFluentMethods.class, new Class[0]);
        Assert.assertEquals((Object)ConcreteInterfaceWithFluentMethods.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)ConcreteInterfaceWithFluentMethods.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertTrue((boolean)model.getReferencedTypes().isEmpty());
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        List methods = model.getMethods();
        Assert.assertEquals((long)2L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "foo", 1, (Type)((Object)ConcreteInterfaceWithFluentMethods.class), MethodKind.OTHER, ClassTestBase.MethodCheck.FLUENT);
        this.checkMethod((MethodInfo)methods.get(1), "bar", 1, (Type)((Object)ConcreteInterfaceWithFluentMethods.class), MethodKind.OTHER, ClassTestBase.MethodCheck.FLUENT);
    }

    @Test
    public void testCacheReturnMethods() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceWithCacheReturnMethods.class, new Class[0]);
        Assert.assertEquals((Object)InterfaceWithCacheReturnMethods.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)InterfaceWithCacheReturnMethods.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertEquals((long)1L, (long)model.getReferencedTypes().size());
        Assert.assertTrue((boolean)model.getReferencedTypes().contains(VertxGenClass1Info));
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        List methods = model.getMethods();
        Assert.assertEquals((long)2L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "foo", 1, (Type)((Object)String.class), MethodKind.OTHER, ClassTestBase.MethodCheck.CACHE_RETURN);
        this.checkMethod((MethodInfo)methods.get(1), "bar", 1, (Type)((Object)VertxGenClass1.class), MethodKind.OTHER, ClassTestBase.MethodCheck.CACHE_RETURN);
    }

    @Test
    public void testSupertypes() throws Exception {
        ClassModel gen = new Generator().generateClass(InterfaceWithSupertypes.class, new Class[]{VertxGenClass1.class, VertxGenInterface.class});
        Assert.assertEquals((Object)InterfaceWithSupertypes.class.getName(), (Object)gen.getIfaceFQCN());
        Assert.assertEquals((Object)InterfaceWithSupertypes.class.getSimpleName(), (Object)gen.getIfaceSimpleName());
        Assert.assertEquals((long)2L, (long)gen.getReferencedTypes().size());
        Assert.assertTrue((boolean)gen.getReferencedTypes().contains(VertxGenClass1Info));
        Assert.assertTrue((boolean)gen.getReferencedTypes().contains(VertxGenInterfaceInfo));
        Assert.assertEquals((long)2L, (long)gen.getSuperTypes().size());
        Assert.assertTrue((boolean)gen.getSuperTypes().contains(VertxGenClass1Info));
        Assert.assertTrue((boolean)gen.getSuperTypes().contains(VertxGenInterfaceInfo));
        Assert.assertEquals((Object)VertxGenClass1Info, (Object)gen.getConcreteSuperType());
        Assert.assertEquals((long)1L, (long)gen.getAbstractSuperTypes().size());
        Assert.assertTrue((boolean)gen.getAbstractSuperTypes().contains(VertxGenInterfaceInfo));
        List methods = gen.getMethods();
        Assert.assertEquals((long)2L, (long)methods.size());
        Collections.sort(methods);
        this.checkMethod((MethodInfo)methods.get(0), "bar", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(1), "quux", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
    }

    @Test
    public <T> void testParameterizedClassSuperType() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceWithParameterizedDeclaredSupertype.class, new Class[]{GenericInterface.class});
        Assert.assertEquals((Object)InterfaceWithParameterizedDeclaredSupertype.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)InterfaceWithParameterizedDeclaredSupertype.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertEquals((long)1L, (long)model.getReferencedTypes().size());
        Assert.assertTrue((boolean)model.getReferencedTypes().contains(GenericInterfaceInfo));
        Assert.assertEquals((long)1L, (long)model.getSuperTypes().size());
        Assert.assertTrue((boolean)model.getSuperTypes().contains(TypeReflectionFactory.create((Type)InterfaceWithParameterizedDeclaredSupertype.class.getGenericInterfaces()[0])));
        List methods = model.getMethods();
        Assert.assertEquals((long)1L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "methodWithClassTypeParam", 3, "java.lang.String", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkParam(((MethodInfo)methods.get(0)).getParam(0), "t", new TypeLiteral<String>(){}, new TypeLiteral<T>(){});
        this.checkParam(((MethodInfo)methods.get(0)).getParam(1), "handler", new TypeLiteral<Handler<String>>(){}, new TypeLiteral<Handler<T>>(){});
        this.checkParam(((MethodInfo)methods.get(0)).getParam(2), "asyncResultHandler", new TypeLiteral<Handler<AsyncResult<String>>>(){}, new TypeLiteral<Handler<AsyncResult<T>>>(){});
    }

    @Test
    public void testParameterizedVariableSuperType() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceWithParameterizedVariableSupertype.class, new Class[0]);
        Assert.assertEquals((Object)(InterfaceWithParameterizedVariableSupertype.class.getName() + "<T>"), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)InterfaceWithParameterizedVariableSupertype.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertEquals((long)1L, (long)model.getReferencedTypes().size());
        Assert.assertTrue((boolean)model.getReferencedTypes().contains(GenericInterfaceInfo));
        Assert.assertEquals((long)1L, (long)model.getSuperTypes().size());
        Assert.assertTrue((boolean)model.getSuperTypes().contains(TypeReflectionFactory.create((Type)InterfaceWithParameterizedVariableSupertype.class.getGenericInterfaces()[0])));
        List superTypeArgs = model.getSuperTypeArguments();
        Assert.assertEquals((long)1L, (long)superTypeArgs.size());
        TypeVariableInfo superTypeArg = (TypeVariableInfo)superTypeArgs.get(0);
        Assert.assertEquals((Object)"T", (Object)superTypeArg.getName());
        Assert.assertTrue((boolean)superTypeArg.isClassParam());
    }

    @Test
    public void testNonGenSuperType() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceWithNonGenSuperType.class, new Class[0]);
        Assert.assertEquals((Object)InterfaceWithNonGenSuperType.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)InterfaceWithNonGenSuperType.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertEquals((long)0L, (long)model.getReferencedTypes().size());
        Assert.assertEquals((long)0L, (long)model.getSuperTypes().size());
        List methods = model.getMethods();
        Assert.assertEquals((long)1L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "foo", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
    }

    @Test
    public void testMethodWithTypeVarParamByGenericType() throws Exception {
        Runnable test = () -> {
            try {
                ClassModel model = new Generator().generateClass(MethodWithTypeVarParamByGenericType.class, new Class[0]);
                MethodInfo meth = (MethodInfo)model.getMethods().get(0);
                ParamInfo param = meth.getParam(0);
                ParameterizedTypeInfo handler = (ParameterizedTypeInfo)param.getType();
                Assert.assertEquals((Object)Handler.class.getName(), (Object)handler.getRaw().getName());
                ParameterizedTypeInfo genericInt2 = (ParameterizedTypeInfo)handler.getArg(0);
                Assert.assertEquals((Object)GenericInterface2.class.getName(), (Object)genericInt2.getRaw().getName());
                TypeVariableInfo k = (TypeVariableInfo)genericInt2.getArg(0);
                Assert.assertEquals((Object)"K", (Object)k.getName());
                TypeVariableInfo v = (TypeVariableInfo)genericInt2.getArg(1);
                Assert.assertEquals((Object)"V", (Object)v.getName());
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        };
        ClassTest.blacklist(test, Stream.of(WriteStream.class));
        test.run();
    }

    @Test
    public void testParameterizedForbiddenSuperType() throws Exception {
        Class[] forbidenTypes;
        for (Class forbidenType : forbidenTypes = new Class[]{InterfaceWithParameterizedArraySupertype.class, InterfaceWithParameterizedGenericArraySupertype.class}) {
            try {
                new Generator().generateClass(forbidenType, new Class[0]);
                Assert.fail();
            }
            catch (GenException genException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testGenerateInterfaceWithDefaultMethod() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceWithDefaultMethod.class, new Class[0]);
        Assert.assertEquals((long)2L, (long)model.getMethods().size());
    }

    @Test
    public <T> void testOverloadedMethods() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceWithOverloadedMethods.class, new Class[0]);
        Assert.assertEquals((Object)InterfaceWithOverloadedMethods.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)InterfaceWithOverloadedMethods.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertEquals((long)2L, (long)model.getReferencedTypes().size());
        Assert.assertTrue((boolean)model.getReferencedTypes().contains(VertxGenClass1Info));
        Assert.assertTrue((boolean)model.getReferencedTypes().contains(VertxGenClass2Info));
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        List methods = model.getMethods();
        Assert.assertEquals((long)8L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "foo", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(0)).getParams().get(0), "str", (Type)((Object)String.class));
        this.checkMethod((MethodInfo)methods.get(1), "foo", 2, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(1)).getParams().get(0), "str", (Type)((Object)String.class));
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(1)).getParams().get(1), "handler", new TypeLiteral<Handler<VertxGenClass1>>(){});
        this.checkMethod((MethodInfo)methods.get(2), "foo", 3, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(2)).getParams().get(0), "str", (Type)((Object)String.class));
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(2)).getParams().get(1), "time", Long.TYPE);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(2)).getParams().get(2), "handler", new TypeLiteral<Handler<VertxGenClass1>>(){});
        this.checkMethod((MethodInfo)methods.get(3), "bar", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(3)).getParams().get(0), "obj1", (Type)((Object)VertxGenClass2.class));
        this.checkMethod((MethodInfo)methods.get(4), "bar", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(4)).getParams().get(0), "obj1", (Type)((Object)String.class));
        this.checkMethod((MethodInfo)methods.get(5), "juu", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(0)).getParams().get(0), "str", (Type)((Object)String.class));
        this.checkMethod((MethodInfo)methods.get(6), "juu", 2, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(6)).getParams().get(0), "str", (Type)((Object)String.class));
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(6)).getParams().get(1), "time", Long.TYPE);
        this.checkMethod((MethodInfo)methods.get(7), "juu", 3, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(7)).getParams().get(0), "str", (Type)((Object)String.class));
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(7)).getParams().get(1), "time", Long.TYPE);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(7)).getParams().get(2), "handler", new TypeLiteral<Handler<T>>(){});
        Assert.assertEquals((long)3L, (long)model.getMethodMap().size());
        List meths1 = (List)model.getMethodMap().get("foo");
        Assert.assertEquals((long)3L, (long)meths1.size());
        Assert.assertSame(model.getMethods().get(0), meths1.get(0));
        Assert.assertSame(model.getMethods().get(1), meths1.get(1));
        Assert.assertSame(model.getMethods().get(2), meths1.get(2));
        List meths2 = (List)model.getMethodMap().get("bar");
        Assert.assertEquals((long)2L, (long)meths2.size());
        Assert.assertSame(model.getMethods().get(3), meths2.get(0));
        Assert.assertSame(model.getMethods().get(4), meths2.get(1));
    }

    @Test
    public void testStaticMethods() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceWithStaticMethods.class, new Class[0]);
        Assert.assertEquals((Object)InterfaceWithStaticMethods.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)InterfaceWithStaticMethods.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertEquals((long)2L, (long)model.getReferencedTypes().size());
        Assert.assertTrue((boolean)model.getReferencedTypes().contains(VertxGenClass1Info));
        Assert.assertTrue((boolean)model.getReferencedTypes().contains(VertxGenClass2Info));
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)2L, (long)model.getMethods().size());
        Consumer<List> checker = methods -> {
            this.checkMethod((MethodInfo)methods.get(0), "foo", 1, (Type)((Object)VertxGenClass1.class), MethodKind.OTHER, ClassTestBase.MethodCheck.STATIC);
            this.checkMethod((MethodInfo)methods.get(1), "bar", 1, (Type)((Object)VertxGenClass2.class), MethodKind.OTHER, ClassTestBase.MethodCheck.STATIC);
        };
        checker.accept(model.getMethods());
        checker.accept(model.getStaticMethods());
        Assert.assertEquals(Collections.emptyList(), (Object)model.getInstanceMethods());
    }

    @Test
    public void testStaticSuperStaticMethods() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceWithSuperStaticMethods.class, new Class[0]);
        Assert.assertEquals((Object)InterfaceWithSuperStaticMethods.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)InterfaceWithSuperStaticMethods.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertEquals(Collections.singletonList(TypeReflectionFactory.create(InterfaceWithStaticMethods.class)), (Object)model.getSuperTypes());
        Assert.assertEquals((long)0L, (long)model.getMethods().size());
    }

    @Test
    public void testInstanceMethods() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceWithInstanceMethods.class, new Class[0]);
        Assert.assertEquals((Object)InterfaceWithInstanceMethods.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)InterfaceWithInstanceMethods.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertEquals((long)2L, (long)model.getReferencedTypes().size());
        Assert.assertTrue((boolean)model.getReferencedTypes().contains(VertxGenClass1Info));
        Assert.assertTrue((boolean)model.getReferencedTypes().contains(VertxGenClass2Info));
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)2L, (long)model.getMethods().size());
        Consumer<List> checker = methods -> {
            this.checkMethod((MethodInfo)methods.get(0), "foo", 1, (Type)((Object)VertxGenClass1.class), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(1), "bar", 1, (Type)((Object)VertxGenClass2.class), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        };
        checker.accept(model.getMethods());
        checker.accept(model.getInstanceMethods());
        Assert.assertEquals(Collections.emptyList(), (Object)model.getStaticMethods());
    }

    @Test
    public void testMethodOverride() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceWithMethodOverride.class, new Class[]{VertxGenInterface.class});
        List methods = model.getMethods();
        Assert.assertEquals((long)1L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "bar", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        Assert.assertEquals(ClassTest.set(TypeReflectionFactory.create(InterfaceWithMethodOverride.class), TypeReflectionFactory.create(VertxGenInterface.class)), (Object)((MethodInfo)methods.get(0)).getOwnerTypes());
        this.checkParam((ParamInfo)((MethodInfo)methods.get(0)).getParams().get(0), "str", (Type)((Object)String.class));
    }

    @Test
    public void testMethodOverrideParameterRenamed() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceWithMethodOverrideParameterRenamed.class, new Class[]{VertxGenInterface.class});
        List methods = model.getMethods();
        Assert.assertEquals((long)1L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "bar", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        Assert.assertEquals(ClassTest.set(TypeReflectionFactory.create(InterfaceWithMethodOverrideParameterRenamed.class), TypeReflectionFactory.create(VertxGenInterface.class)), (Object)((MethodInfo)methods.get(0)).getOwnerTypes());
        this.checkParam((ParamInfo)((MethodInfo)methods.get(0)).getParams().get(0), "str_renamed", (Type)((Object)String.class));
    }

    @Test
    public void testInterfaceWithGenericMethodOverride() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceWithGenericMethodOverride.class, new Class[]{GenericAbstractInterface.class});
        List methods = model.getMethods();
        Assert.assertEquals((long)5L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "foo", 0, (Type)((Object)String.class), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(1), "bar", 0, new TypeLiteral<List<String>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(2), "juu", 1, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(3), "daa", 1, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(4), "collargol", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals(ClassTest.set(TypeReflectionFactory.create(InterfaceWithGenericMethodOverride.class), TypeReflectionFactory.create(GenericAbstractInterface.class)), (Object)((MethodInfo)methods.get(i)).getOwnerTypes());
        }
        this.checkParam((ParamInfo)((MethodInfo)methods.get(2)).getParams().get(0), "handler", new TypeLiteral<Handler<AsyncResult<String>>>(){});
        this.checkParam((ParamInfo)((MethodInfo)methods.get(3)).getParams().get(0), "handler", new TypeLiteral<Handler<String>>(){});
        this.checkParam((ParamInfo)((MethodInfo)methods.get(4)).getParams().get(0), "t", (Type)((Object)String.class));
    }

    @Test
    public void testInterfaceExtendingGenericAbstractInterface() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceExtendingGenericAbstractInterface.class, new Class[]{GenericAbstractInterface.class});
        List methods = model.getMethods();
        Assert.assertEquals((long)5L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "foo", 0, (Type)((Object)String.class), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(1), "bar", 0, new TypeLiteral<List<String>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(2), "juu", 1, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(3), "daa", 1, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(4), "collargol", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)methods.get(2)).getParams().get(0), "handler", new TypeLiteral<Handler<AsyncResult<String>>>(){});
        this.checkParam((ParamInfo)((MethodInfo)methods.get(3)).getParams().get(0), "handler", new TypeLiteral<Handler<String>>(){});
        this.checkParam((ParamInfo)((MethodInfo)methods.get(4)).getParams().get(0), "t", (Type)((Object)String.class));
    }

    @Test
    public <R> void testInterfaceExtendingGenericInterface() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceWithParameterizedDeclaredSupertype.class, new Class[]{GenericInterface.class});
        List superTypeArgs = model.getSuperTypeArguments();
        Assert.assertEquals((long)1L, (long)superTypeArgs.size());
        ClassTypeInfo superTypeArg = (ClassTypeInfo)superTypeArgs.get(0);
        Assert.assertEquals((Object)ClassKind.STRING, (Object)superTypeArg.getKind());
        List methods = model.getMethods();
        Assert.assertEquals((long)1L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "methodWithClassTypeParam", 3, (Type)((Object)String.class), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkParam(((MethodInfo)methods.get(0)).getParam(0), "t", (Type)((Object)String.class));
        this.checkParam(((MethodInfo)methods.get(0)).getParam(1), "handler", new TypeLiteral<Handler<String>>(){});
        this.checkParam(((MethodInfo)methods.get(0)).getParam(2), "asyncResultHandler", new TypeLiteral<Handler<AsyncResult<String>>>(){});
    }

    @Test
    public void testInterfaceWithTypeVariableArgument() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceWithTypeVariableArgument3.class, new Class[]{InterfaceWithTypeVariableArgument2.class, InterfaceWithTypeVariableArgument1.class});
        List methods = model.getMethods();
        Assert.assertEquals((long)1L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "foo", 0, (Type)((Object)InterfaceWithTypeVariableArgument3.class), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        Assert.assertEquals(ClassTest.set(TypeReflectionFactory.create(InterfaceWithTypeVariableArgument1.class), TypeReflectionFactory.create(InterfaceWithTypeVariableArgument2.class)), (Object)((MethodInfo)methods.get(0)).getOwnerTypes());
    }

    @Test
    public void testMethodWithSameSignatureInheritedFromDistinctInterfaces() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithSameSignatureInheritedFromDistinctInterfaces.class, new Class[]{SameSignatureMethod1.class, SameSignatureMethod2.class});
        List methods = model.getMethods();
        Assert.assertEquals((long)1L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "foo", 0, "U", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        Assert.assertEquals(ClassTest.set(TypeReflectionFactory.create(SameSignatureMethod1.class), TypeReflectionFactory.create(SameSignatureMethod2.class)), (Object)((MethodInfo)methods.get(0)).getOwnerTypes());
    }

    @Test
    public void testMethodWithDiamond() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithDiamond.class, new Class[]{DiamondMethod1.class, DiamondMethod2.class, DiamondMethod3.class});
        List methods = model.getMethods();
        Assert.assertEquals((long)1L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "foo", 0, "U", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        Assert.assertEquals(ClassTest.set(TypeReflectionFactory.create(DiamondMethod1.class), TypeReflectionFactory.create(DiamondMethod2.class), TypeReflectionFactory.create(DiamondMethod3.class)), (Object)((MethodInfo)methods.get(0)).getOwnerTypes());
    }

    @Test
    public void testMethodComments() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceWithComments.class, new Class[0]);
        Assert.assertEquals((Object)InterfaceWithComments.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)InterfaceWithComments.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertTrue((boolean)model.getReferencedTypes().isEmpty());
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        List methods = model.getMethods();
        Assert.assertEquals((long)2L, (long)methods.size());
        Doc comment1 = new Doc(" Comment 1 line 1\n Comment 1 line 2", null, Arrays.asList(new Tag("param", "str the_string"), new Tag("return", "the_return_value\n")));
        Doc comment2 = new Doc(" Comment 2 line 1\n Comment 2 line 2\n");
        this.checkMethod((MethodInfo)methods.get(0), "foo", 1, (Type)((Object)String.class), MethodKind.OTHER, comment1, new ClassTestBase.MethodCheck[0]);
        Assert.assertEquals((Object)"str", (Object)((ParamInfo)((MethodInfo)methods.get(0)).getParams().get(0)).getName());
        Assert.assertEquals((Object)"the_string", (Object)((ParamInfo)((MethodInfo)methods.get(0)).getParams().get(0)).getDescription().toString());
        this.checkMethod((MethodInfo)methods.get(1), "bar", 1, "void", MethodKind.OTHER, comment2, new ClassTestBase.MethodCheck[0]);
    }

    @Test
    public void testInterfaceComments() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceWithComments.class, new Class[0]);
        Assert.assertEquals((Object)InterfaceWithComments.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)InterfaceWithComments.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertTrue((boolean)model.getReferencedTypes().isEmpty());
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        String firstSentence = " Interface comment line 1\n Interface comment line 2\n Interface comment line 3";
        Assert.assertEquals((Object)firstSentence, (Object)model.getDoc().getFirstSentence().getValue());
    }

    @Test
    public void testSignature() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidBasicParams.class, new Class[0]);
        Assert.assertEquals((long)1L, (long)model.getMethods().size());
        MethodInfo mi = (MethodInfo)model.getMethods().get(0);
        Signature s1 = mi.getSignature();
        Signature s2 = mi.getSignature();
        Assert.assertNotSame((Object)s1, (Object)s2);
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertEquals((long)s1.hashCode(), (long)s2.hashCode());
        Assert.assertEquals((Object)"methodWithBasicParams", (Object)s1.getName());
        Assert.assertEquals((long)9L, (long)s1.getParams().size());
        s1.getParams().remove(8);
        Assert.assertEquals((long)8L, (long)s1.getParams().size());
        Assert.assertEquals((long)9L, (long)mi.getParams().size());
    }

    @Test
    public void testOverloadedMethodFuture() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceWithOverloadedFutureMethod.class, new Class[0]);
        Assert.assertEquals((long)4L, (long)model.getMethods().size());
        Assert.assertEquals((long)2L, (long)model.getMethodMap().size());
        List closes = (List)model.getMethodMap().get("close");
        Assert.assertEquals((long)0L, (long)((MethodInfo)closes.get(0)).getParams().size());
        Assert.assertEquals((long)1L, (long)((MethodInfo)closes.get(1)).getParams().size());
        Signature closeSignature = ((MethodInfo)closes.get(1)).getSignature();
        closeSignature.getParams().remove(0);
        Assert.assertEquals((Object)((MethodInfo)closes.get(0)).getSignature(), (Object)closeSignature);
        List foos = (List)model.getMethodMap().get("foo");
        Assert.assertEquals((long)1L, (long)((MethodInfo)foos.get(0)).getParams().size());
        Assert.assertEquals((long)2L, (long)((MethodInfo)foos.get(1)).getParams().size());
        Signature fooSignature = ((MethodInfo)foos.get(1)).getSignature();
        fooSignature.getParams().remove(1);
        Assert.assertEquals((Object)((MethodInfo)foos.get(0)).getSignature(), (Object)fooSignature);
    }

    @Test
    public void testOverloadedFromParent() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceWithMethodOverloadedFromParent.class, new Class[0]);
        List methods = model.getMethods();
        Assert.assertEquals((long)1L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "foo", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkParam(((MethodInfo)methods.get(0)).getParam(0), "str", (Type)((Object)String.class));
        methods = (List)model.getMethodMap().get("foo");
        Assert.assertEquals((long)2L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "foo", 0, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(1), "foo", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
    }

    @Test
    public void testOverloadedInstanceAndStaticMethod() throws Exception {
        this.assertGenInvalid(InterfaceWithOverloadedInstanceAndStaticMethod.class, new Class[0]);
    }

    @Test
    public void testJsonParams() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidJSONParams.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithValidJSONParams.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithValidJSONParams.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertTrue((boolean)model.getReferencedTypes().isEmpty());
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        List methods = model.getMethods();
        Assert.assertEquals((long)1L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "methodWithJsonParams", 2, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(0)).getParams().get(0), "jsonObject", (Type)((Object)JsonObject.class));
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(0)).getParams().get(1), "jsonArray", (Type)((Object)JsonArray.class));
    }

    @Test
    public void testJsonHandlers() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidHandlerJSON.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithValidHandlerJSON.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithValidHandlerJSON.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertTrue((boolean)model.getReferencedTypes().isEmpty());
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        List methods = model.getMethods();
        Assert.assertEquals((long)1L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "methodWithJsonHandlers", 2, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(0)).getParams().get(0), "jsonObjectHandler", new TypeLiteral<Handler<JsonObject>>(){});
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(0)).getParams().get(1), "jsonArrayHandler", new TypeLiteral<Handler<JsonArray>>(){});
    }

    @Test
    public void testJsonAsyncResultHandlers() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidHandlerAsyncResultJSON.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithValidHandlerAsyncResultJSON.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithValidHandlerAsyncResultJSON.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertTrue((boolean)model.getReferencedTypes().isEmpty());
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        List methods = model.getMethods();
        Assert.assertEquals((long)1L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "methodwithJsonHandlersAsyncResult", 2, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(0), "methodwithJsonHandlersAsyncResult", 2, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(0)).getParams().get(0), "jsonObjectHandler", new TypeLiteral<Handler<AsyncResult<JsonObject>>>(){});
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(0)).getParams().get(1), "jsonArrayHandler", new TypeLiteral<Handler<AsyncResult<JsonArray>>>(){});
    }

    @Test
    public void testJsonReturns() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidJSONReturn.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithValidJSONReturn.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithValidJSONReturn.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertTrue((boolean)model.getReferencedTypes().isEmpty());
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)2L, (long)model.getMethods().size());
        this.checkMethod((MethodInfo)model.getMethods().get(0), "foo", 0, (Type)((Object)JsonObject.class), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(1), "bar", 0, (Type)((Object)JsonArray.class), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
    }

    @Test
    public void testMethodHandlerParam() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithHandlerParam.class, new Class[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(0), "foo_1", 1, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(1), "foo_2", 2, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(2), "foo_3", 2, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(3), "foo_4", 1, (Type)((Object)MethodWithHandlerParam.class), MethodKind.HANDLER, ClassTestBase.MethodCheck.FLUENT);
        this.checkMethod((MethodInfo)model.getMethods().get(4), "foo_5", 2, (Type)((Object)MethodWithHandlerParam.class), MethodKind.HANDLER, ClassTestBase.MethodCheck.FLUENT);
        this.checkMethod((MethodInfo)model.getMethods().get(5), "foo_6", 2, (Type)((Object)MethodWithHandlerParam.class), MethodKind.HANDLER, ClassTestBase.MethodCheck.FLUENT);
        this.checkMethod((MethodInfo)model.getMethods().get(6), "foo_7", 1, (Type)((Object)String.class), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(7), "foo_8", 2, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
    }

    @Test
    public void testMethodHandlerAsyncResultParam() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithHandlerAsyncResultParam.class, new Class[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(0), "foo_1", 1, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(1), "foo_2", 2, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(2), "foo_3", 2, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(3), "foo_4", 1, (Type)((Object)MethodWithHandlerAsyncResultParam.class), MethodKind.FUTURE, ClassTestBase.MethodCheck.FLUENT);
        this.checkMethod((MethodInfo)model.getMethods().get(4), "foo_5", 2, (Type)((Object)MethodWithHandlerAsyncResultParam.class), MethodKind.FUTURE, ClassTestBase.MethodCheck.FLUENT);
        this.checkMethod((MethodInfo)model.getMethods().get(5), "foo_6", 2, (Type)((Object)MethodWithHandlerAsyncResultParam.class), MethodKind.FUTURE, ClassTestBase.MethodCheck.FLUENT);
        this.checkMethod((MethodInfo)model.getMethods().get(6), "foo_7", 1, String.class.getName(), MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(7), "foo_8", 2, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
    }

    @Test
    public <T> void testValidTypeParamByInterfaceReturn() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidTypeParamByInterfaceReturn.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithValidTypeParamByInterfaceReturn.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithValidTypeParamByInterfaceReturn.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertEquals((Object)model.getReferencedTypes(), ClassTest.set(GenericInterfaceInfo, VertxGenClass1Info));
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)18L, (long)model.getMethods().size());
        this.checkMethod((MethodInfo)model.getMethods().get(0), "withByte", 0, new TypeLiteral<GenericInterface<Byte>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(1), "withShort", 0, new TypeLiteral<GenericInterface<Short>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(2), "withInteger", 0, new TypeLiteral<GenericInterface<Integer>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(3), "withLong", 0, new TypeLiteral<GenericInterface<Long>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(4), "withFloat", 0, new TypeLiteral<GenericInterface<Float>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(5), "withDouble", 0, new TypeLiteral<GenericInterface<Double>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(6), "withBoolean", 0, new TypeLiteral<GenericInterface<Boolean>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(7), "withCharacter", 0, new TypeLiteral<GenericInterface<Character>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(8), "withString", 0, new TypeLiteral<GenericInterface<String>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(9), "withJsonObject", 0, new TypeLiteral<GenericInterface<JsonObject>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(10), "withJsonArray", 0, new TypeLiteral<GenericInterface<JsonArray>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(11), "withDataObject", 0, new TypeLiteral<GenericInterface<PlainDataObjectWithToJson>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(12), "withEnum", 0, new TypeLiteral<GenericInterface<TestEnum>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(13), "withGenEnum", 0, new TypeLiteral<GenericInterface<TestGenEnum>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(14), "withUserType", 0, new TypeLiteral<GenericInterface<VertxGenClass1>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(15), "withVoid", 0, new TypeLiteral<GenericInterface<Void>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(16), "withGeneric", 0, new TypeLiteral<GenericInterface<T>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)model.getMethods().get(17), "withClassType", 1, new TypeLiteral<GenericInterface<T>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(17)).getParams().get(0), "classType", new TypeLiteral<Class<T>>(){});
    }

    @Test
    public <T> void testValidHandlerTypeParamByInterface() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidHandlerTypeParamByInterface.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithValidHandlerTypeParamByInterface.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithValidHandlerTypeParamByInterface.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertEquals((Object)model.getReferencedTypes(), ClassTest.set(GenericInterfaceInfo, VertxGenClass1Info));
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)16L, (long)model.getMethods().size());
        this.checkMethod((MethodInfo)model.getMethods().get(0), "withByte", 1, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(0)).getParams().get(0), "handler", new TypeLiteral<Handler<GenericInterface<Byte>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(1), "withShort", 1, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(1)).getParams().get(0), "handler", new TypeLiteral<Handler<GenericInterface<Short>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(2), "withInteger", 1, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(2)).getParams().get(0), "handler", new TypeLiteral<Handler<GenericInterface<Integer>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(3), "withLong", 1, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(3)).getParams().get(0), "handler", new TypeLiteral<Handler<GenericInterface<Long>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(4), "withFloat", 1, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(4)).getParams().get(0), "handler", new TypeLiteral<Handler<GenericInterface<Float>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(5), "withDouble", 1, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(5)).getParams().get(0), "handler", new TypeLiteral<Handler<GenericInterface<Double>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(6), "withBoolean", 1, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(6)).getParams().get(0), "handler", new TypeLiteral<Handler<GenericInterface<Boolean>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(7), "withCharacter", 1, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(7)).getParams().get(0), "handler", new TypeLiteral<Handler<GenericInterface<Character>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(8), "withString", 1, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(8)).getParams().get(0), "handler", new TypeLiteral<Handler<GenericInterface<String>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(9), "withJsonObject", 1, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(9)).getParams().get(0), "handler", new TypeLiteral<Handler<GenericInterface<JsonObject>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(10), "withJsonArray", 1, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(10)).getParams().get(0), "handler", new TypeLiteral<Handler<GenericInterface<JsonArray>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(11), "withDataObject", 1, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(11)).getParams().get(0), "handler", new TypeLiteral<Handler<GenericInterface<PlainDataObjectWithToJson>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(12), "withEnum", 1, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(12)).getParams().get(0), "handler", new TypeLiteral<Handler<GenericInterface<TestEnum>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(13), "withGenEnum", 1, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(13)).getParams().get(0), "handler", new TypeLiteral<Handler<GenericInterface<TestGenEnum>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(14), "withUserType", 1, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(14)).getParams().get(0), "handler", new TypeLiteral<Handler<GenericInterface<VertxGenClass1>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(15), "withClassType", 2, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(15)).getParams().get(0), "classType", new TypeLiteral<Class<T>>(){});
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(15)).getParams().get(1), "handler", new TypeLiteral<Handler<GenericInterface<T>>>(){});
    }

    @Test
    public <T> void testValidHandlerAsyncResultTypeParamByInterface() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithValidHandlerAsyncResultTypeParamByInterface.class, new Class[0]);
        Assert.assertEquals((Object)MethodWithValidHandlerAsyncResultTypeParamByInterface.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)MethodWithValidHandlerAsyncResultTypeParamByInterface.class.getSimpleName(), (Object)model.getIfaceSimpleName());
        Assert.assertEquals((Object)model.getReferencedTypes(), ClassTest.set(GenericInterfaceInfo, VertxGenClass1Info));
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)16L, (long)model.getMethods().size());
        this.checkMethod((MethodInfo)model.getMethods().get(0), "withByte", 1, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(0)).getParams().get(0), "handler", new TypeLiteral<Handler<AsyncResult<GenericInterface<Byte>>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(1), "withShort", 1, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(1)).getParams().get(0), "handler", new TypeLiteral<Handler<AsyncResult<GenericInterface<Short>>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(2), "withInteger", 1, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(2)).getParams().get(0), "handler", new TypeLiteral<Handler<AsyncResult<GenericInterface<Integer>>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(3), "withLong", 1, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(3)).getParams().get(0), "handler", new TypeLiteral<Handler<AsyncResult<GenericInterface<Long>>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(4), "withFloat", 1, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(4)).getParams().get(0), "handler", new TypeLiteral<Handler<AsyncResult<GenericInterface<Float>>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(5), "withDouble", 1, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(5)).getParams().get(0), "handler", new TypeLiteral<Handler<AsyncResult<GenericInterface<Double>>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(6), "withBoolean", 1, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(6)).getParams().get(0), "handler", new TypeLiteral<Handler<AsyncResult<GenericInterface<Boolean>>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(7), "withCharacter", 1, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(7)).getParams().get(0), "handler", new TypeLiteral<Handler<AsyncResult<GenericInterface<Character>>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(8), "withString", 1, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(8)).getParams().get(0), "handler", new TypeLiteral<Handler<AsyncResult<GenericInterface<String>>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(9), "withJsonObject", 1, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(9)).getParams().get(0), "handler", new TypeLiteral<Handler<AsyncResult<GenericInterface<JsonObject>>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(10), "withJsonArray", 1, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(10)).getParams().get(0), "handler", new TypeLiteral<Handler<AsyncResult<GenericInterface<JsonArray>>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(11), "withDataObject", 1, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(11)).getParams().get(0), "handler", new TypeLiteral<Handler<AsyncResult<GenericInterface<PlainDataObjectWithToJson>>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(12), "withEnum", 1, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(12)).getParams().get(0), "handler", new TypeLiteral<Handler<AsyncResult<GenericInterface<TestEnum>>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(13), "withGenEnum", 1, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(13)).getParams().get(0), "handler", new TypeLiteral<Handler<AsyncResult<GenericInterface<TestGenEnum>>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(14), "withUserType", 1, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(14)).getParams().get(0), "handler", new TypeLiteral<Handler<AsyncResult<GenericInterface<VertxGenClass1>>>>(){});
        this.checkMethod((MethodInfo)model.getMethods().get(15), "withClassType", 2, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(15)).getParams().get(0), "classType", new TypeLiteral<Class<T>>(){});
        this.checkParam((ParamInfo)((MethodInfo)model.getMethods().get(15)).getParams().get(1), "handler", new TypeLiteral<Handler<AsyncResult<GenericInterface<T>>>>(){});
    }

    @Test
    public void testMethodInvalidMapReturn1() throws Exception {
        this.assertGenFail(MethodWithInvalidMapReturn1.class, "Invalid Map return should fail");
    }

    @Test
    public void testMethodInvalidMapReturn2() throws Exception {
        this.assertGenFail(MethodWithInvalidMapReturn2.class, "Invalid Map return should fail");
    }

    @Test
    public void testMethodInvalidMapReturn3() throws Exception {
        this.assertGenFail(MethodWithInvalidMapReturn3.class, "Invalid Map return should fail");
    }

    @Test
    public void testMethodInvalidMapReturn4() throws Exception {
        this.assertGenFail(MethodWithInvalidMapReturn4.class, "Invalid Map return should fail");
    }

    @Test
    public void testMethodInvalidMapReturn5() throws Exception {
        this.assertGenFail(MethodWithInvalidMapReturn5.class, "Invalid Map return should fail");
    }

    @Test
    public void testMethodInvalidListReturn1() throws Exception {
        this.assertGenFail(MethodWithInvalidListReturn1.class, "Invalid Map return should fail");
    }

    @Test
    public void testInterfaceExtendingReadStream() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceExtentingReadStream.class, new Class[0]);
        ApiTypeInfo apiType = (ApiTypeInfo)model.getType();
        Assert.assertTrue((boolean)apiType.isReadStream());
        Assert.assertEquals((Object)TypeReflectionFactory.create(String.class), (Object)apiType.getReadStreamArg());
        Assert.assertFalse((boolean)apiType.isWriteStream());
        Assert.assertNull((Object)apiType.getWriteStreamArg());
        Assert.assertFalse((boolean)apiType.isHandler());
    }

    @Test
    public void testGenericInterfaceExtendingReadStream() throws Exception {
        ClassModel model = new Generator().generateClass(GenericInterfaceExtentingReadStream.class, new Class[0]);
        ApiTypeInfo apiType = (ApiTypeInfo)model.getType().getRaw();
        Assert.assertTrue((boolean)apiType.isReadStream());
        TypeVariableInfo readStreamArg = (TypeVariableInfo)apiType.getReadStreamArg();
        Assert.assertEquals((Object)"U", (Object)readStreamArg.getName());
        Assert.assertFalse((boolean)apiType.isWriteStream());
        Assert.assertNull((Object)apiType.getWriteStreamArg());
        Assert.assertFalse((boolean)apiType.isHandler());
    }

    @Test
    public void testInterfaceExtendingWriteStream() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceExtentingWriteStream.class, new Class[0]);
        ApiTypeInfo apiType = (ApiTypeInfo)model.getType();
        Assert.assertFalse((boolean)apiType.isReadStream());
        Assert.assertNull((Object)apiType.getReadStreamArg());
        Assert.assertTrue((boolean)apiType.isWriteStream());
        Assert.assertEquals((Object)TypeReflectionFactory.create(String.class), (Object)apiType.getWriteStreamArg());
        Assert.assertFalse((boolean)apiType.isHandler());
    }

    @Test
    public void testGenericInterfaceExtendingWriteStream() throws Exception {
        ClassModel model = new Generator().generateClass(GenericInterfaceExtentingWriteStream.class, new Class[0]);
        ApiTypeInfo apiType = (ApiTypeInfo)model.getType().getRaw();
        Assert.assertFalse((boolean)apiType.isReadStream());
        Assert.assertNull((Object)apiType.getReadStreamArg());
        Assert.assertTrue((boolean)apiType.isWriteStream());
        TypeVariableInfo writeStreamArg = (TypeVariableInfo)apiType.getWriteStreamArg();
        Assert.assertEquals((Object)"U", (Object)writeStreamArg.getName());
        Assert.assertFalse((boolean)apiType.isHandler());
    }

    @Test
    public void testInterfaceExtendingReadStreamAndWriteStream() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceExtentingReadStreamAndWriteStream.class, new Class[0]);
        ApiTypeInfo apiType = (ApiTypeInfo)model.getType();
        Assert.assertTrue((boolean)apiType.isReadStream());
        Assert.assertEquals((Object)TypeReflectionFactory.create(String.class), (Object)apiType.getReadStreamArg());
        Assert.assertTrue((boolean)apiType.isWriteStream());
        Assert.assertEquals((Object)TypeReflectionFactory.create(String.class), (Object)apiType.getWriteStreamArg());
        Assert.assertFalse((boolean)apiType.isHandler());
    }

    @Test
    public void testGenericInterfaceExtendingReadStreamAndWriteStream() throws Exception {
        ClassModel model = new Generator().generateClass(GenericInterfaceExtentingReadStreamAndWriteStream.class, new Class[0]);
        ApiTypeInfo apiType = (ApiTypeInfo)model.getType().getRaw();
        Assert.assertTrue((boolean)apiType.isReadStream());
        TypeVariableInfo readStreamArg = (TypeVariableInfo)apiType.getReadStreamArg();
        Assert.assertEquals((Object)"U", (Object)readStreamArg.getName());
        Assert.assertTrue((boolean)apiType.isWriteStream());
        TypeVariableInfo writeStreamArg = (TypeVariableInfo)apiType.getWriteStreamArg();
        Assert.assertEquals((Object)"U", (Object)writeStreamArg.getName());
        Assert.assertFalse((boolean)apiType.isHandler());
    }

    @Test
    public void testInterfaceSubtypingReadStream() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceSubtypingReadStream.class, new Class[0]);
        ApiTypeInfo apiType = (ApiTypeInfo)model.getType();
        Assert.assertTrue((boolean)apiType.isReadStream());
        Assert.assertEquals((Object)TypeReflectionFactory.create(String.class), (Object)apiType.getReadStreamArg());
        Assert.assertFalse((boolean)apiType.isWriteStream());
        Assert.assertNull((Object)apiType.getWriteStreamArg());
        Assert.assertFalse((boolean)apiType.isHandler());
    }

    @Test
    public void testReadStreamWithParameterizedTypeArg() throws Exception {
        ClassModel model = new Generator().generateClass(ReadStreamWithParameterizedTypeArg.class, new Class[0]);
        ApiTypeInfo apiType = (ApiTypeInfo)model.getType().getRaw();
        Assert.assertTrue((boolean)apiType.isReadStream());
        ParameterizedTypeInfo readStreamArg = (ParameterizedTypeInfo)apiType.getReadStreamArg();
        Assert.assertEquals((Object)TypeReflectionFactory.create(List.class), (Object)readStreamArg.getRaw());
        Assert.assertEquals((long)1L, (long)readStreamArg.getArgs().size());
        Assert.assertEquals((Object)"T", (Object)((TypeInfo)readStreamArg.getArgs().get(0)).getName());
        Assert.assertFalse((boolean)apiType.isWriteStream());
        Assert.assertNull((Object)apiType.getWriteStreamArg());
        Assert.assertFalse((boolean)apiType.isHandler());
    }

    @Test
    public void testInterfaceExtendingHandlerStringSubtype() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceExtendingHandlerStringSubtype.class, new Class[0]);
        TypeInfo handlerSuperType = model.getHandlerType();
        Assert.assertEquals((Object)TypeReflectionFactory.create(String.class), (Object)handlerSuperType);
        ApiTypeInfo apiType = (ApiTypeInfo)model.getType();
        Assert.assertTrue((boolean)apiType.isHandler());
        Assert.assertEquals((Object)TypeReflectionFactory.create(String.class), (Object)apiType.getHandlerArg());
        Assert.assertFalse((boolean)apiType.isReadStream());
        Assert.assertFalse((boolean)apiType.isWriteStream());
        Assert.assertEquals((long)1L, (long)model.getMethodMap().size());
        Assert.assertEquals((long)1L, (long)((List)model.getMethodMap().get("handle")).size());
        this.checkMethod((MethodInfo)((List)model.getMethodMap().get("handle")).get(0), "handle", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
    }

    @Test
    public void testInterfaceExtendingHandlerVertxGenSubtype() throws Exception {
        ClassModel model = new Generator().generateClass(InterfaceExtendingHandlerVertxGenSubtype.class, new Class[]{VertxGenClass1.class});
        TypeInfo handlerSuperType = model.getHandlerType();
        Assert.assertEquals((Object)TypeReflectionFactory.create(VertxGenClass1.class), (Object)handlerSuperType);
        ApiTypeInfo apiType = (ApiTypeInfo)model.getType();
        Assert.assertTrue((boolean)apiType.isHandler());
        Assert.assertEquals((Object)TypeReflectionFactory.create(VertxGenClass1.class), (Object)apiType.getHandlerArg());
        Assert.assertFalse((boolean)apiType.isReadStream());
        Assert.assertFalse((boolean)apiType.isWriteStream());
        Assert.assertEquals((long)1L, (long)model.getMethodMap().size());
        Assert.assertEquals((long)1L, (long)((List)model.getMethodMap().get("handle")).size());
        this.checkMethod((MethodInfo)((List)model.getMethodMap().get("handle")).get(0), "handle", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
    }

    @Test
    public void testRecursiveFuture() throws Exception {
        ClassModel model = new Generator().generateClass(RecursiveFuture.class, new Class[0]);
        Assert.assertNull((Object)model.getHandlerType());
    }

    @Test
    public void testFutureLike() throws Exception {
        ClassModel model = new Generator().generateClass(FutureLike.class, new Class[0]);
        Assert.assertNull((Object)model.getHandlerType());
    }

    @Test
    public void testMethodInvalidListReturn2() throws Exception {
        this.assertGenFail(MethodWithInvalidListReturn2.class, "Invalid Map return should fail");
    }

    @Test
    public void testMethodInvalidSetReturn1() throws Exception {
        this.assertGenFail(MethodWithInvalidSetReturn1.class, "Invalid Map return should fail");
    }

    @Test
    public void testMethodInvalidSetReturn2() throws Exception {
        this.assertGenFail(MethodWithInvalidSetReturn2.class, "Invalid Map return should fail");
    }

    @Test
    public void testMethodInvalidMapParams1() throws Exception {
        this.assertGenFail(MethodWithInvalidMapParams1.class, "Invalid Map return should fail");
    }

    @Test
    public void testMethodInvalidMapParams2() throws Exception {
        this.assertGenFail(MethodWithInvalidMapParams2.class, "Invalid Map return should fail");
    }

    @Test
    public void testMethodInvalidListParams1() throws Exception {
        this.assertGenFail(MethodWithInvalidListParams1.class, "Invalid Map return should fail");
    }

    @Test
    public void testMethodInvalidListParams2() throws Exception {
        this.assertGenFail(MethodWithInvalidListParams2.class, "Invalid Map return should fail");
    }

    @Test
    public void testMethodInvalidSetParams1() throws Exception {
        this.assertGenFail(MethodWithInvalidSetParams1.class, "Invalid Map return should fail");
    }

    @Test
    public void testMethodInvalidSetParams2() throws Exception {
        this.assertGenFail(MethodWithInvalidSetParams2.class, "Invalid Map return should fail");
    }

    @Test
    public void testMethodInvalidHandlerDataObjectsParam() throws Exception {
        this.assertGenFail(MethodWithInvalidHandlerDataObjectParam.class, "Option without toJson() in Handler param should fail");
    }

    @Test
    public void testMethodInvalidHandlerAsyncResultDataObjectsParam() throws Exception {
        this.assertGenFail(MethodWithInvalidHandlerAsyncResultDataObjectParam.class, "Option without toJson() in AsyncResult param should fail");
    }

    @Test
    public void testMethodInvalidThrowableParam() throws Exception {
        this.assertGenInvalid(MethodWithInvalidExceptionParam.class, new Class[0]);
    }

    @Test
    public void testMethodInvalidNestedEnumParam() throws Exception {
        this.assertGenInvalid(MethodWithInvalidNestedEnumParam.class, new Class[0]);
    }

    @Test
    public void testStringAnnotated() throws Exception {
        ClassModel model = new Generator().generateClass(Annotated.class, new Class[0]);
        Assert.assertFalse((boolean)model.getAnnotations().isEmpty());
        Assert.assertEquals((long)2L, (long)model.getAnnotations().size());
        Assert.assertEquals((Object)VertxGen.class.getName(), (Object)((AnnotationValueInfo)model.getAnnotations().get(0)).getName());
        Assert.assertEquals((Object)EmptyAnnotation.class.getName(), (Object)((AnnotationValueInfo)model.getAnnotations().get(1)).getName());
        Assert.assertFalse((boolean)model.getMethodAnnotations().values().isEmpty());
        Assert.assertEquals((long)1L, (long)((List)model.getMethodAnnotations().get("stringAnnotated")).size());
        Assert.assertEquals((long)3L, (long)((AnnotationValueInfo)((List)model.getMethodAnnotations().get("stringAnnotated")).get(0)).getMembersNames().size());
        Assert.assertNotNull((Object)((AnnotationValueInfo)((List)model.getMethodAnnotations().get("stringAnnotated")).get(0)).getMember("value"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((List)model.getMethodAnnotations().get("stringAnnotated")).get(0)).getMember("array"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((List)model.getMethodAnnotations().get("stringAnnotated")).get(0)).getMember("defaultValue"));
        Assert.assertEquals((Object)"aString", (Object)((AnnotationValueInfo)((List)model.getMethodAnnotations().get("stringAnnotated")).get(0)).getMember("value"));
        Assert.assertArrayEquals((Object[])new String[]{"one", "two"}, (Object[])((List)((AnnotationValueInfo)((List)model.getMethodAnnotations().get("stringAnnotated")).get(0)).getMember("array")).toArray());
        Assert.assertEquals((Object)"defaultString", (Object)((AnnotationValueInfo)((List)model.getMethodAnnotations().get("stringAnnotated")).get(0)).getMember("defaultValue"));
    }

    @Test
    public void testImplPackage() throws Exception {
        try {
            new Generator().generateClass(InterfaceInImplParentPackage.class, new Class[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new Generator().generateClass(InterfaceInImplPackage.class, new Class[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ClassModel model = new Generator().generateClass(InterfaceInImplContainingPackage.class, new Class[0]);
        Assert.assertEquals((Object)InterfaceInImplContainingPackage.class.getName(), (Object)model.getFqn());
    }
}

