/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen;

import io.vertx.codegen.ClassModel;
import io.vertx.codegen.Generator;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.testmodel.TestDataObject;
import io.vertx.codegen.testmodel.TestEnum;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.test.codegen.ClassTestBase;
import io.vertx.test.codegen.TypeLiteral;
import io.vertx.test.codegen.testapi.VertxGenClass1;
import io.vertx.test.codegen.testapi.nullable.DiamondGenericBottomFluentNullableParam;
import io.vertx.test.codegen.testapi.nullable.InterfaceWithInvalidListNullableParamOverride;
import io.vertx.test.codegen.testapi.nullable.InterfaceWithInvalidNullableParamOverride;
import io.vertx.test.codegen.testapi.nullable.InterfaceWithInvalidNullableReturnOverride;
import io.vertx.test.codegen.testapi.nullable.InterfaceWithNonNullableParams;
import io.vertx.test.codegen.testapi.nullable.InterfaceWithNullableReturnMethod;
import io.vertx.test.codegen.testapi.nullable.InterfaceWithNullableReturnOverride;
import io.vertx.test.codegen.testapi.nullable.MethodWithCovariantNullableReturn;
import io.vertx.test.codegen.testapi.nullable.MethodWithHandlerAsyncResultNullableVoid;
import io.vertx.test.codegen.testapi.nullable.MethodWithHandlerNullable;
import io.vertx.test.codegen.testapi.nullable.MethodWithHandlerNullableVoid;
import io.vertx.test.codegen.testapi.nullable.MethodWithInvalidHandlerNullableAsyncResult;
import io.vertx.test.codegen.testapi.nullable.MethodWithInvalidNullableBooleanReturn;
import io.vertx.test.codegen.testapi.nullable.MethodWithInvalidNullableByteReturn;
import io.vertx.test.codegen.testapi.nullable.MethodWithInvalidNullableCharReturn;
import io.vertx.test.codegen.testapi.nullable.MethodWithInvalidNullableDoubleReturn;
import io.vertx.test.codegen.testapi.nullable.MethodWithInvalidNullableFloatReturn;
import io.vertx.test.codegen.testapi.nullable.MethodWithInvalidNullableFluentReturn;
import io.vertx.test.codegen.testapi.nullable.MethodWithInvalidNullableIntReturn;
import io.vertx.test.codegen.testapi.nullable.MethodWithInvalidNullableLongReturn;
import io.vertx.test.codegen.testapi.nullable.MethodWithInvalidNullableShortReturn;
import io.vertx.test.codegen.testapi.nullable.MethodWithInvalidNullableTypeArgumentHandler;
import io.vertx.test.codegen.testapi.nullable.MethodWithInvalidNullableTypeArgumentHandlerAsyncResult;
import io.vertx.test.codegen.testapi.nullable.MethodWithInvalidNullableTypeArgumentParam;
import io.vertx.test.codegen.testapi.nullable.MethodWithInvalidNullableTypeArgumentReturn;
import io.vertx.test.codegen.testapi.nullable.MethodWithInvalidOverloadedNullableParam;
import io.vertx.test.codegen.testapi.nullable.MethodWithListNullableParam;
import io.vertx.test.codegen.testapi.nullable.MethodWithListNullableParamOverride;
import io.vertx.test.codegen.testapi.nullable.MethodWithNullableHandler;
import io.vertx.test.codegen.testapi.nullable.MethodWithNullableHandlerAsyncResult;
import io.vertx.test.codegen.testapi.nullable.MethodWithNullableInheritedParams;
import io.vertx.test.codegen.testapi.nullable.MethodWithNullableNonAnnotatedObjectParam;
import io.vertx.test.codegen.testapi.nullable.MethodWithNullableNonAnnotatedTypeVariableHandler;
import io.vertx.test.codegen.testapi.nullable.MethodWithNullableNonAnnotatedTypeVariableHandlerAsyncResult;
import io.vertx.test.codegen.testapi.nullable.MethodWithNullableNonAnnotatedTypeVariableParam;
import io.vertx.test.codegen.testapi.nullable.MethodWithNullableNonAnnotatedTypeVariableReturn;
import io.vertx.test.codegen.testapi.nullable.MethodWithNullableParam;
import io.vertx.test.codegen.testapi.nullable.MethodWithNullableParamOverride;
import io.vertx.test.codegen.testapi.nullable.MethodWithNullableParams;
import io.vertx.test.codegen.testapi.nullable.MethodWithNullableReturn;
import io.vertx.test.codegen.testapi.nullable.MethodWithNullableReturns;
import io.vertx.test.codegen.testapi.nullable.MethodWithNullableStringHandlerAsyncResult;
import io.vertx.test.codegen.testapi.nullable.MethodWithNullableTypeArgReturn;
import io.vertx.test.codegen.testapi.nullable.MethodWithNullableTypeVariableHandler;
import io.vertx.test.codegen.testapi.nullable.MethodWithNullableTypeVariableHandlerAsyncResult;
import io.vertx.test.codegen.testapi.nullable.MethodWithNullableTypeVariableParam;
import io.vertx.test.codegen.testapi.nullable.MethodWithNullableTypeVariableReturn;
import io.vertx.test.codegen.testapi.nullable.MethodWithOverloadedNullableParam;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class ClassNullableTest
extends ClassTestBase {
    @Test
    public void testMethodWithInvalidHandlerNullableAsyncResult() throws Exception {
        this.assertGenInvalid(MethodWithInvalidHandlerNullableAsyncResult.class, new Class[0]);
    }

    @Test
    public void testInterfaceWithInvalidNullableParamOverride() throws Exception {
        this.assertGenInvalid(InterfaceWithInvalidNullableParamOverride.class, InterfaceWithNonNullableParams.class);
        this.assertGenInvalid(InterfaceWithInvalidNullableParamOverride.class, new Class[0]);
    }

    @Test
    public void testInterfaceWithInvalidListNullableParamOverride() throws Exception {
        this.assertGenInvalid(InterfaceWithInvalidListNullableParamOverride.class, InterfaceWithNonNullableParams.class);
        this.assertGenInvalid(InterfaceWithInvalidListNullableParamOverride.class, new Class[0]);
    }

    @Test
    public void testMethodWithInvalidNullableTypeArgumentParam() throws Exception {
        this.assertGenInvalid(MethodWithInvalidNullableTypeArgumentParam.class, new Class[0]);
    }

    @Test
    public void testMethodWithInvalidNullableTypeArgumentHandler() throws Exception {
        this.assertGenInvalid(MethodWithInvalidNullableTypeArgumentHandler.class, new Class[0]);
    }

    @Test
    public void testMethodWithInvalidNullableTypeArgumentHandlerAsyncResult() throws Exception {
        this.assertGenInvalid(MethodWithInvalidNullableTypeArgumentHandlerAsyncResult.class, new Class[0]);
    }

    @Test
    public void testMethodWithInvalidNullableBooleanReturn() throws Exception {
        this.assertGenInvalid(MethodWithInvalidNullableBooleanReturn.class, new Class[0]);
    }

    @Test
    public void testMethodWithInvalidNullableByteReturn() throws Exception {
        this.assertGenInvalid(MethodWithInvalidNullableByteReturn.class, new Class[0]);
    }

    @Test
    public void testMethodWithInvalidNullableShortReturn() throws Exception {
        this.assertGenInvalid(MethodWithInvalidNullableShortReturn.class, new Class[0]);
    }

    @Test
    public void testMethodWithInvalidNullableIntReturn() throws Exception {
        this.assertGenInvalid(MethodWithInvalidNullableIntReturn.class, new Class[0]);
    }

    @Test
    public void testMethodWithInvalidNullableLongReturn() throws Exception {
        this.assertGenInvalid(MethodWithInvalidNullableLongReturn.class, new Class[0]);
    }

    @Test
    public void testMethodWithInvalidNullableFloatReturn() throws Exception {
        this.assertGenInvalid(MethodWithInvalidNullableFloatReturn.class, new Class[0]);
    }

    @Test
    public void testMethodWithInvalidNullableDoubleReturn() throws Exception {
        this.assertGenInvalid(MethodWithInvalidNullableDoubleReturn.class, new Class[0]);
    }

    @Test
    public void testMethodWithInvalidNullableCharReturn() throws Exception {
        this.assertGenInvalid(MethodWithInvalidNullableCharReturn.class, new Class[0]);
    }

    @Test
    public void testMethodWithInvalidOverloadedNullableParam() throws Exception {
        this.assertGenInvalid(MethodWithInvalidOverloadedNullableParam.class, new Class[0]);
    }

    @Test
    public void testInterfaceWithInvalidNullableReturnOverride() throws Exception {
        this.assertGenInvalid(InterfaceWithInvalidNullableReturnOverride.class, new Class[0]);
    }

    @Test
    public void testMethodWithInvalidNullableFluentReturn() throws Exception {
        this.assertGenInvalid(MethodWithInvalidNullableFluentReturn.class, new Class[0]);
    }

    @Test
    public void testMethodWithInvalidNullableTypeArgumentReturn() throws Exception {
        this.assertGenInvalid(MethodWithInvalidNullableTypeArgumentReturn.class, new Class[0]);
    }

    @Test
    public void testMethodWithNullableParam() throws Exception {
        this.generateClass(model -> {
            List methods = model.getMethods();
            Assert.assertEquals((long)1L, (long)methods.size());
            MethodInfo mi1 = (MethodInfo)methods.get(0);
            this.checkMethod(mi1, "method", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            Assert.assertTrue((boolean)((ParamInfo)mi1.getParams().get(0)).isNullable());
        }, MethodWithNullableParam.class, new Class[0]);
    }

    @Test
    public void testMethodWithNullableHandler() throws Exception {
        this.generateClass(model -> {
            List methods = model.getMethods();
            Assert.assertEquals((long)1L, (long)methods.size());
            MethodInfo mi1 = (MethodInfo)methods.get(0);
            this.checkMethod(mi1, "method", 1, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
            Assert.assertTrue((boolean)((ParamInfo)mi1.getParams().get(0)).isNullable());
        }, MethodWithNullableHandler.class, new Class[0]);
    }

    @Test
    public void testMethodWithNullableHandlerAsyncResult() throws Exception {
        this.generateClass(model -> {
            List methods = model.getMethods();
            Assert.assertEquals((long)1L, (long)methods.size());
            MethodInfo mi1 = (MethodInfo)methods.get(0);
            this.checkMethod(mi1, "method", 1, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
            Assert.assertTrue((boolean)((ParamInfo)mi1.getParams().get(0)).isNullable());
        }, MethodWithNullableHandlerAsyncResult.class, new Class[0]);
    }

    @Test
    public void testInterfaceWithNullableParamOverride() throws Exception {
        Consumer<ClassModel> test = model -> {
            List methods = model.getMethods();
            Assert.assertEquals((long)1L, (long)methods.size());
            MethodInfo mi1 = (MethodInfo)methods.get(0);
            Assert.assertTrue((boolean)((ParamInfo)mi1.getParams().get(0)).isNullable());
        };
        this.generateClass(test, MethodWithNullableParamOverride.class, new Class[0]);
    }

    @Test
    public void testInterfaceWithListNullableParamOverride() throws Exception {
        this.generateClass(model -> {
            List methods = model.getMethods();
            Assert.assertEquals((long)1L, (long)methods.size());
            MethodInfo mi2 = (MethodInfo)methods.get(0);
            Assert.assertTrue((boolean)((ParameterizedTypeInfo)((ParamInfo)mi2.getParams().get(0)).getType()).getArg(0).isNullable());
        }, MethodWithListNullableParamOverride.class, MethodWithListNullableParam.class);
    }

    @Test
    public void testMethodWithNullableInheritedParams() throws Exception {
        Consumer<ClassModel> check = model -> {
            List methods = model.getMethods();
            Assert.assertEquals((long)1L, (long)methods.size());
            MethodInfo mi2 = (MethodInfo)methods.get(0);
            Assert.assertTrue((boolean)((ParamInfo)mi2.getParams().get(0)).getType().isNullable());
            Assert.assertTrue((boolean)((ParameterizedTypeInfo)((ParamInfo)mi2.getParams().get(1)).getType()).getArg(0).isNullable());
            Assert.assertTrue((boolean)((ParameterizedTypeInfo)((ParameterizedTypeInfo)((ParamInfo)mi2.getParams().get(2)).getType()).getArg(0)).getArg(0).isNullable());
        };
        this.generateClass(check, MethodWithNullableInheritedParams.class, MethodWithNullableParams.class);
        this.generateClass(check, MethodWithNullableInheritedParams.class, new Class[0]);
    }

    @Test
    public void testMethodWithCovariantNullableReturn() throws Exception {
        Consumer<ClassModel> check = model -> {
            List methods = model.getMethods();
            Assert.assertEquals((long)1L, (long)methods.size());
            MethodInfo mi2 = (MethodInfo)methods.get(0);
            Assert.assertTrue((boolean)mi2.getReturnType().isNullable());
        };
        this.generateClass(check, MethodWithCovariantNullableReturn.class, MethodWithNullableReturn.class);
        this.generateClass(check, MethodWithCovariantNullableReturn.class, new Class[0]);
    }

    @Test
    public void testMethodWithNullableTypeVariableParam() throws Exception {
        this.generateClass(model -> {
            List methods = model.getMethods();
            Assert.assertEquals((long)1L, (long)methods.size());
            MethodInfo mi1 = (MethodInfo)methods.get(0);
            this.checkMethod(mi1, "method", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            Assert.assertTrue((boolean)((ParamInfo)mi1.getParams().get(0)).isNullable());
        }, MethodWithNullableTypeVariableParam.class, new Class[0]);
    }

    @Test
    public void testMethodWithNullableNonAnnotatedTypeVariableParam() throws Exception {
        this.generateClass(model -> {
            List methods = model.getMethods();
            Assert.assertEquals((long)1L, (long)methods.size());
            MethodInfo mi1 = (MethodInfo)methods.get(0);
            this.checkMethod(mi1, "method", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            Assert.assertTrue((boolean)((ParamInfo)mi1.getParams().get(0)).isNullable());
        }, MethodWithNullableNonAnnotatedTypeVariableParam.class, new Class[0]);
    }

    @Test
    public void testMethodWithNullableNonAnnotatedObjectParam() throws Exception {
        this.generateClass(model -> {
            List methods = model.getMethods();
            Assert.assertEquals((long)1L, (long)methods.size());
            MethodInfo mi1 = (MethodInfo)methods.get(0);
            this.checkMethod(mi1, "method", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            Assert.assertTrue((boolean)((ParamInfo)mi1.getParams().get(0)).isNullable());
        }, MethodWithNullableNonAnnotatedObjectParam.class, new Class[0]);
    }

    @Test
    public void testMethodWithHandlerNullable() throws Exception {
        for (Class clazz : Arrays.asList(MethodWithHandlerNullable.class, MethodWithNullableTypeVariableHandler.class, MethodWithHandlerNullableVoid.class)) {
            this.generateClass(model -> {
                List methods = model.getMethods();
                Assert.assertEquals((long)1L, (long)methods.size());
                MethodInfo mi1 = (MethodInfo)methods.get(0);
                Assert.assertTrue((boolean)((ParameterizedTypeInfo)((ParamInfo)mi1.getParams().get(0)).getType()).getArg(0).isNullable());
            }, clazz, new Class[0]);
        }
    }

    @Test
    public void testMethodWithNullableNonAnnotatedTypeVariableHandler() throws Exception {
        this.generateClass(model -> {
            List methods = model.getMethods();
            Assert.assertEquals((long)1L, (long)methods.size());
            MethodInfo mi1 = (MethodInfo)methods.get(0);
            this.checkMethod(mi1, "method", 1, "void", MethodKind.HANDLER, new ClassTestBase.MethodCheck[0]);
            Assert.assertFalse((boolean)((ParamInfo)mi1.getParams().get(0)).isNullableCallback());
        }, MethodWithNullableNonAnnotatedTypeVariableHandler.class, new Class[0]);
    }

    @Test
    public void testMethodWithHandlerAsyncResultNullable() throws Exception {
        for (Class clazz : Arrays.asList(MethodWithNullableTypeVariableHandlerAsyncResult.class, MethodWithNullableStringHandlerAsyncResult.class, MethodWithHandlerAsyncResultNullableVoid.class)) {
            this.generateClass(model -> {
                List methods = model.getMethods();
                Assert.assertEquals((long)1L, (long)methods.size());
                MethodInfo mi1 = (MethodInfo)methods.get(0);
                this.checkMethod(mi1, "method", 1, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
                Assert.assertTrue((boolean)((ParamInfo)mi1.getParams().get(0)).isNullableCallback());
            }, clazz, new Class[0]);
        }
    }

    @Test
    public void testMethodWithNullableStringHandlerAsyncResult() throws Exception {
        this.generateClass(model -> {
            List methods = model.getMethods();
            Assert.assertEquals((long)1L, (long)methods.size());
            MethodInfo mi1 = (MethodInfo)methods.get(0);
            this.checkMethod(mi1, "method", 1, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
            Assert.assertTrue((boolean)((ParamInfo)mi1.getParams().get(0)).isNullableCallback());
        }, MethodWithNullableStringHandlerAsyncResult.class, new Class[0]);
    }

    @Test
    public void testMethodWithNullableNonAnnotatedTypeVariableHandlerAsyncResult() throws Exception {
        this.generateClass(model -> {
            List methods = model.getMethods();
            Assert.assertEquals((long)1L, (long)methods.size());
            MethodInfo mi1 = (MethodInfo)methods.get(0);
            this.checkMethod(mi1, "method", 1, "void", MethodKind.FUTURE, new ClassTestBase.MethodCheck[0]);
            Assert.assertFalse((boolean)((ParamInfo)mi1.getParams().get(0)).isNullableCallback());
        }, MethodWithNullableNonAnnotatedTypeVariableHandlerAsyncResult.class, new Class[0]);
    }

    @Test
    public void testMethodWithOverloadedNullableParam() throws Exception {
        this.generateClass(model -> {
            List methods = model.getMethods();
            Assert.assertEquals((long)2L, (long)methods.size());
            MethodInfo mi1 = (MethodInfo)methods.get(0);
            this.checkMethod(mi1, "method", 2, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            Assert.assertEquals((Object)ClassKind.STRING, (Object)((ParamInfo)mi1.getParams().get(0)).getType().getKind());
            this.checkParam((ParamInfo)mi1.getParams().get(0), "s", (Type)((Object)String.class));
            Assert.assertTrue((boolean)((ParamInfo)mi1.getParams().get(0)).isNullable());
            this.checkParam((ParamInfo)mi1.getParams().get(1), "i", (Type)((Object)Integer.class));
            Assert.assertFalse((boolean)((ParamInfo)mi1.getParams().get(1)).isNullable());
            MethodInfo mi2 = (MethodInfo)methods.get(1);
            this.checkMethod(mi2, "method", 2, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkParam((ParamInfo)mi2.getParams().get(0), "i", (Type)((Object)Integer.class));
            Assert.assertFalse((boolean)((ParamInfo)mi2.getParams().get(0)).isNullable());
            this.checkParam((ParamInfo)mi2.getParams().get(1), "s", (Type)((Object)String.class));
            Assert.assertTrue((boolean)((ParamInfo)mi2.getParams().get(1)).isNullable());
        }, MethodWithOverloadedNullableParam.class, new Class[0]);
    }

    @Test
    public <T> void testMethodWithNullableReturns() throws Exception {
        TypeLiteral typeLiteral = new TypeLiteral<T>(){};
        this.generateClass(model -> {
            List methods = model.getMethods();
            Assert.assertEquals((long)50L, (long)methods.size());
            this.checkMethod((MethodInfo)methods.get(0), "nullableByteReturn", 0, new TypeLiteral<Byte>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(1), "nullableShortReturn", 0, new TypeLiteral<Short>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(2), "nullableIntegerReturn", 0, new TypeLiteral<Integer>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(3), "nullableLongReturn", 0, new TypeLiteral<Long>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(4), "nullableFloatReturn", 0, new TypeLiteral<Float>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(5), "nullableDoubleReturn", 0, new TypeLiteral<Double>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(6), "nullableCharacterReturn", 0, new TypeLiteral<Character>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(7), "nullableStringReturn", 0, new TypeLiteral<String>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(8), "nullableJsonObjectReturn", 0, new TypeLiteral<JsonObject>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(9), "nullableJsonArrayReturn", 0, new TypeLiteral<JsonArray>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(10), "nullableTypeVariableReturn", 0, typeLiteral, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(11), "nullableEnumReturn", 0, new TypeLiteral<TestEnum>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(12), "nullableDataObjectReturn", 0, new TypeLiteral<TestDataObject>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(13), "nullableApiReturn", 0, new TypeLiteral<VertxGenClass1>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(14), "nullableListByteReturn", 0, new TypeLiteral<List<Byte>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(15), "nullableListShortReturn", 0, new TypeLiteral<List<Short>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(16), "nullableListIntegerReturn", 0, new TypeLiteral<List<Integer>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(17), "nullableListLongReturn", 0, new TypeLiteral<List<Long>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(18), "nullableListFloatReturn", 0, new TypeLiteral<List<Float>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(19), "nullableListDoubleReturn", 0, new TypeLiteral<List<Double>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(20), "nullableListCharacterReturn", 0, new TypeLiteral<List<Character>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(21), "nullableListStringReturn", 0, new TypeLiteral<List<String>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(22), "nullableListJsonObjectReturn", 0, new TypeLiteral<List<JsonObject>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(23), "nullableListJsonArrayReturn", 0, new TypeLiteral<List<JsonArray>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(24), "nullableListEnumReturn", 0, new TypeLiteral<List<TestEnum>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(25), "nullableListDataObjectReturn", 0, new TypeLiteral<List<TestDataObject>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(26), "nullableListApiReturn", 0, new TypeLiteral<List<VertxGenClass1>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(27), "nullableSetByteReturn", 0, new TypeLiteral<Set<Byte>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(28), "nullableSetShortReturn", 0, new TypeLiteral<Set<Short>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(29), "nullableSetIntegerReturn", 0, new TypeLiteral<Set<Integer>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(30), "nullableSetLongReturn", 0, new TypeLiteral<Set<Long>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(31), "nullableSetFloatReturn", 0, new TypeLiteral<Set<Float>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(32), "nullableSetDoubleReturn", 0, new TypeLiteral<Set<Double>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(33), "nullableSetCharacterReturn", 0, new TypeLiteral<Set<Character>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(34), "nullableSetStringReturn", 0, new TypeLiteral<Set<String>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(35), "nullableSetJsonObjectReturn", 0, new TypeLiteral<Set<JsonObject>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(36), "nullableSetJsonArrayReturn", 0, new TypeLiteral<Set<JsonArray>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(37), "nullableSetEnumReturn", 0, new TypeLiteral<Set<TestEnum>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(38), "nullableSetDataObjectReturn", 0, new TypeLiteral<Set<TestDataObject>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(39), "nullableSetApiReturn", 0, new TypeLiteral<Set<VertxGenClass1>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(40), "nullableMapByteReturn", 0, new TypeLiteral<Map<String, Byte>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(41), "nullableMapShortReturn", 0, new TypeLiteral<Map<String, Short>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(42), "nullableMapIntegerReturn", 0, new TypeLiteral<Map<String, Integer>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(43), "nullableMapLongReturn", 0, new TypeLiteral<Map<String, Long>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(44), "nullableMapFloatReturn", 0, new TypeLiteral<Map<String, Float>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(45), "nullableMapDoubleReturn", 0, new TypeLiteral<Map<String, Double>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(46), "nullableMapCharacterReturn", 0, new TypeLiteral<Map<String, Character>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(47), "nullableMapStringReturn", 0, new TypeLiteral<Map<String, String>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(48), "nullableMapJsonObjectReturn", 0, new TypeLiteral<Map<String, JsonObject>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            this.checkMethod((MethodInfo)methods.get(49), "nullableMapJsonArrayReturn", 0, new TypeLiteral<Map<String, JsonArray>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            methods.forEach(m -> Assert.assertTrue((String)("Expects " + m.getName() + " to have nullable return type"), (boolean)m.isNullableReturn()));
        }, MethodWithNullableReturns.class, new Class[0]);
    }

    @Test
    public void testMethodWithNullableTypeArgReturn() throws Exception {
        ClassModel model = new Generator().generateClass(MethodWithNullableTypeArgReturn.class, new Class[0]);
        List methods = model.getMethods();
        Assert.assertEquals((long)36L, (long)methods.size());
        this.checkMethod((MethodInfo)methods.get(0), "listNullableByteReturn", 0, new TypeLiteral<List<Byte>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(1), "listNullableShortReturn", 0, new TypeLiteral<List<Short>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(2), "listNullableIntegerReturn", 0, new TypeLiteral<List<Integer>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(3), "listNullableLongReturn", 0, new TypeLiteral<List<Long>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(4), "listNullableFloatReturn", 0, new TypeLiteral<List<Float>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(5), "listNullableDoubleReturn", 0, new TypeLiteral<List<Double>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(6), "listNullableCharacterReturn", 0, new TypeLiteral<List<Character>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(7), "listNullableStringReturn", 0, new TypeLiteral<List<String>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(8), "listNullableJsonObjectReturn", 0, new TypeLiteral<List<JsonObject>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(9), "listNullableJsonArrayReturn", 0, new TypeLiteral<List<JsonArray>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(10), "listNullableEnumReturn", 0, new TypeLiteral<List<TestEnum>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(11), "listNullableDataObjectReturn", 0, new TypeLiteral<List<TestDataObject>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(12), "listNullableApiReturn", 0, new TypeLiteral<List<VertxGenClass1>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(13), "setNullableByteReturn", 0, new TypeLiteral<Set<Byte>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(14), "setNullableShortReturn", 0, new TypeLiteral<Set<Short>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(15), "setNullableIntegerReturn", 0, new TypeLiteral<Set<Integer>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(16), "setNullableLongReturn", 0, new TypeLiteral<Set<Long>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(17), "setNullableFloatReturn", 0, new TypeLiteral<Set<Float>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(18), "setNullableDoubleReturn", 0, new TypeLiteral<Set<Double>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(19), "setNullableCharacterReturn", 0, new TypeLiteral<Set<Character>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(20), "setNullableStringReturn", 0, new TypeLiteral<Set<String>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(21), "setNullableJsonObjectReturn", 0, new TypeLiteral<Set<JsonObject>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(22), "setNullableJsonArrayReturn", 0, new TypeLiteral<Set<JsonArray>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(23), "setNullableEnumReturn", 0, new TypeLiteral<Set<TestEnum>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(24), "setNullableDataObjectReturn", 0, new TypeLiteral<Set<TestDataObject>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(25), "setNullableApiReturn", 0, new TypeLiteral<Set<VertxGenClass1>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(26), "mapNullableByteReturn", 0, new TypeLiteral<Map<String, Byte>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(27), "mapNullableShortReturn", 0, new TypeLiteral<Map<String, Short>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(28), "mapNullableIntegerReturn", 0, new TypeLiteral<Map<String, Integer>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(29), "mapNullableLongReturn", 0, new TypeLiteral<Map<String, Long>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(30), "mapNullableFloatReturn", 0, new TypeLiteral<Map<String, Float>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(31), "mapNullableDoubleReturn", 0, new TypeLiteral<Map<String, Double>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(32), "mapNullableCharacterReturn", 0, new TypeLiteral<Map<String, Character>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(33), "mapNullableStringReturn", 0, new TypeLiteral<Map<String, String>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(34), "mapNullableJsonObjectReturn", 0, new TypeLiteral<Map<String, JsonObject>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkMethod((MethodInfo)methods.get(35), "mapNullableJsonArrayReturn", 0, new TypeLiteral<Map<String, JsonArray>>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        methods.forEach(m -> {
            Assert.assertFalse((String)("Expects " + m.getName() + " to have nullable return type"), (boolean)m.isNullableReturn());
            List args = ((ParameterizedTypeInfo)m.getReturnType()).getArgs();
            Assert.assertTrue((String)("Expects " + m.getName() + " to have nullable return type"), (boolean)((TypeInfo)args.get(args.size() - 1)).isNullable());
        });
    }

    @Test
    public void testInterfaceWithNullableReturnOverride() throws Exception {
        this.generateClass(model -> {
            List methods = model.getMethods();
            Assert.assertEquals((long)1L, (long)methods.size());
            MethodInfo mi3 = (MethodInfo)methods.get(0);
            Assert.assertTrue((boolean)mi3.getReturnType().isNullable());
        }, InterfaceWithNullableReturnOverride.class, InterfaceWithNullableReturnMethod.class);
    }

    @Test
    public void testDiamondFluentNullableReturn() throws Exception {
        ClassModel model = new Generator().generateClass(DiamondGenericBottomFluentNullableParam.class, new Class[0]);
    }

    @Test
    public void testMethodWithNullableTypeVariableReturn() throws Exception {
        this.generateClass(model -> {
            List methods = model.getMethods();
            Assert.assertEquals((long)1L, (long)methods.size());
            MethodInfo mi1 = (MethodInfo)methods.get(0);
            this.checkMethod(mi1, "method", 0, "T", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            Assert.assertTrue((boolean)mi1.isNullableReturn());
        }, MethodWithNullableTypeVariableReturn.class, new Class[0]);
    }

    @Test
    public void testMethodWithNullableNonAnnotatedTypeVariableReturn() throws Exception {
        this.generateClass(model -> {
            List methods = model.getMethods();
            Assert.assertEquals((long)1L, (long)methods.size());
            MethodInfo mi1 = (MethodInfo)methods.get(0);
            this.checkMethod(mi1, "method", 0, "T", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
            Assert.assertFalse((boolean)mi1.isNullableReturn());
        }, MethodWithNullableNonAnnotatedTypeVariableReturn.class, new Class[0]);
    }

    private void generateClass(Consumer<ClassModel> test, Class<?> clazz, Class<?> ... rest) throws Exception {
        ClassNullableTest.blacklist(() -> {
            try {
                test.accept(new Generator().generateClass(clazz, new Class[0]));
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }, Stream.of(clazz));
        ClassNullableTest.blacklist(() -> {
            try {
                test.accept(new Generator().generateClass(clazz, rest));
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }, Stream.concat(Stream.of(clazz), Stream.of(rest)));
    }

    @Override
    void assertGenInvalid(Class<?> c, Class<?> ... rest) throws Exception {
        ClassNullableTest.blacklist(() -> {
            try {
                ClassNullableTest.super.assertGenInvalid(c, rest);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }, Stream.concat(Stream.of(c), Stream.of(rest)));
    }
}

