/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.testmodel;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.testmodel.TestDataObject;
import io.vertx.codegen.testmodel.TestEnum;
import io.vertx.codegen.testmodel.TestGenEnum;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

@DataObject
public class DataObjectWithLists {
    List<Short> shortValues = new ArrayList<Short>();
    List<Integer> integerValues = new ArrayList<Integer>();
    List<Long> longValues = new ArrayList<Long>();
    List<Float> floatValues = new ArrayList<Float>();
    List<Double> doubleValues = new ArrayList<Double>();
    List<Boolean> booleanValues = new ArrayList<Boolean>();
    List<String> stringValues = new ArrayList<String>();
    List<JsonObject> jsonObjectValues = new ArrayList<JsonObject>();
    List<JsonArray> jsonArrayValues = new ArrayList<JsonArray>();
    List<TestDataObject> dataObjectValues = new ArrayList<TestDataObject>();
    List<TestEnum> enumValues = new ArrayList<TestEnum>();
    List<TestGenEnum> genEnumValues = new ArrayList<TestGenEnum>();

    private static <T> JsonArray toArray(List<T> list) {
        JsonArray array = new JsonArray();
        array.getList().addAll(list);
        return array;
    }

    private static <T> List<T> fromArray(JsonObject obj, String name) {
        return DataObjectWithLists.fromArray(obj, name, o -> o);
    }

    private static <T> List<T> fromArray(JsonObject obj, String name, Function<Object, T> converter) {
        JsonArray array = obj.getJsonArray(name);
        if (array != null) {
            return array.stream().map(converter).collect(Collectors.toList());
        }
        return null;
    }

    public DataObjectWithLists() {
    }

    public DataObjectWithLists(DataObjectWithLists that) {
        throw new UnsupportedOperationException("not used");
    }

    public DataObjectWithLists(JsonObject json) {
        this.booleanValues = DataObjectWithLists.fromArray(json, "booleanValues");
        this.shortValues = DataObjectWithLists.fromArray(json, "shortValues", o -> Short.parseShort(o.toString()));
        this.integerValues = DataObjectWithLists.fromArray(json, "integerValues");
        this.longValues = DataObjectWithLists.fromArray(json, "longValues", o -> Long.parseLong(o.toString()));
        this.floatValues = DataObjectWithLists.fromArray(json, "floatValues", o -> Float.valueOf(Float.parseFloat(o.toString())));
        this.doubleValues = DataObjectWithLists.fromArray(json, "doubleValues");
        this.stringValues = DataObjectWithLists.fromArray(json, "stringValues");
        this.jsonObjectValues = DataObjectWithLists.fromArray(json, "jsonObjectValues", o -> (JsonObject)o);
        this.jsonArrayValues = DataObjectWithLists.fromArray(json, "jsonArrayValues", o -> (JsonArray)o);
        this.dataObjectValues = DataObjectWithLists.fromArray(json, "dataObjectValues", o -> new TestDataObject((JsonObject)o));
        this.enumValues = DataObjectWithLists.fromArray(json, "enumValues", o -> TestEnum.valueOf(o.toString()));
        this.genEnumValues = DataObjectWithLists.fromArray(json, "genEnumValues", o -> TestGenEnum.valueOf(o.toString()));
    }

    public DataObjectWithLists setShortValues(List<Short> shortValues) {
        this.shortValues = shortValues;
        return this;
    }

    public DataObjectWithLists setIntegerValues(List<Integer> integerValues) {
        this.integerValues = integerValues;
        return this;
    }

    public DataObjectWithLists setLongValues(List<Long> longValues) {
        this.longValues = longValues;
        return this;
    }

    public DataObjectWithLists setFloatValues(List<Float> floatValues) {
        this.floatValues = floatValues;
        return this;
    }

    public DataObjectWithLists setDoubleValues(List<Double> doubleValues) {
        this.doubleValues = doubleValues;
        return this;
    }

    public DataObjectWithLists setBooleanValues(List<Boolean> booleanValues) {
        this.booleanValues = booleanValues;
        return this;
    }

    public DataObjectWithLists setStringValues(List<String> stringValue) {
        this.stringValues = stringValue;
        return this;
    }

    public DataObjectWithLists setEnumValues(List<TestEnum> enumValues) {
        this.enumValues = enumValues;
        return this;
    }

    public DataObjectWithLists setGenEnumValues(List<TestGenEnum> genEnumValues) {
        this.genEnumValues = genEnumValues;
        return this;
    }

    public DataObjectWithLists setDataObjectValues(List<TestDataObject> dataObjectValues) {
        this.dataObjectValues = dataObjectValues;
        return this;
    }

    public DataObjectWithLists setJsonObjectValues(List<JsonObject> jsonObjectValues) {
        this.jsonObjectValues = jsonObjectValues;
        return this;
    }

    public DataObjectWithLists setJsonArrayValues(List<JsonArray> jsonArrayValues) {
        this.jsonArrayValues = jsonArrayValues;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.booleanValues != null) {
            json.put("booleanValues", DataObjectWithLists.toArray(this.booleanValues));
        }
        if (this.shortValues != null) {
            json.put("shortValues", DataObjectWithLists.toArray(this.shortValues));
        }
        if (this.integerValues != null) {
            json.put("integerValues", DataObjectWithLists.toArray(this.integerValues));
        }
        if (this.longValues != null) {
            json.put("longValues", DataObjectWithLists.toArray(this.longValues));
        }
        if (this.floatValues != null) {
            json.put("floatValues", DataObjectWithLists.toArray(this.floatValues));
        }
        if (this.doubleValues != null) {
            json.put("doubleValues", DataObjectWithLists.toArray(this.doubleValues));
        }
        if (this.stringValues != null) {
            json.put("stringValues", DataObjectWithLists.toArray(this.stringValues));
        }
        if (this.jsonObjectValues != null) {
            json.put("jsonObjectValues", DataObjectWithLists.toArray(this.jsonObjectValues));
        }
        if (this.jsonArrayValues != null) {
            json.put("jsonArrayValues", DataObjectWithLists.toArray(this.jsonArrayValues));
        }
        if (this.dataObjectValues != null) {
            json.put("dataObjectValues", DataObjectWithLists.toArray(this.dataObjectValues.stream().map(o -> o.toJson().getMap()).collect(Collectors.toList())));
        }
        if (this.enumValues != null) {
            json.put("enumValues", DataObjectWithLists.toArray(this.enumValues));
        }
        if (this.genEnumValues != null) {
            json.put("genEnumValues", DataObjectWithLists.toArray(this.genEnumValues));
        }
        return json;
    }
}

