/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Context;
import io.tiledb.java.api.TileDBError;
import io.tiledb.java.api.TileDBObjectType;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_object_t;
import io.tiledb.libtiledb.tiledb;

public class TileDBObject {
    private final Context ctx;
    private TileDBObjectType type;
    private String uri;

    public TileDBObject(Context ctx, String uri) throws TileDBError {
        SWIGTYPE_p_tiledb_object_t typep = tiledb.new_tiledb_object_tp();
        try {
            ctx.handleError(tiledb.tiledb_object_type(ctx.getCtxp(), uri, typep));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_object_tp(typep);
            throw err;
        }
        this.uri = uri;
        this.ctx = ctx;
        this.type = TileDBObjectType.fromSwigEnum(tiledb.tiledb_object_tp_value(typep));
        tiledb.delete_tiledb_object_tp(typep);
    }

    protected TileDBObject(Context ctx, String uri, TileDBObjectType type) {
        this.ctx = ctx;
        this.uri = uri;
        this.type = type;
    }

    public static void remove(Context ctx, String uri) throws TileDBError {
        ctx.handleError(tiledb.tiledb_object_remove(ctx.getCtxp(), uri));
    }

    public static void move(Context ctx, String old_uri, String new_uri) throws TileDBError {
        ctx.handleError(tiledb.tiledb_object_move(ctx.getCtxp(), old_uri, new_uri));
    }

    public String toString() {
        String ret = "Obj<";
        switch (this.type) {
            case TILEDB_ARRAY: {
                ret = ret + "ARRAY";
                break;
            }
            case TILEDB_GROUP: {
                ret = ret + "GROUP";
                break;
            }
            case TILEDB_INVALID: {
                ret = ret + "INVALID";
                break;
            }
            case TILEDB_KEY_VALUE: {
                ret = ret + "KEYVALUE";
            }
        }
        ret = ret + " \"" + this.uri + "\">";
        return ret;
    }

    public TileDBObjectType getType() {
        return this.type;
    }

    public String getUri() {
        return this.uri;
    }
}

