/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Array;
import io.tiledb.java.api.ArraySchema;
import io.tiledb.java.api.Attribute;
import io.tiledb.java.api.Callback;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.Domain;
import io.tiledb.java.api.Layout;
import io.tiledb.java.api.NativeArray;
import io.tiledb.java.api.Pair;
import io.tiledb.java.api.QueryStatus;
import io.tiledb.java.api.QueryType;
import io.tiledb.java.api.TileDBError;
import io.tiledb.java.api.Types;
import io.tiledb.libtiledb.PointerUtils;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_query_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_query_status_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_query_t;
import io.tiledb.libtiledb.Utils;
import io.tiledb.libtiledb.tiledb;
import io.tiledb.libtiledb.uint64_tArray;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class Query
implements AutoCloseable {
    private Context ctx;
    private Array array;
    private QueryType type;
    private SWIGTYPE_p_p_tiledb_query_t querypp;
    private SWIGTYPE_p_tiledb_query_t queryp;
    private NativeArray subarray;
    private HashMap<String, NativeArray> buffers_;
    private HashMap<String, Pair<NativeArray, NativeArray>> var_buffers_;
    private HashMap<String, Pair<uint64_tArray, uint64_tArray>> buffer_sizes_;

    public Query(Array array, QueryType type) throws TileDBError {
        Context _ctx = array.getCtx();
        SWIGTYPE_p_p_tiledb_query_t _querypp = tiledb.new_tiledb_query_tpp();
        try {
            _ctx.handleError(tiledb.tiledb_query_alloc(_ctx.getCtxp(), array.getArrayp(), type.toSwigEnum(), _querypp));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_query_tpp(_querypp);
            throw err;
        }
        this.ctx = _ctx;
        this.type = type;
        this.array = array;
        this.querypp = _querypp;
        this.queryp = tiledb.tiledb_query_tpp_value(_querypp);
        this.buffers_ = new HashMap();
        this.var_buffers_ = new HashMap();
        this.buffer_sizes_ = new HashMap();
    }

    public Query(Array array) throws TileDBError {
        this(array, array.getQueryType());
    }

    public Query setLayout(Layout layout) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_query_set_layout(this.ctx.getCtxp(), this.queryp, layout.toSwigEnum()));
        return this;
    }

    public QueryStatus getQueryStatus() throws TileDBError {
        QueryStatus status;
        SWIGTYPE_p_tiledb_query_status_t statusp = tiledb.new_tiledb_query_status_tp();
        try {
            this.ctx.handleError(tiledb.tiledb_query_get_status(this.ctx.getCtxp(), this.queryp, statusp));
            status = QueryStatus.fromSwigEnum(tiledb.tiledb_query_status_tp_value(statusp));
        }
        finally {
            tiledb.delete_tiledb_query_status_tp(statusp);
        }
        return status;
    }

    public QueryStatus submit() throws TileDBError {
        this.prepareSubmission();
        this.ctx.handleError(tiledb.tiledb_query_submit(this.ctx.getCtxp(), this.queryp));
        return this.getQueryStatus();
    }

    public void submitAsync() throws TileDBError {
        this.submitAsync(new DefaultCallback());
    }

    public void submitAsync(Callback callback) throws TileDBError {
        this.prepareSubmission();
        this.ctx.handleError(Utils.tiledb_query_submit_async(this.ctx.getCtxp(), this.queryp, callback));
    }

    public Query setSubarray(NativeArray subarray) throws TileDBError {
        Types.typeCheck(subarray.getNativeType(), this.array.getSchema().getDomain().getType());
        this.ctx.handleError(tiledb.tiledb_query_set_subarray(this.ctx.getCtxp(), this.queryp, subarray.toVoidPointer()));
        if (this.subarray != null) {
            this.subarray.close();
        }
        this.subarray = subarray;
        return this;
    }

    public Query setBuffer(String attr, NativeArray buffer) throws TileDBError {
        block20: {
            try (ArraySchema schema = this.array.getSchema();){
                if (attr.equals(tiledb.tiledb_coords())) {
                    try (Domain domain = schema.getDomain();){
                        Types.typeCheck(domain.getType(), buffer.getNativeType());
                        break block20;
                    }
                }
                try (Attribute attribute = schema.getAttribute(attr);){
                    Types.typeCheck(attribute.getType(), buffer.getNativeType());
                }
            }
        }
        Pair<uint64_tArray, uint64_tArray> buffer_sizes = new Pair<uint64_tArray, uint64_tArray>(new uint64_tArray(1), new uint64_tArray(1));
        buffer_sizes.getFirst().setitem(0, BigInteger.valueOf(0L));
        buffer_sizes.getSecond().setitem(0, BigInteger.valueOf(buffer.getNBytes()));
        if (this.buffers_.containsKey(attr)) {
            this.buffers_.get(attr).close();
        }
        this.buffers_.put(attr, buffer);
        this.buffer_sizes_.put(attr, buffer_sizes);
        return this;
    }

    public Query setBuffer(String attr, NativeArray offsets, NativeArray buffer) throws TileDBError {
        if (attr.equals(tiledb.tiledb_coords())) {
            throw new TileDBError("Cannot set coordinate buffer as variable sized.");
        }
        if (!offsets.getNativeType().equals((Object)Datatype.TILEDB_UINT64)) {
            throw new TileDBError("Buffer offsets should be of getType TILEDB_UINT64 or Long. Found getType: " + (Object)((Object)offsets.getNativeType()));
        }
        try (ArraySchema schema = this.array.getSchema();
             Attribute attribute = schema.getAttribute(attr);){
            Types.typeCheck(attribute.getType(), buffer.getNativeType());
        }
        Pair<uint64_tArray, uint64_tArray> buffer_sizes = new Pair<uint64_tArray, uint64_tArray>(new uint64_tArray(1), new uint64_tArray(1));
        buffer_sizes.getFirst().setitem(0, BigInteger.valueOf(offsets.getNBytes()));
        buffer_sizes.getSecond().setitem(0, BigInteger.valueOf(buffer.getNBytes()));
        if (this.var_buffers_.containsKey(attr)) {
            Pair<NativeArray, NativeArray> prev_buffers = this.var_buffers_.get(attr);
            prev_buffers.getFirst().close();
            prev_buffers.getSecond().close();
        }
        this.var_buffers_.put(attr, new Pair<NativeArray, NativeArray>(offsets, buffer));
        this.buffer_sizes_.put(attr, buffer_sizes);
        return this;
    }

    public Query setCoordinates(NativeArray buffer) throws TileDBError {
        this.setBuffer(tiledb.tiledb_coords(), buffer);
        return this;
    }

    public Object getCoordinates() throws TileDBError {
        return this.getBuffer(tiledb.tiledb_coords());
    }

    public HashMap<String, Pair<Long, Long>> resultBufferElements() throws TileDBError {
        String name;
        HashMap<String, Pair<Long, Long>> result = new HashMap<String, Pair<Long, Long>>();
        for (Map.Entry<String, NativeArray> entry : this.buffers_.entrySet()) {
            name = entry.getKey();
            NativeArray val_buffer = entry.getValue();
            BigInteger val_nbytes = this.buffer_sizes_.get(name).getSecond().getitem(0);
            Long nelements = val_nbytes.divide(BigInteger.valueOf(val_buffer.getNativeTypeSize())).longValue();
            result.put(name, new Pair<Long, Long>(0L, nelements));
        }
        for (Map.Entry<String, Object> entry : this.var_buffers_.entrySet()) {
            name = entry.getKey();
            Pair<uint64_tArray, uint64_tArray> buffer_size = this.buffer_sizes_.get(name);
            NativeArray off_buffer = (NativeArray)((Pair)entry.getValue()).getFirst();
            BigInteger off_nbytes = buffer_size.getFirst().getitem(0);
            Long off_nelements = off_nbytes.divide(BigInteger.valueOf(off_buffer.getNativeTypeSize())).longValue();
            NativeArray val_buffer = (NativeArray)((Pair)entry.getValue()).getSecond();
            BigInteger val_nbytes = buffer_size.getSecond().getitem(0);
            Long val_nelements = val_nbytes.divide(BigInteger.valueOf(val_buffer.getNativeTypeSize())).longValue();
            result.put(name, new Pair<Long, Long>(off_nelements, val_nelements));
        }
        return result;
    }

    public void resetBuffers() {
        for (NativeArray nativeArray : this.buffers_.values()) {
            nativeArray.close();
        }
        this.buffers_.clear();
        for (Pair pair : this.var_buffers_.values()) {
            ((NativeArray)pair.getFirst()).close();
            ((NativeArray)pair.getSecond()).close();
        }
        this.var_buffers_.clear();
        for (Pair pair : this.buffer_sizes_.values()) {
            ((uint64_tArray)pair.getFirst()).delete();
            ((uint64_tArray)pair.getSecond()).delete();
        }
        this.buffer_sizes_.clear();
    }

    public void resetBufferSizes() {
        BigInteger zero = BigInteger.valueOf(0L);
        for (Pair<uint64_tArray, uint64_tArray> size_pair : this.buffer_sizes_.values()) {
            size_pair.getFirst().setitem(0, zero);
            size_pair.getSecond().setitem(0, zero);
        }
    }

    private void prepareSubmission() throws TileDBError {
        Object buffer_size;
        String name;
        for (Map.Entry<String, NativeArray> entry : this.buffers_.entrySet()) {
            name = entry.getKey();
            NativeArray buffer = entry.getValue();
            Pair<uint64_tArray, uint64_tArray> buffer_sizes = this.buffer_sizes_.get(name);
            buffer_sizes.getFirst().setitem(0, BigInteger.valueOf(0L));
            buffer_sizes.getSecond().setitem(0, BigInteger.valueOf(buffer.getNBytes()));
            buffer_size = buffer_sizes.getSecond();
            this.ctx.handleError(tiledb.tiledb_query_set_buffer(this.ctx.getCtxp(), this.queryp, name, buffer.toVoidPointer(), ((uint64_tArray)buffer_size).cast()));
        }
        for (Map.Entry<String, Object> entry : this.var_buffers_.entrySet()) {
            name = entry.getKey();
            NativeArray off_buffer = (NativeArray)((Pair)entry.getValue()).getFirst();
            NativeArray val_buffer = (NativeArray)((Pair)entry.getValue()).getSecond();
            buffer_size = this.buffer_sizes_.get(name);
            ((Pair)buffer_size).getFirst().setitem(0, BigInteger.valueOf(off_buffer.getNBytes()));
            ((uint64_tArray)((Pair)buffer_size).getSecond()).setitem(0, BigInteger.valueOf(val_buffer.getNBytes()));
            uint64_tArray offsets = PointerUtils.uint64_tArrayFromVoid(off_buffer.toVoidPointer());
            uint64_tArray off_size = (uint64_tArray)((Pair)buffer_size).getFirst();
            uint64_tArray val_size = (uint64_tArray)((Pair)buffer_size).getSecond();
            this.ctx.handleError(tiledb.tiledb_query_set_buffer_var(this.ctx.getCtxp(), this.queryp, name, offsets.cast(), off_size.cast(), val_buffer.toVoidPointer(), val_size.cast()));
        }
    }

    public Object getBuffer(String attr) throws TileDBError {
        if (this.buffers_.containsKey(attr)) {
            NativeArray buffer = this.buffers_.get(attr);
            Integer nelements = this.buffer_sizes_.get(attr).getSecond().getitem(0).divide(BigInteger.valueOf(buffer.getNativeTypeSize())).intValue();
            return buffer.toJavaArray(nelements);
        }
        if (this.var_buffers_.containsKey(attr)) {
            NativeArray buffer = this.var_buffers_.get(attr).getSecond();
            Integer nelements = this.buffer_sizes_.get(attr).getSecond().getitem(0).divide(BigInteger.valueOf(buffer.getNativeTypeSize())).intValue();
            return buffer.toJavaArray(nelements);
        }
        throw new TileDBError("Query attribute buffer does not exist: " + attr);
    }

    public long[] getVarBuffer(String attr) throws TileDBError {
        if (!this.var_buffers_.containsKey(attr)) {
            throw new TileDBError("Query variable attribute buffer does not exist: " + attr);
        }
        NativeArray buffer = this.var_buffers_.get(attr).getFirst();
        Integer nelements = this.buffer_sizes_.get(attr).getFirst().getitem(0).divide(BigInteger.valueOf(buffer.getNativeTypeSize())).intValue();
        return (long[])buffer.toJavaArray(nelements);
    }

    public Query finalizeQuery() throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_query_finalize(this.ctx.getCtxp(), this.queryp));
        return this;
    }

    public String toString() {
        switch (this.type) {
            case TILEDB_READ: {
                return "READ";
            }
            case TILEDB_WRITE: {
                return "WRITE";
            }
        }
        return "";
    }

    @Override
    public void close() {
        if (this.queryp != null) {
            for (Pair<uint64_tArray, uint64_tArray> pair : this.buffer_sizes_.values()) {
                pair.getFirst().delete();
                pair.getSecond().delete();
            }
            for (NativeArray nativeArray : this.buffers_.values()) {
                nativeArray.close();
            }
            for (Pair pair : this.var_buffers_.values()) {
                ((NativeArray)pair.getFirst()).close();
                ((NativeArray)pair.getSecond()).close();
            }
            if (this.subarray != null) {
                this.subarray.close();
            }
            tiledb.tiledb_query_free(this.querypp);
            this.queryp = null;
        }
    }

    private static class DefaultCallback
    implements Callback {
        @Override
        public void call() {
        }
    }
}

