/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Config;
import io.tiledb.java.api.ContextCallback;
import io.tiledb.java.api.Filesystem;
import io.tiledb.java.api.TileDBError;
import io.tiledb.libtiledb.SWIGTYPE_p_int;
import io.tiledb.libtiledb.SWIGTYPE_p_p_char;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_ctx_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_error_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_ctx_t;
import io.tiledb.libtiledb.tiledb;

public class Context
implements AutoCloseable {
    private SWIGTYPE_p_p_tiledb_ctx_t ctxpp;
    private SWIGTYPE_p_tiledb_ctx_t ctxp;
    private Config config;
    private ContextCallback errorHandler;

    public Context() throws TileDBError {
        this.createContext(new Config());
    }

    public Context(Config config) throws TileDBError {
        this.createContext(config);
    }

    public void setErrorHandler(ContextCallback errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void handleError(int rc) throws TileDBError {
        if (rc == 0) {
            return;
        }
        SWIGTYPE_p_p_tiledb_error_t errorpp = tiledb.new_tiledb_error_tpp();
        rc = tiledb.tiledb_ctx_get_last_error(this.ctxp, errorpp);
        if (rc != 0) {
            tiledb.tiledb_error_free(errorpp);
            tiledb.delete_tiledb_error_tpp(errorpp);
            this.errorHandler.call("[TileDB::JavaAPI] Error: Non-retrievable error occurred");
        }
        SWIGTYPE_p_p_char msgpp = tiledb.new_charpp();
        rc = tiledb.tiledb_error_message(tiledb.tiledb_error_tpp_value(errorpp), msgpp);
        String msg = tiledb.charpp_value(msgpp);
        if (rc != 0) {
            tiledb.tiledb_error_free(errorpp);
            tiledb.delete_tiledb_error_tpp(errorpp);
            this.errorHandler.call("[TileDB::JavaAPI] Error: Non-retrievable error occurred");
        }
        tiledb.tiledb_error_free(errorpp);
        tiledb.delete_tiledb_error_tpp(errorpp);
        this.errorHandler.call(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSupportedFs(Filesystem fs) throws TileDBError {
        boolean isSupported;
        SWIGTYPE_p_int ret = tiledb.new_intp();
        try {
            this.handleError(tiledb.tiledb_ctx_is_supported_fs(this.ctxp, fs.toSwigEnum(), ret));
            isSupported = tiledb.intp_value(ret) != 0;
        }
        finally {
            tiledb.delete_intp(ret);
        }
        return isSupported;
    }

    private void createContext(Config config) throws TileDBError {
        SWIGTYPE_p_p_tiledb_ctx_t _ctxpp = tiledb.new_tiledb_ctx_tpp();
        if (tiledb.tiledb_ctx_alloc(config.getConfigp(), _ctxpp) != 0) {
            tiledb.delete_tiledb_ctx_tpp(_ctxpp);
            throw new TileDBError("[TileDB::JavaAPI] Error: Failed to create context");
        }
        this.ctxpp = _ctxpp;
        this.ctxp = tiledb.tiledb_ctx_tpp_value(_ctxpp);
        this.config = config;
        this.errorHandler = new ContextCallback();
    }

    protected SWIGTYPE_p_tiledb_ctx_t getCtxp() {
        return this.ctxp;
    }

    public Config getConfig() {
        return this.config;
    }

    @Override
    public void close() {
        if (this.ctxp != null) {
            tiledb.tiledb_ctx_free(this.ctxpp);
            this.ctxp = null;
            this.ctxpp = null;
        }
        if (this.config != null) {
            this.config.close();
        }
    }
}

