/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.ArraySchema;
import io.tiledb.java.api.Attribute;
import io.tiledb.java.api.Config;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Dimension;
import io.tiledb.java.api.Domain;
import io.tiledb.java.api.EncryptionType;
import io.tiledb.java.api.NativeArray;
import io.tiledb.java.api.Pair;
import io.tiledb.java.api.QueryType;
import io.tiledb.java.api.TileDBError;
import io.tiledb.java.api.TileDBObjectType;
import io.tiledb.java.api.Types;
import io.tiledb.libtiledb.SWIGTYPE_p_int;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_array_schema_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_array_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_array_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_object_t;
import io.tiledb.libtiledb.tiledb;
import io.tiledb.libtiledb.uint64_tArray;
import java.util.HashMap;

public class Array
implements AutoCloseable {
    private Context ctx;
    private String uri;
    private ArraySchema schema;
    private QueryType query_type;
    private SWIGTYPE_p_tiledb_array_t arrayp;
    private SWIGTYPE_p_p_tiledb_array_t arraypp;

    public Array(Context ctx, String uri) throws TileDBError {
        this.openArray(ctx, uri, QueryType.TILEDB_READ, EncryptionType.TILEDB_NO_ENCRYPTION, new byte[0]);
    }

    public Array(Context ctx, String uri, QueryType query_type) throws TileDBError {
        this.openArray(ctx, uri, query_type, EncryptionType.TILEDB_NO_ENCRYPTION, new byte[0]);
    }

    public Array(Context ctx, String uri, QueryType query_type, EncryptionType encryption_type, byte[] key) throws TileDBError {
        this.openArray(ctx, uri, query_type, encryption_type, key);
    }

    private synchronized void openArray(Context ctx, String uri, QueryType query_type, EncryptionType encryption_type, byte[] key) throws TileDBError {
        ArraySchema _schema;
        SWIGTYPE_p_p_tiledb_array_t _arraypp = tiledb.new_tiledb_array_tpp();
        try {
            ctx.handleError(tiledb.tiledb_array_alloc(ctx.getCtxp(), uri, _arraypp));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_array_tpp(_arraypp);
            throw err;
        }
        SWIGTYPE_p_tiledb_array_t _arrayp = tiledb.tiledb_array_tpp_value(_arraypp);
        try (NativeArray keyArray = new NativeArray(ctx, (Object)key, Byte.class);){
            try {
                ctx.handleError(tiledb.tiledb_array_open_with_key(ctx.getCtxp(), _arrayp, query_type.toSwigEnum(), encryption_type.toSwigEnum(), keyArray.toVoidPointer(), keyArray.getSize()));
            }
            catch (TileDBError err) {
                tiledb.delete_tiledb_array_tpp(_arraypp);
                throw err;
            }
            _schema = new ArraySchema(ctx, uri, encryption_type, key);
        }
        this.ctx = ctx;
        this.uri = uri;
        this.query_type = query_type;
        this.schema = _schema;
        this.arraypp = _arraypp;
        this.arrayp = _arrayp;
    }

    private void checkIsOpen() throws TileDBError {
        if (this.arrayp == null) {
            throw new TileDBError("TileDB Array " + this.uri + " is closed");
        }
    }

    public static void consolidate(Context ctx, String uri) throws TileDBError {
        Array.consolidate(ctx, uri, EncryptionType.TILEDB_NO_ENCRYPTION, new byte[0]);
    }

    public static void consolidate(Context ctx, String uri, Config config) throws TileDBError {
        Array.consolidate(ctx, uri, EncryptionType.TILEDB_NO_ENCRYPTION, new byte[0], config);
    }

    public static void consolidate(Context ctx, String uri, EncryptionType encryption_type, byte[] key) throws TileDBError {
        Array.consolidate(ctx, uri, encryption_type, key, new Config());
    }

    public static void consolidate(Context ctx, String uri, EncryptionType encryption_type, byte[] key, Config config) throws TileDBError {
        try (NativeArray keyArray = new NativeArray(ctx, (Object)key, Byte.class);){
            ctx.handleError(tiledb.tiledb_array_consolidate_with_key(ctx.getCtxp(), uri, encryption_type.toSwigEnum(), keyArray.toVoidPointer(), keyArray.getSize(), config.getConfigp()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(Context ctx, String uri) throws TileDBError {
        TileDBObjectType objtype;
        SWIGTYPE_p_tiledb_object_t objtypep = tiledb.new_tiledb_object_tp();
        try {
            ctx.handleError(tiledb.tiledb_object_type(ctx.getCtxp(), uri, objtypep));
            objtype = TileDBObjectType.fromSwigEnum(tiledb.tiledb_object_tp_value(objtypep));
        }
        finally {
            tiledb.delete_tiledb_object_tp(objtypep);
        }
        return objtype == TileDBObjectType.TILEDB_ARRAY;
    }

    public static void create(String uri, ArraySchema schema) throws TileDBError {
        Context ctx = schema.getCtx();
        ctx.handleError(tiledb.tiledb_array_schema_check(ctx.getCtxp(), schema.getSchemap()));
        ctx.handleError(tiledb.tiledb_array_create(ctx.getCtxp(), uri, schema.getSchemap()));
    }

    public static void create(String uri, ArraySchema schema, EncryptionType encryption_type, byte[] key) throws TileDBError {
        Context ctx = schema.getCtx();
        ctx.handleError(tiledb.tiledb_array_schema_check(ctx.getCtxp(), schema.getSchemap()));
        try (NativeArray keyArray = new NativeArray(ctx, (Object)key, Byte.class);){
            ctx.handleError(tiledb.tiledb_array_create_with_key(ctx.getCtxp(), uri, schema.getSchemap(), encryption_type.toSwigEnum(), keyArray.toVoidPointer(), keyArray.getSize()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Pair> nonEmptyDomain() throws TileDBError {
        this.checkIsOpen();
        HashMap<String, Pair> ret = new HashMap<String, Pair>();
        try (Domain domain = this.schema.getDomain();
             NativeArray domainArray = new NativeArray(this.ctx, 2 * (int)domain.getRank(), domain.getType());){
            SWIGTYPE_p_int emptyp = tiledb.new_intp();
            try {
                this.ctx.handleError(tiledb.tiledb_array_get_non_empty_domain(this.ctx.getCtxp(), this.arrayp, domainArray.toVoidPointer(), emptyp));
                if (tiledb.intp_value(emptyp) == 1) {
                    HashMap<String, Pair> hashMap = ret;
                    return hashMap;
                }
            }
            finally {
                tiledb.delete_intp(emptyp);
            }
            int i = 0;
            while ((long)i < domain.getRank()) {
                try (Dimension d = domain.getDimension(i);){
                    ret.put(d.getName(), new Pair<Object, Object>(domainArray.getItem(2 * i + 0), domainArray.getItem(2 * i + 1)));
                }
                ++i;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Pair<Long, Long>> maxBufferElements(NativeArray subarray) throws TileDBError {
        this.checkIsOpen();
        HashMap<String, Pair<Long, Long>> ret = new HashMap<String, Pair<Long, Long>>();
        uint64_tArray off_nbytes = new uint64_tArray(1);
        uint64_tArray val_nbytes = new uint64_tArray(1);
        try (Domain domain = this.schema.getDomain();){
            Types.typeCheck(subarray.getNativeType(), domain.getType());
            for (long i = 0L; i < this.schema.getAttributeNum(); ++i) {
                try (Attribute attr = this.schema.getAttribute(i);){
                    String attrName = attr.getName();
                    if (attr.isVar()) {
                        this.ctx.handleError(tiledb.tiledb_array_max_buffer_size_var(this.ctx.getCtxp(), this.arrayp, attrName, subarray.toVoidPointer(), off_nbytes.cast(), val_nbytes.cast()));
                        ret.put(attrName, new Pair<Long, Long>(off_nbytes.getitem(0).longValue() / tiledb.tiledb_offset_size().longValue(), val_nbytes.getitem(0).longValue() / tiledb.tiledb_datatype_size(attr.getType().toSwigEnum()).longValue()));
                        continue;
                    }
                    this.ctx.handleError(tiledb.tiledb_array_max_buffer_size(this.ctx.getCtxp(), this.arrayp, attrName, subarray.toVoidPointer(), val_nbytes.cast()));
                    ret.put(attrName, new Pair<Long, Long>(0L, val_nbytes.getitem(0).longValue() / tiledb.tiledb_datatype_size(attr.getType().toSwigEnum()).longValue()));
                    continue;
                }
            }
            this.ctx.handleError(tiledb.tiledb_array_max_buffer_size(this.ctx.getCtxp(), this.arrayp, tiledb.tiledb_coords(), subarray.toVoidPointer(), val_nbytes.cast()));
            ret.put(tiledb.tiledb_coords(), new Pair<Long, Long>(0L, val_nbytes.getitem(0).longValue() / tiledb.tiledb_datatype_size(domain.getType().toSwigEnum()).longValue()));
        }
        finally {
            off_nbytes.delete();
            val_nbytes.delete();
        }
        return ret;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public String getUri() {
        return this.uri;
    }

    public ArraySchema getSchema() throws TileDBError {
        ArraySchema _schema;
        SWIGTYPE_p_p_tiledb_array_schema_t schemapp = tiledb.new_tiledb_array_schema_tpp();
        try {
            this.ctx.handleError(tiledb.tiledb_array_get_schema(this.ctx.getCtxp(), this.getArrayp(), schemapp));
            _schema = new ArraySchema(this.ctx, schemapp);
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_array_schema_tpp(schemapp);
            throw err;
        }
        return _schema;
    }

    public QueryType getQueryType() {
        return this.query_type;
    }

    protected SWIGTYPE_p_tiledb_array_t getArrayp() {
        return this.arrayp;
    }

    @Override
    public synchronized void close() {
        if (this.arrayp != null && this.arraypp != null) {
            tiledb.tiledb_array_close(this.ctx.getCtxp(), this.arrayp);
            tiledb.tiledb_array_free(this.arraypp);
            this.arrayp = null;
            this.arraypp = null;
            if (this.schema != null) {
                this.schema.close();
            }
        }
    }
}

