/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.tcp;

import io.testproject.sdk.internal.exceptions.AgentConnectException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SocketManager {
    private static final int TIMEOUT_MILLISECONDS = 5000;
    private static SocketManager instance;
    private static final Logger LOG;
    private Socket socket;

    private SocketManager() {
    }

    public static SocketManager getInstance() {
        if (instance == null) {
            instance = new SocketManager();
        }
        return instance;
    }

    public void closeSocket() {
        if (this.isOpen()) {
            LOG.debug("Disconnecting TCP development socket...");
            try {
                this.socket.close();
                this.socket = null;
                LOG.debug("Development socket closed");
            }
            catch (IOException e) {
                LOG.error("Failed closing development socket connected to the Agent", (Throwable)e);
            }
        }
    }

    public void openSocket(String host, int port) throws AgentConnectException {
        if (this.socket != null && this.socket.isConnected()) {
            LOG.debug("Development socket is already connected.");
            return;
        }
        try {
            LOG.trace("Connecting to Agent socket: {}:{}", (Object)host, (Object)port);
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(host, port), 5000);
            LOG.debug("Development socket connected");
        }
        catch (IOException e) {
            LOG.error("Failed connecting to Agent socket at {}:{}", new Object[]{host, port, e});
            throw new AgentConnectException("Failed connecting to Agent socket", e);
        }
    }

    public boolean isOpen() {
        return this.socket != null && this.socket.isConnected();
    }

    static {
        LOG = LoggerFactory.getLogger(SocketManager.class);
    }
}

