/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.reporting.inferrers;

import io.testproject.sdk.internal.rest.ReportSettings;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ReportSettingsInferrer {
    public static final Logger LOG = LoggerFactory.getLogger(ReportSettingsInferrer.class);

    public ReportSettings inferReportSettings();

    default public ReportSettings getUnnamedEntries() {
        LOG.info("Failed to infer Project and Job names, will use default 'Unnamed' values.");
        return new ReportSettings("Unnamed Project", "Unnamed Job");
    }

    default public String getPackageName(Class<?> clazz) {
        return StringUtils.isEmpty((CharSequence)clazz.getPackageName()) ? this.getUnnamedEntries().getProjectName() : clazz.getPackageName();
    }

    public String inferTestName();
}

