/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.reporting.inferrers;

import io.testproject.sdk.internal.reporting.inferrers.ReportSettingsInferrer;
import io.testproject.sdk.internal.rest.ReportSettings;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnitInferrer
implements ReportSettingsInferrer {
    private static final Logger LOG = LoggerFactory.getLogger(JUnitInferrer.class);
    private final List<StackTraceElement> traces;

    public JUnitInferrer(List<StackTraceElement> traces) {
        this.traces = traces;
    }

    @Override
    public ReportSettings inferReportSettings() {
        for (StackTraceElement stackTraceElement : this.traces) {
            Class<?> clazz;
            try {
                clazz = Class.forName(stackTraceElement.getClassName());
            }
            catch (ClassNotFoundException e) {
                LOG.error("Failed to create an instance of a class", (Throwable)e);
                return this.getUnnamedEntries();
            }
            Optional<Method> method = Arrays.stream(clazz.getDeclaredMethods()).filter(m -> m.getName().equals(stackTraceElement.getMethodName())).findFirst();
            if (method.isEmpty() || !Arrays.stream(method.get().getDeclaredAnnotations()).anyMatch(a -> a.annotationType().getName().startsWith("org.junit"))) continue;
            ReportSettings result = this.inspectDisplayName(clazz);
            return Objects.requireNonNullElseGet(result, () -> new ReportSettings(this.getPackageName(clazz), clazz.getSimpleName()));
        }
        LOG.warn("Something is wrong... JUnit classes in stack but no annotated methods were found.");
        return this.getUnnamedEntries();
    }

    private ReportSettings inspectDisplayName(Class<?> clazz) {
        Optional<Annotation> annotation = Arrays.stream(clazz.getAnnotations()).filter(a -> a.annotationType().getName().equals("org.junit.jupiter.api.DisplayName")).findFirst();
        if (annotation.isEmpty()) {
            return null;
        }
        try {
            Method valueMethod = annotation.get().annotationType().getDeclaredMethod("value", new Class[0]);
            return new ReportSettings(this.getPackageName(clazz), valueMethod.invoke((Object)annotation.get(), new Object[0]).toString());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error("Failed to infer JobName from DisplayName annotation", (Throwable)e);
            return null;
        }
    }

    @Override
    public String inferTestName() {
        for (StackTraceElement stackTraceElement : this.traces) {
            Class<?> clazz;
            try {
                clazz = Class.forName(stackTraceElement.getClassName());
            }
            catch (ClassNotFoundException e) {
                LOG.error("Failed to create an instance of a class", (Throwable)e);
                return this.traces.get(this.traces.size() - 1).getMethodName();
            }
            Optional<Method> method = Arrays.stream(clazz.getDeclaredMethods()).filter(m -> m.getName().equals(stackTraceElement.getMethodName())).findFirst();
            if (method.isEmpty()) continue;
            boolean annotated = Arrays.stream(method.get().getDeclaredAnnotations()).anyMatch(a -> a.annotationType().getName().startsWith("org.junit"));
            if (stackTraceElement.getClassName().equals("org.junit.jupiter.engine.descriptor.DynamicTestTestDescriptor")) {
                return "Dynamic Test";
            }
            if (!annotated) continue;
            Optional<Annotation> displayNameAnnotation = Arrays.stream(method.get().getDeclaredAnnotations()).filter(a -> a.annotationType().getName().equals("org.junit.jupiter.api.DisplayName")).findFirst();
            if (displayNameAnnotation.isPresent()) {
                try {
                    Method valueMethod = displayNameAnnotation.get().annotationType().getDeclaredMethod("value", new Class[0]);
                    return valueMethod.invoke((Object)displayNameAnnotation.get(), new Object[0]).toString();
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    LOG.error("Failed to infer Test name from DisplayName annotation", (Throwable)e);
                    return method.get().getName();
                }
            }
            return method.get().getName();
        }
        return this.traces.get(this.traces.size() - 1).getMethodName();
    }
}

