/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.reporting.inferrers;

import io.testproject.sdk.internal.reporting.inferrers.ReportSettingsInferrer;
import io.testproject.sdk.internal.rest.ReportSettings;
import java.util.List;

public class GenericInferrer
implements ReportSettingsInferrer {
    private final List<StackTraceElement> traces;

    public GenericInferrer(List<StackTraceElement> traces) {
        this.traces = traces;
    }

    @Override
    public ReportSettings inferReportSettings() {
        Class<?> clazz;
        StackTraceElement firstTrace = this.traces.get(this.traces.size() - 1);
        try {
            clazz = Class.forName(firstTrace.getClassName());
        }
        catch (ClassNotFoundException e) {
            LOG.error("Failed to create an instance of a class", (Throwable)e);
            return this.getUnnamedEntries();
        }
        String projectName = this.getPackageName(clazz);
        String jobName = firstTrace.getClassName();
        return new ReportSettings(projectName, jobName);
    }

    @Override
    public String inferTestName() {
        return this.traces.get(this.traces.size() - 1).getMethodName();
    }
}

