/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.reporting.extensions.junit5;

import io.testproject.sdk.drivers.ReportingDriver;
import io.testproject.sdk.internal.rest.messages.StepReport;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ExceptionsReporter
implements AfterTestExecutionCallback {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionsReporter.class);
    public static final String TESTPROJECT_TLD = "io.testproject";

    public void afterTestExecution(ExtensionContext context) throws Exception {
        Optional test = context.getTestInstance();
        if (test.isEmpty()) {
            LOG.warn("Test instance is required in order to obtain a reporting driver");
            return;
        }
        if (!io.testproject.sdk.interfaces.junit5.ExceptionsReporter.class.isAssignableFrom(test.get().getClass())) {
            LOG.error("Class [{}] is using extension directly, but instead must implement [{}] interface.", (Object)test.get().getClass().getName(), (Object)io.testproject.sdk.interfaces.junit5.ExceptionsReporter.class.getName());
            return;
        }
        ReportingDriver driver = ((io.testproject.sdk.interfaces.junit5.ExceptionsReporter)test.get()).getDriver();
        if (driver == null) {
            LOG.error("Failed to obtain an instance of [{}] from [{}] to be used for reporting", (Object)ReportingDriver.class.getName(), (Object)((io.testproject.sdk.interfaces.junit5.ExceptionsReporter)test.get()).getClass().getName());
            return;
        }
        if (context.getExecutionException().isEmpty()) {
            return;
        }
        Throwable exception = (Throwable)context.getExecutionException().get();
        if (exception instanceof WebDriverException || exception.getClass().getPackage().getName().startsWith(TESTPROJECT_TLD)) {
            return;
        }
        String resultDescription = null;
        if (exception.getMessage() != null) {
            String message = exception.getMessage();
            String string = resultDescription = StringUtils.isEmpty((Object)message) ? exception.getClass().getName() : exception.getMessage();
        }
        if (driver.getReportingCommandExecutor().isReportsDisabled()) {
            LOG.trace("Step [{}] - [{}]", (Object)resultDescription, (Object)false);
            return;
        }
        StepReport report = new StepReport(resultDescription, null, false, null);
        if (!driver.getReportingCommandExecutor().getAgentClient().reportStep(report)) {
            LOG.error("Failed reporting exception: [{}]", (Object)report);
        }
    }
}

