/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.helpers;

import java.util.Collection;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShutdownThreadManager
extends Thread {
    private static ShutdownThreadManager instance;
    private Runnable agentClientShutdownThread;
    private HashMap<Object, Runnable> driverShutdownThreads = new HashMap();
    private static final Logger LOG;

    public void addAgentClient(Runnable shutdownThread) {
        this.agentClientShutdownThread = shutdownThread;
    }

    public void removeAgentClient() {
        this.agentClientShutdownThread = null;
    }

    public void addDriver(Object driver, Runnable driverShutdownThread) {
        this.driverShutdownThreads.put(driver.hashCode(), driverShutdownThread);
    }

    public void removeDriver(Object driver) {
        this.driverShutdownThreads.remove(driver.hashCode());
    }

    private ShutdownThreadManager() {
        Runtime.getRuntime().addShutdownHook(this);
    }

    public static ShutdownThreadManager getInstance() {
        if (instance == null) {
            instance = new ShutdownThreadManager();
        }
        return instance;
    }

    @Override
    public void run() {
        Collection<Runnable> runnables = this.driverShutdownThreads.values();
        try {
            for (Runnable runnable : runnables) {
                runnable.run();
            }
            if (this.agentClientShutdownThread != null) {
                this.agentClientShutdownThread.run();
            }
        }
        catch (Throwable e) {
            LOG.error("Failed running shutdown thread", e);
        }
    }

    static {
        LOG = LoggerFactory.getLogger(ShutdownThreadManager.class);
    }
}

