/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.drivers.web;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.testproject.sdk.drivers.ReportingDriver;
import io.testproject.sdk.internal.exceptions.AgentConnectException;
import io.testproject.sdk.internal.exceptions.InvalidTokenException;
import io.testproject.sdk.internal.exceptions.ObsoleteVersionException;
import io.testproject.sdk.internal.helpers.DriverHelper;
import io.testproject.sdk.internal.helpers.ReportingCommandsExecutor;
import io.testproject.sdk.internal.helpers.ShutdownThreadManager;
import io.testproject.sdk.internal.reporting.Reporter;
import io.testproject.sdk.internal.rest.AgentClient;
import io.testproject.sdk.internal.rest.ReportSettings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.edge.EdgeDriverService;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.remote.CommandExecutor;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"}, justification="Minimize changes required in any migrated tests")
public class EdgeDriver
extends org.openqa.selenium.edge.EdgeDriver
implements ReportingDriver {
    private Reporter reporter = new Reporter(this, AgentClient.getClient(this.getCapabilities()));

    public EdgeDriver() throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, new EdgeOptions());
    }

    public EdgeDriver(EdgeOptions options) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, options);
    }

    public EdgeDriver(EdgeOptions options, boolean disableReports) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, options, null, null, disableReports);
    }

    public EdgeDriver(EdgeOptions options, String projectName) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, options, projectName, null, false);
    }

    public EdgeDriver(EdgeOptions options, String projectName, String jobName) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, options, projectName, jobName, false);
    }

    public EdgeDriver(String token, EdgeOptions options) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, token, options, null, null, false);
    }

    public EdgeDriver(String token, EdgeOptions options, String projectName) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, token, options, projectName, null, false);
    }

    public EdgeDriver(String token, EdgeOptions options, String projectName, String jobName) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, token, options, projectName, jobName, false);
    }

    public EdgeDriver(URL remoteAddress, EdgeOptions options) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, null, options, null, null, false);
    }

    public EdgeDriver(URL remoteAddress, EdgeOptions options, String projectName) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, null, options, projectName, null, false);
    }

    public EdgeDriver(URL remoteAddress, EdgeOptions options, String projectName, String jobName) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, null, options, projectName, jobName, false);
    }

    public EdgeDriver(URL remoteAddress, String token, EdgeOptions options) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, token, options, null, null, false);
    }

    public EdgeDriver(URL remoteAddress, String token, EdgeOptions options, String projectName, String jobName, boolean disableReports) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        super((EdgeDriverService)new FakeDriverService(), new EdgeOptions().merge(AgentClient.getClient(remoteAddress, token, (Capabilities)options, new ReportSettings(projectName, jobName), disableReports).getSession().getCapabilities()));
        this.getReportingCommandExecutor().setReportsDisabled(disableReports);
        ShutdownThreadManager.getInstance().addDriver(this, this::stop);
    }

    protected void startSession(Capabilities capabilities) {
        try {
            AgentClient agentClient = AgentClient.getClient(capabilities);
            DriverHelper.setCapabilities((WebDriver)this, capabilities);
            this.setSessionId(agentClient.getSession().getSessionId());
            this.setCommandExecutor((CommandExecutor)DriverHelper.getHttpCommandExecutor(agentClient, false));
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public void quit() {
        ShutdownThreadManager.getInstance().removeDriver(this);
        this.stop();
    }

    @Override
    public void stop() {
        ReportingCommandsExecutor executor = (ReportingCommandsExecutor)this.getCommandExecutor();
        executor.clearStash();
        super.quit();
    }

    @Override
    public Reporter report() {
        return this.reporter;
    }

    static class FakeDriverService
    extends EdgeDriverService {
        FakeDriverService() throws IOException {
            super(new File(""), 0, null, null);
        }
    }
}

