/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.drivers.android;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.testproject.sdk.drivers.ReportingDriver;
import io.testproject.sdk.internal.exceptions.AgentConnectException;
import io.testproject.sdk.internal.exceptions.InvalidTokenException;
import io.testproject.sdk.internal.exceptions.ObsoleteVersionException;
import io.testproject.sdk.internal.helpers.DriverHelper;
import io.testproject.sdk.internal.helpers.ReportingCommandsExecutor;
import io.testproject.sdk.internal.helpers.ShutdownThreadManager;
import io.testproject.sdk.internal.reporting.Reporter;
import io.testproject.sdk.internal.rest.AgentClient;
import io.testproject.sdk.internal.rest.ReportSettings;
import java.net.MalformedURLException;
import java.net.URL;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"}, justification="Minimize changes required in any migrated tests")
public class AndroidDriver<T extends WebElement>
extends io.appium.java_client.android.AndroidDriver<T>
implements ReportingDriver {
    private Reporter reporter = new Reporter(this, AgentClient.getClient(this.getCapabilities()));

    public AndroidDriver(Capabilities capabilities) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, null, capabilities, null, null, false);
    }

    public AndroidDriver(Capabilities capabilities, boolean disableReports) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, null, capabilities, null, null, disableReports);
    }

    public AndroidDriver(Capabilities capabilities, String projectName) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, null, capabilities, projectName, null, false);
    }

    public AndroidDriver(Capabilities capabilities, String projectName, String jobName) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, null, capabilities, projectName, jobName, false);
    }

    public AndroidDriver(String token, Capabilities capabilities) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, token, capabilities, null, null, false);
    }

    public AndroidDriver(String token, Capabilities capabilities, String projectName) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, token, capabilities, projectName, null, false);
    }

    public AndroidDriver(String token, Capabilities capabilities, String projectName, String jobName) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, token, capabilities, projectName, jobName, false);
    }

    public AndroidDriver(URL remoteAddress, Capabilities capabilities) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, capabilities, null, null, false);
    }

    public AndroidDriver(URL remoteAddress, Capabilities capabilities, String projectName) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, capabilities, projectName, null, false);
    }

    public AndroidDriver(URL remoteAddress, Capabilities capabilities, String projectName, String jobName) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, capabilities, projectName, jobName, false);
    }

    public AndroidDriver(URL remoteAddress, String token, Capabilities capabilities) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, token, capabilities, null, null, false);
    }

    public AndroidDriver(URL remoteAddress, String token, Capabilities capabilities, String projectName, String jobName, boolean disableReports) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        super(DriverHelper.getHttpCommandExecutor(AgentClient.getClient(remoteAddress, token, capabilities, new ReportSettings(projectName, jobName), disableReports), true), AgentClient.getClient(capabilities).getSession().getCapabilities());
        this.getReportingCommandExecutor().setReportsDisabled(disableReports);
        ShutdownThreadManager.getInstance().addDriver(this, this::stop);
    }

    protected void startSession(Capabilities capabilities) {
        try {
            DriverHelper.setCapabilities((WebDriver)this, capabilities);
            this.setSessionId(AgentClient.getClient(capabilities).getSession().getSessionId());
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public void quit() {
        ShutdownThreadManager.getInstance().removeDriver(this);
        this.stop();
    }

    @Override
    public void stop() {
        ReportingCommandsExecutor executor = (ReportingCommandsExecutor)this.getCommandExecutor();
        executor.clearStash();
        super.quit();
    }

    @Override
    public Reporter report() {
        return this.reporter;
    }
}

