/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractCppCodegen;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Qt5CPPGenerator
extends AbstractCppCodegen
implements CodegenConfig {
    public static final String CPP_NAMESPACE = "cppNamespace";
    public static final String CPP_NAMESPACE_DESC = "C++ namespace (convention: name::space::for::api).";
    public static final String OPTIONAL_PROJECT_FILE_DESC = "Generate client.pri.";
    protected final String PREFIX = "SWG";
    protected Set<String> foundationClasses = new HashSet<String>();
    protected String sourceFolder = "client";
    protected String apiVersion = "1.0.0";
    protected Map<String, String> namespaces = new HashMap<String, String>();
    protected Set<String> systemIncludes = new HashSet<String>();
    protected String cppNamespace = "Swagger";
    protected boolean optionalProjectFileFlag = true;

    public Qt5CPPGenerator() {
        this.outputFolder = "generated-code/qt5cpp";
        if (this.modelNamePrefix == "") {
            this.modelNamePrefix = "SWG";
        }
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-body.mustache", ".cpp");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-body.mustache", ".cpp");
        this.templateDir = "qt5cpp";
        this.embeddedTemplateDir = "qt5cpp";
        this.addOption(CPP_NAMESPACE, CPP_NAMESPACE_DESC, this.cppNamespace);
        this.addSwitch("optionalProjectFile", OPTIONAL_PROJECT_FILE_DESC, this.optionalProjectFileFlag);
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.additionalProperties().put("prefix", "SWG");
        this.additionalProperties.put(CPP_NAMESPACE, this.cppNamespace);
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("bool", "qint32", "qint64", "float", "double"));
        this.supportingFiles.add(new SupportingFile("helpers-header.mustache", this.sourceFolder, "SWGHelpers.h"));
        this.supportingFiles.add(new SupportingFile("helpers-body.mustache", this.sourceFolder, "SWGHelpers.cpp"));
        this.supportingFiles.add(new SupportingFile("HttpRequest.h.mustache", this.sourceFolder, "SWGHttpRequest.h"));
        this.supportingFiles.add(new SupportingFile("HttpRequest.cpp.mustache", this.sourceFolder, "SWGHttpRequest.cpp"));
        this.supportingFiles.add(new SupportingFile("modelFactory.mustache", this.sourceFolder, "SWGModelFactory.h"));
        this.supportingFiles.add(new SupportingFile("object.mustache", this.sourceFolder, "SWGObject.h"));
        this.supportingFiles.add(new SupportingFile("QObjectWrapper.h.mustache", this.sourceFolder, "SWGQObjectWrapper.h"));
        if (this.optionalProjectFileFlag) {
            this.supportingFiles.add(new SupportingFile("Project.mustache", this.sourceFolder, "client.pri"));
        }
        this.typeMapping = new HashMap();
        this.typeMapping.put("date", "QDate");
        this.typeMapping.put("DateTime", "QDateTime");
        this.typeMapping.put("string", "QString");
        this.typeMapping.put("integer", "qint32");
        this.typeMapping.put("long", "qint64");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("array", "QList");
        this.typeMapping.put("map", "QMap");
        this.typeMapping.put("file", "SWGHttpRequestInputFileElement");
        this.typeMapping.put("object", "SWGObject");
        this.typeMapping.put("binary", "QString");
        this.typeMapping.put("ByteArray", "QByteArray");
        this.typeMapping.put("UUID", "QString");
        this.importMapping = new HashMap();
        this.importMapping.put("SWGHttpRequestInputFileElement", "#include \"SWGHttpRequest.h\"");
        this.namespaces = new HashMap<String, String>();
        this.foundationClasses.add("QString");
        this.systemIncludes.add("QString");
        this.systemIncludes.add("QList");
        this.systemIncludes.add("QMap");
        this.systemIncludes.add("QDate");
        this.systemIncludes.add("QDateTime");
        this.systemIncludes.add("QByteArray");
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(CPP_NAMESPACE)) {
            this.cppNamespace = (String)this.additionalProperties.get(CPP_NAMESPACE);
        }
        this.additionalProperties.put("cppNamespaceDeclarations", this.cppNamespace.split("\\::"));
        if (this.additionalProperties.containsKey("modelNamePrefix")) {
            this.supportingFiles.clear();
            this.supportingFiles.add(new SupportingFile("helpers-header.mustache", this.sourceFolder, this.modelNamePrefix + "Helpers.h"));
            this.supportingFiles.add(new SupportingFile("helpers-body.mustache", this.sourceFolder, this.modelNamePrefix + "Helpers.cpp"));
            this.supportingFiles.add(new SupportingFile("HttpRequest.h.mustache", this.sourceFolder, this.modelNamePrefix + "HttpRequest.h"));
            this.supportingFiles.add(new SupportingFile("HttpRequest.cpp.mustache", this.sourceFolder, this.modelNamePrefix + "HttpRequest.cpp"));
            this.supportingFiles.add(new SupportingFile("modelFactory.mustache", this.sourceFolder, this.modelNamePrefix + "ModelFactory.h"));
            this.supportingFiles.add(new SupportingFile("object.mustache", this.sourceFolder, this.modelNamePrefix + "Object.h"));
            this.supportingFiles.add(new SupportingFile("QObjectWrapper.h.mustache", this.sourceFolder, this.modelNamePrefix + "QObjectWrapper.h"));
            this.typeMapping.put("object", this.modelNamePrefix + "Object");
            this.typeMapping.put("file", this.modelNamePrefix + "HttpRequestInputFileElement");
            this.importMapping.put("SWGHttpRequestInputFileElement", "#include \"" + this.modelNamePrefix + "HttpRequest.h\"");
            this.additionalProperties().put("prefix", this.modelNamePrefix);
        }
        if (this.additionalProperties.containsKey("optionalProjectFile")) {
            this.setOptionalProjectFileFlag(this.convertPropertyToBooleanAndWriteBack("optionalProjectFile"));
        } else {
            this.additionalProperties.put("optionalProjectFile", this.optionalProjectFileFlag);
        }
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "qt5cpp";
    }

    @Override
    public String getHelp() {
        return "Generates a qt5 C++ client library.";
    }

    @Override
    public String toModelImport(String name) {
        if (this.namespaces.containsKey(name)) {
            return "using " + this.namespaces.get(name) + ";";
        }
        if (this.systemIncludes.contains(name)) {
            return "#include <" + name + ">";
        }
        String folder = this.modelPackage().replace("::", File.separator);
        if (!folder.isEmpty()) {
            folder = folder + File.separator;
        }
        return "#include \"" + folder + name + ".h\"";
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.modelPackage().replace("::", File.separator);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.apiPackage().replace("::", File.separator);
    }

    @Override
    public String toModelFilename(String name) {
        return this.modelNamePrefix + this.initialCaps(name);
    }

    @Override
    public String toApiFilename(String name) {
        return this.modelNamePrefix + this.initialCaps(name) + "Api";
    }

    @Override
    public String getTypeDeclaration(Property p) {
        String swaggerType = this.getSwaggerType(p);
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "<" + this.getTypeDeclaration(inner) + ">*";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "<QString, " + this.getTypeDeclaration(inner) + ">*";
        }
        if (this.foundationClasses.contains(swaggerType)) {
            return swaggerType + "*";
        }
        if (this.languageSpecificPrimitives.contains(swaggerType)) {
            return this.toModelName(swaggerType);
        }
        return swaggerType + "*";
    }

    @Override
    public String toDefaultValue(Property p) {
        if (p instanceof StringProperty) {
            return "new QString(\"\")";
        }
        if (p instanceof BooleanProperty) {
            return "false";
        }
        if (p instanceof DateProperty) {
            return "NULL";
        }
        if (p instanceof DateTimeProperty) {
            return "NULL";
        }
        if (p instanceof DoubleProperty) {
            return "0.0";
        }
        if (p instanceof FloatProperty) {
            return "0.0f";
        }
        if (p instanceof IntegerProperty) {
            return "0";
        }
        if (p instanceof LongProperty) {
            return "0L";
        }
        if (p instanceof BaseIntegerProperty) {
            return "0";
        }
        if (p instanceof DecimalProperty) {
            return "0.0";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return "new QMap<QString, " + this.getTypeDeclaration(inner) + ">()";
        }
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return "new QList<" + this.getTypeDeclaration(inner) + ">()";
        }
        if (p instanceof RefProperty) {
            RefProperty rp = (RefProperty)p;
            return "new " + this.toModelName(rp.getSimpleRef()) + "()";
        }
        return "NULL";
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
            if (this.foundationClasses.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toModelName(String type) {
        if (this.typeMapping.keySet().contains(type) || this.typeMapping.values().contains(type) || this.importMapping.values().contains(type) || this.defaultIncludes.contains(type) || this.languageSpecificPrimitives.contains(type)) {
            return type;
        }
        return this.modelNamePrefix + Character.toUpperCase(type.charAt(0)) + type.substring(1);
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]*$")) {
            name = name.toLowerCase();
        }
        if (this.isReservedWord(name = Qt5CPPGenerator.underscore(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toApiName(String type) {
        return this.modelNamePrefix + Character.toUpperCase(type.charAt(0)) + type.substring(1) + "Api";
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    public void setOptionalProjectFileFlag(boolean flag) {
        this.optionalProjectFileFlag = flag;
    }
}

