/**
 * Cupix API
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 1.7.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { Inject, Injectable, Optional }                      from '@angular/core';
import { Http, Headers, URLSearchParams }                    from '@angular/http';
import { RequestMethod, RequestOptions, RequestOptionsArgs } from '@angular/http';
import { Response, ResponseContentType }                     from '@angular/http';

import { Observable }                                        from 'rxjs/Observable';
import '../rxjs-operators';

import { ProjectEntity } from '../model/projectEntity';
import { ProjectList } from '../model/projectList';

import { BASE_PATH }                                         from '../variables';
import { Configuration }                                     from '../configuration';

/* tslint:disable:no-unused-variable member-ordering */


@Injectable()
export class ProjectService {
    protected basePath = 'https://localhost/v1';
    public defaultHeaders: Headers = new Headers();
    public configuration: Configuration = new Configuration();

    constructor(protected http: Http, @Optional()@Inject(BASE_PATH) basePath: string, @Optional() configuration: Configuration) {
        if (basePath) {
            this.basePath = basePath;
        }
        if (configuration) {
            this.configuration = configuration;
			this.basePath = basePath || configuration.basePath || this.basePath;
        }
    }

    /**
     * Create a Project
     * Creates an empty Project
     * @param name 
     * @param address 
     * @param longitude 
     * @param latitude 
     * @param meta 
     */
    public createProject(name?: string, address?: string, longitude?: number, latitude?: number, meta?: string, extraHttpRequestParams?: any): Observable<ProjectEntity> {
        return this.createProjectWithHttpInfo(name, address, longitude, latitude, meta, extraHttpRequestParams)
            .map((response: Response) => {
                if (response.status === 204) {
                    return undefined;
                } else {
                    return response.json();
                }
            });
    }

    /**
     * Delete a Project
     * Returns a Project JSON object
     * @param id Project id
     */
    public deleteProjectById(id: number, extraHttpRequestParams?: any): Observable<{}> {
        return this.deleteProjectByIdWithHttpInfo(id, extraHttpRequestParams)
            .map((response: Response) => {
                if (response.status === 204) {
                    return undefined;
                } else {
                    return response.json();
                }
            });
    }

    /**
     * Get a Project
     * Returns a Project JSON object
     * @param id Project id
     */
    public getProjectById(id: number, extraHttpRequestParams?: any): Observable<ProjectEntity> {
        return this.getProjectByIdWithHttpInfo(id, extraHttpRequestParams)
            .map((response: Response) => {
                if (response.status === 204) {
                    return undefined;
                } else {
                    return response.json();
                }
            });
    }

    /**
     * Get project list
     * Returns a Project JSON object
     * @param page 
     * @param perPage 
     * @param kind 
     * @param q 
     * @param filter 
     * @param latitude Valid with kind as location
     * @param longitude Valid with kind as location
     * @param scope Valid with kind as location, and between 1~9
     */
    public getProjectList(page?: number, perPage?: number, kind?: string, q?: string, filter?: string, latitude?: number, longitude?: number, scope?: number, extraHttpRequestParams?: any): Observable<ProjectList> {
        return this.getProjectListWithHttpInfo(page, perPage, kind, q, filter, latitude, longitude, scope, extraHttpRequestParams)
            .map((response: Response) => {
                if (response.status === 204) {
                    return undefined;
                } else {
                    return response.json();
                }
            });
    }

    /**
     * Update project
     * 
     * @param id Project id
     * @param name User ID
     * @param address Address
     * @param longitude 
     * @param latitude 
     * @param meta 
     * @param thumbnail Project thumbnail
     */
    public updateProject(id: number, name?: string, address?: string, longitude?: number, latitude?: number, meta?: string, thumbnail?: any, extraHttpRequestParams?: any): Observable<ProjectEntity> {
        return this.updateProjectWithHttpInfo(id, name, address, longitude, latitude, meta, thumbnail, extraHttpRequestParams)
            .map((response: Response) => {
                if (response.status === 204) {
                    return undefined;
                } else {
                    return response.json();
                }
            });
    }


    /**
     * Create a Project
     * Creates an empty Project
     * @param name 
     * @param address 
     * @param longitude 
     * @param latitude 
     * @param meta 
     */
    public createProjectWithHttpInfo(name?: string, address?: string, longitude?: number, latitude?: number, meta?: string, extraHttpRequestParams?: any): Observable<Response> {
        const path = this.basePath + `/projects`;

        let queryParameters = new URLSearchParams();
        let headers = new Headers(this.defaultHeaders.toJSON()); // https://github.com/angular/angular/issues/6845
        let formParams = new URLSearchParams();



        // to determine the Content-Type header
        let consumes: string[] = [
            'application/x-www-form-urlencoded'
        ];

        // to determine the Accept header
        let produces: string[] = [
            'application/json'
        ];
        
            
        headers.set('Content-Type', 'application/x-www-form-urlencoded');


        if (name !== undefined) {
            formParams.set('name', <any>name); 
        }
        if (address !== undefined) {
            formParams.set('address', <any>address); 
        }
        if (longitude !== undefined) {
            formParams.set('longitude', <any>longitude); 
        }
        if (latitude !== undefined) {
            formParams.set('latitude', <any>latitude); 
        }
        if (meta !== undefined) {
            formParams.set('meta', <any>meta); 
        }

        let requestOptions: RequestOptionsArgs = new RequestOptions({
            method: RequestMethod.Post,
            headers: headers,
            body: formParams.toString(),
            search: queryParameters,
            responseType: ResponseContentType.Json
        });

        return this.http.request(path, requestOptions);
    }

    /**
     * Delete a Project
     * Returns a Project JSON object
     * @param id Project id
     */
    public deleteProjectByIdWithHttpInfo(id: number, extraHttpRequestParams?: any): Observable<Response> {
        const path = this.basePath + `/projects/${id}`;

        let queryParameters = new URLSearchParams();
        let headers = new Headers(this.defaultHeaders.toJSON()); // https://github.com/angular/angular/issues/6845
        // verify required parameter 'id' is not null or undefined
        if (id === null || id === undefined) {
            throw new Error('Required parameter id was null or undefined when calling deleteProjectById.');
        }


        // to determine the Content-Type header
        let consumes: string[] = [
            'application/json'
        ];

        // to determine the Accept header
        let produces: string[] = [
            'application/json'
        ];
        
            



        let requestOptions: RequestOptionsArgs = new RequestOptions({
            method: RequestMethod.Delete,
            headers: headers,
            search: queryParameters,
            responseType: ResponseContentType.Json
        });

        return this.http.request(path, requestOptions);
    }

    /**
     * Get a Project
     * Returns a Project JSON object
     * @param id Project id
     */
    public getProjectByIdWithHttpInfo(id: number, extraHttpRequestParams?: any): Observable<Response> {
        const path = this.basePath + `/projects/${id}`;

        let queryParameters = new URLSearchParams();
        let headers = new Headers(this.defaultHeaders.toJSON()); // https://github.com/angular/angular/issues/6845
        // verify required parameter 'id' is not null or undefined
        if (id === null || id === undefined) {
            throw new Error('Required parameter id was null or undefined when calling getProjectById.');
        }


        // to determine the Content-Type header
        let consumes: string[] = [
            'application/json'
        ];

        // to determine the Accept header
        let produces: string[] = [
            'application/json'
        ];
        
            



        let requestOptions: RequestOptionsArgs = new RequestOptions({
            method: RequestMethod.Get,
            headers: headers,
            search: queryParameters,
            responseType: ResponseContentType.Json
        });

        return this.http.request(path, requestOptions);
    }

    /**
     * Get project list
     * Returns a Project JSON object
     * @param page 
     * @param perPage 
     * @param kind 
     * @param q 
     * @param filter 
     * @param latitude Valid with kind as location
     * @param longitude Valid with kind as location
     * @param scope Valid with kind as location, and between 1~9
     */
    public getProjectListWithHttpInfo(page?: number, perPage?: number, kind?: string, q?: string, filter?: string, latitude?: number, longitude?: number, scope?: number, extraHttpRequestParams?: any): Observable<Response> {
        const path = this.basePath + `/projects`;

        let queryParameters = new URLSearchParams();
        let headers = new Headers(this.defaultHeaders.toJSON()); // https://github.com/angular/angular/issues/6845
        if (page !== undefined) {
            queryParameters.set('page', <any>page);
        }
        if (perPage !== undefined) {
            queryParameters.set('per_page', <any>perPage);
        }
        if (kind !== undefined) {
            queryParameters.set('kind', <any>kind);
        }
        if (q !== undefined) {
            queryParameters.set('q', <any>q);
        }
        if (filter !== undefined) {
            queryParameters.set('filter', <any>filter);
        }
        if (latitude !== undefined) {
            queryParameters.set('latitude', <any>latitude);
        }
        if (longitude !== undefined) {
            queryParameters.set('longitude', <any>longitude);
        }
        if (scope !== undefined) {
            queryParameters.set('scope', <any>scope);
        }


        // to determine the Content-Type header
        let consumes: string[] = [
            'application/json'
        ];

        // to determine the Accept header
        let produces: string[] = [
            'application/json'
        ];
        
            



        let requestOptions: RequestOptionsArgs = new RequestOptions({
            method: RequestMethod.Get,
            headers: headers,
            search: queryParameters,
            responseType: ResponseContentType.Json
        });

        return this.http.request(path, requestOptions);
    }

    /**
     * Update project
     * 
     * @param id Project id
     * @param name User ID
     * @param address Address
     * @param longitude 
     * @param latitude 
     * @param meta 
     * @param thumbnail Project thumbnail
     */
    public updateProjectWithHttpInfo(id: number, name?: string, address?: string, longitude?: number, latitude?: number, meta?: string, thumbnail?: any, extraHttpRequestParams?: any): Observable<Response> {
        const path = this.basePath + `/projects/${id}`;

        let queryParameters = new URLSearchParams();
        let headers = new Headers(this.defaultHeaders.toJSON()); // https://github.com/angular/angular/issues/6845
        let formParams = new URLSearchParams();

        // verify required parameter 'id' is not null or undefined
        if (id === null || id === undefined) {
            throw new Error('Required parameter id was null or undefined when calling updateProject.');
        }


        // to determine the Content-Type header
        let consumes: string[] = [
            'multipart/form-data'
        ];

        // to determine the Accept header
        let produces: string[] = [
            'application/json'
        ];
        
            
        headers.set('Content-Type', 'application/x-www-form-urlencoded');


        if (name !== undefined) {
            formParams.set('name', <any>name); 
        }
        if (address !== undefined) {
            formParams.set('address', <any>address); 
        }
        if (longitude !== undefined) {
            formParams.set('longitude', <any>longitude); 
        }
        if (latitude !== undefined) {
            formParams.set('latitude', <any>latitude); 
        }
        if (meta !== undefined) {
            formParams.set('meta', <any>meta); 
        }
        if (thumbnail !== undefined) {
            formParams.set('thumbnail', <any>thumbnail); 
        }

        let requestOptions: RequestOptionsArgs = new RequestOptions({
            method: RequestMethod.Put,
            headers: headers,
            body: formParams.toString(),
            search: queryParameters,
            responseType: ResponseContentType.Json
        });

        return this.http.request(path, requestOptions);
    }

}
