/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.typescript.fetch;

import com.google.common.collect.Sets;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.languages.TypeScriptFetchClientCodegen;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.parser.SwaggerParser;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TypeScriptFetchModelTest {
    @Test(description="convert a simple TypeScript Angular model")
    public void simpleModelTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("id", (Property)new LongProperty()).property("name", (Property)new StringProperty()).property("createdAt", (Property)new DateTimeProperty()).property("birthDate", (Property)new DateProperty()).required("id").required("name");
        TypeScriptFetchClientCodegen codegen = new TypeScriptFetchClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)4);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"id");
        Assert.assertEquals((String)property1.datatype, (String)"number");
        Assert.assertEquals((String)property1.name, (String)"id");
        Assert.assertEquals((String)property1.defaultValue, (String)"undefined");
        Assert.assertEquals((String)property1.baseType, (String)"number");
        Assert.assertTrue((boolean)property1.hasMore);
        Assert.assertTrue((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isNotContainer);
        CodegenProperty property2 = (CodegenProperty)cm.vars.get(1);
        Assert.assertEquals((String)property2.baseName, (String)"name");
        Assert.assertEquals((String)property2.datatype, (String)"string");
        Assert.assertEquals((String)property2.name, (String)"name");
        Assert.assertEquals((String)property2.defaultValue, (String)"undefined");
        Assert.assertEquals((String)property2.baseType, (String)"string");
        Assert.assertTrue((boolean)property2.hasMore);
        Assert.assertTrue((boolean)property2.required);
        Assert.assertTrue((boolean)property2.isNotContainer);
        CodegenProperty property3 = (CodegenProperty)cm.vars.get(2);
        Assert.assertEquals((String)property3.baseName, (String)"createdAt");
        Assert.assertEquals((String)property3.complexType, null);
        Assert.assertEquals((String)property3.datatype, (String)"Date");
        Assert.assertEquals((String)property3.name, (String)"createdAt");
        Assert.assertEquals((String)property3.defaultValue, (String)"undefined");
        Assert.assertTrue((boolean)property3.hasMore);
        Assert.assertFalse((boolean)property3.required);
        Assert.assertTrue((boolean)property3.isNotContainer);
        CodegenProperty property4 = (CodegenProperty)cm.vars.get(3);
        Assert.assertEquals((String)property4.baseName, (String)"birthDate");
        Assert.assertEquals((String)property4.complexType, null);
        Assert.assertEquals((String)property4.datatype, (String)"string");
        Assert.assertEquals((String)property4.name, (String)"birthDate");
        Assert.assertEquals((String)property4.defaultValue, (String)"undefined");
        Assert.assertFalse((boolean)property4.hasMore);
        Assert.assertFalse((boolean)property4.required);
        Assert.assertTrue((boolean)property4.isNotContainer);
    }

    @Test(description="convert a model with list property")
    public void listPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("id", (Property)new LongProperty()).property("urls", (Property)new ArrayProperty().items((Property)new StringProperty())).required("id");
        TypeScriptFetchClientCodegen codegen = new TypeScriptFetchClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)2);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"id");
        Assert.assertEquals((String)property1.datatype, (String)"number");
        Assert.assertEquals((String)property1.name, (String)"id");
        Assert.assertEquals((String)property1.defaultValue, (String)"undefined");
        Assert.assertEquals((String)property1.baseType, (String)"number");
        Assert.assertTrue((boolean)property1.hasMore);
        Assert.assertTrue((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isNotContainer);
        CodegenProperty property2 = (CodegenProperty)cm.vars.get(1);
        Assert.assertEquals((String)property2.baseName, (String)"urls");
        Assert.assertEquals((String)property2.datatype, (String)"Array<string>");
        Assert.assertEquals((String)property2.name, (String)"urls");
        Assert.assertEquals((String)property2.baseType, (String)"Array");
        Assert.assertFalse((boolean)property2.hasMore);
        Assert.assertFalse((boolean)property2.required);
        Assert.assertTrue((boolean)property2.isContainer);
    }

    @Test(description="convert a model with complex property")
    public void complexPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new RefProperty("#/definitions/Children"));
        TypeScriptFetchClientCodegen codegen = new TypeScriptFetchClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"children");
        Assert.assertEquals((String)property1.datatype, (String)"Children");
        Assert.assertEquals((String)property1.name, (String)"children");
        Assert.assertEquals((String)property1.defaultValue, (String)"undefined");
        Assert.assertEquals((String)property1.baseType, (String)"Children");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isNotContainer);
    }

    @Test(description="convert a model with complex list property")
    public void complexListPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new ArrayProperty().items((Property)new RefProperty("#/definitions/Children")));
        TypeScriptFetchClientCodegen codegen = new TypeScriptFetchClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"children");
        Assert.assertEquals((String)property1.complexType, (String)"Children");
        Assert.assertEquals((String)property1.datatype, (String)"Array<Children>");
        Assert.assertEquals((String)property1.name, (String)"children");
        Assert.assertEquals((String)property1.baseType, (String)"Array");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isContainer);
    }

    @Test(description="convert an array model")
    public void arrayModelTest() {
        ArrayModel model = new ArrayModel().description("an array model").items((Property)new RefProperty("#/definitions/Children"));
        TypeScriptFetchClientCodegen codegen = new TypeScriptFetchClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"an array model");
        Assert.assertEquals((int)cm.vars.size(), (int)0);
    }

    @Test(description="convert a map model")
    public void mapModelTest() {
        ModelImpl model = new ModelImpl().description("a map model").additionalProperties((Property)new RefProperty("#/definitions/Children"));
        TypeScriptFetchClientCodegen codegen = new TypeScriptFetchClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a map model");
        Assert.assertEquals((int)cm.vars.size(), (int)0);
        Assert.assertEquals((int)cm.imports.size(), (int)1);
        Assert.assertEquals((int)Sets.intersection((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"Children"})).size(), (int)1);
    }

    @Test(description="test enum array model")
    public void enumArrayMdoelTest() {
        Swagger model = new SwaggerParser().read("src/test/resources/2_0/petstore-with-fake-endpoints-models-for-testing.yaml");
        TypeScriptFetchClientCodegen codegen = new TypeScriptFetchClientCodegen();
        Model definition = (Model)model.getDefinitions().get("EnumArrays");
        Property property = (Property)definition.getProperties().get("array_enum");
        CodegenProperty prope = codegen.fromProperty("array_enum", property);
        codegen.updateCodegenPropertyEnum(prope);
        Assert.assertEquals((String)prope.datatypeWithEnum, (String)"Array<ArrayEnumEnum>");
        Assert.assertEquals((String)prope.enumName, (String)"ArrayEnumEnum");
        Assert.assertTrue((boolean)prope.isEnum);
        Assert.assertEquals(prope.allowableValues.get("values"), Arrays.asList("fish", "crab"));
        HashMap<String, String> fish = new HashMap<String, String>();
        fish.put("name", "Fish");
        fish.put("value", "'fish'");
        HashMap<String, String> crab = new HashMap<String, String>();
        crab.put("name", "Crab");
        crab.put("value", "'crab'");
        Assert.assertEquals(prope.allowableValues.get("enumVars"), Arrays.asList(fish, crab));
        Assert.assertEquals((String)prope.datatypeWithEnum, (String)"Array<ArrayEnumEnum>");
        Assert.assertEquals((String)prope.enumName, (String)"ArrayEnumEnum");
        Assert.assertTrue((boolean)prope.items.isEnum);
        Assert.assertEquals(prope.items.allowableValues.get("values"), Arrays.asList("fish", "crab"));
        Assert.assertEquals(prope.items.allowableValues.get("enumVars"), Arrays.asList(fish, crab));
    }

    @Test(description="test enum model for values (numeric, string, etc)")
    public void enumMdoelValueTest() {
        Swagger model = new SwaggerParser().read("src/test/resources/2_0/petstore-with-fake-endpoints-models-for-testing.yaml");
        TypeScriptFetchClientCodegen codegen = new TypeScriptFetchClientCodegen();
        Model definition = (Model)model.getDefinitions().get("Enum_Test");
        Property property = (Property)definition.getProperties().get("enum_integer");
        CodegenProperty prope = codegen.fromProperty("enum_integer", property);
        codegen.updateCodegenPropertyEnum(prope);
        Assert.assertEquals((String)prope.datatypeWithEnum, (String)"EnumIntegerEnum");
        Assert.assertEquals((String)prope.enumName, (String)"EnumIntegerEnum");
        Assert.assertTrue((boolean)prope.isEnum);
        Assert.assertFalse((boolean)prope.isContainer);
        Assert.assertNull((Object)prope.items);
        Assert.assertEquals(prope.allowableValues.get("values"), Arrays.asList(1, -1));
        HashMap<String, String> one = new HashMap<String, String>();
        one.put("name", "NUMBER_1");
        one.put("value", "1");
        HashMap<String, String> minusOne = new HashMap<String, String>();
        minusOne.put("name", "NUMBER_MINUS_1");
        minusOne.put("value", "-1");
        Assert.assertEquals(prope.allowableValues.get("enumVars"), Arrays.asList(one, minusOne));
    }
}

