/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.testutils;

import java.nio.file.Path;
import java.nio.file.Paths;

public class IntegrationTestPathsConfig {
    private static final Path INTEGRATION_TEST_PATH = Paths.get("target/test-classes/integrationtests", new String[0]).toAbsolutePath();
    private final Path outputPath;
    private final Path specPath;
    private final Path expectedPath;
    private final Path ignoreFilePath;

    public IntegrationTestPathsConfig(String location) {
        this(location + "-spec.json", location + "-result", location + "-expected", location + ".ignore");
    }

    public IntegrationTestPathsConfig(String specLocation, String outputLocation, String expectedLocation, String ignoreFileLocation) {
        this.outputPath = INTEGRATION_TEST_PATH.resolve(outputLocation);
        this.expectedPath = INTEGRATION_TEST_PATH.resolve(expectedLocation);
        this.specPath = INTEGRATION_TEST_PATH.resolve(specLocation);
        this.ignoreFilePath = INTEGRATION_TEST_PATH.resolve(ignoreFileLocation);
    }

    public Path getOutputPath() {
        return this.outputPath;
    }

    public Path getSpecPath() {
        return this.specPath;
    }

    public Path getExpectedPath() {
        return this.expectedPath;
    }

    public Path getIgnoreFilePath() {
        return this.ignoreFilePath;
    }
}

