/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.testutils;

import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.List;
import org.testng.Assert;

public class AssertFile {
    private AssertFile() {
        throw new RuntimeException("This class should not be instantiated");
    }

    public static void assertPathEqualsRecursively(Path expected, Path actual) {
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)actual);
        final Path absoluteExpected = expected.toAbsolutePath();
        final Path absoluteActual = actual.toAbsolutePath();
        try {
            Files.walkFileTree(expected, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path expectedDir, BasicFileAttributes attrs) throws IOException {
                    Path relativeExpectedDir = absoluteExpected.relativize(expectedDir.toAbsolutePath());
                    Path actualDir = absoluteActual.resolve(relativeExpectedDir);
                    if (!Files.exists(actualDir, new LinkOption[0])) {
                        Assert.fail((String)String.format("Directory '%s' is missing.", actualDir));
                    }
                    Object[] expected = expectedDir.toFile().list();
                    Object[] actual = actualDir.toFile().list();
                    if (expected != null) {
                        Arrays.sort(expected);
                    }
                    if (actual != null) {
                        Arrays.sort(actual);
                    }
                    Assert.assertEquals((Object[])expected, (Object[])actual, (String)String.format("Directory content of '%s' and '%s' differ.", expectedDir, actualDir));
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path expectedFile, BasicFileAttributes attrs) throws IOException {
                    Path relativeExpectedFile = absoluteExpected.relativize(expectedFile.toAbsolutePath());
                    Path actualFile = absoluteActual.resolve(relativeExpectedFile);
                    if (!Files.exists(actualFile, new LinkOption[0])) {
                        Assert.fail((String)String.format("File '%s' is missing.", actualFile));
                    }
                    AssertFile.assertFilesAreEqual(expectedFile, actualFile);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    Assert.fail((String)exc.getMessage());
                    return FileVisitResult.TERMINATE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    public static void assertFilesAreEqual(Path expected, Path actual) {
        if (!Files.isRegularFile(expected, new LinkOption[0])) {
            Assert.fail((String)"expected: '%s' is not a readable file");
        }
        if (!Files.isRegularFile(actual, new LinkOption[0])) {
            Assert.fail((String)"actual: '%s' is not a readable file");
        }
        try {
            List<String> expectedLines = Files.readAllLines(expected, Charset.defaultCharset());
            List<String> actualLines = Files.readAllLines(actual, Charset.defaultCharset());
            Patch diff = DiffUtils.diff(expectedLines, actualLines);
            List deltas = diff.getDeltas();
            if (!deltas.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("files diff:\n");
                stringBuilder.append("\tfile: '").append(expected.toAbsolutePath().toString()).append("' \n");
                stringBuilder.append("\tfile: '").append(actual.toAbsolutePath().toString()).append("' \n");
                stringBuilder.append("\tdiffs:\n");
                for (Delta delta : deltas) {
                    stringBuilder.append(delta.toString()).append("\n");
                }
                Assert.fail((String)stringBuilder.toString());
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }
}

