/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.swift4;

import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenResponse;
import io.swagger.codegen.languages.Swift4Codegen;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import org.testng.Assert;
import org.testng.annotations.Test;

public class Swift4CodegenTest {
    Swift4Codegen swiftCodegen = new Swift4Codegen();

    @Test
    public void testCapitalizedReservedWord() throws Exception {
        Assert.assertEquals((String)this.swiftCodegen.toEnumVarName("AS", null), (String)"_as");
    }

    @Test
    public void testReservedWord() throws Exception {
        Assert.assertEquals((String)this.swiftCodegen.toEnumVarName("Public", null), (String)"_public");
    }

    @Test
    public void shouldNotBreakNonReservedWord() throws Exception {
        Assert.assertEquals((String)this.swiftCodegen.toEnumVarName("Error", null), (String)"error");
    }

    @Test
    public void shouldNotBreakCorrectName() throws Exception {
        Assert.assertEquals((String)this.swiftCodegen.toEnumVarName("EntryName", null), (String)"entryName");
    }

    @Test
    public void testSingleWordAllCaps() throws Exception {
        Assert.assertEquals((String)this.swiftCodegen.toEnumVarName("VALUE", null), (String)"value");
    }

    @Test
    public void testSingleWordLowercase() throws Exception {
        Assert.assertEquals((String)this.swiftCodegen.toEnumVarName("value", null), (String)"value");
    }

    @Test
    public void testCapitalsWithUnderscore() throws Exception {
        Assert.assertEquals((String)this.swiftCodegen.toEnumVarName("ENTRY_NAME", null), (String)"entryName");
    }

    @Test
    public void testCapitalsWithDash() throws Exception {
        Assert.assertEquals((String)this.swiftCodegen.toEnumVarName("ENTRY-NAME", null), (String)"entryName");
    }

    @Test
    public void testCapitalsWithSpace() throws Exception {
        Assert.assertEquals((String)this.swiftCodegen.toEnumVarName("ENTRY NAME", null), (String)"entryName");
    }

    @Test
    public void testLowercaseWithUnderscore() throws Exception {
        Assert.assertEquals((String)this.swiftCodegen.toEnumVarName("entry_name", null), (String)"entryName");
    }

    @Test
    public void testStartingWithNumber() throws Exception {
        Assert.assertEquals((String)this.swiftCodegen.toEnumVarName("123EntryName", null), (String)"_123entryName");
        Assert.assertEquals((String)this.swiftCodegen.toEnumVarName("123Entry_name", null), (String)"_123entryName");
        Assert.assertEquals((String)this.swiftCodegen.toEnumVarName("123EntryName123", null), (String)"_123entryName123");
    }

    @Test(description="returns Data when response format is binary")
    public void binaryDataTest() {
        Swagger model = new SwaggerParser().read("src/test/resources/2_0/binaryDataTest.json");
        Swift4Codegen codegen = new Swift4Codegen();
        String path = "/tests/binaryResponse";
        Operation p = ((Path)model.getPaths().get("/tests/binaryResponse")).getPost();
        CodegenOperation op = codegen.fromOperation("/tests/binaryResponse", "post", p, model.getDefinitions());
        Assert.assertEquals((String)op.returnType, (String)"Data");
        Assert.assertEquals((String)op.bodyParam.dataType, (String)"Data");
        Assert.assertTrue((boolean)op.bodyParam.isBinary);
        Assert.assertTrue((boolean)((CodegenResponse)op.responses.get((int)0)).isBinary);
    }

    @Test(description="returns Date when response format is date")
    public void dateTest() {
        Swagger model = new SwaggerParser().read("src/test/resources/2_0/datePropertyTest.json");
        Swift4Codegen codegen = new Swift4Codegen();
        String path = "/tests/dateResponse";
        Operation p = ((Path)model.getPaths().get("/tests/dateResponse")).getPost();
        CodegenOperation op = codegen.fromOperation("/tests/dateResponse", "post", p, model.getDefinitions());
        Assert.assertEquals((String)op.returnType, (String)"Date");
        Assert.assertEquals((String)op.bodyParam.dataType, (String)"Date");
    }

    @Test
    public void testDefaultPodAuthors() throws Exception {
        this.swiftCodegen.processOpts();
        String podAuthors = (String)this.swiftCodegen.additionalProperties().get("podAuthors");
        Assert.assertEquals((String)podAuthors, (String)"Swagger Codegen");
    }

    @Test
    public void testPodAuthors() throws Exception {
        String swaggerDevs = "Swagger Devs";
        this.swiftCodegen.additionalProperties().put("podAuthors", "Swagger Devs");
        this.swiftCodegen.processOpts();
        String podAuthors = (String)this.swiftCodegen.additionalProperties().get("podAuthors");
        Assert.assertEquals((String)podAuthors, (String)"Swagger Devs");
    }

    @Test
    public void testInitialConfigValues() throws Exception {
        Swift4Codegen codegen = new Swift4Codegen();
        codegen.processOpts();
        Assert.assertEquals(codegen.additionalProperties().get("hideGenerationTimestamp"), (Object)Boolean.TRUE);
        Assert.assertEquals((boolean)codegen.isHideGenerationTimestamp(), (boolean)true);
    }

    @Test
    public void testSettersForConfigValues() throws Exception {
        Swift4Codegen codegen = new Swift4Codegen();
        codegen.setHideGenerationTimestamp(false);
        codegen.processOpts();
        Assert.assertEquals(codegen.additionalProperties().get("hideGenerationTimestamp"), (Object)Boolean.FALSE);
        Assert.assertEquals((boolean)codegen.isHideGenerationTimestamp(), (boolean)false);
    }

    @Test
    public void testAdditionalPropertiesPutForConfigValues() throws Exception {
        Swift4Codegen codegen = new Swift4Codegen();
        codegen.additionalProperties().put("hideGenerationTimestamp", false);
        codegen.processOpts();
        Assert.assertEquals(codegen.additionalProperties().get("hideGenerationTimestamp"), (Object)Boolean.FALSE);
        Assert.assertEquals((boolean)codegen.isHideGenerationTimestamp(), (boolean)false);
    }
}

