/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.swift;

import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenResponse;
import io.swagger.codegen.languages.SwiftCodegen;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SwiftCodegenTest {
    SwiftCodegen swiftCodegen = new SwiftCodegen();

    @Test
    public void shouldNotBreakCorrectName() throws Exception {
        Assert.assertEquals((String)this.swiftCodegen.toSwiftyEnumName("EntryName"), (String)"EntryName");
    }

    @Test
    public void testSingleWordAllCaps() throws Exception {
        Assert.assertEquals((String)this.swiftCodegen.toSwiftyEnumName("VALUE"), (String)"Value");
    }

    @Test
    public void testSingleWordLowercase() throws Exception {
        Assert.assertEquals((String)this.swiftCodegen.toSwiftyEnumName("value"), (String)"Value");
    }

    @Test
    public void testCapitalsWithUnderscore() throws Exception {
        Assert.assertEquals((String)this.swiftCodegen.toSwiftyEnumName("ENTRY_NAME"), (String)"EntryName");
    }

    @Test
    public void testCapitalsWithDash() throws Exception {
        Assert.assertEquals((String)this.swiftCodegen.toSwiftyEnumName("ENTRY-NAME"), (String)"EntryName");
    }

    @Test
    public void testCapitalsWithSpace() throws Exception {
        Assert.assertEquals((String)this.swiftCodegen.toSwiftyEnumName("ENTRY NAME"), (String)"EntryName");
    }

    @Test
    public void testLowercaseWithUnderscore() throws Exception {
        Assert.assertEquals((String)this.swiftCodegen.toSwiftyEnumName("entry_name"), (String)"EntryName");
    }

    @Test
    public void testSlash() throws Exception {
        Assert.assertEquals((String)this.swiftCodegen.toSwiftyEnumName("application/x-tar"), (String)"ApplicationXTar");
    }

    @Test(description="returns NSData when response format is binary")
    public void binaryDataTest() {
        Swagger model = new SwaggerParser().read("src/test/resources/2_0/binaryDataTest.json");
        SwiftCodegen codegen = new SwiftCodegen();
        String path = "/tests/binaryResponse";
        Operation p = ((Path)model.getPaths().get("/tests/binaryResponse")).getPost();
        CodegenOperation op = codegen.fromOperation("/tests/binaryResponse", "post", p, model.getDefinitions());
        Assert.assertEquals((String)op.returnType, (String)"NSData");
        Assert.assertEquals((String)op.bodyParam.dataType, (String)"NSData");
        Assert.assertTrue((boolean)op.bodyParam.isBinary);
        Assert.assertTrue((boolean)((CodegenResponse)op.responses.get((int)0)).isBinary);
    }

    @Test(description="returns ISOFullDate when response format is date")
    public void dateTest() {
        Swagger model = new SwaggerParser().read("src/test/resources/2_0/datePropertyTest.json");
        SwiftCodegen codegen = new SwiftCodegen();
        String path = "/tests/dateResponse";
        Operation p = ((Path)model.getPaths().get("/tests/dateResponse")).getPost();
        CodegenOperation op = codegen.fromOperation("/tests/dateResponse", "post", p, model.getDefinitions());
        Assert.assertEquals((String)op.returnType, (String)"ISOFullDate");
        Assert.assertEquals((String)op.bodyParam.dataType, (String)"ISOFullDate");
    }

    @Test
    public void testDefaultPodAuthors() throws Exception {
        this.swiftCodegen.processOpts();
        String podAuthors = (String)this.swiftCodegen.additionalProperties().get("podAuthors");
        Assert.assertEquals((String)podAuthors, (String)"Swagger Codegen");
    }

    @Test
    public void testPodAuthors() throws Exception {
        String swaggerDevs = "Swagger Devs";
        this.swiftCodegen.additionalProperties().put("podAuthors", "Swagger Devs");
        this.swiftCodegen.processOpts();
        String podAuthors = (String)this.swiftCodegen.additionalProperties().get("podAuthors");
        Assert.assertEquals((String)podAuthors, (String)"Swagger Devs");
    }

    @Test
    public void testInitialConfigValues() throws Exception {
        SwiftCodegen codegen = new SwiftCodegen();
        codegen.processOpts();
        Assert.assertEquals(codegen.additionalProperties().get("hideGenerationTimestamp"), (Object)Boolean.TRUE);
        Assert.assertEquals((boolean)codegen.isHideGenerationTimestamp(), (boolean)true);
    }

    @Test
    public void testSettersForConfigValues() throws Exception {
        SwiftCodegen codegen = new SwiftCodegen();
        codegen.setHideGenerationTimestamp(false);
        codegen.processOpts();
        Assert.assertEquals(codegen.additionalProperties().get("hideGenerationTimestamp"), (Object)Boolean.FALSE);
        Assert.assertEquals((boolean)codegen.isHideGenerationTimestamp(), (boolean)false);
    }

    @Test
    public void testAdditionalPropertiesPutForConfigValues() throws Exception {
        SwiftCodegen codegen = new SwiftCodegen();
        codegen.additionalProperties().put("hideGenerationTimestamp", false);
        codegen.processOpts();
        Assert.assertEquals(codegen.additionalProperties().get("hideGenerationTimestamp"), (Object)Boolean.FALSE);
        Assert.assertEquals((boolean)codegen.isHideGenerationTimestamp(), (boolean)false);
    }
}

