/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.statichtml;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.swagger.codegen.ClientOptInput;
import io.swagger.codegen.ClientOpts;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.DefaultGenerator;
import io.swagger.codegen.languages.StaticHtmlGenerator;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.junit.rules.TemporaryFolder;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class StaticHtmlTagsTest {
    public TemporaryFolder folder = new TemporaryFolder();

    @BeforeMethod
    public void setUp() throws Exception {
        this.folder.create();
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this.folder.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testApiTags() throws Exception {
        Swagger swagger = new SwaggerParser().read("src/test/resources/2_0/petstore.json");
        int maxTagsToTest = 2;
        final ArrayList<Operation> expectedOperations = new ArrayList<Operation>();
        final String capitalCommatizedTags = this.pickupFewTagsAndOps(swagger, 2, expectedOperations);
        final ArrayList seenOperations = new ArrayList();
        StaticHtmlGenerator codegenConfig = new StaticHtmlGenerator(){

            public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
                Collection actualOperations = StaticHtmlTagsTest.getOperations(objs);
                seenOperations.addAll(actualOperations);
                Assert.assertEquals((int)actualOperations.size(), (int)expectedOperations.size(), (String)("Expectig the same size of ops for -Dapis=" + capitalCommatizedTags + " in fact, actual " + actualOperations + " doesn't seem like expecting " + expectedOperations));
                return objs;
            }
        };
        codegenConfig.setOutputDir(this.folder.getRoot().getAbsolutePath());
        ClientOptInput clientOptInput = new ClientOptInput().opts(new ClientOpts()).swagger(swagger).config((CodegenConfig)codegenConfig);
        String apisBackup = System.setProperty("apis", capitalCommatizedTags);
        try {
            DefaultGenerator gen = new DefaultGenerator();
            gen.opts(clientOptInput);
            gen.generate();
            Assert.assertEquals((boolean)seenOperations.isEmpty(), (boolean)false, (String)"something has been changed in code and now code bypass the mock above...");
        }
        finally {
            if (apisBackup != null) {
                System.setProperty("apis", apisBackup);
            } else {
                System.clearProperty("apis");
            }
        }
    }

    protected String pickupFewTagsAndOps(Swagger swagger, int maxTagsToTest, Collection<Operation> expectedOperations) {
        HashSet<String> expectedTags = new HashSet<String>();
        for (Path path : swagger.getPaths().values()) {
            for (Operation op : path.getOperations()) {
                for (String tag : op.getTags()) {
                    if (expectedTags.size() < maxTagsToTest) {
                        expectedTags.add(tag);
                        expectedOperations.add(op);
                        continue;
                    }
                    if (!expectedTags.contains(tag)) continue;
                    expectedOperations.add(op);
                }
            }
        }
        String capitalCommatizedTags = StringUtils.join((Iterable)Lists.transform((List)Lists.newArrayList(expectedTags), (Function)new Function<String, String>(){

            @Nullable
            public String apply(String input) {
                return StringUtils.capitalize((String)input);
            }
        }), (String)",");
        return capitalCommatizedTags;
    }

    protected static Collection getOperations(Map<String, Object> objs) {
        ArrayList rez = new ArrayList();
        Map apiInfo = (Map)objs.get("apiInfo");
        for (Object apiElem : (List)apiInfo.get("apis")) {
            Map api = (Map)apiElem;
            rez.addAll((Collection)((Map)api.get("operations")).get("operation"));
        }
        return rez;
    }
}

