/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.staticDocs;

import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.languages.StaticDocCodegen;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import org.testng.Assert;
import org.testng.annotations.Test;

public class StaticOperationTest {
    @Test(description="convert a string parameter")
    public void stringParameterTest() {
        StringProperty property = new StringProperty();
        StaticDocCodegen codegen = new StaticDocCodegen();
        CodegenProperty cp = codegen.fromProperty("property", (Property)property);
        Assert.assertEquals((String)cp.baseName, (String)"property");
        Assert.assertEquals((String)cp.datatype, (String)"String");
        Assert.assertEquals((String)cp.name, (String)"property");
        Assert.assertEquals((String)cp.baseType, (String)"string");
        Assert.assertTrue((boolean)cp.isNotContainer);
    }

    @Test(description="convert a boolean parameter")
    public void booleanParameterTest() {
        BooleanProperty property = new BooleanProperty();
        StaticDocCodegen codegen = new StaticDocCodegen();
        CodegenProperty cp = codegen.fromProperty("property", (Property)property);
        Assert.assertEquals((String)cp.baseName, (String)"property");
        Assert.assertEquals((String)cp.datatype, (String)"Boolean");
        Assert.assertEquals((String)cp.name, (String)"property");
        Assert.assertEquals((String)cp.baseType, (String)"boolean");
        Assert.assertTrue((boolean)cp.isNotContainer);
        Assert.assertTrue((boolean)cp.isBoolean);
        Assert.assertEquals((String)cp.getter, (String)"getProperty");
    }

    @Test(description="convert a complex parameter")
    public void complexParameterTest() {
        RefProperty property = new RefProperty("Children");
        StaticDocCodegen codegen = new StaticDocCodegen();
        CodegenProperty cp = codegen.fromProperty("property", (Property)property);
        Assert.assertEquals((String)cp.baseName, (String)"property");
        Assert.assertEquals((String)cp.complexType, (String)"Children");
        Assert.assertEquals((String)cp.getter, (String)"getProperty");
        Assert.assertEquals((String)cp.setter, (String)"setProperty");
        Assert.assertEquals((String)cp.datatype, (String)"Children");
        Assert.assertEquals((String)cp.name, (String)"property");
        Assert.assertEquals((String)cp.defaultValue, (String)"null");
        Assert.assertEquals((String)cp.baseType, (String)"Children");
        Assert.assertTrue((boolean)cp.isNotContainer);
    }

    @Test(description="convert a complex list parameter")
    public void listParameterTest() {
        ArrayProperty property = new ArrayProperty().items((Property)new RefProperty("Children"));
        StaticDocCodegen codegen = new StaticDocCodegen();
        CodegenProperty cp = codegen.fromProperty("property", (Property)property);
        Assert.assertEquals((String)cp.baseName, (String)"property");
        Assert.assertEquals((String)cp.complexType, (String)"Children");
        Assert.assertEquals((String)cp.getter, (String)"getProperty");
        Assert.assertEquals((String)cp.setter, (String)"setProperty");
        Assert.assertEquals((String)cp.datatype, (String)"List");
        Assert.assertEquals((String)cp.name, (String)"property");
        Assert.assertEquals((String)cp.baseType, (String)"array");
        Assert.assertEquals((String)cp.containerType, (String)"array");
        Assert.assertTrue((boolean)cp.isContainer);
    }
}

