/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.ruby;

import io.swagger.codegen.ClientOptInput;
import io.swagger.codegen.ClientOpts;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.DefaultGenerator;
import io.swagger.codegen.languages.RubyClientCodegen;
import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.rules.TemporaryFolder;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RubyClientCodegenTest {
    public TemporaryFolder folder = new TemporaryFolder();

    @BeforeMethod
    public void setUp() throws Exception {
        this.folder.create();
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this.folder.delete();
    }

    @Test
    public void testGenerateRubyClientWithHtmlEntity() throws Exception {
        File output = this.folder.getRoot();
        Swagger swagger = new SwaggerParser().read("src/test/resources/2_0/pathWithHtmlEntity.yaml");
        RubyClientCodegen codegenConfig = new RubyClientCodegen();
        codegenConfig.setOutputDir(output.getAbsolutePath());
        ClientOptInput clientOptInput = new ClientOptInput().opts(new ClientOpts()).swagger(swagger).config((CodegenConfig)codegenConfig);
        DefaultGenerator generator = new DefaultGenerator();
        List files = generator.opts(clientOptInput).generate();
        boolean apiFileGenerated = false;
        for (File file : files) {
            if (!file.getName().equals("default_api.rb")) continue;
            apiFileGenerated = true;
            Assert.assertTrue((boolean)FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8).contains("local_var_path = '/foo=bar'"));
        }
        if (!apiFileGenerated) {
            Assert.fail((String)"Default api file is not generated!");
        }
    }

    @Test
    public void testInitialConfigValues() throws Exception {
        RubyClientCodegen codegen = new RubyClientCodegen();
        codegen.processOpts();
        Assert.assertEquals(codegen.additionalProperties().get("hideGenerationTimestamp"), (Object)Boolean.TRUE);
        Assert.assertEquals((boolean)codegen.isHideGenerationTimestamp(), (boolean)true);
        Assert.assertEquals((String)codegen.modelPackage(), (String)"models");
        Assert.assertEquals(codegen.additionalProperties().get("modelPackage"), null);
        Assert.assertEquals((String)codegen.apiPackage(), (String)"api");
        Assert.assertEquals(codegen.additionalProperties().get("apiPackage"), null);
    }

    @Test
    public void testSettersForConfigValues() throws Exception {
        RubyClientCodegen codegen = new RubyClientCodegen();
        codegen.setHideGenerationTimestamp(false);
        codegen.processOpts();
        Assert.assertEquals(codegen.additionalProperties().get("hideGenerationTimestamp"), (Object)Boolean.FALSE);
        Assert.assertEquals((boolean)codegen.isHideGenerationTimestamp(), (boolean)false);
    }

    @Test
    public void testAdditionalPropertiesPutForConfigValues() throws Exception {
        RubyClientCodegen codegen = new RubyClientCodegen();
        codegen.additionalProperties().put("hideGenerationTimestamp", false);
        codegen.additionalProperties().put("modelPackage", "ruby-models");
        codegen.additionalProperties().put("apiPackage", "ruby-api");
        codegen.processOpts();
        Assert.assertEquals(codegen.additionalProperties().get("hideGenerationTimestamp"), (Object)Boolean.FALSE);
        Assert.assertEquals((boolean)codegen.isHideGenerationTimestamp(), (boolean)false);
        Assert.assertEquals(codegen.additionalProperties().get("modelPackage"), (Object)"ruby-models");
        Assert.assertEquals(codegen.additionalProperties().get("apiPackage"), (Object)"ruby-api");
    }
}

