/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.python;

import com.google.common.collect.Sets;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.languages.PythonClientCodegen;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.parser.SwaggerParser;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PythonTest {
    @Test(description="convert a python model with dots")
    public void modelTest() {
        Swagger swagger = new SwaggerParser().read("src/test/resources/2_0/v1beta3.json");
        PythonClientCodegen codegen = new PythonClientCodegen();
        CodegenModel simpleName = codegen.fromModel("v1beta3.Binding", (Model)swagger.getDefinitions().get("v1beta3.Binding"));
        Assert.assertEquals((String)simpleName.name, (String)"v1beta3.Binding");
        Assert.assertEquals((String)simpleName.classname, (String)"V1beta3Binding");
        Assert.assertEquals((String)simpleName.classVarName, (String)"v1beta3_binding");
        CodegenModel compoundName = codegen.fromModel("v1beta3.ComponentStatus", (Model)swagger.getDefinitions().get("v1beta3.ComponentStatus"));
        Assert.assertEquals((String)compoundName.name, (String)"v1beta3.ComponentStatus");
        Assert.assertEquals((String)compoundName.classname, (String)"V1beta3ComponentStatus");
        Assert.assertEquals((String)compoundName.classVarName, (String)"v1beta3_component_status");
        String path = "/api/v1beta3/namespaces/{namespaces}/bindings";
        Operation operation = ((Path)swagger.getPaths().get("/api/v1beta3/namespaces/{namespaces}/bindings")).getPost();
        CodegenOperation codegenOperation = codegen.fromOperation("/api/v1beta3/namespaces/{namespaces}/bindings", "get", operation, swagger.getDefinitions());
        Assert.assertEquals((String)codegenOperation.returnType, (String)"V1beta3Binding");
        Assert.assertEquals((String)codegenOperation.returnBaseType, (String)"V1beta3Binding");
    }

    @Test(description="convert a simple java model")
    public void simpleModelTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("id", (Property)new LongProperty()).property("name", (Property)new StringProperty()).property("createdAt", (Property)new DateTimeProperty()).required("id").required("name");
        PythonClientCodegen codegen = new PythonClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)3);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"id");
        Assert.assertEquals((String)property1.datatype, (String)"int");
        Assert.assertEquals((String)property1.name, (String)"id");
        Assert.assertNull((Object)property1.defaultValue);
        Assert.assertEquals((String)property1.baseType, (String)"int");
        Assert.assertTrue((boolean)property1.hasMore);
        Assert.assertTrue((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isPrimitiveType);
        Assert.assertTrue((boolean)property1.isNotContainer);
        CodegenProperty property2 = (CodegenProperty)cm.vars.get(1);
        Assert.assertEquals((String)property2.baseName, (String)"name");
        Assert.assertEquals((String)property2.datatype, (String)"str");
        Assert.assertEquals((String)property2.name, (String)"name");
        Assert.assertNull((Object)property2.defaultValue);
        Assert.assertEquals((String)property2.baseType, (String)"str");
        Assert.assertTrue((boolean)property2.hasMore);
        Assert.assertTrue((boolean)property2.required);
        Assert.assertTrue((boolean)property2.isPrimitiveType);
        Assert.assertTrue((boolean)property2.isNotContainer);
        CodegenProperty property3 = (CodegenProperty)cm.vars.get(2);
        Assert.assertEquals((String)property3.baseName, (String)"createdAt");
        Assert.assertEquals((String)property3.datatype, (String)"datetime");
        Assert.assertEquals((String)property3.name, (String)"created_at");
        Assert.assertNull((Object)property3.defaultValue);
        Assert.assertEquals((String)property3.baseType, (String)"datetime");
        Assert.assertFalse((boolean)property3.hasMore);
        Assert.assertFalse((boolean)property3.required);
        Assert.assertTrue((boolean)property3.isNotContainer);
    }

    @Test(description="convert a model with list property")
    public void listPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("id", (Property)new LongProperty()).property("urls", (Property)new ArrayProperty().items((Property)new StringProperty())).required("id");
        PythonClientCodegen codegen = new PythonClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)2);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"id");
        Assert.assertEquals((String)property1.datatype, (String)"int");
        Assert.assertEquals((String)property1.name, (String)"id");
        Assert.assertNull((Object)property1.defaultValue);
        Assert.assertEquals((String)property1.baseType, (String)"int");
        Assert.assertTrue((boolean)property1.hasMore);
        Assert.assertTrue((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isPrimitiveType);
        Assert.assertTrue((boolean)property1.isNotContainer);
        CodegenProperty property2 = (CodegenProperty)cm.vars.get(1);
        Assert.assertEquals((String)property2.baseName, (String)"urls");
        Assert.assertEquals((String)property2.datatype, (String)"list[str]");
        Assert.assertEquals((String)property2.name, (String)"urls");
        Assert.assertNull((Object)property2.defaultValue);
        Assert.assertEquals((String)property2.baseType, (String)"list");
        Assert.assertFalse((boolean)property2.hasMore);
        Assert.assertEquals((String)property2.containerType, (String)"array");
        Assert.assertFalse((boolean)property2.required);
        Assert.assertTrue((boolean)property2.isPrimitiveType);
        Assert.assertTrue((boolean)property2.isContainer);
    }

    @Test(description="convert a model with a map property")
    public void mapPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("translations", (Property)new MapProperty().additionalProperties((Property)new StringProperty())).required("id");
        PythonClientCodegen codegen = new PythonClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"translations");
        Assert.assertEquals((String)property1.datatype, (String)"dict(str, str)");
        Assert.assertEquals((String)property1.name, (String)"translations");
        Assert.assertEquals((String)property1.baseType, (String)"dict");
        Assert.assertEquals((String)property1.containerType, (String)"map");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isContainer);
        Assert.assertTrue((boolean)property1.isPrimitiveType);
    }

    @Test(description="convert a model with complex property")
    public void complexPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new RefProperty("#/definitions/Children"));
        PythonClientCodegen codegen = new PythonClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"children");
        Assert.assertEquals((String)property1.datatype, (String)"Children");
        Assert.assertEquals((String)property1.name, (String)"children");
        Assert.assertEquals((String)property1.baseType, (String)"Children");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isNotContainer);
    }

    @Test(description="convert a model with complex list property")
    public void complexListPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new ArrayProperty().items((Property)new RefProperty("#/definitions/Children")));
        PythonClientCodegen codegen = new PythonClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"children");
        Assert.assertEquals((String)property1.complexType, (String)"Children");
        Assert.assertEquals((String)property1.datatype, (String)"list[Children]");
        Assert.assertEquals((String)property1.name, (String)"children");
        Assert.assertEquals((String)property1.baseType, (String)"list");
        Assert.assertEquals((String)property1.containerType, (String)"array");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isContainer);
    }

    @Test(description="convert a model with complex map property")
    public void complexMapPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new MapProperty().additionalProperties((Property)new RefProperty("#/definitions/Children")));
        PythonClientCodegen codegen = new PythonClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        Assert.assertEquals((int)Sets.intersection((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"Children"})).size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"children");
        Assert.assertEquals((String)property1.complexType, (String)"Children");
        Assert.assertEquals((String)property1.datatype, (String)"dict(str, Children)");
        Assert.assertEquals((String)property1.name, (String)"children");
        Assert.assertEquals((String)property1.baseType, (String)"dict");
        Assert.assertEquals((String)property1.containerType, (String)"map");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isContainer);
        Assert.assertFalse((boolean)property1.isNotContainer);
    }

    @Test(enabled=false, description="convert an array model")
    public void arrayModelTest() {
        ArrayModel model = new ArrayModel().description("an array model").items((Property)new RefProperty("#/definitions/Children"));
        PythonClientCodegen codegen = new PythonClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"an array model");
        Assert.assertEquals((int)cm.vars.size(), (int)0);
        Assert.assertEquals((String)cm.parent, (String)"null<Children>");
        Assert.assertEquals((int)cm.imports.size(), (int)1);
        Assert.assertEquals((int)Sets.intersection((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"Children"})).size(), (int)1);
    }

    @Test(enabled=false, description="convert an map model")
    public void mapModelTest() {
        ModelImpl model = new ModelImpl().description("a map model").additionalProperties((Property)new RefProperty("#/definitions/Children"));
        PythonClientCodegen codegen = new PythonClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a map model");
        Assert.assertEquals((int)cm.vars.size(), (int)0);
        Assert.assertEquals((String)cm.parent, (String)"null<String, Children>");
        Assert.assertEquals((int)cm.imports.size(), (int)2);
        Assert.assertEquals((int)Sets.intersection((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"Children"})).size(), (int)1);
    }
}

