/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.php;

import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.languages.PhpClientCodegen;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.parser.SwaggerParser;
import java.util.Arrays;
import java.util.HashMap;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class PhpModelTest {
    @Test(description="convert a simple php model")
    public void simpleModelTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("id", (Property)new LongProperty()).property("name", (Property)new StringProperty()).property("createdAt", (Property)new DateTimeProperty()).required("id").required("name");
        PhpClientCodegen codegen = new PhpClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)3);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"id");
        Assert.assertEquals((String)property1.datatype, (String)"int");
        Assert.assertEquals((String)property1.name, (String)"id");
        Assert.assertEquals((String)property1.defaultValue, null);
        Assert.assertEquals((String)property1.baseType, (String)"int");
        Assert.assertTrue((boolean)property1.hasMore);
        Assert.assertTrue((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isPrimitiveType);
        Assert.assertTrue((boolean)property1.isNotContainer);
        CodegenProperty property2 = (CodegenProperty)cm.vars.get(1);
        Assert.assertEquals((String)property2.baseName, (String)"name");
        Assert.assertEquals((String)property2.datatype, (String)"string");
        Assert.assertEquals((String)property2.name, (String)"name");
        Assert.assertEquals((String)property2.defaultValue, null);
        Assert.assertEquals((String)property2.baseType, (String)"string");
        Assert.assertTrue((boolean)property2.hasMore);
        Assert.assertTrue((boolean)property2.required);
        Assert.assertTrue((boolean)property2.isPrimitiveType);
        Assert.assertTrue((boolean)property2.isNotContainer);
        CodegenProperty property3 = (CodegenProperty)cm.vars.get(2);
        Assert.assertEquals((String)property3.baseName, (String)"createdAt");
        Assert.assertEquals((String)property3.complexType, (String)"\\DateTime");
        Assert.assertEquals((String)property3.datatype, (String)"\\DateTime");
        Assert.assertEquals((String)property3.name, (String)"created_at");
        Assert.assertEquals((String)property3.defaultValue, null);
        Assert.assertEquals((String)property3.baseType, (String)"\\DateTime");
        Assert.assertFalse((boolean)property3.hasMore);
        Assert.assertFalse((boolean)property3.required);
        Assert.assertTrue((boolean)property3.isNotContainer);
    }

    @Test(description="convert a model with list property")
    public void listPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("id", (Property)new LongProperty()).property("urls", (Property)new ArrayProperty().items((Property)new StringProperty())).required("id");
        PhpClientCodegen codegen = new PhpClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)2);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"id");
        Assert.assertEquals((String)property1.datatype, (String)"int");
        Assert.assertEquals((String)property1.name, (String)"id");
        Assert.assertEquals((String)property1.defaultValue, null);
        Assert.assertEquals((String)property1.baseType, (String)"int");
        Assert.assertTrue((boolean)property1.hasMore);
        Assert.assertTrue((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isPrimitiveType);
        Assert.assertTrue((boolean)property1.isNotContainer);
        CodegenProperty property2 = (CodegenProperty)cm.vars.get(1);
        Assert.assertEquals((String)property2.baseName, (String)"urls");
        Assert.assertEquals((String)property2.datatype, (String)"string[]");
        Assert.assertEquals((String)property2.name, (String)"urls");
        Assert.assertEquals((String)property2.baseType, (String)"array");
        Assert.assertFalse((boolean)property2.hasMore);
        Assert.assertEquals((String)property2.containerType, (String)"array");
        Assert.assertFalse((boolean)property2.required);
        Assert.assertTrue((boolean)property2.isPrimitiveType);
        Assert.assertTrue((boolean)property2.isContainer);
    }

    @Test(description="convert a model with a map property")
    public void mapPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("translations", (Property)new MapProperty().additionalProperties((Property)new StringProperty())).required("id");
        PhpClientCodegen codegen = new PhpClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"translations");
        Assert.assertEquals((String)property1.datatype, (String)"map[string,string]");
        Assert.assertEquals((String)property1.name, (String)"translations");
        Assert.assertEquals((String)property1.baseType, (String)"map");
        Assert.assertEquals((String)property1.containerType, (String)"map");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isContainer);
        Assert.assertTrue((boolean)property1.isPrimitiveType);
    }

    @Test(description="convert a model with complex property")
    public void complexPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new RefProperty("#/definitions/Children"));
        PhpClientCodegen codegen = new PhpClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"children");
        Assert.assertEquals((String)property1.datatype, (String)"\\Swagger\\Client\\Model\\Children");
        Assert.assertEquals((String)property1.name, (String)"children");
        Assert.assertEquals((String)property1.baseType, (String)"Children");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isNotContainer);
    }

    @Test(description="convert a model with complex list property")
    public void complexListProperty() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new ArrayProperty().items((Property)new RefProperty("#/definitions/Children")));
        PhpClientCodegen codegen = new PhpClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"children");
        Assert.assertEquals((String)property1.datatype, (String)"\\Swagger\\Client\\Model\\Children[]");
        Assert.assertEquals((String)property1.name, (String)"children");
        Assert.assertEquals((String)property1.baseType, (String)"array");
        Assert.assertEquals((String)property1.containerType, (String)"array");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isContainer);
    }

    @Test(description="convert a model with complex map property")
    public void complexMapProperty() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new MapProperty().additionalProperties((Property)new RefProperty("#/definitions/Children")));
        PhpClientCodegen codegen = new PhpClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"children");
        Assert.assertEquals((String)property1.complexType, (String)"Children");
        Assert.assertEquals((String)property1.datatype, (String)"map[string,\\Swagger\\Client\\Model\\Children]");
        Assert.assertEquals((String)property1.name, (String)"children");
        Assert.assertEquals((String)property1.baseType, (String)"map");
        Assert.assertEquals((String)property1.containerType, (String)"map");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isContainer);
        Assert.assertFalse((boolean)property1.isNotContainer);
    }

    @Test(description="convert an array model")
    public void arrayModelTest() {
        ArrayModel model = new ArrayModel().description("an array model").items((Property)new RefProperty("#/definitions/Children"));
        PhpClientCodegen codegen = new PhpClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"an array model");
        Assert.assertEquals((int)cm.vars.size(), (int)0);
    }

    @Test(description="convert an map model")
    public void mapModelTest() {
        ModelImpl model = new ModelImpl().description("a map model").additionalProperties((Property)new RefProperty("#/definitions/Children"));
        PhpClientCodegen codegen = new PhpClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a map model");
        Assert.assertEquals((int)cm.vars.size(), (int)0);
    }

    @DataProvider(name="modelNames")
    public static Object[][] primeNumbers() {
        return new Object[][]{{"sample", "Sample"}, {"sample_name", "SampleName"}, {"sample__name", "SampleName"}, {"/sample", "Sample"}, {"\\sample", "\\Sample"}, {"sample.name", "SampleName"}, {"_sample", "Sample"}};
    }

    @Test(dataProvider="modelNames", description="avoid inner class")
    public void modelNameTest(String name, String expectedName) {
        ModelImpl model = new ModelImpl();
        PhpClientCodegen codegen = new PhpClientCodegen();
        CodegenModel cm = codegen.fromModel(name, (Model)model);
        Assert.assertEquals((String)cm.name, (String)name);
        Assert.assertEquals((String)cm.classname, (String)expectedName);
    }

    @Test(description="test enum array model")
    public void enumArrayMdoelTest() {
        Swagger model = new SwaggerParser().read("src/test/resources/2_0/petstore-with-fake-endpoints-models-for-testing.yaml");
        PhpClientCodegen codegen = new PhpClientCodegen();
        Model definition = (Model)model.getDefinitions().get("EnumArrays");
        Property property = (Property)definition.getProperties().get("array_enum");
        CodegenProperty prope = codegen.fromProperty("array_enum", property);
        codegen.updateCodegenPropertyEnum(prope);
        Assert.assertEquals((String)prope.datatypeWithEnum, (String)"ARRAY_ENUM[]");
        Assert.assertEquals((String)prope.enumName, (String)"ARRAY_ENUM");
        Assert.assertTrue((boolean)prope.isEnum);
        Assert.assertEquals(prope.allowableValues.get("values"), Arrays.asList("fish", "crab"));
        HashMap<String, String> fish = new HashMap<String, String>();
        fish.put("name", "FISH");
        fish.put("value", "'fish'");
        HashMap<String, String> crab = new HashMap<String, String>();
        crab.put("name", "CRAB");
        crab.put("value", "'crab'");
        Assert.assertEquals(prope.allowableValues.get("enumVars"), Arrays.asList(fish, crab));
        Assert.assertEquals((String)prope.datatypeWithEnum, (String)"ARRAY_ENUM[]");
        Assert.assertEquals((String)prope.enumName, (String)"ARRAY_ENUM");
        Assert.assertTrue((boolean)prope.items.isEnum);
        Assert.assertEquals(prope.items.allowableValues.get("values"), Arrays.asList("fish", "crab"));
        Assert.assertEquals(prope.items.allowableValues.get("enumVars"), Arrays.asList(fish, crab));
    }

    @Test(description="test enum model for values (numeric, string, etc)")
    public void enumMdoelValueTest() {
        Swagger model = new SwaggerParser().read("src/test/resources/2_0/petstore-with-fake-endpoints-models-for-testing.yaml");
        PhpClientCodegen codegen = new PhpClientCodegen();
        Model definition = (Model)model.getDefinitions().get("Enum_Test");
        Property property = (Property)definition.getProperties().get("enum_integer");
        CodegenProperty prope = codegen.fromProperty("enum_integer", property);
        codegen.updateCodegenPropertyEnum(prope);
        Assert.assertEquals((String)prope.datatypeWithEnum, (String)"ENUM_INTEGER");
        Assert.assertEquals((String)prope.enumName, (String)"ENUM_INTEGER");
        Assert.assertTrue((boolean)prope.isEnum);
        Assert.assertFalse((boolean)prope.isContainer);
        Assert.assertNull((Object)prope.items);
        Assert.assertEquals(prope.allowableValues.get("values"), Arrays.asList(1, -1));
        HashMap<String, String> one = new HashMap<String, String>();
        one.put("name", "1");
        one.put("value", "1");
        HashMap<String, String> minusOne = new HashMap<String, String>();
        minusOne.put("name", "MINUS_1");
        minusOne.put("value", "-1");
        Assert.assertEquals(prope.allowableValues.get("enumVars"), Arrays.asList(one, minusOne));
    }

    @Test(description="test enum variable names for reserved words")
    public void testReservedWord() throws Exception {
        PhpClientCodegen codegen = new PhpClientCodegen();
        Assert.assertEquals((String)codegen.toEnumVarName("public", null), (String)"_PUBLIC");
        Assert.assertEquals((String)codegen.toEnumVarName("Private", null), (String)"_PRIVATE");
        Assert.assertEquals((String)codegen.toEnumVarName("IF", null), (String)"_IF");
        Assert.assertEquals((String)codegen.toEnumVarName("hello", null), (String)"HELLO");
    }

    @Test(description="returns DateTime when using `--model-name-prefix`")
    public void dateTest() {
        Swagger model = new SwaggerParser().read("src/test/resources/2_0/datePropertyTest.json");
        PhpClientCodegen codegen = new PhpClientCodegen();
        codegen.setModelNamePrefix("foo");
        String path = "/tests/dateResponse";
        Operation p = ((Path)model.getPaths().get("/tests/dateResponse")).getPost();
        CodegenOperation op = codegen.fromOperation("/tests/dateResponse", "post", p, model.getDefinitions());
        Assert.assertEquals((String)op.returnType, (String)"\\DateTime");
        Assert.assertEquals((String)op.bodyParam.dataType, (String)"\\DateTime");
    }
}

