/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.objc;

import com.google.common.collect.Sets;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenResponse;
import io.swagger.codegen.languages.ObjcClientCodegen;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.parser.SwaggerParser;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ObjcModelTest {
    @Test(description="convert a model with a advanced map property")
    public void advancedMapPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("translations", (Property)new MapProperty().additionalProperties((Property)new MapProperty().additionalProperties((Property)new StringProperty()))).required("id");
        ObjcClientCodegen codegen = new ObjcClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"SWGSample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"translations");
        Assert.assertEquals((String)property1.datatype, (String)"NSDictionary<NSString*, NSDictionary<NSString*, NSString*>*>*");
        Assert.assertEquals((String)property1.name, (String)"translations");
        Assert.assertEquals((String)property1.baseType, (String)"NSDictionary");
        Assert.assertEquals((String)property1.containerType, (String)"map");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isContainer);
    }

    @Test(description="convert a simple java model")
    public void simpleModelTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("id", (Property)new LongProperty()).property("name", (Property)new StringProperty()).property("createdAt", (Property)new DateTimeProperty()).required("id").required("name").discriminator("test");
        ObjcClientCodegen codegen = new ObjcClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"SWGSample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)3);
        Assert.assertEquals((String)cm.discriminator, (String)"test");
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"id");
        Assert.assertEquals((String)property1.datatype, (String)"NSNumber*");
        Assert.assertEquals((String)property1.name, (String)"_id");
        Assert.assertNull((Object)property1.defaultValue);
        Assert.assertEquals((String)property1.baseType, (String)"NSNumber");
        Assert.assertTrue((boolean)property1.hasMore);
        Assert.assertTrue((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isPrimitiveType);
        Assert.assertTrue((boolean)property1.isNotContainer);
        CodegenProperty property2 = (CodegenProperty)cm.vars.get(1);
        Assert.assertEquals((String)property2.baseName, (String)"name");
        Assert.assertEquals((String)property2.datatype, (String)"NSString*");
        Assert.assertEquals((String)property2.name, (String)"name");
        Assert.assertNull((Object)property2.defaultValue);
        Assert.assertEquals((String)property2.baseType, (String)"NSString");
        Assert.assertTrue((boolean)property2.hasMore);
        Assert.assertTrue((boolean)property2.required);
        Assert.assertTrue((boolean)property2.isPrimitiveType);
        Assert.assertTrue((boolean)property2.isNotContainer);
        CodegenProperty property3 = (CodegenProperty)cm.vars.get(2);
        Assert.assertEquals((String)property3.baseName, (String)"createdAt");
        Assert.assertEquals((String)property3.datatype, (String)"NSDate*");
        Assert.assertEquals((String)property3.name, (String)"createdAt");
        Assert.assertNull((Object)property3.defaultValue);
        Assert.assertEquals((String)property3.baseType, (String)"NSDate");
        Assert.assertFalse((boolean)property3.hasMore);
        Assert.assertFalse((boolean)property3.required);
        Assert.assertTrue((boolean)property3.isNotContainer);
    }

    @Test(description="convert a model with list property")
    public void listPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("id", (Property)new LongProperty()).property("urls", (Property)new ArrayProperty().items((Property)new StringProperty())).required("id");
        ObjcClientCodegen codegen = new ObjcClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"SWGSample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)2);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"id");
        Assert.assertEquals((String)property1.datatype, (String)"NSNumber*");
        Assert.assertEquals((String)property1.name, (String)"_id");
        Assert.assertNull((Object)property1.defaultValue);
        Assert.assertEquals((String)property1.baseType, (String)"NSNumber");
        Assert.assertTrue((boolean)property1.hasMore);
        Assert.assertTrue((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isPrimitiveType);
        Assert.assertTrue((boolean)property1.isNotContainer);
        CodegenProperty property2 = (CodegenProperty)cm.vars.get(1);
        Assert.assertEquals((String)property2.baseName, (String)"urls");
        Assert.assertEquals((String)property2.datatype, (String)"NSArray<NSString*>*");
        Assert.assertEquals((String)property2.name, (String)"urls");
        Assert.assertNull((Object)property2.defaultValue);
        Assert.assertEquals((String)property2.baseType, (String)"NSArray");
        Assert.assertFalse((boolean)property2.hasMore);
        Assert.assertEquals((String)property2.containerType, (String)"array");
        Assert.assertFalse((boolean)property2.required);
        Assert.assertTrue((boolean)property2.isPrimitiveType);
        Assert.assertTrue((boolean)property2.isContainer);
    }

    @Test(description="convert a model with a map property")
    public void mapPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("translations", (Property)new MapProperty().additionalProperties((Property)new StringProperty())).required("id");
        ObjcClientCodegen codegen = new ObjcClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"SWGSample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"translations");
        Assert.assertEquals((String)property1.datatype, (String)"NSDictionary<NSString*, NSString*>*");
        Assert.assertEquals((String)property1.name, (String)"translations");
        Assert.assertEquals((String)property1.baseType, (String)"NSDictionary");
        Assert.assertEquals((String)property1.containerType, (String)"map");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isContainer);
        Assert.assertTrue((boolean)property1.isPrimitiveType);
    }

    @Test(description="convert a model with complex property")
    public void complexPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new RefProperty("#/definitions/Children"));
        ObjcClientCodegen codegen = new ObjcClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"SWGSample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"children");
        Assert.assertEquals((String)property1.datatype, (String)"SWGChildren*");
        Assert.assertEquals((String)property1.name, (String)"children");
        Assert.assertEquals((String)property1.baseType, (String)"SWGChildren");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isNotContainer);
    }

    @Test(description="convert a model with complex list property")
    public void complexListPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new ArrayProperty().items((Property)new RefProperty("#/definitions/Children")));
        ObjcClientCodegen codegen = new ObjcClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"SWGSample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"children");
        Assert.assertEquals((String)property1.complexType, (String)"SWGChildren");
        Assert.assertEquals((String)property1.datatype, (String)"NSArray<SWGChildren>*");
        Assert.assertEquals((String)property1.name, (String)"children");
        Assert.assertEquals((String)property1.baseType, (String)"NSArray");
        Assert.assertEquals((String)property1.containerType, (String)"array");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isContainer);
    }

    @Test(description="convert a model with complex map property")
    public void complexMapPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new MapProperty().additionalProperties((Property)new RefProperty("#/definitions/Children")));
        ObjcClientCodegen codegen = new ObjcClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"SWGSample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        Assert.assertEquals((int)Sets.intersection((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"SWGChildren"})).size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"children");
        Assert.assertEquals((String)property1.complexType, (String)"SWGChildren");
        Assert.assertEquals((String)property1.datatype, (String)"NSDictionary<SWGChildren>*");
        Assert.assertEquals((String)property1.name, (String)"children");
        Assert.assertEquals((String)property1.baseType, (String)"NSDictionary");
        Assert.assertEquals((String)property1.containerType, (String)"map");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isContainer);
        Assert.assertFalse((boolean)property1.isNotContainer);
    }

    @Test(description="convert an array model")
    public void arrayModelTest() {
        ArrayModel model = new ArrayModel().description("an array model").items((Property)new RefProperty("#/definitions/Children"));
        ObjcClientCodegen codegen = new ObjcClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"SWGSample");
        Assert.assertEquals((String)cm.description, (String)"an array model");
        Assert.assertEquals((int)cm.vars.size(), (int)0);
        Assert.assertEquals((String)cm.parent, (String)"NSMutableArray");
        Assert.assertEquals((int)cm.imports.size(), (int)1);
        Assert.assertEquals((int)Sets.intersection((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"SWGChildren"})).size(), (int)1);
    }

    @Test(description="convert an map model")
    public void mapModelTest() {
        ModelImpl model = new ModelImpl().description("a map model").additionalProperties((Property)new RefProperty("#/definitions/Children"));
        ObjcClientCodegen codegen = new ObjcClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"SWGSample");
        Assert.assertEquals((String)cm.description, (String)"a map model");
        Assert.assertEquals((int)cm.vars.size(), (int)0);
        Assert.assertEquals((String)cm.parent, (String)"NSMutableDictionary");
        Assert.assertEquals((int)cm.imports.size(), (int)1);
        Assert.assertEquals((int)Sets.intersection((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"SWGChildren"})).size(), (int)1);
    }

    @Test(description="test udid")
    public void udidAndPasswordDataModelTest() {
        Swagger model = new SwaggerParser().read("src/test/resources/2_0/petstore-with-fake-endpoints-models-for-testing.yaml");
        ObjcClientCodegen codegen = new ObjcClientCodegen();
        Model definition = (Model)model.getDefinitions().get("format_test");
        Property property = (Property)definition.getProperties().get("uuid");
        CodegenProperty prope = codegen.fromProperty("uuid", property);
        Assert.assertEquals((String)prope.baseType, (String)"NSString");
        prope = codegen.fromProperty("password", property);
        Assert.assertEquals((String)prope.baseType, (String)"NSString");
    }

    @Test(description="test mixedProperties")
    public void mixedPropertiesDataModelTest() {
        Swagger model = new SwaggerParser().read("src/test/resources/2_0/petstore-with-fake-endpoints-models-for-testing.yaml");
        ObjcClientCodegen codegen = new ObjcClientCodegen();
        Model definition = (Model)model.getDefinitions().get("MixedPropertiesAndAdditionalPropertiesClass");
        Property property = (Property)definition.getProperties().get("map");
        CodegenProperty prope = codegen.fromProperty("map", property);
        Assert.assertEquals((String)prope.baseType, (String)"NSDictionary");
    }

    @Test(description="test isArrayModel")
    public void isArrayModelModelTest() {
        Swagger model = new SwaggerParser().read("src/test/resources/2_0/petstore-with-fake-endpoints-models-for-testing.yaml");
        ObjcClientCodegen codegen = new ObjcClientCodegen();
        Model definition = (Model)model.getDefinitions().get("AnimalFarm");
        CodegenModel codegenModel = codegen.fromModel("AnimalFarm", definition);
        Assert.assertEquals((boolean)codegenModel.isArrayModel, (boolean)true);
        Assert.assertEquals((String)codegenModel.arrayModelType, (String)"SWGAnimal");
    }

    @Test(description="test binary data")
    public void binaryDataModelTest() {
        Swagger model = new SwaggerParser().read("src/test/resources/2_0/binaryDataTest.json");
        ObjcClientCodegen codegen = new ObjcClientCodegen();
        String path = "/tests/binaryResponse";
        Operation p = ((Path)model.getPaths().get("/tests/binaryResponse")).getPost();
        CodegenOperation op = codegen.fromOperation("/tests/binaryResponse", "post", p, model.getDefinitions());
        Assert.assertEquals((String)op.returnType, (String)"NSData*");
        Assert.assertEquals((String)op.bodyParam.dataType, (String)"NSData*");
        Assert.assertTrue((boolean)op.bodyParam.isBinary);
        Assert.assertTrue((boolean)((CodegenResponse)op.responses.get((int)0)).isBinary);
    }

    @Test(description="create proper imports per #316")
    public void issue316Test() {
        Swagger model = new SwaggerParser().read("src/test/resources/2_0/postBodyTest.json");
        ObjcClientCodegen codegen = new ObjcClientCodegen();
        Map animalPaths = model.getPaths();
        Path animalOps = (Path)animalPaths.get("/animals");
        Assert.assertNotNull((Object)animalOps.getPost());
        CodegenOperation animalCo = codegen.fromOperation("/animals", "POST", animalOps.getPost(), model.getDefinitions());
        Assert.assertEquals((int)animalCo.imports.size(), (int)1);
        Assert.assertTrue((boolean)animalCo.imports.contains("SWGAnimal"));
        Map insectPaths = model.getPaths();
        Path insectOps = (Path)insectPaths.get("/insects");
        Assert.assertNotNull((Object)insectOps.getPost());
        CodegenOperation insectCo = codegen.fromOperation("/insects", "POST", insectOps.getPost(), model.getDefinitions());
        Assert.assertEquals((int)insectCo.imports.size(), (int)1);
        Assert.assertTrue((boolean)insectCo.imports.contains("SWGInsect"));
    }
}

